/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;

public class PlayerReceivesMessageScriptEvent
extends BukkitScriptEvent {
    public static PlayerReceivesMessageScriptEvent instance;
    public Element message;
    public Element rawJson;
    public Element system;
    public dPlayer player;
    public boolean messageModified;
    public boolean rawJsonModified;
    public boolean loaded;

    public PlayerReceivesMessageScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("player receives message");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        return true;
    }

    @Override
    public String getName() {
        return "PlayerReceivesMessage";
    }

    @Override
    public void init() {
        this.loaded = true;
    }

    @Override
    public void destroy() {
        this.loaded = false;
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        String lower = CoreUtilities.toLowerCase(determination);
        if (lower.startsWith("message:")) {
            this.message = new Element(determination.substring("message:".length()));
            this.messageModified = true;
            return true;
        }
        if (lower.startsWith("raw_json:")) {
            this.rawJson = new Element(determination.substring("raw_json:".length()));
            this.rawJsonModified = true;
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("message")) {
            return this.message;
        }
        if (name.equals("raw_json")) {
            return this.rawJson;
        }
        if (name.equals("system_message")) {
            return this.system;
        }
        return super.getContext(name);
    }
}

