/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.ParticleHelper;
import com.denizenscript.denizen.nms.interfaces.Particle;
import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class PlayEffectCommand
extends AbstractCommand {
    public PlayEffectCommand() {
        this.setName("playeffect");
        this.setSyntax("playeffect [effect:<name>] [at:<location>|...] (data:<#.#>) (special_data:<data>) (visibility:<#.#>) (quantity:<#>) (offset:<#.#>,<#.#>,<#.#>) (targets:<player>|...) (velocity:<vector>)");
        this.setRequiredArguments(2, 8);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        ParticleHelper particleHelper = NMSHandler.getParticleHelper();
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentList(LocationTag.class) && (arg.matchesPrefix("at") || !arg.hasPrefix())) {
                if (arg.matchesPrefix("at")) {
                    scriptEntry.addObject("no_offset", new ElementTag(true));
                }
                scriptEntry.addObject("location", arg.asType(ListTag.class).filter(LocationTag.class, scriptEntry));
                continue;
            }
            if (!(scriptEntry.hasObject("effect") || scriptEntry.hasObject("particleeffect") || scriptEntry.hasObject("iconcrack"))) {
                if (particleHelper.hasParticle(arg.getValue())) {
                    scriptEntry.addObject("particleeffect", particleHelper.getParticle(arg.getValue()));
                    continue;
                }
                if (arg.matches("random")) {
                    List<Particle> visible = particleHelper.getVisibleParticles();
                    scriptEntry.addObject("particleeffect", visible.get(CoreUtilities.getRandom().nextInt(visible.size())));
                    continue;
                }
                if (arg.startsWith("iconcrack_")) {
                    Deprecations.oldPlayEffectSpecials.warn(scriptEntry);
                    String shrunk = arg.getValue().substring("iconcrack_".length());
                    ItemTag item = ItemTag.valueOf(shrunk, scriptEntry.context);
                    if (item != null) {
                        scriptEntry.addObject("iconcrack", item);
                        continue;
                    }
                    Debug.echoError("Invalid iconcrack_[item]. Must be a valid ItemTag!");
                    continue;
                }
                if (arg.matchesEnum((Enum<?>[])Effect.values())) {
                    scriptEntry.addObject("effect", Effect.valueOf((String)arg.getValue().toUpperCase()));
                    continue;
                }
                if (NMSHandler.getParticleHelper().effectRemap.containsKey(arg.getValue().toUpperCase())) {
                    scriptEntry.addObject("effect", NMSHandler.getParticleHelper().effectRemap.get(arg.getValue().toUpperCase()));
                }
            }
            if (!scriptEntry.hasObject("radius") && arg.matchesFloat() && arg.matchesPrefix("visibility", "v", "radius", "r")) {
                scriptEntry.addObject("radius", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("data") && arg.matchesFloat() && arg.matchesPrefix("data", "d")) {
                scriptEntry.addObject("data", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("special_data") && arg.matchesPrefix("special_data")) {
                scriptEntry.addObject("special_data", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("qty") && arg.matchesInteger() && arg.matchesPrefix("qty", "q", "quantity")) {
                scriptEntry.addObject("qty", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("offset") && arg.matchesFloat() && arg.matchesPrefix("offset", "o")) {
                double offset = arg.asElement().asDouble();
                scriptEntry.addObject("offset", new LocationTag(null, offset, offset, offset));
                continue;
            }
            if (!scriptEntry.hasObject("offset") && arg.matchesArgumentType(LocationTag.class) && arg.matchesPrefix("offset", "o")) {
                scriptEntry.addObject("offset", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("velocity") && arg.matchesArgumentType(LocationTag.class) && arg.matchesPrefix("velocity")) {
                scriptEntry.addObject("velocity", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("targets") && arg.matchesArgumentList(PlayerTag.class) && arg.matchesPrefix("targets", "target", "t")) {
                scriptEntry.addObject("targets", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("location", Utilities.entryDefaultLocation(scriptEntry, false));
        scriptEntry.defaultObject("data", new ElementTag(0));
        scriptEntry.defaultObject("radius", new ElementTag(15));
        scriptEntry.defaultObject("qty", new ElementTag(1));
        scriptEntry.defaultObject("offset", new LocationTag(null, 0.5, 0.5, 0.5));
        if (!(scriptEntry.hasObject("effect") || scriptEntry.hasObject("particleeffect") || scriptEntry.hasObject("iconcrack"))) {
            throw new InvalidArgumentsException("Missing effect argument!");
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Missing location argument!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        List locations = (List)scriptEntry.getObject("location");
        List targets = (List)scriptEntry.getObject("targets");
        Effect effect = (Effect)scriptEntry.getObject("effect");
        Particle particleEffect = (Particle)scriptEntry.getObject("particleeffect");
        ItemTag iconcrack = (ItemTag)scriptEntry.getObjectTag("iconcrack");
        ElementTag radius = scriptEntry.getElement("radius");
        ElementTag data = scriptEntry.getElement("data");
        ElementTag qty = scriptEntry.getElement("qty");
        ElementTag no_offset = scriptEntry.getElement("no_offset");
        boolean should_offset = no_offset == null || !no_offset.asBoolean();
        LocationTag offset = (LocationTag)scriptEntry.getObjectTag("offset");
        ElementTag special_data = scriptEntry.getElement("special_data");
        LocationTag velocity = (LocationTag)scriptEntry.getObjectTag("velocity");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), (effect != null ? ArgumentHelper.debugObj("effect", effect.name()) : (particleEffect != null ? ArgumentHelper.debugObj("special effect", particleEffect.getName()) : (iconcrack != null ? iconcrack.debug() : ""))) + ArgumentHelper.debugObj("locations", locations.toString()) + (targets != null ? ArgumentHelper.debugObj("targets", targets.toString()) : "") + radius.debug() + data.debug() + qty.debug() + offset.debug() + (special_data != null ? special_data.debug() : "") + (velocity != null ? velocity.debug() : "") + (should_offset ? ArgumentHelper.debugObj("note", "Location will be offset 1 block-height upward (see documentation)") : ""));
        }
        for (LocationTag location : locations) {
            if (should_offset) {
                location = new LocationTag(location.clone().add(0.0, 1.0, 0.0));
            }
            if (effect != null) {
                for (int n = 0; n < qty.asInt(); ++n) {
                    if (targets != null) {
                        for (Object player : targets) {
                            if (!((PlayerTag)player).isValid() || !((PlayerTag)player).isOnline()) continue;
                            ((PlayerTag)player).getPlayerEntity().playEffect((Location)location, effect, data.asInt());
                        }
                        continue;
                    }
                    location.getWorld().playEffect((Location)location, effect, data.asInt(), radius.asInt());
                }
                continue;
            }
            if (particleEffect != null) {
                ArrayList<Player> players = new ArrayList<Player>();
                if (targets == null) {
                    Object player;
                    float rad = radius.asFloat();
                    player = location.getWorld().getPlayers().iterator();
                    while (player.hasNext()) {
                        Player player2 = (Player)player.next();
                        if (!(player2.getLocation().distanceSquared((Location)location) < (double)(rad * rad))) continue;
                        players.add(player2);
                    }
                } else {
                    for (Object player : targets) {
                        if (!((PlayerTag)player).isValid() || !((PlayerTag)player).isOnline()) continue;
                        players.add(((PlayerTag)player).getPlayerEntity());
                    }
                }
                Class clazz = particleEffect.neededData();
                BlockData dataObject = null;
                if (clazz != null) {
                    if (special_data == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Missing required special data for particle: " + particleEffect.getName());
                    } else if (clazz == Particle.DustOptions.class) {
                        ListTag dataList = ListTag.valueOf(special_data.asString(), scriptEntry.getContext());
                        if (dataList.size() != 2) {
                            Debug.echoError(scriptEntry.getResidingQueue(), "DustOptions special_data must have 2 list entries for particle: " + particleEffect.getName());
                        } else {
                            float size = Float.parseFloat(dataList.get(0));
                            ColorTag color = ColorTag.valueOf(dataList.get(1), scriptEntry.context);
                            dataObject = new Particle.DustOptions(color.getColor(), size);
                        }
                    } else if (clazz == BlockData.class) {
                        MaterialTag blockMaterial = MaterialTag.valueOf(special_data.asString(), scriptEntry.getContext());
                        dataObject = blockMaterial.getModernData().data;
                    } else if (clazz == ItemStack.class) {
                        ItemTag itemType = ItemTag.valueOf(special_data.asString(), scriptEntry.getContext());
                        dataObject = itemType.getItemStack();
                    } else {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Unknown particle data type: " + clazz.getCanonicalName() + " for particle: " + particleEffect.getName());
                    }
                } else if (special_data != null) {
                    Debug.echoError("Particles of type '" + particleEffect.getName() + "' cannot take special_data as input.");
                }
                Random random = CoreUtilities.getRandom();
                float osX = (float)offset.getX();
                float osY = (float)offset.getY();
                float osZ = (float)offset.getZ();
                int quantity = qty.asInt();
                for (Player player : players) {
                    if (velocity == null) {
                        particleEffect.playFor(player, location, quantity, offset.toVector(), data.asFloat(), dataObject);
                        continue;
                    }
                    Vector velocityVector = velocity.toVector();
                    for (int i = 0; i < quantity; ++i) {
                        LocationTag singleLocation = location.clone().add(random.nextDouble() * (double)osX - (double)osX * 0.5, random.nextDouble() * (double)osY - (double)osY * 0.5, random.nextDouble() * (double)osZ - (double)osZ * 0.5);
                        particleEffect.playFor(player, singleLocation, 0, velocityVector, 1.0, dataObject);
                    }
                }
                continue;
            }
            ArrayList<Player> players = new ArrayList<Player>();
            if (targets == null) {
                float rad = radius.asFloat();
                for (Player player2 : location.getWorld().getPlayers()) {
                    if (!(player2.getLocation().distanceSquared((Location)location) < (double)(rad * rad))) continue;
                    players.add(player2);
                }
            } else {
                for (Object player : targets) {
                    if (!((PlayerTag)player).isValid() || !((PlayerTag)player).isOnline()) continue;
                    players.add(((PlayerTag)player).getPlayerEntity());
                }
            }
            if (iconcrack == null) continue;
            ItemStack itemStack = iconcrack.getItemStack();
            Particle particle = NMSHandler.getParticleHelper().getParticle("ITEM_CRACK");
            for (Player player : players) {
                particle.playFor(player, location, qty.asInt(), offset.toVector(), data.asFloat(), itemStack);
            }
        }
    }
}

