/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.plugin.Plugin;

public class ChunkLoadCommand
extends AbstractCommand
implements Listener {
    Map<String, Long> chunkDelays = new HashMap<String, Long>();

    public ChunkLoadCommand() {
        this.setName("chunkload");
        this.setSyntax("chunkload ({add}/remove/removeall) [<chunk>|...] (duration:<value>)");
        this.setRequiredArguments(1, 3);
        Denizen denizen = DenizenAPI.getCurrentInstance();
        denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)denizen);
        if (Depends.citizens != null) {
            denizen.getServer().getPluginManager().registerEvents((Listener)new ChunkLoadCommandNPCEvents(), (Plugin)denizen);
        }
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matchesEnum(Action.values()) && !scriptEntry.hasObject("action")) {
                scriptEntry.addObject("action", new ElementTag(arg.getValue().toUpperCase()));
                if (!arg.getValue().equalsIgnoreCase("removeall")) continue;
                scriptEntry.addObject("location", new ListTag((Collection<? extends ObjectTag>)Arrays.asList(new LocationTag((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0))));
                continue;
            }
            if (arg.matchesArgumentList(ChunkTag.class) && !scriptEntry.hasObject("location")) {
                scriptEntry.addObject("location", arg.asType(ListTag.class));
                continue;
            }
            if (arg.matchesArgumentList(LocationTag.class) && !scriptEntry.hasObject("location")) {
                scriptEntry.addObject("location", arg.asType(ListTag.class));
                continue;
            }
            if (arg.matchesArgumentType(DurationTag.class) && !scriptEntry.hasObject("duration")) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Missing location argument!");
        }
        if (!scriptEntry.hasObject("action")) {
            scriptEntry.addObject("action", new ElementTag("ADD"));
        }
        if (!scriptEntry.hasObject("duration")) {
            scriptEntry.addObject("duration", new DurationTag(0));
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag action = scriptEntry.getElement("action");
        ListTag chunklocs = (ListTag)scriptEntry.getObjectTag("location");
        DurationTag length = (DurationTag)scriptEntry.getObjectTag("duration");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), action.debug() + chunklocs.debug() + length.debug());
        }
        for (String chunkText : chunklocs) {
            Chunk chunk;
            if (ChunkTag.matches(chunkText)) {
                chunk = ChunkTag.valueOf(chunkText, scriptEntry.context).getChunk();
            } else if (LocationTag.matches(chunkText)) {
                chunk = LocationTag.valueOf(chunkText, scriptEntry.context).getChunk();
            } else {
                Debug.echoError("Chunk input '" + chunkText + "' is invalid.");
                return;
            }
            final String chunkString = chunk.getX() + ", " + chunk.getZ() + "," + chunk.getWorld().getName();
            switch (Action.valueOf(action.asString())) {
                case ADD: {
                    if (length.getSeconds() != 0.0) {
                        this.chunkDelays.put(chunkString, System.currentTimeMillis() + length.getMillis());
                    } else {
                        this.chunkDelays.put(chunkString, 0L);
                    }
                    Debug.echoDebug((Debuggable)scriptEntry, "...added chunk " + chunk.getX() + ", " + chunk.getZ() + " with a delay of " + length.getSeconds() + " seconds.");
                    if (!chunk.isLoaded()) {
                        chunk.load();
                    }
                    chunk.setForceLoaded(true);
                    if (!(length.getSeconds() > 0.0)) break;
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                        @Override
                        public void run() {
                            if (ChunkLoadCommand.this.chunkDelays.containsKey(chunkString) && ChunkLoadCommand.this.chunkDelays.get(chunkString) <= System.currentTimeMillis()) {
                                chunk.setForceLoaded(false);
                                ChunkLoadCommand.this.chunkDelays.remove(chunkString);
                            }
                        }
                    }, length.getTicks() + 20L);
                    break;
                }
                case REMOVE: {
                    if (this.chunkDelays.containsKey(chunkString)) {
                        this.chunkDelays.remove(chunkString);
                        chunk.setForceLoaded(false);
                        Debug.echoDebug((Debuggable)scriptEntry, "...allowing unloading of chunk " + chunk.getX() + ", " + chunk.getZ());
                        break;
                    }
                    Debug.echoError("Chunk was not on the load list!");
                    break;
                }
                case REMOVEALL: {
                    Debug.echoDebug((Debuggable)scriptEntry, "...allowing unloading of all stored chunks");
                    for (String chunkStr : this.chunkDelays.keySet()) {
                        ChunkTag loopChunk = ChunkTag.valueOf(chunkStr, scriptEntry.context);
                        loopChunk.getChunk().setForceLoaded(false);
                    }
                    this.chunkDelays.clear();
                }
            }
        }
    }

    @EventHandler
    public void stopUnload(ChunkUnloadEvent e) {
        if (!(e instanceof Cancellable)) {
            return;
        }
        String chunkString = e.getChunk().getX() + ", " + e.getChunk().getZ() + "," + e.getChunk().getWorld().getName();
        if (this.chunkDelays.containsKey(chunkString)) {
            if (this.chunkDelays.get(chunkString) == 0L) {
                ((Cancellable)e).setCancelled(true);
            } else if (System.currentTimeMillis() < this.chunkDelays.get(chunkString)) {
                ((Cancellable)e).setCancelled(true);
            } else {
                this.chunkDelays.remove(chunkString);
            }
        }
    }

    public class ChunkLoadCommandNPCEvents
    implements Listener {
        @EventHandler
        public void stopDespawn(NPCDespawnEvent e) {
            if (e.getNPC() == null || !e.getNPC().isSpawned()) {
                return;
            }
            Chunk chnk = e.getNPC().getEntity().getLocation().getChunk();
            String chunkString = chnk.getX() + ", " + chnk.getZ();
            if (ChunkLoadCommand.this.chunkDelays.containsKey(chunkString)) {
                if (ChunkLoadCommand.this.chunkDelays.get(chunkString) == 0L) {
                    e.setCancelled(true);
                } else if (System.currentTimeMillis() < ChunkLoadCommand.this.chunkDelays.get(chunkString)) {
                    e.setCancelled(true);
                } else {
                    ChunkLoadCommand.this.chunkDelays.remove(chunkString);
                }
            }
        }
    }

    private static enum Action {
        ADD,
        REMOVE,
        REMOVEALL;

    }
}

