/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.server;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.CachedServerIcon;

public class ListPingScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static ListPingScriptEvent instance;
    public ServerListPingEvent event;
    public static HashMap<String, CachedServerIcon> iconCache;

    public ListPingScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("server list ping");
    }

    @Override
    public String getName() {
        return "ServerListPing";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (determination.startsWith("icon:")) {
            String iconFile = determination.substring("icon:".length());
            CachedServerIcon icon = iconCache.get(iconFile);
            if (icon != null) {
                this.event.setServerIcon(icon);
                return true;
            }
            File file = new File(iconFile);
            if (!Utilities.canReadFile(file)) {
                Debug.echoError("Cannot read icon file '" + iconFile + "'");
                return false;
            }
            try {
                icon = Bukkit.loadServerIcon((File)file);
            }
            catch (Exception ex) {
                Debug.echoError(ex);
            }
            if (icon != null) {
                iconCache.put(iconFile, icon);
                this.event.setServerIcon(icon);
            }
            return true;
        }
        if (determination.length() > 0 && !determination.equalsIgnoreCase("none")) {
            List<String> values = CoreUtilities.split(determination, '|', 2);
            if (new ElementTag(values.get(0)).isInt()) {
                this.event.setMaxPlayers(new ElementTag(values.get(0)).asInt());
                if (values.size() == 2) {
                    this.event.setMotd(values.get(1));
                }
            } else {
                this.event.setMotd(determination);
            }
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("motd")) {
            return new ElementTag(this.event.getMotd());
        }
        if (name.equals("max_players")) {
            return new ElementTag(this.event.getMaxPlayers());
        }
        if (name.equals("num_players")) {
            return new ElementTag(this.event.getNumPlayers());
        }
        if (name.equals("address")) {
            return new ElementTag(this.event.getAddress().toString());
        }
        return super.getContext(name);
    }

    static {
        iconCache = new HashMap();
    }

    public static class ListPingScriptEventSpigotImpl
    extends ListPingScriptEvent {
        @EventHandler
        public void onListPing(ServerListPingEvent event) {
            this.event = event;
            if (!Bukkit.isPrimaryThread()) {
                BukkitScriptEvent altEvent = (BukkitScriptEvent)this.clone();
                Future future = Bukkit.getScheduler().callSyncMethod((Plugin)DenizenAPI.getCurrentInstance(), () -> {
                    altEvent.fire();
                    return null;
                });
                try {
                    future.get(5L, TimeUnit.SECONDS);
                }
                catch (Throwable ex) {
                    Debug.echoError(ex);
                }
                return;
            }
            this.fire((Event)event);
        }
    }
}

