/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.flags;

import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.SlowWarning;
import com.denizenscript.denizencore.utilities.debugging.Warning;
import java.util.Collection;

public abstract class AbstractFlagTracker {
    public static Warning listFlagsTagWarning = new SlowWarning("The list_flags tag is meant for testing/debugging only. Do not use it in scripts (ignore this warning if using for testing reasons).");

    public abstract ObjectTag getFlagValue(String var1);

    public abstract TimeTag getFlagExpirationTime(String var1);

    public abstract Collection<String> listAllFlags();

    public abstract void setFlag(String var1, ObjectTag var2, TimeTag var3);

    public boolean hasFlag(String key) {
        return this.getFlagValue(key) != null;
    }

    public ElementTag doHasFlagTag(Attribute attribute) {
        if (!attribute.hasContext(1)) {
            attribute.echoError("The has_flag[...] tag must have an input!");
            return null;
        }
        return new ElementTag(this.hasFlag(attribute.getContext(1)));
    }

    public ObjectTag doFlagTag(Attribute attribute) {
        if (!attribute.hasContext(1)) {
            attribute.echoError("The flag[...] tag must have an input!");
            return null;
        }
        if (attribute.getAttributeWithoutContext(2).equals("is_expired")) {
            Deprecations.flagIsExpiredTag.warn(attribute.context);
            return new ElementTag(!this.hasFlag(attribute.getContext(1)));
        }
        if (attribute.getAttributeWithoutContext(2).equals("expiration")) {
            Deprecations.flagExpirationTag.warn(attribute.context);
            return this.getFlagExpirationTime(attribute.getContext(1));
        }
        return this.getFlagValue(attribute.getContext(1));
    }

    public TimeTag doFlagExpirationTag(Attribute attribute) {
        if (!attribute.hasContext(1)) {
            attribute.echoError("The flag_expiration[...] tag must have an input!");
            return null;
        }
        return this.getFlagExpirationTime(attribute.getContext(1));
    }

    public ListTag doListFlagsTag(Attribute attribute) {
        listFlagsTagWarning.warn(attribute.context);
        ListTag list = new ListTag();
        list.addAll((Collection<? extends String>)this.listAllFlags());
        return list;
    }
}

