/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.ImprovedOfflinePlayer;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.notable.NotableManager;
import com.denizenscript.denizen.scripts.containers.core.InventoryScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.InventoryScriptHelper;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.inventory.InventoryTrackerSystem;
import com.denizenscript.denizen.utilities.inventory.RecipeHelper;
import com.denizenscript.denizen.utilities.inventory.SlotHelper;
import com.denizenscript.denizen.utilities.nbt.CustomNBT;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.Note;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.HorseInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class InventoryTag
implements ObjectTag,
Notable,
Adjustable {
    public static final int maxSlots = 54;
    public static final String[] idTypes = new String[]{"npc", "player", "crafting", "enderchest", "workbench", "entity", "location", "generic"};
    public boolean isSaving = false;
    public static final ElementTag defaultIdHolder = new ElementTag("unknown");
    public String idType = null;
    public ObjectTag idHolder = defaultIdHolder;
    public Long uniquifier = null;
    public Inventory inventory = null;
    public String prefix = this.getObjectType();
    public static ObjectTagProcessor<InventoryTag> tagProcessor = new ObjectTagProcessor();

    public static void trackTemporaryInventory(InventoryTag tagForm) {
        if (tagForm == null) {
            return;
        }
        InventoryTrackerSystem.trackTemporaryInventory(tagForm.inventory, tagForm);
    }

    public static void setupInventoryTracker() {
        InventoryTrackerSystem.setup();
    }

    public static InventoryTag mirrorBukkitInventory(Inventory inventory) {
        if (inventory == null) {
            return null;
        }
        InventoryTag result = InventoryTrackerSystem.getTagFormFor(inventory);
        if (result != null) {
            return result;
        }
        result = InventoryScriptHelper.notedInventories.get(inventory);
        if (result != null) {
            return result;
        }
        for (Map.Entry<UUID, PlayerInventory> entry : ImprovedOfflinePlayer.offlineInventories.entrySet()) {
            if (!entry.getValue().equals(inventory)) continue;
            return new InventoryTag(NMSHandler.getPlayerHelper().getOfflineData(entry.getKey()));
        }
        for (Map.Entry<UUID, PlayerInventory> entry : ImprovedOfflinePlayer.offlineEnderChests.entrySet()) {
            if (!((Inventory)entry.getValue()).equals(inventory)) continue;
            return new InventoryTag(NMSHandler.getPlayerHelper().getOfflineData(entry.getKey()), true);
        }
        return new InventoryTag(inventory);
    }

    @Override
    public boolean isUnique() {
        return NotableManager.isSaved(this);
    }

    @Override
    @Note(value="Inventories")
    public String getSaveObject() {
        this.isSaving = true;
        try {
            String string = "in@" + this.idType + PropertyParser.getPropertiesString(this);
            return string;
        }
        finally {
            this.isSaving = false;
        }
    }

    public void setInventory(Inventory inventory) {
        if (this.isUnique()) {
            InventoryScriptHelper.notedInventories.remove(this.inventory);
            InventoryScriptHelper.notedInventories.put(inventory, this);
        }
        this.inventory = inventory;
    }

    @Override
    public void makeUnique(String id) {
        this.uniquifier = null;
        String title = NMSHandler.getInstance().getTitle(this.inventory);
        if (title == null || title.startsWith("container.")) {
            title = this.inventory.getType().getDefaultTitle();
        }
        ItemStack[] contents = this.inventory.getContents();
        this.inventory = this.getInventoryType() == InventoryType.CHEST ? Bukkit.getServer().createInventory(null, this.inventory.getSize(), title) : Bukkit.getServer().createInventory(null, this.inventory.getType(), title);
        this.inventory.setContents(contents);
        InventoryScriptHelper.notedInventories.put(this.inventory, this);
        if (!this.idType.equals("generic") && !this.idType.equals("script")) {
            this.idType = "generic";
            this.idHolder = new ElementTag(CoreUtilities.toLowerCase(this.getInventoryType().name()));
        }
        NotableManager.saveAs(this, id);
    }

    @Override
    public void forget() {
        NotableManager.remove(this);
        InventoryScriptHelper.notedInventories.remove(this.inventory);
    }

    public static InventoryTag valueOf(String string, PlayerTag player, NPCTag npc, boolean silent) {
        return InventoryTag.valueOf(string, new BukkitTagContext(player, npc, null, !silent, null));
    }

    public static InventoryTag valueOf(String string, PlayerTag player, NPCTag npc) {
        return InventoryTag.valueOf(string, player, npc, false);
    }

    public static InventoryTag internalGetInventoryFor(TagContext context, List<String> properties) {
        ScriptTag script;
        InventoryType type;
        String typeName = properties.get(0);
        String holder = null;
        int size = -1;
        for (String property : properties) {
            if (property.startsWith("holder=")) {
                holder = ObjectFetcher.unescapeProperty(property.substring("holder=".length()));
                continue;
            }
            if (property.startsWith("script_name=")) {
                holder = ObjectFetcher.unescapeProperty(property.substring("script_name=".length()));
                typeName = "script";
                continue;
            }
            if (property.startsWith("uniquifier=")) {
                String idText = property.substring("uniquifier=".length());
                if (!ArgumentHelper.matchesInteger(idText)) {
                    return null;
                }
                long id = Long.parseLong(idText);
                InventoryTag fixedResult = InventoryTrackerSystem.idTrackedInventories.get(id);
                if (fixedResult == null) continue;
                InventoryTag.trackTemporaryInventory(fixedResult);
                return fixedResult;
            }
            if (!property.startsWith("size=")) continue;
            String sizeText = property.substring("size=".length());
            if (!ArgumentHelper.matchesInteger(sizeText)) {
                return null;
            }
            size = Integer.parseInt(sizeText);
        }
        if (holder != null) {
            if (typeName.equals("player") || typeName.equals("enderchest") || typeName.equals("workbench") || typeName.equals("crafting")) {
                PlayerTag player = PlayerTag.valueOf(holder, context);
                if (player == null) {
                    if (context == null || context.showErrors()) {
                        Debug.echoError("Invalid inventory player '" + holder + "'");
                    }
                    return null;
                }
                if (typeName.equals("player")) {
                    return player.getInventory();
                }
                if (typeName.equals("enderchest")) {
                    return player.getEnderChest();
                }
                if (typeName.equals("workbench")) {
                    return player.getWorkbench();
                }
                if (typeName.equals("crafting")) {
                    Inventory opened = player.getPlayerEntity().getOpenInventory().getTopInventory();
                    if (opened instanceof CraftingInventory) {
                        return new InventoryTag(opened, (InventoryHolder)player.getPlayerEntity());
                    }
                    return player.getInventory();
                }
            } else {
                if (typeName.equals("npc")) {
                    NPCTag npc = NPCTag.valueOf(holder, context);
                    if (npc == null) {
                        if (context == null || context.showErrors()) {
                            Debug.echoError("Invalid inventory npc '" + holder + "'");
                        }
                        return null;
                    }
                    return npc.getDenizenInventory();
                }
                if (typeName.equals("entity")) {
                    EntityTag entity = EntityTag.valueOf(holder, context);
                    if (entity == null) {
                        if (context == null || context.showErrors()) {
                            Debug.echoError("Invalid inventory entity '" + holder + "'");
                        }
                        return null;
                    }
                    return entity.getInventory();
                }
                if (typeName.equals("location")) {
                    LocationTag location = LocationTag.valueOf(holder, context);
                    if (location == null) {
                        if (context == null || context.showErrors()) {
                            Debug.echoError("Invalid inventory location '" + holder + "'");
                        }
                        return null;
                    }
                    return location.getInventory();
                }
            }
        }
        InventoryTag result = null;
        if (typeName.equals("generic")) {
            if (holder != null && !new ElementTag(holder).matchesEnum((Enum[])InventoryType.values())) {
                if (context == null || context.showErrors()) {
                    Debug.echoError("Unknown inventory type '" + holder + "'");
                }
                return null;
            }
            InventoryType inventoryType = type = holder == null ? InventoryType.CHEST : InventoryType.valueOf((String)holder.toUpperCase());
            result = size == -1 || type != InventoryType.CHEST ? new InventoryTag(type) : new InventoryTag(size);
        } else if (typeName.equals("script") && holder != null) {
            script = ScriptTag.valueOf(holder, context);
            if (script == null || !(script.getContainer() instanceof InventoryScriptContainer)) {
                if (context == null || context.showErrors()) {
                    Debug.echoError("Unknown inventory script '" + holder + "'");
                }
                return null;
            }
            result = ((InventoryScriptContainer)script.getContainer()).getInventoryFrom(context);
            if (size != -1) {
                result.setSize(size);
            }
        }
        if (result == null && (script = ScriptTag.valueOf(holder, context)) != null && script.getContainer() instanceof InventoryScriptContainer) {
            result = ((InventoryScriptContainer)script.getContainer()).getInventoryFrom(context);
        }
        if (result == null && new ElementTag(typeName).matchesEnum((Enum[])InventoryType.values())) {
            type = InventoryType.valueOf((String)typeName.toUpperCase());
            result = size == -1 || type != InventoryType.CHEST ? new InventoryTag(type) : new InventoryTag(size);
        }
        if (result == null) {
            if (context == null || context.showErrors()) {
                Debug.echoError("Unknown inventory idType '" + typeName + "'");
            }
            return null;
        }
        InventoryTag.internalApplyPropertySet(result, context, properties);
        return result;
    }

    public static void internalApplyPropertySet(InventoryTag result, TagContext context, List<String> properties) {
        for (int i = 1; i < properties.size(); ++i) {
            List<String> data = CoreUtilities.split(properties.get(i), '=', 2);
            if (data.size() != 2) {
                if (context != null && !context.showErrors()) continue;
                Debug.echoError("Invalid property string '" + properties.get(i) + "'!");
                continue;
            }
            String name = CoreUtilities.toLowerCase(data.get(0));
            String description = ObjectFetcher.unescapeProperty(data.get(1));
            ElementTag descriptionElement = new ElementTag(description);
            Mechanism mechanism = new Mechanism(new ElementTag(data.get(0)), descriptionElement, context);
            if (name.equals("holder") || name.equals("uniquifier") || name.equals("size") || name.equals("script_name")) continue;
            result.safeAdjust(mechanism);
        }
    }

    @Fetchable(value="in")
    public static InventoryTag valueOf(String string, TagContext context) {
        List<String> properties;
        if (string == null) {
            return null;
        }
        if (string.startsWith("in@")) {
            string = string.substring("in@".length());
        }
        if ((properties = ObjectFetcher.separateProperties(string)) != null && properties.size() > 1) {
            InventoryTag result = InventoryTag.internalGetInventoryFor(context, properties);
            if (result == null) {
                if (context == null || context.showErrors()) {
                    Debug.echoError("Value of InventoryTag returning null. Invalid InventoryTag-with-properties specified: " + string);
                }
                return null;
            }
            InventoryTag.trackTemporaryInventory(result);
            return result;
        }
        Notable noted = NotableManager.getSavedObject(string);
        if (noted instanceof InventoryTag) {
            return (InventoryTag)noted;
        }
        if (ScriptRegistry.containsScript(string, InventoryScriptContainer.class)) {
            return ScriptRegistry.getScriptContainerAs(string, InventoryScriptContainer.class).getInventoryFrom(context);
        }
        if (new ElementTag(string).matchesEnum((Enum[])InventoryType.values())) {
            InventoryType type = InventoryType.valueOf((String)string.toUpperCase());
            return new InventoryTag(type);
        }
        if (context == null || context.showErrors()) {
            Debug.echoError("Value of InventoryTag returning null. Invalid InventoryTag specified: " + string);
        }
        return null;
    }

    public static boolean matches(String arg) {
        if (CoreUtilities.toLowerCase(arg).startsWith("in@")) {
            return true;
        }
        String tid = arg;
        if (arg.contains("[")) {
            tid = arg.substring(0, arg.indexOf(91));
        }
        if (new ElementTag(tid).matchesEnum((Enum[])InventoryType.values())) {
            return true;
        }
        if (ScriptRegistry.containsScript(tid, InventoryScriptContainer.class)) {
            return true;
        }
        if (NotableManager.isType(tid, InventoryTag.class)) {
            return true;
        }
        for (String idType : idTypes) {
            if (!tid.equalsIgnoreCase(idType)) continue;
            return true;
        }
        return false;
    }

    public boolean isGeneric() {
        return this.idType.equals("generic") || this.idType.equals("script") && !this.isUnique();
    }

    private InventoryTag(Inventory inventory) {
        this.inventory = inventory;
        this.loadIdentifiers(inventory.getHolder());
    }

    public InventoryTag(Inventory inventory, InventoryHolder holder) {
        this.inventory = inventory;
        this.loadIdentifiers(holder);
    }

    public InventoryTag(ItemStack[] items) {
        this.inventory = Bukkit.getServer().createInventory(null, (int)Math.ceil((double)items.length / 9.0) * 9);
        this.idType = "generic";
        this.idHolder = new ElementTag("chest");
        this.setContents(items);
    }

    public InventoryTag(ImprovedOfflinePlayer offlinePlayer) {
        this(offlinePlayer, false);
    }

    public InventoryTag(ImprovedOfflinePlayer offlinePlayer, boolean isEnderChest) {
        this.inventory = isEnderChest ? offlinePlayer.getEnderChest() : offlinePlayer.getInventory();
        this.idType = isEnderChest ? "enderchest" : "player";
        this.idHolder = new PlayerTag(offlinePlayer.getUniqueId());
    }

    public InventoryTag(int size, String title) {
        if (size <= 0 || size % 9 != 0) {
            Debug.echoError("InventorySize must be multiple of 9, and greater than 0.");
            return;
        }
        this.inventory = Bukkit.getServer().createInventory(null, size, title);
        this.idType = "generic";
        this.idHolder = new ElementTag("chest");
    }

    public InventoryTag(InventoryType type) {
        this.inventory = Bukkit.getServer().createInventory(null, type);
        this.idType = "generic";
        this.idHolder = new ElementTag(CoreUtilities.toLowerCase(type.name()));
    }

    public InventoryTag(InventoryType type, String title) {
        this.inventory = Bukkit.getServer().createInventory(null, type, title);
        this.idType = "generic";
        this.idHolder = new ElementTag(CoreUtilities.toLowerCase(type.name()));
    }

    public InventoryTag(int size) {
        this(size, "Chest");
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public boolean containsItem(ItemTag item, int amount) {
        if (item == null) {
            return false;
        }
        item = new ItemTag(item.getItemStack().clone());
        item.setAmount(1);
        String myItem = CoreUtilities.toLowerCase(item.identify());
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            ItemStack is = this.inventory.getItem(i);
            if (is == null || item.getMaterial().getMaterial() != is.getType()) continue;
            is = is.clone();
            int count = is.getAmount();
            is.setAmount(1);
            String newItem = CoreUtilities.toLowerCase(new ItemTag(is).identify());
            if (!myItem.equals(newItem) || !(count <= amount ? (amount -= count) == 0 : count > amount)) continue;
            return true;
        }
        return false;
    }

    public void setSize(int size) {
        String title;
        if (!this.getIdType().equals("generic") && !this.getIdType().equals("script")) {
            return;
        }
        if (size <= 0 || size % 9 != 0) {
            Debug.echoError("InventorySize must be multiple of 9, and greater than 0.");
            return;
        }
        if (this.inventory == null) {
            this.inventory = Bukkit.getServer().createInventory(null, size, "Chest");
            return;
        }
        int oldSize = this.inventory.getSize();
        if (oldSize == size) {
            return;
        }
        ItemStack[] oldContents = this.inventory.getContents();
        ItemStack[] newContents = new ItemStack[size];
        if (oldSize > size) {
            for (int i = 0; i < size; ++i) {
                newContents[i] = oldContents[i];
            }
        } else {
            newContents = oldContents;
        }
        if ((title = NMSHandler.getInstance().getTitle(this.inventory)) == null) {
            this.setInventory(Bukkit.getServer().createInventory(null, size));
        } else {
            this.setInventory(Bukkit.getServer().createInventory(null, size, title));
        }
        this.inventory.setContents(newContents);
        InventoryTag.trackTemporaryInventory(this);
    }

    private void loadIdentifiers(InventoryHolder holder) {
        if (this.inventory == null) {
            return;
        }
        InventoryTag realInv = InventoryTrackerSystem.getTagFormFor(this.inventory);
        if (realInv != null) {
            Debug.echoError("Tried to load already-tracked inventory as new inventory?");
            return;
        }
        InventoryTag.trackTemporaryInventory(this);
        if (holder != null) {
            if (holder instanceof NPCTag) {
                this.idType = "npc";
                this.idHolder = (NPCTag)holder;
                return;
            }
            if (holder instanceof Player) {
                if (Depends.citizens != null && CitizensAPI.getNPCRegistry().isNPC((Entity)((Player)holder))) {
                    this.idType = "npc";
                    this.idHolder = NPCTag.fromEntity((Entity)((Player)holder));
                    return;
                }
                if (this.inventory.getType() == InventoryType.CRAFTING) {
                    this.idType = "crafting";
                }
                this.idType = this.inventory.getType() == InventoryType.ENDER_CHEST ? "enderchest" : (this.inventory.getType() == InventoryType.WORKBENCH ? "workbench" : "player");
                this.idHolder = new PlayerTag((Player)holder);
                return;
            }
            if (holder instanceof Entity) {
                this.idType = "entity";
                this.idHolder = new EntityTag((Entity)holder);
                return;
            }
            this.idType = "location";
            this.idHolder = this.getLocation(holder);
            if (this.idHolder != null) {
                return;
            }
        } else if (this.getIdType().equals("player")) {
            if (this.idHolder instanceof PlayerTag) {
                return;
            }
            for (Map.Entry<UUID, PlayerInventory> inv : ImprovedOfflinePlayer.offlineInventories.entrySet()) {
                if (!inv.getValue().equals(this.inventory)) continue;
                this.idHolder = new PlayerTag(inv.getKey());
                return;
            }
        } else if (this.getIdType().equals("enderchest")) {
            if (this.idHolder instanceof PlayerTag) {
                return;
            }
            for (Map.Entry<UUID, Inventory> inv : ImprovedOfflinePlayer.offlineEnderChests.entrySet()) {
                if (!inv.getValue().equals(this.inventory)) continue;
                this.idHolder = new PlayerTag(inv.getKey());
                return;
            }
        } else if (this.getIdType().equals("script")) {
            if (this.idHolder instanceof ScriptTag) {
                return;
            }
            InventoryTag tracked = InventoryTrackerSystem.retainedInventoryLinks.get(this.inventory);
            if (tracked != null) {
                this.idHolder = tracked.idHolder;
                return;
            }
        }
        this.idType = "generic";
        this.idHolder = new ElementTag(CoreUtilities.toLowerCase(this.getInventory().getType().name()));
    }

    public String getIdType() {
        return this.idType == null ? "" : this.idType;
    }

    public ObjectTag getIdHolder() {
        return this.idHolder;
    }

    public LocationTag getLocation() {
        return this.getLocation(this.inventory.getHolder());
    }

    public LocationTag getLocation(InventoryHolder holder) {
        if (this.inventory != null && holder != null) {
            if (holder instanceof BlockState) {
                return new LocationTag(((BlockState)holder).getLocation());
            }
            if (holder instanceof DoubleChest) {
                return new LocationTag(((DoubleChest)holder).getLocation());
            }
            if (holder instanceof Entity) {
                return new LocationTag(((Entity)holder).getLocation());
            }
            if (holder instanceof NPCTag) {
                NPCTag npc = (NPCTag)holder;
                if (npc.getLocation() == null) {
                    return new LocationTag(((NPCTag)holder).getCitizen().getStoredLocation());
                }
                return npc.getLocation();
            }
        }
        return null;
    }

    public ItemStack[] getContents() {
        if (this.inventory != null) {
            return this.inventory.getContents();
        }
        return new ItemStack[0];
    }

    public ItemStack[] getStorageContents() {
        if (this.inventory != null) {
            return this.inventory.getStorageContents();
        }
        return new ItemStack[0];
    }

    public static void addToMapIfNonAir(MapTag map, String name, ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        map.putObject(name, new ItemTag(item));
    }

    public MapTag getEquipmentMap() {
        MapTag output = new MapTag();
        if (this.inventory instanceof PlayerInventory) {
            ItemStack[] equipment = ((PlayerInventory)this.inventory).getArmorContents();
            InventoryTag.addToMapIfNonAir(output, "boots", equipment[0]);
            InventoryTag.addToMapIfNonAir(output, "leggings", equipment[1]);
            InventoryTag.addToMapIfNonAir(output, "chestplate", equipment[2]);
            InventoryTag.addToMapIfNonAir(output, "helmet", equipment[3]);
        } else if (this.inventory instanceof HorseInventory) {
            InventoryTag.addToMapIfNonAir(output, "saddle", ((HorseInventory)this.inventory).getSaddle());
            InventoryTag.addToMapIfNonAir(output, "armor", ((HorseInventory)this.inventory).getArmor());
        } else {
            return null;
        }
        return output;
    }

    public ListTag getEquipment() {
        ItemStack[] equipment = null;
        if (this.inventory instanceof PlayerInventory) {
            equipment = ((PlayerInventory)this.inventory).getArmorContents();
        } else if (this.inventory instanceof HorseInventory) {
            equipment = new ItemStack[]{((HorseInventory)this.inventory).getSaddle(), ((HorseInventory)this.inventory).getArmor()};
        }
        if (equipment == null) {
            return null;
        }
        ListTag equipmentList = new ListTag();
        for (ItemStack item : equipment) {
            equipmentList.addObject(new ItemTag(item));
        }
        return equipmentList;
    }

    public InventoryType getInventoryType() {
        return this.inventory.getType();
    }

    public int getSize() {
        return this.inventory.getSize();
    }

    public void setContents(ItemStack[] contents) {
        this.inventory.setContents(contents);
    }

    public void setContents(ListTag list, TagContext context) {
        int size;
        if (this.inventory == null) {
            size = (int)Math.ceil((double)list.size() / 9.0) * 9;
            if (size == 0) {
                size = 9;
            }
            this.inventory = Bukkit.getServer().createInventory(null, size);
            this.idType = "generic";
            this.idHolder = new ElementTag("chest");
        } else {
            size = this.inventory.getSize();
        }
        ItemStack[] contents = new ItemStack[size];
        int filled = 0;
        for (ItemTag item : list.filter(ItemTag.class, context)) {
            if (filled >= contents.length) {
                Debug.echoError("Cannot set contents of inventory to " + list.size() + " items, as the inventory size is only " + size + "!");
                break;
            }
            contents[filled] = item.getItemStack();
            ++filled;
        }
        while (filled < size) {
            contents[filled] = new ItemStack(Material.AIR);
            ++filled;
        }
        this.inventory.setContents(contents);
        if (Depends.citizens != null && this.idHolder instanceof NPCTag) {
            ((NPCTag)this.idHolder).getInventoryTrait().setContents(contents);
        }
    }

    public int firstPartial(int startSlot, ItemStack item) {
        ItemStack[] inventory = this.getContents();
        if (item == null) {
            return -1;
        }
        for (int i = startSlot; i < inventory.length; ++i) {
            ItemStack item1 = inventory[i];
            if (item1 == null || item1.getAmount() >= item.getMaxStackSize() || !item1.isSimilar(item)) continue;
            return i;
        }
        return -1;
    }

    public int firstEmpty(int startSlot) {
        ItemStack[] inventory = this.getStorageContents();
        for (int i = startSlot; i < inventory.length; ++i) {
            if (inventory[i] != null) continue;
            return i;
        }
        return -1;
    }

    public InventoryTag add(int slot, ItemStack ... items) {
        if (this.inventory == null || items == null) {
            return this;
        }
        block0: for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            if (item == null) continue;
            int amount = item.getAmount();
            int max = item.getMaxStackSize();
            while (true) {
                int firstPartial;
                if ((firstPartial = this.firstPartial(slot, item)) == -1) {
                    int firstFree = this.firstEmpty(slot);
                    if (firstFree == -1) continue block0;
                    if (amount > max) {
                        ItemStack clone = item.clone();
                        clone.setAmount(max);
                        NMSHandler.getItemHelper().setInventoryItem(this.inventory, clone, firstFree);
                        item.setAmount(amount -= max);
                        continue;
                    }
                    NMSHandler.getItemHelper().setInventoryItem(this.inventory, item, firstFree);
                    continue block0;
                }
                ItemStack partialItem = this.inventory.getItem(firstPartial);
                int partialAmount = partialItem.getAmount();
                int total = amount + partialAmount;
                if (total <= max) {
                    partialItem.setAmount(total);
                    continue block0;
                }
                partialItem.setAmount(max);
                amount = total - max;
                item.setAmount(amount);
            }
        }
        return this;
    }

    public List<ItemStack> addWithLeftovers(int slot, boolean keepMaxStackSize, ItemStack ... items) {
        if (this.inventory == null || items == null) {
            return null;
        }
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        block0: for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            if (item == null) continue;
            int amount = item.getAmount();
            int max = keepMaxStackSize ? item.getMaxStackSize() : 64;
            while (true) {
                int firstPartial;
                if ((firstPartial = this.firstPartial(slot, item)) == -1) {
                    int firstFree = this.firstEmpty(slot);
                    if (firstFree == -1) {
                        leftovers.add(item);
                        continue block0;
                    }
                    if (amount > max) {
                        ItemStack clone = item.clone();
                        clone.setAmount(max);
                        NMSHandler.getItemHelper().setInventoryItem(this.inventory, clone, firstFree);
                        item.setAmount(amount -= max);
                        continue;
                    }
                    NMSHandler.getItemHelper().setInventoryItem(this.inventory, item, firstFree);
                    continue block0;
                }
                ItemStack partialItem = this.inventory.getItem(firstPartial);
                int partialAmount = partialItem.getAmount();
                int total = amount + partialAmount;
                if (total <= max) {
                    partialItem.setAmount(total);
                    continue block0;
                }
                partialItem.setAmount(max);
                amount = total - max;
                item.setAmount(amount);
            }
        }
        return leftovers;
    }

    public int countByMaterial(Material material) {
        if (this.inventory == null) {
            return 0;
        }
        int qty = 0;
        for (ItemStack invStack : this.inventory) {
            if (invStack == null || invStack.getType() != material || new ItemTag(invStack).isItemscript()) continue;
            qty += invStack.getAmount();
        }
        return qty;
    }

    public int countByScriptName(String scriptName) {
        if (this.inventory == null) {
            return 0;
        }
        int qty = 0;
        for (ItemStack invStack : this.inventory) {
            ItemTag item;
            if (invStack == null || !(item = new ItemTag(invStack)).isItemscript() || !item.getScriptName().equalsIgnoreCase(scriptName)) continue;
            qty += invStack.getAmount();
        }
        return qty;
    }

    public int count(ItemStack item, boolean stacks) {
        if (this.inventory == null) {
            return 0;
        }
        int qty = 0;
        for (ItemStack invStack : this.inventory) {
            if (invStack == null || item != null && !invStack.isSimilar(item)) continue;
            qty += stacks ? 1 : invStack.getAmount();
        }
        return qty;
    }

    public InventoryTag setSlots(int slot, ItemStack ... items) {
        return this.setSlots(slot, items, items.length);
    }

    public InventoryTag setSlots(int slot, ItemStack[] items, int c) {
        if (this.inventory == null || items == null) {
            return this;
        }
        for (int i = 0; i < c; ++i) {
            if (i >= items.length || items[i] == null) {
                NMSHandler.getItemHelper().setInventoryItem(this.inventory, new ItemStack(Material.AIR), slot + i);
            }
            ItemStack item = items[i];
            if (slot + i < 0 || slot + i >= this.inventory.getSize()) break;
            NMSHandler.getItemHelper().setInventoryItem(this.inventory, item, slot + i);
        }
        if (Depends.citizens != null && this.idHolder instanceof NPCTag) {
            ((NPCTag)this.idHolder).getInventoryTrait().setContents(this.inventory.getContents());
        }
        return this;
    }

    public void clear() {
        if (this.inventory != null) {
            this.inventory.clear();
        }
    }

    @Override
    public String getObjectType() {
        return "Inventory";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public InventoryTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String identify() {
        if (this.isUnique()) {
            return "in@" + NotableManager.getSavedId(this);
        }
        InventoryTag.trackTemporaryInventory(this);
        return "in@" + this.idType + PropertyParser.getPropertiesString(this);
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public static void registerTags() {
        InventoryTag.registerTag("empty_slots", (attribute, object) -> {
            InventoryTag dummyInv;
            if (object.inventory.getType() == InventoryType.PLAYER) {
                ItemStack[] contents = object.getStorageContents();
                if (contents.length != (dummyInv = new InventoryTag(contents.length)).getSize()) {
                    contents = Arrays.copyOf(contents, dummyInv.getSize());
                }
                dummyInv.setContents(contents);
            } else {
                dummyInv = object;
            }
            int full = dummyInv.count(null, true);
            return new ElementTag(dummyInv.getSize() - full);
        }, new String[0]);
        InventoryTag.registerTag("can_fit", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            List<ItemTag> items = attribute.contextAsType(1, ListTag.class).filter(ItemTag.class, attribute.context, !attribute.hasAlternative());
            if (items == null || items.isEmpty()) {
                return null;
            }
            InventoryType type = object.inventory.getType();
            InventoryTag dummyInv = new InventoryTag(type == InventoryType.PLAYER ? InventoryType.CHEST : type, NMSHandler.getInstance().getTitle(object.inventory));
            ItemStack[] contents = object.getStorageContents();
            if (dummyInv.getInventoryType() == InventoryType.CHEST) {
                dummyInv.setSize(contents.length);
            }
            if (contents.length != dummyInv.getSize()) {
                contents = Arrays.copyOf(contents, dummyInv.getSize());
            }
            dummyInv.setContents(contents);
            if (attribute.startsWith("count", 2)) {
                ItemStack toAdd = items.get(0).getItemStack().clone();
                int totalCount = 16384;
                toAdd.setAmount(totalCount);
                List<ItemStack> leftovers = dummyInv.addWithLeftovers(0, true, toAdd);
                int result = 0;
                if (leftovers.size() > 0) {
                    result += leftovers.get(0).getAmount();
                }
                attribute.fulfill(1);
                return new ElementTag(totalCount - result);
            }
            if ((attribute.startsWith("quantity", 2) || attribute.startsWith("qty", 2)) && attribute.hasContext(2)) {
                if (attribute.startsWith("qty", 2)) {
                    Deprecations.qtyTags.warn(attribute.context);
                }
                int qty = attribute.getIntContext(2);
                items.get(0).setAmount(qty);
                attribute.fulfill(1);
            }
            for (ItemTag itm : items) {
                List<ItemStack> leftovers = dummyInv.addWithLeftovers(0, true, itm.getItemStack());
                if (leftovers.isEmpty()) continue;
                return new ElementTag(false);
            }
            return new ElementTag(true);
        }, new String[0]);
        InventoryTag.registerTag("include", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            List<ItemTag> items = ListTag.getListFor(attribute.getContextObject(1), attribute.context).filter(ItemTag.class, attribute.context);
            InventoryTag dummyInv = new InventoryTag(object.inventory.getType(), NMSHandler.getInstance().getTitle(object.inventory));
            if (object.inventory.getType() == InventoryType.CHEST) {
                dummyInv.setSize(object.inventory.getSize());
            }
            dummyInv.setContents(object.getContents());
            if (object.idHolder instanceof ScriptTag) {
                dummyInv.idType = "script";
                dummyInv.idHolder = object.idHolder;
            }
            InventoryTag.trackTemporaryInventory(dummyInv);
            if ((attribute.startsWith("quantity", 2) || attribute.startsWith("qty", 2)) && attribute.hasContext(2)) {
                if (attribute.startsWith("qty", 2)) {
                    Deprecations.qtyTags.warn(attribute.context);
                }
                int qty = attribute.getIntContext(2);
                items.get(0).setAmount(qty);
                attribute.fulfill(1);
            }
            for (ItemTag item : items) {
                dummyInv.add(0, item.getItemStack());
            }
            return dummyInv;
        }, new String[0]);
        InventoryTag.registerTag("exclude", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            List<ItemTag> items = ListTag.getListFor(attribute.getContextObject(1), attribute.context).filter(ItemTag.class, attribute.context);
            InventoryTag dummyInv = new InventoryTag(object.inventory.getType(), NMSHandler.getInstance().getTitle(object.inventory));
            if (object.inventory.getType() == InventoryType.CHEST) {
                dummyInv.setSize(object.inventory.getSize());
            }
            dummyInv.setContents(object.getContents());
            if (object.idHolder instanceof ScriptTag) {
                dummyInv.idType = "script";
                dummyInv.idHolder = object.idHolder;
            }
            InventoryTag.trackTemporaryInventory(dummyInv);
            if ((attribute.startsWith("quantity", 2) || attribute.startsWith("qty", 2)) && attribute.hasContext(2)) {
                if (attribute.startsWith("qty", 2)) {
                    Deprecations.qtyTags.warn(attribute.context);
                }
                int qty = attribute.getIntContext(2);
                items.get(0).setAmount(qty);
                attribute.fulfill(1);
            }
            for (ItemTag item : items) {
                dummyInv.inventory.removeItem(new ItemStack[]{item.getItemStack().clone()});
            }
            return dummyInv;
        }, new String[0]);
        InventoryTag.registerTag("is_empty", (attribute, object) -> {
            boolean empty = true;
            for (ItemStack item : object.getStorageContents()) {
                if (item == null || item.getType() == Material.AIR) continue;
                empty = false;
                break;
            }
            return new ElementTag(empty);
        }, new String[0]);
        InventoryTag.registerTag("is_full", (attribute, object) -> {
            boolean full = true;
            for (ItemStack item : object.getStorageContents()) {
                if (item != null && item.getType() != Material.AIR && item.getAmount() >= item.getMaxStackSize()) continue;
                full = false;
                break;
            }
            return new ElementTag(full);
        }, new String[0]);
        InventoryTag.registerTag("contains", (attribute, object) -> {
            List<ItemTag> contains;
            if (attribute.startsWith("display", 2)) {
                if (!attribute.hasContext(2)) {
                    return null;
                }
                String search_string = attribute.getContext(2);
                boolean strict = false;
                if (CoreUtilities.toLowerCase(search_string).startsWith("strict:") && search_string.length() > 7) {
                    strict = true;
                    search_string = search_string.substring(7);
                }
                if (search_string.length() == 0) {
                    return null;
                }
                int qty = 1;
                if ((attribute.startsWith("quantity", 3) || attribute.startsWith("qty", 3)) && attribute.hasContext(3)) {
                    if (attribute.startsWith("qty", 3)) {
                        Deprecations.qtyTags.warn(attribute.context);
                    }
                    qty = attribute.getIntContext(3);
                    attribute.fulfill(1);
                }
                int found_items = 0;
                if (strict) {
                    for (ItemStack item : object.getContents()) {
                        if (item == null || !item.hasItemMeta()) continue;
                        ItemMeta meta = item.getItemMeta();
                        if (!(item.getType() == Material.WRITTEN_BOOK && ((BookMeta)meta).getTitle().equalsIgnoreCase(search_string) ? (found_items += item.getAmount()) >= qty : meta.hasDisplayName() && meta.getDisplayName().equalsIgnoreCase(search_string) && (found_items += item.getAmount()) >= qty)) {
                            continue;
                        }
                        break;
                    }
                } else {
                    for (ItemStack item : object.getContents()) {
                        if (item == null || !item.hasItemMeta()) continue;
                        ItemMeta meta = item.getItemMeta();
                        if (!(item.getType() == Material.WRITTEN_BOOK && CoreUtilities.toLowerCase(((BookMeta)meta).getTitle()).contains(CoreUtilities.toLowerCase(search_string)) ? (found_items += item.getAmount()) >= qty : meta.hasDisplayName() && CoreUtilities.toLowerCase(meta.getDisplayName()).contains(CoreUtilities.toLowerCase(search_string)) && (found_items += item.getAmount()) >= qty)) {
                            continue;
                        }
                        break;
                    }
                }
                attribute.fulfill(1);
                return new ElementTag(found_items >= qty);
            }
            if (attribute.startsWith("lore", 2)) {
                if (!attribute.hasContext(2)) {
                    return null;
                }
                String search_string = attribute.getContext(2);
                boolean strict = false;
                if (CoreUtilities.toLowerCase(search_string).startsWith("strict:")) {
                    strict = true;
                    search_string = search_string.substring("strict:".length());
                }
                if (search_string.length() == 0) {
                    return null;
                }
                ListTag lore = ListTag.valueOf(search_string, attribute.context);
                int qty = 1;
                if ((attribute.startsWith("quantity", 3) || attribute.startsWith("qty", 3)) && attribute.hasContext(3)) {
                    if (attribute.startsWith("qty", 3)) {
                        Deprecations.qtyTags.warn(attribute.context);
                    }
                    qty = attribute.getIntContext(3);
                    attribute.fulfill(1);
                }
                int found_items2 = 0;
                if (strict) {
                    block2: for (ItemStack item : object.getContents()) {
                        ItemMeta meta;
                        if (item == null || !item.hasItemMeta() || !(meta = item.getItemMeta()).hasLore()) continue;
                        List item_lore = meta.getLore();
                        if (lore.size() != item_lore.size()) continue;
                        for (int i = 0; i < item_lore.size(); ++i) {
                            if (!lore.get(i).equalsIgnoreCase((String)item_lore.get(i))) continue block2;
                        }
                        if ((found_items2 += item.getAmount()) < qty) {
                            continue;
                        }
                        break;
                    }
                } else {
                    for (ItemStack item : object.getContents()) {
                        ItemMeta meta;
                        if (item == null || !item.hasItemMeta() || !(meta = item.getItemMeta()).hasLore()) continue;
                        List item_lore = meta.getLore();
                        int loreCount = 0;
                        block5: for (String line : lore) {
                            for (String item_line : item_lore) {
                                if (!CoreUtilities.toLowerCase(item_line).contains(CoreUtilities.toLowerCase(line))) continue;
                                ++loreCount;
                                continue block5;
                            }
                        }
                        if (loreCount != lore.size() || (found_items2 += item.getAmount()) < qty) {
                            continue;
                        }
                        break;
                    }
                }
                attribute.fulfill(1);
                return new ElementTag(found_items2 >= qty);
            }
            if (attribute.startsWith("scriptname", 2)) {
                String itemName;
                ItemStack item;
                if (!attribute.hasContext(2)) {
                    return null;
                }
                ListTag scrNameList = attribute.contextAsType(2, ListTag.class);
                HashSet<String> scrNames = new HashSet<String>();
                for (String name : scrNameList) {
                    scrNames.add(CoreUtilities.toLowerCase(name));
                }
                int qty = 1;
                if ((attribute.startsWith("quantity", 3) || attribute.startsWith("qty", 3)) && attribute.hasContext(3)) {
                    if (attribute.startsWith("qty", 3)) {
                        Deprecations.qtyTags.warn(attribute.context);
                    }
                    qty = attribute.getIntContext(3);
                    attribute.fulfill(1);
                }
                int found_items = 0;
                ItemStack[] found_items2 = object.getContents();
                int n = found_items2.length;
                for (int i = 0; !(i >= n || (item = found_items2[i]) != null && (itemName = new ItemTag(item).getScriptName()) != null && scrNames.contains(CoreUtilities.toLowerCase(itemName)) && (found_items += item.getAmount()) >= qty); ++i) {
                }
                attribute.fulfill(1);
                return new ElementTag(found_items >= qty);
            }
            if (attribute.startsWith("nbt", 2)) {
                ItemStack item;
                if (!attribute.hasContext(2)) {
                    return null;
                }
                String keyName = attribute.getContext(2);
                int qty = 1;
                if ((attribute.startsWith("quantity", 3) || attribute.startsWith("qty", 3)) && attribute.hasContext(3)) {
                    if (attribute.startsWith("qty", 3)) {
                        Deprecations.qtyTags.warn(attribute.context);
                    }
                    qty = attribute.getIntContext(3);
                    attribute.fulfill(1);
                }
                int found_items = 0;
                ItemStack[] itemStackArray = object.getContents();
                int found_items2 = itemStackArray.length;
                for (int i = 0; !(i >= found_items2 || CustomNBT.hasCustomNBT(item = itemStackArray[i], keyName, "Denizen NBT") && (found_items += item.getAmount()) >= qty); ++i) {
                }
                attribute.fulfill(1);
                return new ElementTag(found_items >= qty);
            }
            if (attribute.startsWith("material", 2)) {
                if (!attribute.hasContext(2)) {
                    return null;
                }
                List<MaterialTag> materials = attribute.contextAsType(2, ListTag.class).filter(MaterialTag.class, attribute.context);
                int qty = 1;
                if ((attribute.startsWith("quantity", 3) || attribute.startsWith("qty", 3)) && attribute.hasContext(3)) {
                    if (attribute.startsWith("qty", 3)) {
                        Deprecations.qtyTags.warn(attribute.context);
                    }
                    qty = attribute.getIntContext(3);
                    attribute.fulfill(1);
                }
                int found_items = 0;
                block10: for (ItemStack item : object.getContents()) {
                    if (item == null) continue;
                    for (MaterialTag material : materials) {
                        if (item.getType() != material.getMaterial() || new ItemTag(item).isItemscript() || (found_items += item.getAmount()) < qty) continue;
                        break block10;
                    }
                }
                attribute.fulfill(1);
                return new ElementTag(found_items >= qty);
            }
            if (!attribute.hasContext(1)) {
                return null;
            }
            ListTag list = attribute.contextAsType(1, ListTag.class);
            if (list.isEmpty()) {
                return null;
            }
            int qty = 1;
            if ((attribute.startsWith("quantity", 2) || attribute.startsWith("qty", 2)) && attribute.hasContext(2)) {
                if (attribute.startsWith("qty", 2)) {
                    Deprecations.qtyTags.warn(attribute.context);
                }
                qty = attribute.getIntContext(2);
                attribute.fulfill(1);
            }
            if ((contains = list.filter(ItemTag.class, attribute.context, !attribute.hasAlternative())).size() == list.size()) {
                for (ItemTag item : contains) {
                    if (object.containsItem(item, qty)) continue;
                    return new ElementTag(false);
                }
                return new ElementTag(true);
            }
            return new ElementTag(false);
        }, new String[0]);
        InventoryTag.registerTag("contains_any", (attribute, object) -> {
            List<ItemTag> contains;
            if (!attribute.hasContext(1)) {
                return null;
            }
            ListTag list = attribute.contextAsType(1, ListTag.class);
            if (list.isEmpty()) {
                return null;
            }
            int qty = 1;
            if ((attribute.startsWith("quantity", 2) || attribute.startsWith("qty", 2)) && attribute.hasContext(2)) {
                if (attribute.startsWith("qty", 2)) {
                    Deprecations.qtyTags.warn(attribute.context);
                }
                qty = attribute.getIntContext(2);
                attribute.fulfill(1);
            }
            if (!(contains = list.filter(ItemTag.class, attribute.context, !attribute.hasAlternative())).isEmpty()) {
                for (ItemTag item : contains) {
                    if (!object.containsItem(item, qty)) continue;
                    return new ElementTag(true);
                }
            }
            return new ElementTag(false);
        }, new String[0]);
        InventoryTag.registerTag("first_empty", (attribute, object) -> {
            int val = object.firstEmpty(0);
            return new ElementTag(val >= 0 ? val + 1 : -1);
        }, new String[0]);
        InventoryTag.registerTag("find", (attribute, object) -> {
            if (attribute.startsWith("material", 2)) {
                ListTag list = attribute.contextAsType(2, ListTag.class);
                if (list == null) {
                    return null;
                }
                HashSet<Material> materials = new HashSet<Material>();
                for (ObjectTag obj : list.objectForms) {
                    materials.add(obj.asType(MaterialTag.class, attribute.context).getMaterial());
                }
                int slot = -1;
                for (int i = 0; i < object.inventory.getSize(); ++i) {
                    if (object.inventory.getItem(i) == null || !materials.contains(object.inventory.getItem(i).getType())) continue;
                    slot = i + 1;
                    break;
                }
                attribute.fulfill(1);
                return new ElementTag(slot);
            }
            if (attribute.startsWith("scriptname", 2)) {
                String scrname = attribute.contextAsType(2, ItemTag.class).getScriptName();
                if (scrname == null) {
                    return null;
                }
                int slot = -1;
                for (int i = 0; i < object.inventory.getSize(); ++i) {
                    if (object.inventory.getItem(i) == null || !scrname.equalsIgnoreCase(new ItemTag(object.inventory.getItem(i)).getScriptName())) continue;
                    slot = i + 1;
                    break;
                }
                attribute.fulfill(1);
                return new ElementTag(slot);
            }
            if (!attribute.hasContext(1) || !ItemTag.matches(attribute.getContext(1))) {
                return null;
            }
            ItemTag item = attribute.contextAsType(1, ItemTag.class);
            item.setAmount(1);
            int slot = -1;
            for (int i = 0; i < object.inventory.getSize(); ++i) {
                if (object.inventory.getItem(i) == null) continue;
                ItemTag compare_to = new ItemTag(object.inventory.getItem(i).clone());
                compare_to.setAmount(1);
                if (!item.identify().equalsIgnoreCase(compare_to.identify())) continue;
                slot = i + 1;
                break;
            }
            return new ElementTag(slot);
        }, new String[0]);
        InventoryTag.registerTag("find_imperfect", (attribute, object) -> {
            if (!attribute.hasContext(1) || !ItemTag.matches(attribute.getContext(1))) {
                return null;
            }
            ItemTag item = attribute.contextAsType(1, ItemTag.class);
            item.setAmount(1);
            int slot = -1;
            for (int i = 0; i < object.inventory.getSize(); ++i) {
                if (object.inventory.getItem(i) == null) continue;
                ItemTag compare_to = new ItemTag(object.inventory.getItem(i).clone());
                compare_to.setAmount(1);
                if (!item.identify().equalsIgnoreCase(compare_to.identify()) && !item.getScriptName().equalsIgnoreCase(compare_to.getScriptName())) continue;
                slot = i + 1;
                break;
            }
            return new ElementTag(slot);
        }, new String[0]);
        InventoryTag.registerTag("id_type", (attribute, object) -> new ElementTag(object.idType), new String[0]);
        InventoryTag.registerTag("note_name", (attribute, object) -> {
            String notname = NotableManager.getSavedId(object);
            if (notname == null) {
                return null;
            }
            return new ElementTag(notname);
        }, "notable_name");
        InventoryTag.registerTag("location", (attribute, object) -> object.getLocation(), new String[0]);
        InventoryTag.registerTag("quantity", (attribute, object) -> {
            if (attribute.startsWith("scriptname", 2)) {
                if (!attribute.hasContext(2)) {
                    return null;
                }
                String scriptName = attribute.getContext(2);
                attribute.fulfill(1);
                return new ElementTag(object.countByScriptName(scriptName));
            }
            if (attribute.startsWith("material", 2)) {
                if (!attribute.hasContext(2) || !MaterialTag.matches(attribute.getContext(2))) {
                    return null;
                }
                MaterialTag material = attribute.contextAsType(2, MaterialTag.class);
                attribute.fulfill(1);
                return new ElementTag(object.countByMaterial(material.getMaterial()));
            }
            if (attribute.hasContext(1) && ItemTag.matches(attribute.getContext(1))) {
                return new ElementTag(object.count(attribute.contextAsType(1, ItemTag.class).getItemStack(), false));
            }
            return new ElementTag(object.count(null, false));
        }, "qty");
        InventoryTag.registerTag("stacks", (attribute, object) -> {
            if (attribute.hasContext(1) && ItemTag.matches(attribute.getContext(1))) {
                return new ElementTag(object.count(attribute.contextAsType(1, ItemTag.class).getItemStack(), true));
            }
            return new ElementTag(object.count(null, true));
        }, new String[0]);
        InventoryTag.registerTag("slot", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            ListTag slots = ListTag.getListFor(attribute.getContextObject(1), attribute.context);
            if (slots.isEmpty()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("Cannot get a list of zero slots.");
                }
                return null;
            }
            if (slots.size() == 1) {
                int slot = SlotHelper.nameToIndex(attribute.getContext(1));
                if (slot < 0) {
                    slot = 0;
                } else if (slot > object.getInventory().getSize() - 1) {
                    slot = object.getInventory().getSize() - 1;
                }
                return new ItemTag(object.getInventory().getItem(slot));
            }
            ListTag result = new ListTag();
            for (String slotText : slots) {
                int slot = SlotHelper.nameToIndex(slotText);
                if (slot < 0) {
                    slot = 0;
                } else if (slot > object.getInventory().getSize() - 1) {
                    slot = object.getInventory().getSize() - 1;
                }
                result.addObject(new ItemTag(object.getInventory().getItem(slot)));
            }
            return result;
        }, new String[0]);
        InventoryTag.registerTag("inventory_type", (attribute, object) -> new ElementTag(object.inventory instanceof HorseInventory ? "HORSE" : object.getInventory().getType().name()), new String[0]);
        InventoryTag.registerTag("equipment_map", (attribute, object) -> object.getEquipmentMap(), new String[0]);
        InventoryTag.registerTag("equipment", (attribute, object) -> object.getEquipment(), new String[0]);
        InventoryTag.registerTag("matrix", (attribute, object) -> {
            if (!(object.inventory instanceof CraftingInventory)) {
                return null;
            }
            ListTag recipeList = new ListTag();
            for (ItemStack item : ((CraftingInventory)object.inventory).getMatrix()) {
                if (item != null) {
                    recipeList.addObject(new ItemTag(item));
                    continue;
                }
                recipeList.addObject(new ItemTag(Material.AIR));
            }
            return recipeList;
        }, new String[0]);
        InventoryTag.registerTag("recipe", (attribute, object) -> {
            if (!(object.inventory instanceof CraftingInventory)) {
                return null;
            }
            Recipe recipe = ((CraftingInventory)object.inventory).getRecipe();
            if (recipe == null) {
                return null;
            }
            return new ElementTag(((Keyed)recipe).getKey().toString());
        }, new String[0]);
        InventoryTag.registerTag("craftable_quantity", (attribute, object) -> {
            if (!(object.inventory instanceof CraftingInventory)) {
                return null;
            }
            Recipe recipe = ((CraftingInventory)object.inventory).getRecipe();
            if (recipe == null) {
                return null;
            }
            return new ElementTag(RecipeHelper.getMaximumOutputQuantity(recipe, (CraftingInventory)object.inventory) * recipe.getResult().getAmount());
        }, new String[0]);
        InventoryTag.registerTag("result", (attribute, object) -> {
            ItemStack result;
            if (object.inventory instanceof CraftingInventory) {
                result = ((CraftingInventory)object.inventory).getResult();
            } else if (object.inventory instanceof FurnaceInventory) {
                result = ((FurnaceInventory)object.inventory).getResult();
            } else {
                return null;
            }
            if (result == null) {
                return null;
            }
            return new ItemTag(result);
        }, new String[0]);
        InventoryTag.registerTag("anvil_repair_cost", (attribute, object) -> {
            if (!(object.inventory instanceof AnvilInventory)) {
                return null;
            }
            return new ElementTag(((AnvilInventory)object.inventory).getRepairCost());
        }, new String[0]);
        InventoryTag.registerTag("anvil_max_repair_cost", (attribute, object) -> {
            if (!(object.inventory instanceof AnvilInventory)) {
                return null;
            }
            return new ElementTag(((AnvilInventory)object.inventory).getMaximumRepairCost());
        }, new String[0]);
        InventoryTag.registerTag("anvil_rename_text", (attribute, object) -> {
            if (!(object.inventory instanceof AnvilInventory)) {
                return null;
            }
            return new ElementTag(((AnvilInventory)object.inventory).getRenameText());
        }, new String[0]);
        InventoryTag.registerTag("fuel", (attribute, object) -> {
            if (object.getInventory() instanceof FurnaceInventory) {
                return new ItemTag(((FurnaceInventory)object.getInventory()).getFuel());
            }
            if (object.getInventory() instanceof BrewerInventory) {
                return new ItemTag(((BrewerInventory)object.getInventory()).getFuel());
            }
            return null;
        }, new String[0]);
        InventoryTag.registerTag("input", (attribute, object) -> {
            if (object.getInventory() instanceof FurnaceInventory) {
                return new ItemTag(((FurnaceInventory)object.getInventory()).getSmelting());
            }
            if (object.getInventory() instanceof BrewerInventory) {
                return new ItemTag(((BrewerInventory)object.getInventory()).getIngredient());
            }
            return null;
        }, new String[0]);
        tagProcessor.registerFutureTagDeprecation("smelting", "input");
        InventoryTag.registerTag("property_map", (attribute, object) -> PropertyParser.getPropertiesMap(object), new String[0]);
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<InventoryTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        Debug.echoError("Cannot apply properties to non-generic inventory!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        CraftingInventory craftingInventory;
        CoreUtilities.autoPropertyMechanism(this, mechanism);
        if (mechanism.matches("matrix") && mechanism.requireObject(ListTag.class)) {
            if (!(this.inventory instanceof CraftingInventory)) {
                Debug.echoError("Inventory is not a crafting inventory, cannot set matrix.");
                return;
            }
            craftingInventory = (CraftingInventory)this.inventory;
            List<ItemTag> items = mechanism.valueAsType(ListTag.class).filter(ItemTag.class, mechanism.context);
            ItemStack[] itemStacks = new ItemStack[9];
            for (int i = 0; i < 9 && i < items.size(); ++i) {
                itemStacks[i] = items.get(i).getItemStack();
            }
            craftingInventory.setMatrix(itemStacks);
            ((Player)this.inventory.getHolder()).updateInventory();
        }
        if (mechanism.matches("result") && mechanism.requireObject(ItemTag.class)) {
            if (this.inventory instanceof CraftingInventory) {
                craftingInventory = (CraftingInventory)this.inventory;
                craftingInventory.setResult(mechanism.valueAsType(ItemTag.class).getItemStack());
                ((Player)this.inventory.getHolder()).updateInventory();
            } else if (this.inventory instanceof FurnaceInventory) {
                FurnaceInventory furnaceInventory = (FurnaceInventory)this.inventory;
                furnaceInventory.setResult(mechanism.valueAsType(ItemTag.class).getItemStack());
            } else {
                Debug.echoError("Inventory is not a crafting inventory or furnace inventory, cannot set result.");
            }
        }
        if (mechanism.matches("fuel") && mechanism.requireObject(ItemTag.class)) {
            if (this.inventory instanceof FurnaceInventory) {
                ((FurnaceInventory)this.inventory).setFuel(mechanism.valueAsType(ItemTag.class).getItemStack());
            } else if (this.inventory instanceof BrewerInventory) {
                ((BrewerInventory)this.inventory).setFuel(mechanism.valueAsType(ItemTag.class).getItemStack());
            } else {
                Debug.echoError("Inventory is not a furnace or brewing stand inventory, cannot set fuel.");
            }
        }
        if ((mechanism.matches("input") || mechanism.matches("smelting")) && mechanism.requireObject(ItemTag.class)) {
            if (this.inventory instanceof FurnaceInventory) {
                ((FurnaceInventory)this.inventory).setSmelting(mechanism.valueAsType(ItemTag.class).getItemStack());
            } else if (this.inventory instanceof BrewerInventory) {
                ((BrewerInventory)this.inventory).setIngredient(mechanism.valueAsType(ItemTag.class).getItemStack());
            } else {
                Debug.echoError("Inventory is not a furnace inventory, cannot set smelting.");
            }
        }
        if (mechanism.matches("anvil_max_repair_cost") && mechanism.requireInteger()) {
            if (!(this.inventory instanceof AnvilInventory)) {
                Debug.echoError("Inventory is not an anvil, cannot set max repair cost.");
                return;
            }
            ((AnvilInventory)this.inventory).setMaximumRepairCost(mechanism.getValue().asInt());
        }
        if (mechanism.matches("anvil_repair_cost") && mechanism.requireInteger()) {
            if (!(this.inventory instanceof AnvilInventory)) {
                Debug.echoError("Inventory is not an anvil, cannot set repair cost.");
                return;
            }
            ((AnvilInventory)this.inventory).setRepairCost(mechanism.getValue().asInt());
        }
    }
}

