/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.events;

import com.denizenscript.denizencore.events.OldSmartEvent;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.core.WorldScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ContextSource;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OldEventManager {
    public static Map<String, WorldScriptContainer> world_scripts = new HashMap<String, WorldScriptContainer>();
    public static Map<String, List<WorldScriptContainer>> events = new HashMap<String, List<WorldScriptContainer>>();
    public static Set<OldSmartEvent> smart_events = new HashSet<OldSmartEvent>();

    public static void scanWorldEvents() {
        try {
            if (Debug.showLoading) {
                Debug.log("Scanning " + world_scripts.size() + " world scripts...");
            }
            for (WorldScriptContainer script : world_scripts.values()) {
                if (script == null) {
                    Debug.echoError("Null world script?!");
                    continue;
                }
                if (script.contains("EVENTS")) {
                    YamlConfiguration configSection = script.getConfigurationSection("EVENTS");
                    if (configSection == null) {
                        Debug.echoError("Script '" + script.getName() + "' has an invalid events block!");
                        break;
                    }
                    Set<StringHolder> keys = configSection.getKeys(false);
                    if (keys == null) {
                        Debug.echoError("Script '" + script.getName() + "' has an empty events block!");
                        break;
                    }
                    for (StringHolder eventName1 : keys) {
                        String eventName = eventName1.str.toUpperCase();
                        List<Object> list = events.containsKey(eventName) ? events.get(eventName) : new ArrayList();
                        list.add(script);
                        events.put(eventName, list);
                    }
                    continue;
                }
                Debug.echoError("Script '" + script.getName() + "' does not have an events block!");
            }
            for (OldSmartEvent smartEvent : smart_events) {
                smartEvent.breakDown();
            }
            for (OldSmartEvent smartEvent : smart_events) {
                if (!smartEvent.shouldInitialize(events.keySet())) continue;
                smartEvent._initialize();
            }
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
    }

    public static List<String> trimEvents(List<String> original) {
        ArrayList<String> event = new ArrayList<String>(original);
        ArrayList<String> parsed = new ArrayList<String>();
        if (Debug.showEventsTrimming) {
            Debug.echoApproval("Trimming world events '" + ((Object)event).toString() + '\'');
        }
        block0: for (int i = 0; i < event.size(); ++i) {
            for (int x = 0; x < event.size(); ++x) {
                if (i == x || !((String)event.get(i)).equalsIgnoreCase((String)event.get(x))) continue;
                event.remove(i);
                --i;
                continue block0;
            }
        }
        for (String e : event) {
            if (!events.containsKey("ON " + e.toUpperCase())) continue;
            parsed.add(e);
        }
        return parsed;
    }

    public static List<String> addAlternates(List<String> events) {
        HashSet<String> newEvents = new HashSet<String>();
        for (String event : events) {
            if (event.indexOf(64) == -1) continue;
            StringBuilder sb = new StringBuilder();
            int len = event.length();
            char[] data = event.toCharArray();
            for (int i = 0; i < len; ++i) {
                if (data[i] >= 'a' && data[i] <= 'z' && i + 1 < len) {
                    if (i + 2 < len && data[i + 2] == '@') {
                        i += 2;
                        continue;
                    }
                    if (data[i + 1] == '@') {
                        ++i;
                        continue;
                    }
                }
                sb.append(data[i]);
            }
            newEvents.add(sb.toString());
        }
        ArrayList<String> finalEvents = new ArrayList<String>();
        finalEvents.addAll(events);
        finalEvents.addAll(newEvents);
        return finalEvents;
    }

    public static List<String> doEvents(List<String> eventNames, ScriptEntryData data, Map<String, ObjectTag> context, boolean strip_ids) {
        return OldEventManager.doEvents(OldEventManager.addAlternates(eventNames), data, context);
    }

    public static List<String> doEvents(List<String> eventNames, ScriptEntryData data, Map<String, ObjectTag> context) {
        try {
            List<String> determinations = new ArrayList<String>();
            eventNames = OldEventManager.trimEvents(eventNames);
            for (String eventName : eventNames) {
                if (!events.containsKey("ON " + eventName.toUpperCase())) continue;
                for (WorldScriptContainer script : events.get("ON " + eventName.toUpperCase())) {
                    List<ScriptEntry> entries;
                    if (script == null || (entries = script.getEntries(data, "events.on " + eventName)).isEmpty()) continue;
                    Debug.report(script, "Event", ArgumentHelper.debugObj("Type", "on " + eventName) + script.getAsScriptArg().debug() + data.toString() + (context != null ? ArgumentHelper.debugObj("Context", context.toString()) : ""));
                    Debug.echoDebug(script, Debug.DebugElement.Header, "Building event 'ON " + eventName.toUpperCase() + "' for " + script.getName());
                    ScriptQueue queue = new InstantQueue(script.getName()).addEntries(entries);
                    if (context != null) {
                        OldEventContextSource oecs = new OldEventContextSource();
                        oecs.contexts = context;
                        queue.setContextSource(oecs);
                    }
                    queue.start();
                    if (queue.determinations == null) continue;
                    determinations = queue.determinations;
                }
            }
            return determinations;
        }
        catch (Exception e) {
            Debug.echoError(e);
            return new ArrayList<String>();
        }
    }

    public static class OldEventContextSource
    implements ContextSource {
        public Map<String, ObjectTag> contexts;

        @Override
        public ObjectTag getContext(String name) {
            return this.contexts.get(name);
        }
    }
}

