/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import net.citizensnpcs.trait.Poses;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class PoseCommand
extends AbstractCommand {
    public PoseCommand() {
        this.setName("pose");
        this.setSyntax("pose (add/remove/{assume}) [id:<name>] (player/{npc}) (<location>)");
        this.setRequiredArguments(1, 4);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matches("add", "assume", "remove")) {
                scriptEntry.addObject("action", (Object)Action.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (arg.matchesPrefix("id")) {
                scriptEntry.addObject("pose_id", arg.getValue());
                continue;
            }
            if (arg.matches("player")) {
                scriptEntry.addObject("target", (Object)TargetType.PLAYER);
                continue;
            }
            if (!arg.matchesArgumentType(LocationTag.class)) continue;
            scriptEntry.addObject("pose_loc", arg.asType(LocationTag.class));
        }
        if (!Utilities.entryHasNPC(scriptEntry)) {
            throw new InvalidArgumentsException("This command requires an NPC!");
        }
        if (!scriptEntry.hasObject("pose_id")) {
            throw new InvalidArgumentsException("No ID specified!");
        }
        scriptEntry.defaultObject("target", new Object[]{TargetType.NPC});
        scriptEntry.defaultObject("action", new Object[]{Action.ASSUME});
        if (scriptEntry.getObject("target") == TargetType.PLAYER) {
            if (scriptEntry.getObject("action") != Action.ASSUME) {
                throw new InvalidArgumentsException("You cannot add or remove poses from a player.");
            }
            if (!Utilities.entryHasPlayer(scriptEntry)) {
                throw new InvalidArgumentsException("This command requires a linked player!");
            }
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        TargetType target = (TargetType)((Object)scriptEntry.getObject("target"));
        NPCTag npc = Utilities.getEntryNPC(scriptEntry);
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        String id = (String)scriptEntry.getObject("pose_id");
        LocationTag pose_loc = (LocationTag)scriptEntry.getObjectTag("pose_loc");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugObj("Target", target.toString()) + (target == TargetType.PLAYER ? Utilities.getEntryPlayer(scriptEntry).debug() : "") + npc.debug() + ArgumentHelper.debugObj("Action", action.toString()) + ArgumentHelper.debugObj("Id", id) + (pose_loc != null ? pose_loc.debug() : ""));
        }
        if (!npc.getCitizen().hasTrait(Poses.class)) {
            npc.getCitizen().addTrait(Poses.class);
        }
        Poses poses = (Poses)npc.getCitizen().getOrAddTrait(Poses.class);
        switch (action) {
            case ASSUME: {
                if (!poses.hasPose(id)) {
                    Debug.echoError("Pose \"" + id + "\" doesn't exist for " + npc.toString());
                }
                if (target.name().equals("NPC")) {
                    poses.assumePose(id);
                    break;
                }
                Player player = Utilities.getEntryPlayer(scriptEntry).getPlayerEntity();
                Location location = player.getLocation();
                location.setYaw(poses.getPose(id).getYaw());
                location.setPitch(poses.getPose(id).getPitch());
                player.teleport(location);
                break;
            }
            case ADD: {
                if (poses.addPose(id, (Location)pose_loc)) break;
                Debug.echoError(npc.toString() + " already has that pose!");
                break;
            }
            case REMOVE: {
                if (poses.removePose(id)) break;
                Debug.echoError(npc.toString() + " does not have that pose!");
            }
        }
    }

    private static enum Action {
        ADD,
        REMOVE,
        ASSUME;

    }

    private static enum TargetType {
        NPC,
        PLAYER;

    }
}

