/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.midi;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.SoundHelper;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.midi.MidiUtil;
import com.denizenscript.denizen.utilities.midi.ToneUtil;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.plugin.Plugin;

public class NoteBlockReceiver
implements Receiver,
MetaEventListener {
    public float VOLUME_RANGE = 10.0f;
    private List<EntityTag> entities;
    private LocationTag location;
    private Map<Integer, Integer> channelPatches;
    public String key;
    public Sequencer sequencer;
    public boolean closing = false;
    public Runnable onFinish = null;

    public NoteBlockReceiver(List<EntityTag> entities, String _Key) throws InvalidMidiDataException, IOException {
        this.entities = entities;
        this.location = null;
        this.channelPatches = Maps.newHashMap();
        this.key = _Key;
    }

    public NoteBlockReceiver(LocationTag location, String _Key) throws InvalidMidiDataException, IOException {
        this.entities = null;
        this.location = location;
        this.channelPatches = Maps.newHashMap();
        this.key = _Key;
    }

    public void setSequencer(Sequencer sequencer) {
        this.sequencer = sequencer;
    }

    @Override
    public void meta(MetaMessage meta) {
        if (meta.getType() == 47) {
            this.close();
        }
    }

    @Override
    public void send(MidiMessage m, long time) {
        if (this.closing) {
            return;
        }
        if (m instanceof ShortMessage) {
            ShortMessage smessage = (ShortMessage)m;
            int chan = smessage.getChannel();
            switch (smessage.getCommand()) {
                case 192: {
                    int patch = smessage.getData1();
                    this.channelPatches.put(chan, patch);
                    break;
                }
                case 144: {
                    this.playNote(smessage);
                    break;
                }
                case 128: {
                    break;
                }
                case 252: {
                    this.close();
                }
            }
        }
    }

    public void playNote(ShortMessage message) {
        if (144 != message.getCommand()) {
            return;
        }
        int channel = message.getChannel();
        if (channel == 9) {
            return;
        }
        if (this.channelPatches == null) {
            Debug.echoError("Trying to play notes on closed midi NoteBlockReceiver!");
            return;
        }
        Integer patch = this.channelPatches.get(channel);
        float pitch = (float)ToneUtil.midiToPitch(message);
        float volume = this.VOLUME_RANGE * ((float)message.getData2() / 127.0f);
        SoundHelper soundHelper = NMSHandler.getSoundHelper();
        Sound instrument = soundHelper.getDefaultMidiInstrument();
        if (patch != null) {
            instrument = soundHelper.getMidiInstrumentFromPatch(patch);
        }
        if (this.location != null) {
            this.location.getWorld().playSound((Location)this.location, instrument, volume, pitch);
        } else if (this.entities != null && !this.entities.isEmpty()) {
            for (int i = 0; i < this.entities.size(); ++i) {
                EntityTag entity = this.entities.get(i);
                if (entity.isSpawned()) {
                    if (entity.isPlayer()) {
                        NMSHandler.getSoundHelper().playSound(entity.getPlayer(), (Location)entity.getLocation(), instrument, volume, pitch, "RECORDS");
                        continue;
                    }
                    NMSHandler.getSoundHelper().playSound(null, (Location)entity.getLocation(), instrument, volume, pitch, "RECORDS");
                    continue;
                }
                this.entities.remove(i);
                --i;
            }
        } else {
            this.close();
        }
    }

    @Override
    public void close() {
        if (this.closing) {
            return;
        }
        this.closing = true;
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), () -> {
            MidiUtil.receivers.remove(this.key);
            if (this.sequencer != null) {
                this.sequencer.close();
                this.sequencer = null;
            }
            this.channelPatches.clear();
            this.channelPatches = null;
            this.entities = null;
            this.location = null;
            if (this.onFinish != null) {
                this.onFinish.run();
            }
        }, 1L);
    }
}

