/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.scripts.containers.core.BookScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptHelper;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.nbt.LeatherColorer;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemScriptContainer
extends ScriptContainer {
    String hash = "";
    private ItemTag cleanReference;
    boolean isProcessing = false;

    public ItemScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        this.canRunScripts = false;
        ItemScriptHelper.item_scripts.put(this.getName(), this);
        ItemScriptHelper.item_scripts_by_hash_id.put(ItemScriptHelper.createItemScriptID(this), this);
    }

    public ItemTag getCleanReference() {
        if (this.cleanReference == null) {
            this.cleanReference = this.getItemFrom();
        }
        return new ItemTag(this.cleanReference.getItemStack().clone());
    }

    public String getHashID() {
        return this.hash;
    }

    public void setHashID(String HashID) {
        this.hash = HashID;
    }

    public ItemTag getItemFrom() {
        return this.getItemFrom(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemTag getItemFrom(TagContext context) {
        ItemTag stack;
        if (this.isProcessing) {
            Debug.echoError("Item script contains (or chains to) a reference to itself. Cannot process.");
            return null;
        }
        if (context == null) {
            context = new BukkitTagContext(null, null, new ScriptTag(this));
        } else {
            context = new BukkitTagContext((BukkitTagContext)context);
            context.script = new ScriptTag(this);
        }
        this.isProcessing = true;
        try {
            if (!this.contains("material")) {
                Debug.echoError("Item script '" + this.getName() + "' does not contain a material. Script cannot function.");
                ItemTag itemTag = null;
                return itemTag;
            }
            String material = TagManager.tag(this.getString("material"), context);
            if (material.startsWith("m@")) {
                material = material.substring(2);
            }
            if ((stack = ItemTag.valueOf(material, this)) == null) {
                ItemTag itemTag = null;
                return itemTag;
            }
            if (this.contains("mechanisms")) {
                YamlConfiguration mechs = this.getConfigurationSection("mechanisms");
                for (StringHolder key : mechs.getKeys(false)) {
                    ObjectTag obj = CoreUtilities.objectToTagForm(mechs.get(key.low), context, true, true);
                    stack.safeAdjust(new Mechanism(new ElementTag(key.low), new ElementTag(obj.toString()), context));
                }
            }
            if (this.contains("display name")) {
                String displayName = TagManager.tag(this.getString("display name"), context);
                NMSHandler.getItemHelper().setDisplayName(stack, displayName);
            }
            if (this.contains("bound")) {
                Deprecations.boundWarning.warn(context);
            }
            if (this.contains("lore")) {
                List<String> lore = NMSHandler.getItemHelper().getLore(stack);
                if (lore == null) {
                    lore = new ArrayList<String>();
                }
                for (String line : this.getStringList("lore")) {
                    line = TagManager.tag(line, context);
                    lore.add(line);
                }
                NMSHandler.getItemHelper().setLore(stack, lore);
            }
            if (this.contains("durability")) {
                short durability = Short.valueOf(this.getString("durability"));
                stack.setDurability(durability);
            }
            if (this.contains("enchantments")) {
                for (String enchantment : this.getStringList("enchantments")) {
                    enchantment = TagManager.tag(enchantment, context);
                    try {
                        int level = 1;
                        String[] split = enchantment.split(":");
                        if (split.length > 1) {
                            level = Integer.valueOf(split[1].replace(" ", ""));
                            enchantment = split[0].replace(" ", "");
                        } else {
                            Debug.echoError("Item script '" + this.getName() + "' has enchantment '" + enchantment + "' without a level.");
                        }
                        Enchantment ench = Utilities.getEnchantmentByName(enchantment);
                        if (stack.getItemStack().getType() == Material.ENCHANTED_BOOK) {
                            EnchantmentStorageMeta meta = (EnchantmentStorageMeta)stack.getItemMeta();
                            meta.addStoredEnchant(ench, level, true);
                            stack.setItemMeta((ItemMeta)meta);
                            continue;
                        }
                        stack.getItemStack().addUnsafeEnchantment(ench, level);
                        stack.resetCache();
                    }
                    catch (Exception ex) {
                        Debug.echoError("While constructing '" + this.getName() + "', encountered error: '" + enchantment + "' is an invalid enchantment: " + ex.getClass().getName() + ": " + ex.getMessage());
                        if (!Debug.verbose) continue;
                        Debug.echoError(ex);
                    }
                }
            }
            if (this.contains("color")) {
                String color = TagManager.tag(this.getString("color"), context);
                LeatherColorer.colorArmor(stack, color);
            }
            if (this.contains("book")) {
                BookScriptContainer book = (BookScriptContainer)ScriptRegistry.getScriptContainer(TagManager.tag(this.getString("book"), context).replace("s@", ""));
                stack = book.writeBookTo(stack, context);
            }
            stack.setItemScript(this);
        }
        catch (Exception e) {
            Debug.echoError("Woah! An exception has been called with this item script!");
            Debug.echoError(e);
            stack = null;
        }
        finally {
            this.isProcessing = false;
        }
        return stack;
    }
}

