/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.data.ActionableDataProvider;
import com.denizenscript.denizencore.utilities.data.DataAction;
import com.denizenscript.denizencore.utilities.data.DataActionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;

public class FlagCommand
extends AbstractCommand {
    public FlagCommand() {
        this.setName("flag");
        this.setSyntax("flag [<object>|...] [<name>([<#>])](:<action>)[:<value>] (duration:<value>)");
        this.setRequiredArguments(1, 3);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("targets") && !arg.hasPrefix()) {
                scriptEntry.addObject("targets", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesPrefix("duration") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("flag_action")) {
                scriptEntry.addObject("flag_action", DataActionHelper.parse(new FlagActionProvider(), arg.getRawValue()));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("targets")) {
            throw new InvalidArgumentsException("Must specify flag target(s)!");
        }
        if (!scriptEntry.hasObject("flag_action")) {
            throw new InvalidArgumentsException("Must specify a flag to set!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ListTag targets = (ListTag)scriptEntry.getObjectTag("targets");
        DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        DataAction flagAction = (DataAction)scriptEntry.getObject("flag_action");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), targets.debug() + (duration == null ? "" : duration.debug()) + flagAction.debug());
        }
        if (duration != null) {
            ((FlagActionProvider)flagAction.provider).expiration = new TimeTag(TimeTag.now().millis() + duration.getMillis());
        }
        for (ObjectTag object : targets.objectForms) {
            AbstractFlagTracker tracker;
            if (CoreUtilities.equalsIgnoreCase(object.toString(), "server")) {
                tracker = DenizenCore.getImplementation().getServerFlags();
            } else if (object instanceof FlaggableObject) {
                tracker = ((FlaggableObject)object).getFlagTracker();
            } else {
                FlaggableObject obj = DenizenCore.getImplementation().simpleWordToFlaggable(object.toString(), scriptEntry);
                if (obj != null) {
                    tracker = obj.getFlagTracker();
                } else {
                    Debug.echoError("Cannot flag '" + object + "': that object type is not flaggable!");
                    continue;
                }
            }
            if (tracker == null) {
                Debug.echoError("Something went wrong, cannot flag '" + object + "'...");
                continue;
            }
            ((FlagActionProvider)flagAction.provider).tracker = tracker;
            flagAction.execute(scriptEntry.getContext());
            if (!(object instanceof FlaggableObject)) continue;
            ((FlaggableObject)object).reapplyTracker(tracker);
        }
    }

    public static class FlagActionProvider
    extends ActionableDataProvider {
        public AbstractFlagTracker tracker;
        public TimeTag expiration;

        @Override
        public ObjectTag getValueAt(String keyName) {
            return this.tracker.getFlagValue(keyName);
        }

        @Override
        public void setValueAt(String keyName, ObjectTag value) {
            this.tracker.setFlag(keyName, value, this.expiration);
        }
    }
}

