/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.flags;

import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class MapTagFlagTracker
extends AbstractFlagTracker {
    public MapTag map;
    public static StringHolder valueString = new StringHolder("__value");
    public static StringHolder expirationString = new StringHolder("__expiration");

    public MapTagFlagTracker() {
        this.map = new MapTag();
    }

    public MapTagFlagTracker(MapTag map) {
        this.map = map;
        this.doClean(map);
    }

    public MapTagFlagTracker(String mapTagValue, TagContext context) {
        this(MapTag.valueOf(mapTagValue, context));
    }

    public static boolean isExpired(ObjectTag expirationObj) {
        if (expirationObj == null) {
            return false;
        }
        return TimeTag.now().millis() > ((TimeTag)expirationObj).millis();
    }

    public ObjectTag getFlagValueOfType(String key, StringHolder type) {
        List<String> splitKey = CoreUtilities.split(key, '.');
        String endKey = splitKey.get(splitKey.size() - 1);
        MapTag map = this.map;
        for (int i = 0; i < splitKey.size() - 1; ++i) {
            MapTag subMap = (MapTag)map.getObject(splitKey.get(i));
            if (subMap == null) {
                return null;
            }
            if (MapTagFlagTracker.isExpired(subMap.map.get(expirationString))) {
                return null;
            }
            ObjectTag subValue = subMap.map.get(valueString);
            if (!(subValue instanceof MapTag)) {
                return null;
            }
            map = (MapTag)subValue;
        }
        MapTag obj = (MapTag)map.getObject(endKey);
        if (obj == null) {
            return null;
        }
        ObjectTag value = obj.map.get(type);
        if (value == null) {
            return null;
        }
        if (MapTagFlagTracker.isExpired(obj.map.get(expirationString))) {
            return null;
        }
        if (value instanceof MapTag) {
            return this.deflaggedSubMap((MapTag)value);
        }
        return value;
    }

    @Override
    public ObjectTag getFlagValue(String key) {
        return this.getFlagValueOfType(key, valueString);
    }

    public MapTag deflaggedSubMap(MapTag map) {
        MapTag toReturn = new MapTag();
        for (Map.Entry<StringHolder, ObjectTag> pair : map.map.entrySet()) {
            MapTag subMap = (MapTag)pair.getValue();
            if (MapTagFlagTracker.isExpired(subMap.map.get(expirationString))) continue;
            ObjectTag subValue = subMap.map.get(valueString);
            if (subValue instanceof MapTag) {
                subValue = this.deflaggedSubMap((MapTag)subValue);
            }
            toReturn.map.put(pair.getKey(), subValue);
        }
        return toReturn;
    }

    @Override
    public TimeTag getFlagExpirationTime(String key) {
        return (TimeTag)this.getFlagValueOfType(key, expirationString);
    }

    @Override
    public Collection<String> listAllFlags() {
        ArrayList<String> keys = new ArrayList<String>(this.map.map.size());
        for (StringHolder string : this.map.map.keySet()) {
            keys.add(string.str);
        }
        return keys;
    }

    public void doClean(MapTag map) {
        ArrayList<StringHolder> toRemove = new ArrayList<StringHolder>();
        for (Map.Entry<StringHolder, ObjectTag> entry : map.map.entrySet()) {
            if (MapTagFlagTracker.isExpired(((MapTag)entry.getValue()).map.get(expirationString))) {
                toRemove.add(entry.getKey());
                continue;
            }
            ObjectTag subValue = ((MapTag)entry.getValue()).map.get(valueString);
            if (!(subValue instanceof MapTag)) continue;
            this.doClean((MapTag)subValue);
        }
        for (StringHolder str : toRemove) {
            map.map.remove(str);
        }
    }

    public MapTag flaggifyMapTag(MapTag map) {
        MapTag toReturn = new MapTag();
        for (Map.Entry<StringHolder, ObjectTag> pair : map.map.entrySet()) {
            MapTag flagMap = new MapTag();
            if (pair.getValue() instanceof MapTag) {
                flagMap.map.put(valueString, this.flaggifyMapTag((MapTag)pair.getValue()));
            } else {
                flagMap.map.put(valueString, pair.getValue());
            }
            toReturn.map.put(pair.getKey(), flagMap);
        }
        return toReturn;
    }

    @Override
    public void setFlag(String key, ObjectTag value, TimeTag expiration) {
        List<String> splitKey = CoreUtilities.split(key, '.');
        String endKey = splitKey.get(splitKey.size() - 1);
        MapTag map = this.map;
        for (int i = 0; i < splitKey.size() - 1; ++i) {
            MapTag flagMap = (MapTag)map.getObject(splitKey.get(i));
            if (flagMap == null) {
                flagMap = new MapTag();
                map.putObject(splitKey.get(i), flagMap);
            }
            ObjectTag innerMapTag = flagMap.map.get(valueString);
            flagMap.map.remove(expirationString);
            if (!(innerMapTag instanceof MapTag)) {
                innerMapTag = new MapTag();
                flagMap.map.put(valueString, innerMapTag);
            }
            map = (MapTag)innerMapTag;
        }
        if (value == null) {
            map.map.remove(new StringHolder(endKey));
        } else {
            MapTag mappified;
            MapTag resultMap = new MapTag();
            if (value instanceof MapTag) {
                value = this.flaggifyMapTag((MapTag)value);
            } else if (value instanceof ElementTag && value.toString().startsWith("map@") && (mappified = MapTag.valueOf(value.toString(), CoreUtilities.noDebugContext)) != null) {
                value = this.flaggifyMapTag(mappified);
            }
            resultMap.map.put(valueString, value);
            if (expiration != null) {
                resultMap.map.put(expirationString, expiration);
            }
            map.putObject(endKey, resultMap);
        }
    }

    public String toString() {
        return this.map.toString();
    }
}

