/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.file;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptHelper;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.scheduling.AsyncSchedulable;
import com.denizenscript.denizencore.utilities.scheduling.OneTimeSchedulable;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import com.denizenscript.shaded.org.json.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class YamlCommand
extends AbstractCommand
implements Holdable {
    public Map<String, YamlConfiguration> yamlDocuments = new HashMap<String, YamlConfiguration>();

    public YamlCommand() {
        this.setName("yaml");
        this.setSyntax("yaml [create]/[load:<file>]/[loadtext:<text>]/[unload]/[savefile:<file>]/[copykey:<source_key> <target_key> (to_id:<name>)]/[set <key>([<#>])(:<action>):<value>] [id:<name>]");
        this.setRequiredArguments(2, 4);
        TagManager.registerTagHandler("yaml", this::yamlTagProcess);
        this.isProcedural = false;
    }

    private YamlConfiguration getYaml(String id) {
        if (id == null) {
            Debug.echoError("Trying to get YAML file with NULL ID!");
            return null;
        }
        return this.yamlDocuments.get(CoreUtilities.toLowerCase(id));
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        boolean isSet = false;
        boolean isCopyKey = false;
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("load")) {
                scriptEntry.addObject("action", new ElementTag("LOAD"));
                scriptEntry.addObject("filename", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("loadtext")) {
                scriptEntry.addObject("action", new ElementTag("LOADTEXT"));
                scriptEntry.addObject("raw_text", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("savefile", "filesave")) {
                scriptEntry.addObject("action", new ElementTag("SAVE"));
                scriptEntry.addObject("filename", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matches("create")) {
                scriptEntry.addObject("action", new ElementTag("CREATE"));
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matches("set")) {
                scriptEntry.addObject("action", new ElementTag("SET"));
                isSet = true;
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("copykey")) {
                scriptEntry.addObject("action", new ElementTag("COPYKEY"));
                scriptEntry.addObject("key", arg.asElement());
                isCopyKey = true;
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matches("unload")) {
                scriptEntry.addObject("action", new ElementTag("UNLOAD"));
                continue;
            }
            if (!scriptEntry.hasObject("value") && arg.matchesPrefix("value")) {
                if (arg.matchesArgumentType(ListTag.class)) {
                    scriptEntry.addObject("value", arg.asType(ListTag.class));
                    continue;
                }
                scriptEntry.addObject("value", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("id") && arg.matchesPrefix("id")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("to_id") && arg.matchesPrefix("to_id")) {
                scriptEntry.addObject("to_id", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("split") && arg.matches("split_list")) {
                scriptEntry.addObject("split", new ElementTag("true"));
                continue;
            }
            if (!scriptEntry.hasObject("fix_formatting") && arg.matches("fix_formatting")) {
                Deprecations.yamlFixFormatting.warn(scriptEntry);
                continue;
            }
            if (isSet && !scriptEntry.hasObject("value")) {
                String[] flagArgs;
                if (!arg.canBeElement) {
                    scriptEntry.addObject("yaml_action", (Object)YAML_Action.SET_VALUE);
                    scriptEntry.addObject("key", new ElementTag(arg.prefix));
                    scriptEntry.addObject("value", arg.object);
                    continue;
                }
                int split = arg.getRawValue().split(":", 3).length;
                if (split == 2) {
                    flagArgs = arg.getRawValue().split(":", 2);
                    scriptEntry.addObject("key", new ElementTag(flagArgs[0]));
                    if (flagArgs[1].equals("++") || flagArgs[1].equals("+")) {
                        scriptEntry.addObject("yaml_action", (Object)YAML_Action.INCREASE);
                        scriptEntry.addObject("value", new ElementTag(1));
                        continue;
                    }
                    if (flagArgs[1].equals("--") || flagArgs[1].equals("-")) {
                        scriptEntry.addObject("yaml_action", (Object)YAML_Action.DECREASE);
                        scriptEntry.addObject("value", new ElementTag(1));
                        continue;
                    }
                    if (flagArgs[1].equals("!")) {
                        scriptEntry.addObject("yaml_action", (Object)YAML_Action.DELETE);
                        scriptEntry.addObject("value", new ElementTag(false));
                        continue;
                    }
                    if (flagArgs[1].equals("<-")) {
                        scriptEntry.addObject("yaml_action", (Object)YAML_Action.REMOVE);
                        scriptEntry.addObject("value", new ElementTag(false));
                        continue;
                    }
                    scriptEntry.addObject("yaml_action", (Object)YAML_Action.SET_VALUE);
                    scriptEntry.addObject("value", new ElementTag(flagArgs[1]));
                    continue;
                }
                if (split == 3) {
                    flagArgs = arg.getRawValue().split(":", 3);
                    scriptEntry.addObject("key", new ElementTag(flagArgs[0]));
                    if (flagArgs[1].equals("->")) {
                        scriptEntry.addObject("yaml_action", (Object)YAML_Action.INSERT);
                    } else if (flagArgs[1].equals("<-")) {
                        scriptEntry.addObject("yaml_action", (Object)YAML_Action.REMOVE);
                    } else if (flagArgs[1].equals("||") || flagArgs[1].equals("|")) {
                        scriptEntry.addObject("yaml_action", (Object)YAML_Action.SPLIT);
                    } else if (flagArgs[1].equals("!|")) {
                        scriptEntry.addObject("yaml_action", (Object)YAML_Action.SPLIT_NEW);
                    } else if (flagArgs[1].equals("++") || flagArgs[1].equals("+")) {
                        scriptEntry.addObject("yaml_action", (Object)YAML_Action.INCREASE);
                    } else if (flagArgs[1].equals("--") || flagArgs[1].equals("-")) {
                        scriptEntry.addObject("yaml_action", (Object)YAML_Action.DECREASE);
                    } else if (flagArgs[1].equals("**") || flagArgs[1].equals("*")) {
                        scriptEntry.addObject("yaml_action", (Object)YAML_Action.MULTIPLY);
                    } else if (flagArgs[1].equals("//") || flagArgs[1].equals("/")) {
                        scriptEntry.addObject("yaml_action", (Object)YAML_Action.DIVIDE);
                    } else {
                        scriptEntry.addObject("yaml_action", (Object)YAML_Action.SET_VALUE);
                        scriptEntry.addObject("value", new ElementTag(arg.getRawValue().split(":", 2)[1]));
                        continue;
                    }
                    scriptEntry.addObject("value", new ElementTag(flagArgs[2]));
                    continue;
                }
                arg.reportUnhandled();
                continue;
            }
            if (isCopyKey && !scriptEntry.hasObject("value")) {
                scriptEntry.addObject("value", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("id")) {
            throw new InvalidArgumentsException("Must specify an id!");
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify an action!");
        }
        scriptEntry.defaultObject("value", new ElementTag(""));
    }

    @Override
    public void execute(final ScriptEntry scriptEntry) {
        ElementTag filename = scriptEntry.getElement("filename");
        ElementTag rawText = scriptEntry.getElement("raw_text");
        ElementTag key = scriptEntry.getElement("key");
        Object value = scriptEntry.getObjectTag("value");
        ElementTag split = scriptEntry.getElement("split");
        YAML_Action yaml_action = (YAML_Action)((Object)scriptEntry.getObject("yaml_action"));
        ElementTag actionElement = scriptEntry.getElement("action");
        ElementTag idElement = scriptEntry.getElement("id");
        ElementTag toId = scriptEntry.getElement("to_id");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), idElement.debug() + actionElement.debug() + (filename != null ? filename.debug() : "") + (yaml_action != null ? ArgumentHelper.debugObj("yaml_action", yaml_action.name()) : "") + (key != null ? key.debug() : "") + (value != null ? value.debug() : "") + (split != null ? split.debug() : "") + (rawText != null ? rawText.debug() : "") + (toId != null ? toId.debug() : ""));
        }
        Action action = Action.valueOf(actionElement.asString().toUpperCase());
        final String id = CoreUtilities.toLowerCase(idElement.asString());
        if (action != Action.LOAD && action != Action.SAVE && scriptEntry.shouldWaitFor()) {
            scriptEntry.setFinished(true);
        }
        switch (action) {
            case LOAD: {
                final File file = new File(DenizenCore.getImplementation().getDataFolder(), filename.asString());
                if (!DenizenCore.getImplementation().canReadFile(file)) {
                    Debug.echoError("Server config denies reading files in that location.");
                    scriptEntry.setFinished(true);
                    return;
                }
                if (!file.exists()) {
                    Debug.echoError("File cannot be found!");
                    scriptEntry.setFinished(true);
                    return;
                }
                final YamlConfiguration[] runnableConfigs = new YamlConfiguration[1];
                final Runnable onLoadCompleted = new Runnable(){

                    @Override
                    public void run() {
                        YamlCommand.this.yamlDocuments.remove(id);
                        YamlCommand.this.yamlDocuments.put(id, runnableConfigs[0]);
                        scriptEntry.setFinished(true);
                    }
                };
                Runnable loadRunnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FileInputStream fis = new FileInputStream(file);
                            String str = ScriptHelper.convertStreamToString(fis);
                            fis.close();
                            runnableConfigs[0] = YamlConfiguration.load(str);
                            if (runnableConfigs[0] == null) {
                                runnableConfigs[0] = new YamlConfiguration();
                            }
                            if (scriptEntry.shouldWaitFor()) {
                                DenizenCore.schedule(new OneTimeSchedulable(onLoadCompleted, 0.0f));
                            } else {
                                onLoadCompleted.run();
                            }
                        }
                        catch (Exception e) {
                            Debug.echoError("Failed to load yaml file: " + e);
                        }
                    }
                };
                if (scriptEntry.shouldWaitFor()) {
                    DenizenCore.schedule(new AsyncSchedulable(new OneTimeSchedulable(loadRunnable, 0.0f)));
                    break;
                }
                loadRunnable.run();
                break;
            }
            case LOADTEXT: {
                String str = rawText.asString();
                YamlConfiguration config = YamlConfiguration.load(str);
                this.yamlDocuments.remove(id);
                this.yamlDocuments.put(id, config);
                scriptEntry.setFinished(true);
                break;
            }
            case UNLOAD: {
                if (this.yamlDocuments.containsKey(id)) {
                    this.yamlDocuments.remove(id);
                    break;
                }
                Debug.echoError("Unknown YAML ID '" + id + "'");
                break;
            }
            case SAVE: {
                if (this.yamlDocuments.containsKey(id)) {
                    try {
                        File fileObj;
                        if (!DenizenCore.getImplementation().allowStrangeYAMLSaves()) {
                            fileObj = new File(DenizenCore.getImplementation().getDataFolder().getAbsolutePath() + "/" + filename.asString());
                            String directory = URLDecoder.decode(System.getProperty("user.dir"));
                            if (!fileObj.getCanonicalPath().startsWith(directory)) {
                                Debug.echoError("Outside-the-main-folder YAML saves disabled by administrator.");
                                scriptEntry.setFinished(true);
                                return;
                            }
                        }
                        fileObj = new File(DenizenCore.getImplementation().getDataFolder().getAbsolutePath() + "/" + filename.asString());
                        if (!DenizenCore.getImplementation().canWriteToFile(fileObj)) {
                            Debug.echoError(scriptEntry.getResidingQueue(), "Cannot edit that file!");
                            scriptEntry.setFinished(true);
                            return;
                        }
                        fileObj.getParentFile().mkdirs();
                        YamlConfiguration yaml = this.yamlDocuments.get(id);
                        final String outp = yaml.saveToString(false);
                        yaml.setDirty(false);
                        Runnable saveRunnable = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Charset charset = ScriptHelper.encoding == null ? null : ScriptHelper.encoding.charset();
                                    FileOutputStream fiout = new FileOutputStream(fileObj);
                                    OutputStreamWriter writer = charset == null ? new OutputStreamWriter(fiout) : new OutputStreamWriter((OutputStream)fiout, charset);
                                    writer.write(outp);
                                    writer.close();
                                }
                                catch (IOException e) {
                                    Debug.echoError(e);
                                }
                                scriptEntry.setFinished(true);
                            }
                        };
                        if (scriptEntry.shouldWaitFor()) {
                            DenizenCore.schedule(new AsyncSchedulable(new OneTimeSchedulable(saveRunnable, 0.0f)));
                            break;
                        }
                        saveRunnable.run();
                    }
                    catch (IOException e) {
                        Debug.echoError(e);
                    }
                    break;
                }
                Debug.echoError("Unknown YAML ID '" + id + "'");
                scriptEntry.setFinished(true);
                break;
            }
            case COPYKEY: {
                YamlConfiguration yaml;
                if (!this.yamlDocuments.containsKey(id)) break;
                YamlConfiguration destYaml = yaml = this.yamlDocuments.get(id);
                if (toId != null && (destYaml = this.getYaml(toId.toString())) == null) {
                    Debug.echoError("Unknown YAML TO-ID '" + id + "'");
                    break;
                }
                YamlConfiguration sourceSection = yaml.getConfigurationSection(key.asString());
                if (sourceSection == null) {
                    Debug.echoError("Invalid YAML section key name '" + key.asString() + "'.");
                    break;
                }
                YamlConfiguration newSection = this.copySection(sourceSection);
                destYaml.set(value.toString(), newSection);
                break;
            }
            case SET: {
                if (this.yamlDocuments.containsKey(id)) {
                    if (yaml_action == null || key == null || value == null) {
                        Debug.echoError("Must specify a YAML action, key, and value!");
                        return;
                    }
                    YamlConfiguration yaml = this.yamlDocuments.get(id);
                    int index = -1;
                    if (key.asString().contains("[")) {
                        try {
                            if (Debug.verbose) {
                                Debug.echoDebug((Debuggable)scriptEntry, "Try index: " + key.asString().split("\\[")[1].replace("]", ""));
                            }
                            index = Integer.valueOf(key.asString().split("\\[")[1].replace("]", "")) - 1;
                        }
                        catch (Exception e) {
                            if (Debug.verbose) {
                                Debug.echoError(scriptEntry.getResidingQueue(), e);
                            }
                            index = -1;
                        }
                        key = new ElementTag(key.asString().split("\\[")[0]);
                    }
                    String keyStr = key.asString();
                    String valueStr = yaml_action == YAML_Action.SET_VALUE ? null : value.identify();
                    switch (yaml_action) {
                        case INCREASE: {
                            String originalVal = this.Get(yaml, index, keyStr, "0");
                            if (!ArgumentHelper.matchesDouble(originalVal)) {
                                originalVal = "0";
                            }
                            if (!ArgumentHelper.matchesDouble(valueStr)) {
                                Debug.echoError("YAML action required a decimal number, was given not-a-decimal-number: " + valueStr);
                                return;
                            }
                            this.Set(yaml, index, keyStr, CoreUtilities.doubleToString(Double.parseDouble(originalVal) + Double.parseDouble(valueStr)));
                            break;
                        }
                        case DECREASE: {
                            String originalVal = this.Get(yaml, index, keyStr, "0");
                            if (!ArgumentHelper.matchesDouble(originalVal)) {
                                originalVal = "0";
                            }
                            if (!ArgumentHelper.matchesDouble(valueStr)) {
                                Debug.echoError("YAML action required a decimal number, was given not-a-decimal-number: " + valueStr);
                                return;
                            }
                            this.Set(yaml, index, keyStr, CoreUtilities.doubleToString(Double.parseDouble(originalVal) - Double.parseDouble(valueStr)));
                            break;
                        }
                        case MULTIPLY: {
                            String originalVal = this.Get(yaml, index, keyStr, "1");
                            if (!ArgumentHelper.matchesDouble(originalVal)) {
                                originalVal = "0";
                            }
                            if (!ArgumentHelper.matchesDouble(valueStr)) {
                                Debug.echoError("YAML action required a decimal number, was given not-a-decimal-number: " + valueStr);
                                return;
                            }
                            this.Set(yaml, index, keyStr, CoreUtilities.doubleToString(Double.parseDouble(originalVal) * Double.parseDouble(valueStr)));
                            break;
                        }
                        case DIVIDE: {
                            String originalVal = this.Get(yaml, index, keyStr, "1");
                            if (!ArgumentHelper.matchesDouble(originalVal)) {
                                originalVal = "0";
                            }
                            if (!ArgumentHelper.matchesDouble(valueStr)) {
                                Debug.echoError("YAML action required a decimal number, was given not-a-decimal-number: " + valueStr);
                                return;
                            }
                            this.Set(yaml, index, keyStr, CoreUtilities.doubleToString(Double.parseDouble(originalVal) / Double.parseDouble(valueStr)));
                            break;
                        }
                        case DELETE: {
                            yaml.set(keyStr, null);
                            break;
                        }
                        case SET_VALUE: {
                            this.Set(yaml, index, keyStr, value);
                            break;
                        }
                        case INSERT: {
                            List<String> list = yaml.getStringList(keyStr);
                            if (list == null) {
                                list = new ArrayList<String>();
                            }
                            list.add(valueStr);
                            yaml.set(keyStr, list);
                            break;
                        }
                        case REMOVE: {
                            List<String> list = yaml.getStringList(keyStr);
                            if (list == null) {
                                if (!Debug.verbose) break;
                                Debug.echoDebug((Debuggable)scriptEntry, "List null!");
                                break;
                            }
                            if (index > -1 && index < list.size()) {
                                if (Debug.verbose) {
                                    Debug.echoDebug((Debuggable)scriptEntry, "Remove ind: " + index);
                                }
                                list.remove(index);
                                yaml.set(keyStr, list);
                                break;
                            }
                            if (Debug.verbose) {
                                Debug.echoDebug((Debuggable)scriptEntry, "Remvoe value: " + valueStr);
                            }
                            for (int i = 0; i < list.size(); ++i) {
                                if (!list.get(i).equalsIgnoreCase(valueStr)) continue;
                                list.remove(i);
                                break;
                            }
                            yaml.set(keyStr, list);
                            break;
                        }
                        case SPLIT_NEW: {
                            yaml.set(keyStr, new ArrayList<String>(ListTag.valueOf(valueStr, scriptEntry.getContext())));
                            break;
                        }
                        case SPLIT: {
                            List<String> list = yaml.getStringList(keyStr);
                            if (list == null) {
                                list = new ArrayList<String>();
                            }
                            list.addAll(ListTag.valueOf(valueStr, scriptEntry.getContext()));
                            yaml.set(keyStr, list);
                            break;
                        }
                    }
                    break;
                }
                Debug.echoError("Unknown YAML ID '" + id + "'");
                break;
            }
            case CREATE: {
                this.yamlDocuments.remove(id);
                YamlConfiguration yamlConfiguration = new YamlConfiguration();
                this.yamlDocuments.put(id, yamlConfiguration);
            }
        }
    }

    public YamlConfiguration copySection(YamlConfiguration section) {
        YamlConfiguration newSection = new YamlConfiguration();
        for (StringHolder key : section.getKeys(false)) {
            Object obj = section.get(key.str);
            if (obj instanceof YamlConfiguration) {
                obj = this.copySection((YamlConfiguration)obj);
            }
            newSection.set(key.str, obj);
        }
        return newSection;
    }

    public String Get(YamlConfiguration yaml, int index, String key, String def) {
        if (index == -1) {
            return yaml.getString(key, def);
        }
        List<String> list = yaml.getStringList(key);
        if (index < 0) {
            index = 0;
        }
        if (index > list.size()) {
            index = list.size() - 1;
        }
        if (list.isEmpty()) {
            return "";
        }
        return list.get(index);
    }

    public void Set(YamlConfiguration yaml, int index, String key, Object value) {
        if (index == -1) {
            if (value instanceof MapTag || (value instanceof ElementTag || value instanceof String) && value.toString().startsWith("map@")) {
                MapTag map;
                MapTag mapTag = map = value instanceof MapTag ? (MapTag)value : MapTag.valueOf(value.toString(), CoreUtilities.noDebugContext);
                if (map != null) {
                    yaml.set(key, CoreUtilities.objectTagToJavaForm(map, true));
                    return;
                }
            }
            yaml.set(key, value.toString());
        } else {
            List<String> list = yaml.getStringList(key);
            if (list == null) {
                list = new ArrayList<String>();
            }
            if (index < 0) {
                index = 0;
            }
            if (index >= list.size()) {
                list.add(value.toString());
            } else {
                list.set(index, value.toString());
            }
            yaml.set(key, list);
        }
    }

    public ObjectTag yamlTagProcess(Attribute attribute) {
        String id = attribute.hasContext(1) ? CoreUtilities.toLowerCase(attribute.getContext(1)) : null;
        attribute.fulfill(1);
        if (attribute.startsWith("list")) {
            ListTag list = new ListTag();
            list.addAll((Collection<? extends String>)this.yamlDocuments.keySet());
            return list;
        }
        if (id == null) {
            attribute.echoError("yaml[...] tag must specify a YAML id.");
            return null;
        }
        YamlConfiguration yaml = this.getYaml(id);
        if (yaml == null) {
            attribute.echoError("YAML tag has specified an invalid ID, or the specified id has already been closed. Tag replacement aborted. ID given: '" + id + "'.");
            return null;
        }
        if (attribute.startsWith("contains") && attribute.hasContext(1)) {
            return new ElementTag(yaml.contains(attribute.getContext(1)));
        }
        if (attribute.startsWith("is_list") && attribute.hasContext(1)) {
            return new ElementTag(yaml.isList(attribute.getContext(1)));
        }
        if (attribute.startsWith("parsed_key") && attribute.hasContext(1)) {
            Object obj = yaml.get(attribute.getContext(1));
            if (obj == null) {
                return null;
            }
            return CoreUtilities.objectToTagForm(obj, attribute.context, false, true);
        }
        if (attribute.startsWith("read") && attribute.hasContext(1)) {
            Object obj = yaml.get(attribute.getContext(1));
            if (obj == null) {
                return null;
            }
            return CoreUtilities.objectToTagForm(obj, attribute.context);
        }
        if (attribute.startsWith("list_deep_keys") && attribute.hasContext(1)) {
            Set<StringHolder> keys;
            String path = attribute.getContext(1);
            if (path != null && path.length() > 0) {
                YamlConfiguration section = yaml.getConfigurationSection(path);
                if (section == null) {
                    return null;
                }
                keys = section.getKeys(true);
            } else {
                keys = yaml.getKeys(true);
            }
            if (keys == null) {
                return null;
            }
            return new ListTag(keys);
        }
        if (attribute.startsWith("list_keys") && attribute.hasContext(1)) {
            Set<StringHolder> keys;
            String path = attribute.getContext(1);
            if (path != null && path.length() > 0) {
                YamlConfiguration section = yaml.getConfigurationSection(path);
                if (section == null) {
                    return null;
                }
                keys = section.getKeys(false);
            } else {
                keys = yaml.getKeys(false);
            }
            if (keys == null) {
                return null;
            }
            return new ListTag(keys);
        }
        if (attribute.startsWith("has_changes")) {
            return new ElementTag(yaml.isDirty());
        }
        if (attribute.startsWith("to_json")) {
            return new ElementTag(new JSONObject(yaml.getMap()).toString());
        }
        if (attribute.startsWith("to_text")) {
            return new ElementTag(yaml.saveToString(false));
        }
        return null;
    }

    public static enum YAML_Action {
        SET_VALUE,
        INCREASE,
        DECREASE,
        MULTIPLY,
        DIVIDE,
        INSERT,
        REMOVE,
        SPLIT,
        DELETE,
        SPLIT_NEW;

    }

    public static enum Action {
        LOAD,
        LOADTEXT,
        UNLOAD,
        CREATE,
        SAVE,
        SET,
        COPYKEY;

    }
}

