/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import java.util.Arrays;
import java.util.List;

public class DisguiseCommand
extends AbstractCommand {
    public DisguiseCommand() {
        this.setName("disguise");
        this.setSyntax("disguise [<entity>] [cancel/as:<type>] (players:<player>|...)");
        this.setRequiredArguments(2, 3);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("players") && arg.matchesPrefix("to", "players")) {
                scriptEntry.addObject("players", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            if (arg.matchesPrefix("as") && arg.matchesArgumentType(EntityTag.class)) {
                scriptEntry.addObject("as", arg.asType(EntityTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("entity") && arg.matchesArgumentType(EntityTag.class)) {
                scriptEntry.addObject("entity", arg.asType(EntityTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("cancel") && arg.matches("cancel")) {
                scriptEntry.addObject("cancel", new ElementTag(true));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("players") && Utilities.entryHasPlayer(scriptEntry)) {
            scriptEntry.defaultObject("players", Arrays.asList(Utilities.getEntryPlayer(scriptEntry)));
        }
        if (!scriptEntry.hasObject("as") && !scriptEntry.hasObject("cancel")) {
            throw new InvalidArgumentsException("Must specify a valid type to disguise as!");
        }
        if (!scriptEntry.hasObject("players")) {
            throw new InvalidArgumentsException("Must have a valid, online player attached!");
        }
        if (!scriptEntry.hasObject("entity")) {
            throw new InvalidArgumentsException("Must specify a valid entity!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        EntityTag entity = (EntityTag)scriptEntry.getObjectTag("entity");
        EntityTag as = (EntityTag)scriptEntry.getObjectTag("as");
        ElementTag cancel = scriptEntry.getElement("cancel");
        List players = (List)scriptEntry.getObject("players");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), entity.debug() + (cancel != null ? cancel.debug() : as.debug()) + ArgumentHelper.debugList("players", players));
        }
        if (cancel != null && cancel.asBoolean()) {
            for (PlayerTag player : players) {
                NMSHandler.getPlayerHelper().deTrackEntity(player.getPlayerEntity(), entity.getBukkitEntity());
            }
        } else {
            for (PlayerTag player : players) {
                NMSHandler.getPlayerHelper().sendEntityDestroy(player.getPlayerEntity(), entity.getBukkitEntity());
            }
            NMSHandler.getPlayerHelper().sendEntitySpawn(players, as.getBukkitEntityType(), entity.getLocation(), as.getWaitingMechanisms(), entity.getBukkitEntity().getEntityId(), entity.getUUID(), false);
        }
    }
}

