/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.entity;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class FakeEntity {
    public static final Map<UUID, FakeEntityMap> playersToEntities = new HashMap<UUID, FakeEntityMap>();
    public static final Map<UUID, FakeEntity> idsToEntities = new HashMap<UUID, FakeEntity>();
    public List<PlayerTag> players;
    public int id;
    public EntityTag entity;
    public LocationTag location;
    public BukkitTask currentTask = null;

    public static FakeEntity getFakeEntityFor(UUID uuid, int id) {
        FakeEntityMap map = playersToEntities.get(uuid);
        if (map == null) {
            return null;
        }
        return map.byId.get(id);
    }

    private FakeEntity(List<PlayerTag> player, LocationTag location, int id) {
        this.players = player;
        this.location = location;
        this.id = id;
    }

    public static ListTag showFakeEntityTo(List<PlayerTag> players, EntityTag typeToSpawn, LocationTag location, DurationTag duration) {
        ListTag result = new ListTag();
        for (PlayerTag player : players) {
            if (!player.isOnline() || !player.isValid()) continue;
            UUID uuid = player.getPlayerEntity().getUniqueId();
            FakeEntityMap playerEntities = playersToEntities.get(uuid);
            if (playerEntities == null) {
                playerEntities = new FakeEntityMap();
                playersToEntities.put(uuid, playerEntities);
            }
            EntityTag entTag = NMSHandler.getPlayerHelper().sendEntitySpawn(players, typeToSpawn.getBukkitEntityType(), location, typeToSpawn.getWaitingMechanisms(), -1, null, true);
            FakeEntity fakeEntity = playerEntities.getOrAdd(players, location, entTag.getBukkitEntity().getEntityId());
            entTag.isFake = true;
            entTag.isFakeValid = true;
            fakeEntity.updateEntity(entTag, duration);
            idsToEntities.put(entTag.getUUID(), fakeEntity);
            result.addObject(entTag);
        }
        return result;
    }

    public void cancelEntity() {
        if (this.currentTask != null) {
            this.currentTask.cancel();
            this.currentTask = null;
        }
        idsToEntities.remove(this.entity.getUUID());
        for (PlayerTag player : this.players) {
            if (player.isOnline()) {
                NMSHandler.getPlayerHelper().sendEntityDestroy(player.getPlayerEntity(), this.entity.getBukkitEntity());
            }
            FakeEntityMap mapping = playersToEntities.get(player.getOfflinePlayer().getUniqueId());
            mapping.remove(this);
        }
        this.entity.isFakeValid = false;
    }

    private void updateEntity(EntityTag entity, DurationTag duration) {
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
        this.entity = entity;
        if (duration != null && duration.getTicks() > 0L) {
            this.currentTask = new BukkitRunnable(){

                public void run() {
                    FakeEntity.this.currentTask = null;
                    FakeEntity.this.cancelEntity();
                }
            }.runTaskLater((Plugin)Denizen.getInstance(), duration.getTicks());
        }
    }

    public static class FakeEntityMap {
        public Map<Integer, FakeEntity> byId = new HashMap<Integer, FakeEntity>();

        public FakeEntity getOrAdd(List<PlayerTag> players, LocationTag location, int id) {
            FakeEntity entity = this.byId.get(id);
            if (entity != null) {
                return entity;
            }
            entity = new FakeEntity(players, location, id);
            this.byId.put(id, entity);
            return entity;
        }

        public void remove(FakeEntity entity) {
            this.byId.remove(entity.id);
        }
    }
}

