/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DisguiseCommand
extends AbstractCommand {
    public static HashMap<UUID, HashMap<UUID, TrackedDisguise>> disguises = new HashMap();

    public DisguiseCommand() {
        this.setName("disguise");
        this.setSyntax("disguise [<entity>] [cancel/as:<type>] (players:<player>|...)");
        this.setRequiredArguments(2, 3);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("players") && arg.matchesPrefix("to", "players")) {
                scriptEntry.addObject("players", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            if (arg.matchesPrefix("as") && arg.matchesArgumentType(EntityTag.class)) {
                scriptEntry.addObject("as", arg.asType(EntityTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("entity") && arg.matchesArgumentType(EntityTag.class)) {
                scriptEntry.addObject("entity", arg.asType(EntityTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("cancel") && arg.matches("cancel")) {
                scriptEntry.addObject("cancel", new ElementTag(true));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("players") && Utilities.entryHasPlayer(scriptEntry)) {
            scriptEntry.defaultObject("players", Arrays.asList(Utilities.getEntryPlayer(scriptEntry)));
        }
        if (!scriptEntry.hasObject("as") && !scriptEntry.hasObject("cancel")) {
            throw new InvalidArgumentsException("Must specify a valid type to disguise as!");
        }
        if (!scriptEntry.hasObject("players")) {
            throw new InvalidArgumentsException("Must have a valid, online player attached!");
        }
        if (!scriptEntry.hasObject("entity")) {
            throw new InvalidArgumentsException("Must specify a valid entity!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        EntityTag entity = (EntityTag)scriptEntry.getObjectTag("entity");
        EntityTag as = (EntityTag)scriptEntry.getObjectTag("as");
        ElementTag cancel = scriptEntry.getElement("cancel");
        List players = (List)scriptEntry.getObject("players");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), entity.debug() + (cancel != null ? cancel.debug() : as.debug()) + ArgumentHelper.debugList("players", players));
        }
        if (cancel != null && cancel.asBoolean()) {
            for (PlayerTag player : players) {
                TrackedDisguise disguise;
                HashMap<UUID, TrackedDisguise> playerMap = disguises.get(entity.getUUID());
                if (playerMap == null || (disguise = playerMap.remove(player.getOfflinePlayer().getUniqueId())) == null) continue;
                if (disguise.fake != null && player.getOfflinePlayer().getUniqueId().equals(entity.getUUID())) {
                    NMSHandler.getPacketHelper().removeNoCollideTeam(player.getPlayerEntity(), disguise.fake.entity.getUUID());
                    disguise.fake.cancelEntity();
                    disguise.fake = null;
                } else if (player.isOnline()) {
                    NMSHandler.getPlayerHelper().deTrackEntity(player.getPlayerEntity(), entity.getBukkitEntity());
                }
                if (!playerMap.isEmpty()) continue;
                disguises.remove(entity.getUUID());
            }
        } else {
            TrackedDisguise disguise = new TrackedDisguise(entity, as, players);
            for (PlayerTag player : players) {
                HashMap<UUID, TrackedDisguise> playerMap = disguises.get(entity.getUUID());
                if (playerMap == null) {
                    playerMap = new HashMap();
                    disguises.put(entity.getUUID(), playerMap);
                }
                playerMap.put(player.getOfflinePlayer().getUniqueId(), disguise);
            }
            disguise.sendTo(players);
        }
    }

    public static class TrackedDisguise {
        public EntityTag entity;
        public EntityTag as;
        public HashSet<UUID> players;
        public FakeEntity fake;

        public TrackedDisguise(EntityTag entity, EntityTag as, List<PlayerTag> players) {
            this.entity = entity;
            this.as = as;
            this.players = new HashSet();
            for (PlayerTag player : players) {
                this.players.add(player.getOfflinePlayer().getUniqueId());
            }
        }

        public void sendTo(List<PlayerTag> players) {
            PlayerTag remove = null;
            for (final PlayerTag player : players) {
                if (player.getOfflinePlayer().getUniqueId().equals(this.entity.getUUID())) {
                    remove = player;
                    if (this.fake != null || !player.isOnline()) continue;
                    this.fake = FakeEntity.showFakeEntityTo(Collections.singletonList(player), this.as, player.getLocation(), null);
                    NMSHandler.getPacketHelper().generateNoCollideTeam(player.getPlayerEntity(), this.fake.entity.getUUID());
                    new BukkitRunnable(){

                        public void run() {
                            if (!fake.entity.isFakeValid || !player.isOnline()) {
                                fake = null;
                                this.cancel();
                                return;
                            }
                            NMSHandler.getEntityHelper().move(fake.entity.getBukkitEntity(), player.getLocation().toVector().subtract(fake.entity.getLocation().toVector()));
                            NMSHandler.getEntityHelper().look(fake.entity.getBukkitEntity(), player.getLocation().getYaw(), player.getLocation().getPitch());
                        }
                    }.runTaskTimer((Plugin)Denizen.getInstance(), 1L, 1L);
                    continue;
                }
                NMSHandler.getPlayerHelper().sendEntityDestroy(player.getPlayerEntity(), this.entity.getBukkitEntity());
            }
            if (remove != null) {
                if (players.size() == 1) {
                    return;
                }
                players.remove(remove);
            }
            if (players.isEmpty()) {
                return;
            }
            NMSHandler.getPlayerHelper().sendEntitySpawn(players, this.as.getBukkitEntityType(), this.entity.getLocation(), this.as.getWaitingMechanisms(), this.entity.getBukkitEntity().getEntityId(), this.entity.getUUID(), false);
        }
    }
}

