/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.entity;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class EntityAttachmentHelper {
    public static HashMap<UUID, PlayerAttachMap> attachedEntityToData = new HashMap();
    public static HashMap<UUID, EntityAttachedToMap> toEntityToData = new HashMap();

    public static byte adaptedCompressedAngle(byte angle, float offset) {
        float angleF = (float)angle * 1.40625f;
        angleF += offset;
        return (byte)((angleF %= 180.0f) * 0.7111111f);
    }

    public static byte compressAngle(float angle) {
        return (byte)((angle %= 180.0f) * 0.7111111f);
    }

    public static Vector fixOffset(Vector offset, double yaw, double pitch) {
        yaw = Math.toRadians(yaw);
        pitch = Math.toRadians(pitch);
        Vector offsetPatched = offset.clone();
        double cosPitch = Math.cos(pitch);
        double sinPitch = Math.sin(pitch);
        double y1 = offsetPatched.getY() * cosPitch - offsetPatched.getZ() * sinPitch;
        double z1 = offsetPatched.getY() * sinPitch + offsetPatched.getZ() * cosPitch;
        offsetPatched.setY(y1);
        offsetPatched.setZ(z1);
        double cosYaw = Math.cos(yaw);
        double sinYaw = Math.sin(yaw);
        double x2 = offsetPatched.getX() * cosYaw + offsetPatched.getZ() * sinYaw;
        double z2 = offsetPatched.getX() * -sinYaw + offsetPatched.getZ() * cosYaw;
        offsetPatched.setX(x2);
        offsetPatched.setZ(z2);
        return offsetPatched;
    }

    public static void removeAttachment(UUID attachedId, UUID forPlayer) {
        AttachmentData data;
        PlayerAttachMap map = attachedEntityToData.get(attachedId);
        if (map == null) {
            return;
        }
        if (forPlayer == null) {
            attachedEntityToData.remove(attachedId);
            map.cancelAll();
        } else if (map.playerToAttachment != null && (data = map.playerToAttachment.get(forPlayer)) != null) {
            data.cancelAndRemove();
        }
    }

    public static void registerAttachment(AttachmentData attachment) {
        EntityAttachmentHelper.removeAttachment(attachment.attached.getUUID(), attachment.forPlayer);
        attachment.startTask();
        PlayerAttachMap map = attachedEntityToData.get(attachment.attached.getUUID());
        if (map == null) {
            map = new PlayerAttachMap();
            map.attached = attachment.attached;
            attachedEntityToData.put(attachment.attached.getUUID(), map);
        }
        if (attachment.forPlayer == null) {
            map.everyoneAttachment = attachment;
        } else {
            if (map.playerToAttachment == null) {
                map.playerToAttachment = new HashMap();
            }
            map.playerToAttachment.put(attachment.forPlayer, attachment);
        }
        EntityAttachedToMap toMap = toEntityToData.get(attachment.to.getUUID());
        if (toMap == null) {
            toMap = new EntityAttachedToMap();
            toEntityToData.put(attachment.to.getUUID(), toMap);
        }
        toMap.attachedToMap.put(attachment.attached.getUUID(), map);
    }

    public static void forceAttachMove(EntityTag attached, EntityTag to, Vector offset, boolean matchRotation) {
        EntityAttachmentHelper.removeAttachment(attached.getUUID(), null);
        if (to == null) {
            return;
        }
        AttachmentData data = new AttachmentData();
        data.attached = attached;
        data.to = to;
        data.positionalOffset = offset == null ? null : offset.toLocation(null);
        data.offsetRelative = matchRotation;
        EntityAttachmentHelper.registerAttachment(data);
    }

    public static boolean denyOriginalPacketSend(UUID player, UUID entity) {
        PlayerAttachMap attached = attachedEntityToData.get(entity);
        if (attached == null) {
            return false;
        }
        AttachmentData data = attached.getAttachment(player);
        if (data == null) {
            return false;
        }
        return !data.to.getUUID().equals(player);
    }

    public static class EntityAttachedToMap {
        public HashMap<UUID, PlayerAttachMap> attachedToMap = new HashMap();
    }

    public static class PlayerAttachMap {
        public EntityTag attached;
        public AttachmentData everyoneAttachment;
        public HashMap<UUID, AttachmentData> playerToAttachment;

        public AttachmentData getAttachment(UUID player) {
            if (this.playerToAttachment == null) {
                return this.everyoneAttachment;
            }
            AttachmentData data = this.playerToAttachment.get(player);
            if (data != null) {
                return data;
            }
            return this.everyoneAttachment;
        }

        public void cancelAll() {
            if (this.everyoneAttachment != null) {
                this.everyoneAttachment.cancelAndRemove();
            }
            if (this.playerToAttachment != null) {
                for (AttachmentData attachment : new HashSet<AttachmentData>(this.playerToAttachment.values())) {
                    attachment.cancelAndRemove();
                }
            }
        }

        public void autoNull() {
            if (this.playerToAttachment != null && this.playerToAttachment.isEmpty()) {
                this.playerToAttachment = null;
            }
        }
    }

    public static class AttachmentData {
        public EntityTag attached;
        public EntityTag to;
        public boolean offsetRelative;
        public float yawAngleOffset;
        public float pitchAngleOffset;
        public Location positionalOffset;
        public Vector visiblePosition;
        public boolean syncServer;
        public boolean noRotate;
        public BukkitTask checkTask;
        public UUID forPlayer;

        public Vector fixedForOffset(Vector offset, float yaw, float pitch) {
            if (this.offsetRelative) {
                return offset.clone().add(EntityAttachmentHelper.fixOffset(this.positionalOffset.toVector(), -yaw + this.yawAngleOffset, pitch + this.pitchAngleOffset));
            }
            return offset.clone().add(this.positionalOffset.toVector());
        }

        public void startTask() {
            if (this.checkTask != null) {
                this.checkTask.cancel();
            }
            BukkitRunnable runnable = new BukkitRunnable(){

                public void run() {
                    if (!attached.isValid() || !to.isValid()) {
                        this.cancelAndRemove();
                        return;
                    }
                    if (syncServer) {
                        LocationTag goal = to.getLocation();
                        if (positionalOffset != null) {
                            goal = this.fixedForOffset(goal.toVector(), goal.getYaw(), goal.getPitch()).toLocation(goal.getWorld());
                        }
                        if (noRotate) {
                            LocationTag attachLoc = attached.getLocation();
                            goal.setYaw(attachLoc.getYaw());
                            goal.setPitch(attachLoc.getPitch());
                        }
                        if (attached.isFake) {
                            NMSHandler.getEntityHelper().move(attached.getBukkitEntity(), goal.toVector().subtract(attached.getLocation().toVector()));
                            NMSHandler.getEntityHelper().look(attached.getBukkitEntity(), goal.getYaw(), goal.getPitch());
                        } else {
                            attached.teleport(goal);
                        }
                    }
                }
            };
            runnable.run();
            this.checkTask = runnable.runTaskTimer((Plugin)Denizen.getInstance(), 1L, 1L);
        }

        public void removeFrom(PlayerAttachMap map) {
            if (map != null) {
                if (this.forPlayer == null) {
                    map.everyoneAttachment = null;
                } else {
                    if (map.playerToAttachment != null) {
                        map.playerToAttachment.remove(this.forPlayer);
                    }
                    map.autoNull();
                }
            }
        }

        public void cancelAndRemove() {
            PlayerAttachMap attachMap;
            if (this.checkTask != null) {
                this.checkTask.cancel();
            }
            this.checkTask = null;
            EntityAttachedToMap map = toEntityToData.get(this.to.getUUID());
            if (map != null) {
                PlayerAttachMap subMap = map.attachedToMap.get(this.attached.getUUID());
                this.removeFrom(subMap);
                if (subMap.everyoneAttachment == null && subMap.playerToAttachment == null) {
                    map.attachedToMap.remove(this.attached.getUUID());
                    if (map.attachedToMap.isEmpty()) {
                        toEntityToData.remove(this.to.getUUID());
                    }
                }
            }
            if ((attachMap = attachedEntityToData.get(this.attached.getUUID())) != null) {
                this.removeFrom(attachMap);
                if (attachMap.everyoneAttachment == null && attachMap.playerToAttachment == null) {
                    attachedEntityToData.remove(this.attached.getUUID());
                }
            }
        }
    }
}

