/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_15.helpers;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.abstracts.ImprovedOfflinePlayer;
import com.denizenscript.denizen.nms.interfaces.PlayerHelper;
import com.denizenscript.denizen.nms.v1_15.helpers.ItemHelperImpl;
import com.denizenscript.denizen.nms.v1_15.impl.ImprovedOfflinePlayerImpl;
import com.denizenscript.denizen.nms.v1_15.impl.network.handlers.AbstractListenerPlayInImpl;
import com.denizenscript.denizen.nms.v1_15.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.mojang.authlib.GameProfile;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.v1_15_R1.ChunkCoordIntPair;
import net.minecraft.server.v1_15_R1.DataWatcherObject;
import net.minecraft.server.v1_15_R1.DedicatedServer;
import net.minecraft.server.v1_15_R1.EntityHuman;
import net.minecraft.server.v1_15_R1.EntityLiving;
import net.minecraft.server.v1_15_R1.EntityPlayer;
import net.minecraft.server.v1_15_R1.EntityTrackerEntry;
import net.minecraft.server.v1_15_R1.IRecipe;
import net.minecraft.server.v1_15_R1.JsonListEntry;
import net.minecraft.server.v1_15_R1.MinecraftKey;
import net.minecraft.server.v1_15_R1.OpList;
import net.minecraft.server.v1_15_R1.OpListEntry;
import net.minecraft.server.v1_15_R1.Packet;
import net.minecraft.server.v1_15_R1.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_15_R1.PacketPlayOutGameStateChange;
import net.minecraft.server.v1_15_R1.PacketPlayOutRecipeUpdate;
import net.minecraft.server.v1_15_R1.PacketPlayOutStopSound;
import net.minecraft.server.v1_15_R1.PlayerChunkMap;
import net.minecraft.server.v1_15_R1.PlayerConnection;
import net.minecraft.server.v1_15_R1.RecipeBookServer;
import net.minecraft.server.v1_15_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.SoundCategory;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerHelperImpl
extends PlayerHelper {
    public static final Field ATTACK_COOLDOWN_TICKS = ReflectionHelper.getFields(EntityLiving.class).get("aD");
    public static final Map<String, Field> PLAYER_CONNECTION_FIELDS = ReflectionHelper.getFields(PlayerConnection.class);
    public static final Field FLY_TICKS = PLAYER_CONNECTION_FIELDS.get("C");
    public static final Field VEHICLE_FLY_TICKS = PLAYER_CONNECTION_FIELDS.get("E");
    public static final DataWatcherObject<Byte> ENTITY_HUMAN_SKINLAYERS_DATAWATCHER;

    @Override
    public void stopSound(Player player, String sound, SoundCategory category) {
        MinecraftKey soundKey = sound == null ? null : new MinecraftKey(sound);
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutStopSound(soundKey, net.minecraft.server.v1_15_R1.SoundCategory.valueOf((String)category.name())));
    }

    @Override
    public void deTrackEntity(Player player, Entity entity) {
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        WorldServer world = (WorldServer)nmsPlayer.world;
        PlayerChunkMap.EntityTracker tracker = (PlayerChunkMap.EntityTracker)world.getChunkProvider().playerChunkMap.trackedEntities.get(entity.getEntityId());
        if (tracker == null) {
            return;
        }
        this.sendEntityDestroy(player, entity);
        tracker.clear(nmsPlayer);
    }

    @Override
    public EntityTag sendEntitySpawn(List<PlayerTag> players, EntityType entityType, Location location, ArrayList<Mechanism> mechanisms, int customId, UUID customUUID, boolean autoTrack) {
        CraftWorld world = (CraftWorld)location.getWorld();
        net.minecraft.server.v1_15_R1.Entity nmsEntity = world.createEntity(location, entityType.getEntityClass());
        if (customUUID != null) {
            nmsEntity.e(customId);
            nmsEntity.a(customUUID);
        }
        EntityTag entity = new EntityTag((Entity)nmsEntity.getBukkitEntity());
        for (Mechanism mechanism : mechanisms) {
            entity.safeAdjust(mechanism);
        }
        nmsEntity.dead = false;
        final EntityTag entTag = new EntityTag(entity.getBukkitEntity());
        for (final PlayerTag player : players) {
            EntityPlayer nmsPlayer = ((CraftPlayer)player.getPlayerEntity()).getHandle();
            PlayerConnection conn = nmsPlayer.playerConnection;
            final EntityTrackerEntry tracker = new EntityTrackerEntry(world.getHandle(), nmsEntity, 1, true, arg_0 -> ((PlayerConnection)conn).sendPacket(arg_0), Collections.singleton(nmsPlayer));
            tracker.b(nmsPlayer);
            if (!autoTrack) continue;
            new BukkitRunnable(){

                public void run() {
                    if (!entTag.isFakeValid || !player.isOnline()) {
                        this.cancel();
                        return;
                    }
                    tracker.a();
                }
            }.runTaskTimer((Plugin)Denizen.getInstance(), 1L, 1L);
        }
        return entTag;
    }

    @Override
    public void sendEntityDestroy(Player player, Entity entity) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutEntityDestroy(new int[]{entity.getEntityId()}));
    }

    @Override
    public int getFlyKickCooldown(Player player) {
        PlayerConnection conn = ((CraftPlayer)player).getHandle().playerConnection;
        if (conn instanceof AbstractListenerPlayInImpl) {
            conn = ((AbstractListenerPlayInImpl)conn).oldListener;
        }
        try {
            return Math.max(80 - Math.max(FLY_TICKS.getInt(conn), VEHICLE_FLY_TICKS.getInt(conn)), 0);
        }
        catch (IllegalAccessException e) {
            Debug.echoError(e);
            return 80;
        }
    }

    @Override
    public void setFlyKickCooldown(Player player, int ticks) {
        ticks = 80 - ticks;
        PlayerConnection conn = ((CraftPlayer)player).getHandle().playerConnection;
        if (conn instanceof AbstractListenerPlayInImpl) {
            conn = ((AbstractListenerPlayInImpl)conn).oldListener;
        }
        try {
            FLY_TICKS.setInt(conn, ticks);
            VEHICLE_FLY_TICKS.setInt(conn, ticks);
        }
        catch (IllegalAccessException e) {
            Debug.echoError(e);
        }
    }

    @Override
    public int ticksPassedDuringCooldown(Player player) {
        try {
            return ATTACK_COOLDOWN_TICKS.getInt(((CraftPlayer)player).getHandle());
        }
        catch (IllegalAccessException e) {
            Debug.echoError(e);
            return -1;
        }
    }

    @Override
    public float getMaxAttackCooldownTicks(Player player) {
        return ((CraftPlayer)player).getHandle().ex() + 3.0f;
    }

    @Override
    public float getAttackCooldownPercent(Player player) {
        return ((CraftPlayer)player).getHandle().s(0.5f);
    }

    @Override
    public void setAttackCooldown(Player player, int ticks) {
        try {
            ATTACK_COOLDOWN_TICKS.setInt(((CraftPlayer)player).getHandle(), ticks);
        }
        catch (IllegalAccessException e) {
            Debug.echoError(e);
        }
    }

    @Override
    public boolean hasChunkLoaded(Player player, Chunk chunk) {
        return ((CraftWorld)chunk.getWorld()).getHandle().getChunkProvider().playerChunkMap.a(new ChunkCoordIntPair(chunk.getX(), chunk.getZ()), false).anyMatch(entityPlayer -> entityPlayer.getUniqueID().equals(player.getUniqueId()));
    }

    @Override
    public int getPing(Player player) {
        return ((CraftPlayer)player).getHandle().ping;
    }

    @Override
    public void setTemporaryOp(Player player, boolean op) {
        DedicatedServer server = ((CraftServer)Bukkit.getServer()).getServer();
        GameProfile profile = ((CraftPlayer)player).getProfile();
        OpList opList = server.getPlayerList().getOPs();
        if (op) {
            int permLevel = server.j();
            opList.add((JsonListEntry)new OpListEntry(profile, permLevel, opList.b(profile)));
        } else {
            opList.remove((Object)profile);
        }
        player.recalculatePermissions();
    }

    @Override
    public void showEndCredits(Player player) {
        ((CraftPlayer)player).getHandle().viewingCredits = true;
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutGameStateChange(4, 0.0f));
    }

    @Override
    public ImprovedOfflinePlayer getOfflineData(UUID uuid) {
        return new ImprovedOfflinePlayerImpl(uuid);
    }

    @Override
    public ImprovedOfflinePlayer getOfflineData(OfflinePlayer offlinePlayer) {
        return new ImprovedOfflinePlayerImpl(offlinePlayer.getUniqueId());
    }

    @Override
    public void resendRecipeDetails(Player player) {
        Collection recipes = ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().b();
        PacketPlayOutRecipeUpdate updatePacket = new PacketPlayOutRecipeUpdate(recipes);
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)updatePacket);
    }

    @Override
    public void resendDiscoveredRecipes(Player player) {
        RecipeBookServer recipeBook = ((CraftPlayer)player).getHandle().B();
        recipeBook.a(((CraftPlayer)player).getHandle());
    }

    @Override
    public void quietlyAddRecipe(Player player, NamespacedKey key) {
        RecipeBookServer recipeBook = ((CraftPlayer)player).getHandle().B();
        IRecipe<?> recipe = ItemHelperImpl.getNMSRecipe(key);
        if (recipe == null) {
            Debug.echoError("Cannot add recipe '" + key + "': it does not exist.");
            return;
        }
        recipeBook.a(recipe);
        recipeBook.f(recipe);
    }

    @Override
    public String getPlayerBrand(Player player) {
        return ((DenizenNetworkManagerImpl)((CraftPlayer)player).getHandle().playerConnection.networkManager).packetListener.brand;
    }

    @Override
    public byte getSkinLayers(Player player) {
        return (Byte)((CraftPlayer)player).getHandle().getDataWatcher().get(ENTITY_HUMAN_SKINLAYERS_DATAWATCHER);
    }

    @Override
    public void setSkinLayers(Player player, byte flags) {
        ((CraftPlayer)player).getHandle().getDataWatcher().set(ENTITY_HUMAN_SKINLAYERS_DATAWATCHER, (Object)flags);
    }

    static {
        DataWatcherObject skinlayers = null;
        try {
            skinlayers = (DataWatcherObject)ReflectionHelper.getFields(EntityHuman.class).get("bq").get(null);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        ENTITY_HUMAN_SKINLAYERS_DATAWATCHER = skinlayers;
    }
}

