/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RotateCommand
extends AbstractCommand
implements Holdable {
    public static Set<UUID> rotatingEntities = new HashSet<UUID>();

    public RotateCommand() {
        this.setName("rotate");
        this.setSyntax("rotate (cancel) (<entity>|...) (yaw:<#.#>) (pitch:<#.#>) (infinite/duration:<duration>) (frequency:<duration>)");
        this.setRequiredArguments(1, 6);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("cancel") && (arg.matches("cancel") || arg.matches("stop"))) {
                scriptEntry.addObject("cancel", new ElementTag("true"));
                continue;
            }
            if (!scriptEntry.hasObject("infinite") && arg.matches("infinite")) {
                scriptEntry.addObject("infinite", new ElementTag("true"));
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(DurationTag.class) && arg.matchesPrefix("duration", "d")) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("frequency") && arg.matchesArgumentType(DurationTag.class) && arg.matchesPrefix("frequency", "f")) {
                scriptEntry.addObject("frequency", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("yaw") && arg.matchesPrefix("yaw", "y", "rotation", "r") && arg.matchesFloat()) {
                scriptEntry.addObject("yaw", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("pitch") && arg.matchesPrefix("pitch", "p", "tilt", "t") && arg.matchesFloat()) {
                scriptEntry.addObject("pitch", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("entities", Utilities.entryDefaultEntityList(scriptEntry, true));
        scriptEntry.defaultObject("yaw", new ElementTag(10));
        scriptEntry.defaultObject("pitch", new ElementTag(0));
        scriptEntry.defaultObject("duration", new DurationTag(20));
        scriptEntry.defaultObject("frequency", new DurationTag(1L));
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify entity/entities!");
        }
    }

    @Override
    public void execute(final ScriptEntry scriptEntry) {
        final ArrayList entities = new ArrayList((List)scriptEntry.getObject("entities"));
        final DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        final DurationTag frequency = (DurationTag)scriptEntry.getObjectTag("frequency");
        final ElementTag yaw = scriptEntry.getElement("yaw");
        final ElementTag pitch = scriptEntry.getElement("pitch");
        boolean cancel = scriptEntry.hasObject("cancel");
        final boolean infinite = scriptEntry.hasObject("infinite");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), (cancel ? ArgumentHelper.debugObj("cancel", cancel) : "") + ArgumentHelper.debugObj("entities", ((Object)entities).toString()) + (infinite ? ArgumentHelper.debugObj("duration", "infinite") : duration.debug()) + frequency.debug() + yaw.debug() + pitch.debug());
        }
        for (EntityTag entity : entities) {
            if (cancel) {
                rotatingEntities.remove(entity.getUUID());
                continue;
            }
            rotatingEntities.add(entity.getUUID());
        }
        if (cancel) {
            return;
        }
        BukkitRunnable task = new BukkitRunnable(){
            int ticks = 0;
            int maxTicks = duration.getTicksAsInt();
            Collection<EntityTag> unusedEntities = new LinkedList<EntityTag>();

            public void run() {
                if (entities.isEmpty()) {
                    scriptEntry.setFinished(true);
                    this.cancel();
                } else if (infinite || this.ticks < this.maxTicks) {
                    for (EntityTag entity : entities) {
                        if (entity.isSpawned() && rotatingEntities.contains(entity.getUUID())) {
                            NMSHandler.getEntityHelper().rotate(entity.getBukkitEntity(), NMSHandler.getEntityHelper().normalizeYaw(entity.getLocation().getYaw() + yaw.asFloat()), entity.getLocation().getPitch() + pitch.asFloat());
                            continue;
                        }
                        rotatingEntities.remove(entity.getUUID());
                        this.unusedEntities.add(entity);
                    }
                    if (!this.unusedEntities.isEmpty()) {
                        for (EntityTag unusedEntity : this.unusedEntities) {
                            entities.remove(unusedEntity);
                        }
                        this.unusedEntities.clear();
                    }
                    this.ticks = (int)((long)this.ticks + frequency.getTicks());
                } else {
                    scriptEntry.setFinished(true);
                    this.cancel();
                }
            }
        };
        task.runTaskTimer((Plugin)Denizen.getInstance(), 0L, frequency.getTicks());
    }
}

