/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.queues.core;

import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.tags.Attribute;

public class InstantQueue
extends ScriptQueue {
    public static InstantQueue getQueue(String id) {
        if (id == null) {
            throw new IllegalArgumentException("ID cannot be null!");
        }
        InstantQueue scriptQueue = InstantQueue._queueExists(id) ? (InstantQueue)_queues.get(id) : new InstantQueue(id);
        return scriptQueue;
    }

    public InstantQueue(String id) {
        super(id);
    }

    public InstantQueue(String id, boolean async) {
        super(id, async);
    }

    @Override
    public void onStart() {
        while (this.is_started) {
            this.revolve();
        }
    }

    @Override
    public String getName() {
        return "InstantQueue";
    }

    @Override
    public void onStop() {
    }

    @Override
    protected boolean shouldRevolve() {
        return true;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute.startsWith("speed")) {
            return new Duration(0).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("type")) {
            return new Element("Instant").getAttribute(attribute.fulfill(1));
        }
        return super.getAttribute(attribute);
    }
}

