/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.flags;

import com.denizenscript.denizencore.flags.MapTagBasedFlagTracker;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SavableMapFlagTracker
extends MapTagBasedFlagTracker {
    public HashMap<StringHolder, SaveOptimizedFlag> map;
    public boolean modified;
    public static AsciiMatcher valueEscapeNeededMatcher = new AsciiMatcher("\n\\");
    public static AsciiMatcher keyEscapeNeededMatcher = new AsciiMatcher(":\n\\");

    public SavableMapFlagTracker() {
        this.map = new HashMap();
    }

    public SavableMapFlagTracker(String input) {
        this.map = new HashMap(input.length() / 50);
        int eol = input.indexOf(10);
        int startOfLine = 0;
        while (eol != -1) {
            int colon = input.indexOf(58, startOfLine);
            if (colon != -1) {
                String key = SavableMapFlagTracker.unescapeKey(input.substring(startOfLine, colon));
                String value = SavableMapFlagTracker.unescapeValue(input.substring(colon + 1, eol));
                SaveOptimizedFlag flag = new SaveOptimizedFlag();
                flag.string = value;
                this.map.put(new StringHolder(key), flag);
            }
            startOfLine = eol + 1;
            eol = input.indexOf(10, eol + 1);
        }
        this.doTotalClean();
    }

    public void doTotalClean() {
        if (MapTagBasedFlagTracker.skipAllCleanings) {
            return;
        }
        ArrayList<StringHolder> toRemove = new ArrayList<StringHolder>();
        for (Map.Entry<StringHolder, SaveOptimizedFlag> entry : this.map.entrySet()) {
            if (SavableMapFlagTracker.isExpired(entry.getValue().getMap().map.get(expirationString))) {
                toRemove.add(entry.getKey());
                this.modified = true;
                continue;
            }
            ObjectTag subValue = entry.getValue().getMap().map.get(valueString);
            if (!(subValue instanceof MapTag) || !this.doClean((MapTag)subValue)) continue;
            entry.getValue().string = null;
            this.modified = true;
        }
        for (StringHolder str : toRemove) {
            this.map.remove(str);
        }
    }

    @Override
    public MapTag getRootMap(String key) {
        SaveOptimizedFlag flag = this.map.get(new StringHolder(key));
        if (flag == null) {
            return null;
        }
        return flag.getMap();
    }

    @Override
    public void setRootMap(String key, MapTag value) {
        this.modified = true;
        if (value == null) {
            this.map.remove(new StringHolder(key));
            return;
        }
        SaveOptimizedFlag flag = new SaveOptimizedFlag();
        flag.map = value;
        flag.string = null;
        this.map.put(new StringHolder(key), flag);
    }

    @Override
    public Collection<String> listAllFlags() {
        ArrayList<String> keys = new ArrayList<String>(this.map.size());
        for (StringHolder string : this.map.keySet()) {
            keys.add(string.str);
        }
        return keys;
    }

    public static String unescapeValue(String key) {
        if (!CoreUtilities.contains(key, '\\')) {
            return key;
        }
        key = CoreUtilities.replace(key, "\\nl", "\n");
        key = CoreUtilities.replace(key, "\\bs", "\\");
        return key;
    }

    public static String escapeValue(String key) {
        if (!valueEscapeNeededMatcher.containsAnyMatch(key)) {
            return key;
        }
        key = CoreUtilities.replace(key, "\\", "\\bs");
        key = CoreUtilities.replace(key, "\n", "\\nl");
        return key;
    }

    public static String unescapeKey(String key) {
        if (!CoreUtilities.contains(key, '\\')) {
            return key;
        }
        key = CoreUtilities.replace(key, "\\amp", "&");
        key = CoreUtilities.replace(key, "\\co", ":");
        key = CoreUtilities.replace(key, "\\nl", "\n");
        return key;
    }

    public static String escapeKey(String key) {
        if (!keyEscapeNeededMatcher.containsAnyMatch(key)) {
            return key;
        }
        key = CoreUtilities.replace(key, "\\", "\\bs");
        key = CoreUtilities.replace(key, ":", "\\co");
        key = CoreUtilities.replace(key, "\n", "\\nl");
        return key;
    }

    public String toString() {
        StringBuilder toOutput = new StringBuilder(this.map.size() * 100);
        for (Map.Entry<StringHolder, SaveOptimizedFlag> flag : this.map.entrySet()) {
            toOutput.append(SavableMapFlagTracker.escapeKey(flag.getKey().str)).append(":").append(SavableMapFlagTracker.escapeValue(flag.getValue().getString())).append('\n');
        }
        return toOutput.toString();
    }

    public static class SaveOptimizedFlag {
        public MapTag map;
        public String string;

        public MapTag getMap() {
            if (this.map == null) {
                this.map = MapTag.valueOf(this.string, CoreUtilities.errorButNoDebugContext);
            }
            return this.map;
        }

        public String getString() {
            if (this.string == null) {
                this.string = this.map.toString();
            }
            return this.string;
        }
    }
}

