/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.flags;

import com.denizenscript.denizen.utilities.DataPersistenceHelper;
import com.denizenscript.denizencore.flags.MapTagBasedFlagTracker;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.Collection;
import java.util.stream.Collectors;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;

public class DataPersistenceFlagTracker
extends MapTagBasedFlagTracker {
    public PersistentDataHolder holder;
    public String keyPrefix = "flag_";

    public DataPersistenceFlagTracker(PersistentDataHolder holder) {
        this.holder = holder;
    }

    public DataPersistenceFlagTracker(PersistentDataHolder holder, String keyPrefix) {
        this.holder = holder;
        this.keyPrefix = keyPrefix;
    }

    @Override
    public MapTag getRootMap(String key) {
        return (MapTag)DataPersistenceHelper.getDenizenKey(this.holder, this.keyPrefix + CoreUtilities.toLowerCase(key));
    }

    @Override
    public void setRootMap(String key, MapTag map) {
        if (map == null) {
            DataPersistenceHelper.removeDenizenKey(this.holder, this.keyPrefix + CoreUtilities.toLowerCase(key));
            return;
        }
        DataPersistenceHelper.setDenizenKey(this.holder, this.keyPrefix + CoreUtilities.toLowerCase(key), map);
    }

    @Override
    public Collection<String> listAllFlags() {
        return this.holder.getPersistentDataContainer().getKeys().stream().filter(k -> k.getNamespace().equals("denizen") && k.getKey().startsWith(this.keyPrefix)).map(k -> k.getKey().substring(this.keyPrefix.length())).collect(Collectors.toList());
    }

    public void doTotalClean() {
        if (MapTagBasedFlagTracker.skipAllCleanings) {
            return;
        }
        for (NamespacedKey key : this.holder.getPersistentDataContainer().getKeys()) {
            ObjectTag map;
            if (!key.getNamespace().equals("denizen") || !key.getKey().startsWith("flag_") || !((map = (ObjectTag)this.holder.getPersistentDataContainer().get(key, (PersistentDataType)DataPersistenceHelper.PERSISTER_TYPE)) instanceof MapTag)) continue;
            if (DataPersistenceFlagTracker.isExpired(((MapTag)map).map.get(expirationString))) {
                this.holder.getPersistentDataContainer().remove(key);
                continue;
            }
            ObjectTag subValue = ((MapTag)map).map.get(valueString);
            if (!(subValue instanceof MapTag) || !this.doClean((MapTag)subValue)) continue;
            this.holder.getPersistentDataContainer().set(key, (PersistentDataType)DataPersistenceHelper.PERSISTER_TYPE, (Object)map);
        }
    }
}

