/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import java.util.List;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.nbt.CustomNBT;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemNBT
implements Property {
    dItem item;

    public static boolean describes(dObject item) {
        return item instanceof dItem;
    }

    public static ItemNBT getFrom(dObject item) {
        if (!ItemNBT.describes(item)) {
            return null;
        }
        return new ItemNBT((dItem)item);
    }

    private ItemNBT(dItem item) {
        this.item = item;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("has_nbt")) {
            return new Element(CustomNBT.hasCustomNBT(this.item.getItemStack(), attribute.getContext(1), "Denizen NBT")).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("nbt_keys")) {
            return new dList(CustomNBT.listNBT(this.item.getItemStack(), "Denizen NBT")).getAttribute(attribute.fulfill(1));
        }
        if (attribute.matches("nbt")) {
            if (!attribute.hasContext(1)) {
                dList list = this.getNBTDataList();
                if (list == null) {
                    return null;
                }
                return list.getAttribute(attribute.fulfill(1));
            }
            String res = CustomNBT.getCustomNBT(this.item.getItemStack(), attribute.getContext(1), "Denizen NBT");
            if (res == null) {
                return null;
            }
            return new Element(res).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public dList getNBTDataList() {
        ItemStack itemStack = this.item.getItemStack();
        List<String> nbtKeys = CustomNBT.listNBT(itemStack, "Denizen NBT");
        if (nbtKeys != null && !nbtKeys.isEmpty()) {
            dList list = new dList();
            for (String key : nbtKeys) {
                list.add(key + "/" + CustomNBT.getCustomNBT(itemStack, key, "Denizen NBT"));
            }
            return list;
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        dList list = this.getNBTDataList();
        if (list == null) {
            return null;
        }
        return list.identify();
    }

    @Override
    public String getPropertyId() {
        return "nbt";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("nbt")) {
            if (this.item.getMaterial().getMaterial() == Material.AIR) {
                dB.echoError("Cannot apply NBT to AIR!");
                return;
            }
            dList list = mechanism.getValue().asType(dList.class);
            ItemStack itemStack = this.item.getItemStack();
            for (String string : list) {
                String[] split = string.split("/", 2);
                itemStack = CustomNBT.addCustomNBT(itemStack, split[0], split[1], "Denizen NBT");
            }
            this.item.setItemStack(itemStack);
        }
    }
}

