/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemFirework
implements Property {
    dItem item;

    public static boolean describes(dObject item) {
        return item instanceof dItem && (((dItem)item).getItemStack().getItemMeta() instanceof FireworkMeta || ((dItem)item).getItemStack().getItemMeta() instanceof FireworkEffectMeta);
    }

    public static ItemFirework getFrom(dObject _item) {
        if (!ItemFirework.describes(_item)) {
            return null;
        }
        return new ItemFirework((dItem)_item);
    }

    private ItemFirework(dItem _item) {
        this.item = _item;
    }

    public dList getFireworkData() {
        List<FireworkEffect> effects;
        dList list = new dList();
        if (this.item.getItemStack().getItemMeta() instanceof FireworkMeta) {
            effects = ((FireworkMeta)this.item.getItemStack().getItemMeta()).getEffects();
            int power = ((FireworkMeta)this.item.getItemStack().getItemMeta()).getPower();
            if (power != 0) {
                list.add(String.valueOf(power));
            }
        } else {
            effects = Arrays.asList(((FireworkEffectMeta)this.item.getItemStack().getItemMeta()).getEffect());
        }
        if (effects != null) {
            for (FireworkEffect effect : effects) {
                if (effect == null) continue;
                Color ColOne = effect.getColors() != null && effect.getColors().size() > 0 ? (Color)effect.getColors().get(0) : Color.BLUE;
                Color ColTwo = effect.getFadeColors() != null && effect.getFadeColors().size() > 0 ? (Color)effect.getFadeColors().get(0) : ColOne;
                list.add(effect.hasTrail() + "," + effect.hasFlicker() + "," + effect.getType().name() + "," + ColOne.getRed() + "," + ColOne.getGreen() + "," + ColOne.getBlue() + "," + ColTwo.getRed() + "," + ColTwo.getGreen() + "," + ColTwo.getBlue());
            }
        }
        return list;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("firework")) {
            return this.getFireworkData().getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        dList data = this.getFireworkData();
        return data.size() > 0 ? data.identify() : null;
    }

    @Override
    public String getPropertyId() {
        return "firework";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("firework")) {
            dList fireworks = mechanism.getValue().asType(dList.class);
            ItemMeta meta = this.item.getItemStack().getItemMeta();
            for (String effect : fireworks) {
                String[] data = effect.split(",");
                if (data.length == 9) {
                    FireworkEffect.Builder builder = FireworkEffect.builder();
                    builder.trail(new Element(data[0]).asBoolean());
                    builder.flicker(new Element(data[1]).asBoolean());
                    if (new Element(data[2]).matchesEnum((Enum[])FireworkEffect.Type.values())) {
                        builder.with(FireworkEffect.Type.valueOf((String)data[2].toUpperCase()));
                    } else {
                        dB.echoError("Invalid firework type '" + data[2] + "'");
                    }
                    builder.withColor(Color.fromRGB((int)new Element(data[3]).asInt(), (int)new Element(data[4]).asInt(), (int)new Element(data[5]).asInt()));
                    builder.withFade(Color.fromRGB((int)new Element(data[6]).asInt(), (int)new Element(data[7]).asInt(), (int)new Element(data[8]).asInt()));
                    FireworkEffect built = builder.build();
                    if (meta instanceof FireworkMeta) {
                        ((FireworkMeta)meta).addEffect(built);
                        continue;
                    }
                    ((FireworkEffectMeta)meta).setEffect(built);
                    continue;
                }
                if (data.length == 1) {
                    if (meta instanceof FireworkMeta) {
                        ((FireworkMeta)meta).setPower(new Element(data[0]).asInt());
                        continue;
                    }
                    dB.echoError("Cannot set the power of a firework effect!");
                    continue;
                }
                dB.echoError("Invalid firework data '" + effect + "'");
            }
            this.item.getItemStack().setItemMeta(meta);
        }
    }
}

