/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_16.helpers;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.abstracts.ImprovedOfflinePlayer;
import com.denizenscript.denizen.nms.interfaces.PlayerHelper;
import com.denizenscript.denizen.nms.v1_16.Handler;
import com.denizenscript.denizen.nms.v1_16.helpers.ItemHelperImpl;
import com.denizenscript.denizen.nms.v1_16.impl.ImprovedOfflinePlayerImpl;
import com.denizenscript.denizen.nms.v1_16.impl.network.handlers.AbstractListenerPlayInImpl;
import com.denizenscript.denizen.nms.v1_16.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.mojang.authlib.GameProfile;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.server.v1_16_R3.ChunkCoordIntPair;
import net.minecraft.server.v1_16_R3.DataWatcherObject;
import net.minecraft.server.v1_16_R3.DedicatedServer;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.EntityLiving;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.EntityTrackerEntry;
import net.minecraft.server.v1_16_R3.IRecipe;
import net.minecraft.server.v1_16_R3.JsonListEntry;
import net.minecraft.server.v1_16_R3.MinecraftKey;
import net.minecraft.server.v1_16_R3.OpList;
import net.minecraft.server.v1_16_R3.OpListEntry;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketPlayOutBoss;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_16_R3.PacketPlayOutGameStateChange;
import net.minecraft.server.v1_16_R3.PacketPlayOutRecipeUpdate;
import net.minecraft.server.v1_16_R3.PacketPlayOutStopSound;
import net.minecraft.server.v1_16_R3.PlayerChunkMap;
import net.minecraft.server.v1_16_R3.PlayerConnection;
import net.minecraft.server.v1_16_R3.RecipeBookServer;
import net.minecraft.server.v1_16_R3.SoundCategory;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.boss.BossBar;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerHelperImpl
extends PlayerHelper {
    public static final Field ATTACK_COOLDOWN_TICKS = ReflectionHelper.getFields(EntityLiving.class).get("aD");
    public static final Map<String, Field> PLAYER_CONNECTION_FIELDS = ReflectionHelper.getFields(PlayerConnection.class);
    public static final Field FLY_TICKS = PLAYER_CONNECTION_FIELDS.get("C");
    public static final Field VEHICLE_FLY_TICKS = PLAYER_CONNECTION_FIELDS.get("E");
    public static final DataWatcherObject<Byte> ENTITY_HUMAN_SKINLAYERS_DATAWATCHER;

    @Override
    public void stopSound(Player player, String sound, org.bukkit.SoundCategory category) {
        MinecraftKey soundKey = sound == null ? null : new MinecraftKey(sound);
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutStopSound(soundKey, SoundCategory.valueOf((String)category.name())));
    }

    @Override
    public void deTrackEntity(Player player, org.bukkit.entity.Entity entity) {
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        WorldServer world = (WorldServer)nmsPlayer.world;
        PlayerChunkMap.EntityTracker tracker = (PlayerChunkMap.EntityTracker)world.getChunkProvider().playerChunkMap.trackedEntities.get(entity.getEntityId());
        if (tracker == null) {
            return;
        }
        this.sendEntityDestroy(player, entity);
        tracker.clear(nmsPlayer);
    }

    @Override
    public FakeEntity sendEntitySpawn(List<PlayerTag> players, EntityType entityType, LocationTag location, ArrayList<Mechanism> mechanisms, int customId, UUID customUUID, boolean autoTrack) {
        CraftWorld world = (CraftWorld)location.getWorld();
        Entity nmsEntity = world.createEntity((Location)location, entityType.getEntityClass());
        if (customUUID != null) {
            nmsEntity.e(customId);
            nmsEntity.a_(customUUID);
        }
        EntityTag entity = new EntityTag((org.bukkit.entity.Entity)nmsEntity.getBukkitEntity());
        for (Mechanism mechanism : mechanisms) {
            entity.safeAdjust(mechanism);
        }
        nmsEntity.dead = false;
        final FakeEntity fake = new FakeEntity(players, location, entity.getBukkitEntity().getEntityId());
        fake.entity = new EntityTag(entity.getBukkitEntity());
        final ArrayList<TrackerData> trackers = new ArrayList<TrackerData>();
        for (final PlayerTag player : players) {
            EntityPlayer nmsPlayer = ((CraftPlayer)player.getPlayerEntity()).getHandle();
            PlayerConnection conn = nmsPlayer.playerConnection;
            final EntityTrackerEntry tracker = new EntityTrackerEntry(world.getHandle(), nmsEntity, 1, true, arg_0 -> ((PlayerConnection)conn).sendPacket(arg_0), Collections.singleton(nmsPlayer));
            tracker.b(nmsPlayer);
            TrackerData data = new TrackerData();
            data.player = player;
            data.tracker = tracker;
            trackers.add(data);
            if (!autoTrack) continue;
            new BukkitRunnable(){
                boolean wasOnline = true;

                public void run() {
                    if (!fake.entity.isFakeValid) {
                        this.cancel();
                        return;
                    }
                    if (player.isOnline()) {
                        if (!this.wasOnline) {
                            tracker.b(((CraftPlayer)player.getPlayerEntity()).getHandle());
                            this.wasOnline = true;
                        }
                        tracker.a();
                    } else if (this.wasOnline) {
                        this.wasOnline = false;
                    }
                }
            }.runTaskTimer((Plugin)Denizen.getInstance(), 1L, 1L);
        }
        fake.triggerUpdatePacket = new Runnable(){

            @Override
            public void run() {
                for (TrackerData tracker : trackers) {
                    if (!tracker.player.isOnline()) continue;
                    tracker.tracker.a();
                }
            }
        };
        fake.triggerDestroyPacket = new Runnable(){

            @Override
            public void run() {
                for (TrackerData tracker : trackers) {
                    if (!tracker.player.isOnline()) continue;
                    tracker.tracker.a(((CraftPlayer)tracker.player.getPlayerEntity()).getHandle());
                }
                trackers.clear();
            }
        };
        return fake;
    }

    @Override
    public void sendEntityDestroy(Player player, org.bukkit.entity.Entity entity) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutEntityDestroy(new int[]{entity.getEntityId()}));
    }

    @Override
    public int getFlyKickCooldown(Player player) {
        PlayerConnection conn = ((CraftPlayer)player).getHandle().playerConnection;
        if (conn instanceof AbstractListenerPlayInImpl) {
            conn = ((AbstractListenerPlayInImpl)conn).oldListener;
        }
        try {
            return Math.max(80 - Math.max(FLY_TICKS.getInt(conn), VEHICLE_FLY_TICKS.getInt(conn)), 0);
        }
        catch (IllegalAccessException e) {
            Debug.echoError(e);
            return 80;
        }
    }

    @Override
    public void setFlyKickCooldown(Player player, int ticks) {
        ticks = 80 - ticks;
        PlayerConnection conn = ((CraftPlayer)player).getHandle().playerConnection;
        if (conn instanceof AbstractListenerPlayInImpl) {
            conn = ((AbstractListenerPlayInImpl)conn).oldListener;
        }
        try {
            FLY_TICKS.setInt(conn, ticks);
            VEHICLE_FLY_TICKS.setInt(conn, ticks);
        }
        catch (IllegalAccessException e) {
            Debug.echoError(e);
        }
    }

    @Override
    public int ticksPassedDuringCooldown(Player player) {
        try {
            return ATTACK_COOLDOWN_TICKS.getInt(((CraftPlayer)player).getHandle());
        }
        catch (IllegalAccessException e) {
            Debug.echoError(e);
            return -1;
        }
    }

    @Override
    public float getMaxAttackCooldownTicks(Player player) {
        return ((CraftPlayer)player).getHandle().eR() + 3.0f;
    }

    @Override
    public float getAttackCooldownPercent(Player player) {
        return ((CraftPlayer)player).getHandle().getAttackCooldown(0.5f);
    }

    @Override
    public void setAttackCooldown(Player player, int ticks) {
        try {
            ATTACK_COOLDOWN_TICKS.setInt(((CraftPlayer)player).getHandle(), ticks);
        }
        catch (IllegalAccessException e) {
            Debug.echoError(e);
        }
    }

    @Override
    public boolean hasChunkLoaded(Player player, Chunk chunk) {
        return ((CraftWorld)chunk.getWorld()).getHandle().getChunkProvider().playerChunkMap.a(new ChunkCoordIntPair(chunk.getX(), chunk.getZ()), false).anyMatch(entityPlayer -> entityPlayer.getUniqueID().equals(player.getUniqueId()));
    }

    @Override
    public int getPing(Player player) {
        return ((CraftPlayer)player).getHandle().ping;
    }

    @Override
    public void setTemporaryOp(Player player, boolean op) {
        DedicatedServer server = ((CraftServer)Bukkit.getServer()).getServer();
        GameProfile profile = ((CraftPlayer)player).getProfile();
        OpList opList = server.getPlayerList().getOPs();
        if (op) {
            int permLevel = server.g();
            opList.add((JsonListEntry)new OpListEntry(profile, permLevel, opList.b(profile)));
        } else {
            opList.remove((Object)profile);
        }
        player.recalculatePermissions();
    }

    @Override
    public void showEndCredits(Player player) {
        ((CraftPlayer)player).getHandle().viewingCredits = true;
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.e, 1.0f));
    }

    @Override
    public ImprovedOfflinePlayer getOfflineData(UUID uuid) {
        return new ImprovedOfflinePlayerImpl(uuid);
    }

    @Override
    public ImprovedOfflinePlayer getOfflineData(OfflinePlayer offlinePlayer) {
        return new ImprovedOfflinePlayerImpl(offlinePlayer.getUniqueId());
    }

    @Override
    public void resendRecipeDetails(Player player) {
        Collection recipes = ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().b();
        PacketPlayOutRecipeUpdate updatePacket = new PacketPlayOutRecipeUpdate(recipes);
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)updatePacket);
    }

    @Override
    public void resendDiscoveredRecipes(Player player) {
        RecipeBookServer recipeBook = ((CraftPlayer)player).getHandle().getRecipeBook();
        recipeBook.a(((CraftPlayer)player).getHandle());
    }

    @Override
    public void quietlyAddRecipe(Player player, NamespacedKey key) {
        RecipeBookServer recipeBook = ((CraftPlayer)player).getHandle().getRecipeBook();
        IRecipe<?> recipe = ItemHelperImpl.getNMSRecipe(key);
        if (recipe == null) {
            Debug.echoError("Cannot add recipe '" + key + "': it does not exist.");
            return;
        }
        recipeBook.a(recipe);
        recipeBook.f(recipe);
    }

    @Override
    public String getPlayerBrand(Player player) {
        return ((DenizenNetworkManagerImpl)((CraftPlayer)player).getHandle().playerConnection.networkManager).packetListener.brand;
    }

    @Override
    public byte getSkinLayers(Player player) {
        return (Byte)((CraftPlayer)player).getHandle().getDataWatcher().get(ENTITY_HUMAN_SKINLAYERS_DATAWATCHER);
    }

    @Override
    public void setSkinLayers(Player player, byte flags) {
        ((CraftPlayer)player).getHandle().getDataWatcher().set(ENTITY_HUMAN_SKINLAYERS_DATAWATCHER, (Object)flags);
    }

    @Override
    public void setBossBarTitle(BossBar bar, String title) {
        ((CraftBossBar)bar).getHandle().title = Handler.componentToNMS(FormattedTextHelper.parse(title, ChatColor.WHITE));
        ((CraftBossBar)bar).getHandle().sendUpdate(PacketPlayOutBoss.Action.UPDATE_NAME);
    }

    static {
        DataWatcherObject skinlayers = null;
        try {
            skinlayers = (DataWatcherObject)ReflectionHelper.getFields(EntityHuman.class).get("bi").get(null);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        ENTITY_HUMAN_SKINLAYERS_DATAWATCHER = skinlayers;
    }

    public static class TrackerData {
        public PlayerTag player;
        public EntityTrackerEntry tracker;
    }
}

