/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemChargedProjectile
implements Property {
    public static final String[] handledTags = new String[]{"charged_projectiles", "is_charged"};
    public static final String[] handledMechs = new String[]{"charged_projectiles", "add_charged_projectile", "remove_charged_projectiles"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && ((ItemTag)item).getBukkitMaterial() == Material.CROSSBOW;
    }

    public static ItemChargedProjectile getFrom(ObjectTag item) {
        if (!ItemChargedProjectile.describes(item)) {
            return null;
        }
        return new ItemChargedProjectile((ItemTag)item);
    }

    private ItemChargedProjectile(ItemTag _item) {
        this.item = _item;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("charged_projectiles")) {
            return this.getChargedProjectiles().getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_charged")) {
            return new ElementTag(((CrossbowMeta)this.item.getItemMeta()).hasChargedProjectiles()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public ListTag getChargedProjectiles() {
        CrossbowMeta meta = (CrossbowMeta)this.item.getItemMeta();
        ListTag list = new ListTag();
        if (!meta.hasChargedProjectiles()) {
            return list;
        }
        for (ItemStack projectile : meta.getChargedProjectiles()) {
            list.addObject(new ItemTag(projectile));
        }
        return list;
    }

    @Override
    public String getPropertyString() {
        ListTag projectiles = this.getChargedProjectiles();
        return projectiles.size() > 0 ? projectiles.identify() : null;
    }

    @Override
    public String getPropertyId() {
        return "charged_projectiles";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        CrossbowMeta meta;
        if (mechanism.matches("charged_projectiles")) {
            meta = (CrossbowMeta)this.item.getItemMeta();
            meta.setChargedProjectiles(null);
            for (ItemTag projectile : mechanism.valueAsType(ListTag.class).filter(ItemTag.class, mechanism.context)) {
                try {
                    meta.addChargedProjectile(projectile.getItemStack());
                }
                catch (IllegalArgumentException e) {
                    Debug.echoError("Charged crossbow projectiles may only be arrows or fireworks!");
                }
            }
            this.item.setItemMeta((ItemMeta)meta);
        }
        if (mechanism.matches("add_charged_projectile") && mechanism.requireObject(ItemTag.class)) {
            meta = (CrossbowMeta)this.item.getItemMeta();
            try {
                meta.addChargedProjectile(mechanism.valueAsType(ItemTag.class).getItemStack());
            }
            catch (IllegalArgumentException e) {
                Debug.echoError("Charged crossbow projectiles may only be arrows or fireworks!");
            }
            this.item.setItemMeta((ItemMeta)meta);
        }
        if (mechanism.matches("remove_charged_projectiles")) {
            meta = (CrossbowMeta)this.item.getItemMeta();
            meta.setChargedProjectiles(null);
            this.item.setItemMeta((ItemMeta)meta);
        }
    }
}

