/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.events.OldEventManager;
import net.aufdemrand.denizencore.scripts.ScriptHelper;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.scripts.containers.core.CustomScriptContainer;
import net.aufdemrand.denizencore.scripts.containers.core.ProcedureScriptContainer;
import net.aufdemrand.denizencore.scripts.containers.core.TaskScriptContainer;
import net.aufdemrand.denizencore.scripts.containers.core.WorldScriptContainer;
import net.aufdemrand.denizencore.scripts.containers.core.YamlDataScriptContainer;
import net.aufdemrand.denizencore.utilities.YamlConfiguration;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import net.aufdemrand.denizencore.utilities.text.StringHolder;

public class ScriptRegistry {
    private static Map<String, Object> scriptContainers = new HashMap<String, Object>();
    private static Map<String, Class<? extends ScriptContainer>> scriptContainerTypes = new HashMap<String, Class<? extends ScriptContainer>>();
    public static List<YamlConfiguration> outside_scripts = new ArrayList<YamlConfiguration>();

    public static void _registerType(String typeName, Class<? extends ScriptContainer> scriptContainerClass) {
        scriptContainerTypes.put(typeName.toUpperCase(), scriptContainerClass);
    }

    public static Set<String> _getScriptNames() {
        return scriptContainers.keySet();
    }

    public static void _registerCoreTypes() {
        ScriptRegistry._registerType("custom", CustomScriptContainer.class);
        ScriptRegistry._registerType("task", TaskScriptContainer.class);
        ScriptRegistry._registerType("procedure", ProcedureScriptContainer.class);
        ScriptRegistry._registerType("world", WorldScriptContainer.class);
        ScriptRegistry._registerType("yaml data", YamlDataScriptContainer.class);
    }

    public static boolean containsScript(String id) {
        return scriptContainers.containsKey(id.toUpperCase());
    }

    public static boolean containsScript(String id, Class scriptContainerType) {
        if (!scriptContainers.containsKey(id.toUpperCase())) {
            return false;
        }
        ScriptContainer script = (ScriptContainer)scriptContainers.get(id.toUpperCase());
        String type = null;
        for (Map.Entry<String, Class<? extends ScriptContainer>> entry : scriptContainerTypes.entrySet()) {
            if (entry.getValue() != scriptContainerType) continue;
            type = entry.getKey();
        }
        return type != null && script.getContainerType().equalsIgnoreCase(type);
    }

    public static void _buildCoreYamlScriptContainers(YamlConfiguration yamlScripts) {
        scriptContainers.clear();
        OldEventManager.world_scripts.clear();
        OldEventManager.events.clear();
        DenizenCore.getImplementation().refreshScriptContainers();
        if (yamlScripts == null) {
            return;
        }
        Set<StringHolder> scripts = yamlScripts.getKeys(false);
        for (StringHolder scriptName1 : scripts) {
            String scriptName = scriptName1.str;
            if (yamlScripts.contains(scriptName + ".TYPE")) {
                String type = yamlScripts.getString(scriptName + ".TYPE");
                if (!scriptContainerTypes.containsKey(type.toUpperCase())) {
                    dB.log("<G>Trying to load an invalid script. '<A>" + scriptName + "<Y>(" + type + ")'<G> is an unknown type.");
                    ScriptHelper.setHadError();
                    continue;
                }
                Class<? extends ScriptContainer> typeClass = scriptContainerTypes.get(type.toUpperCase());
                dB.log("Adding script " + scriptName + " as type " + type.toUpperCase());
                try {
                    scriptContainers.put(scriptName, typeClass.getConstructor(YamlConfiguration.class, String.class).newInstance(ScriptHelper._gs().getConfigurationSection(scriptName), scriptName));
                }
                catch (Exception e) {
                    dB.echoError(e);
                    ScriptHelper.setHadError();
                }
                continue;
            }
            dB.echoError("Found type-less container: '" + scriptName + "'.");
            ScriptHelper.setHadError();
        }
    }

    public static void addYamlScriptContainer(YamlConfiguration yaml_script) {
        outside_scripts.add(yaml_script);
    }

    public static void removeYamlScriptContainer(YamlConfiguration yaml_script) {
        outside_scripts.remove(yaml_script);
        DenizenCore.reloadScripts();
    }

    public static <T extends ScriptContainer> T getScriptContainerAs(String name, Class<T> type) {
        try {
            if (scriptContainers.containsKey(name.toUpperCase())) {
                return (T)((ScriptContainer)type.cast(scriptContainers.get(name.toUpperCase())));
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T extends ScriptContainer> T getScriptContainer(String name) {
        if (scriptContainers.containsKey(name.toUpperCase())) {
            return (T)((ScriptContainer)scriptContainers.get(name.toUpperCase()));
        }
        return null;
    }
}

