/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.AreaContainmentObject;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EllipsoidTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.notable.NotableManager;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.block.Biome;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;

public class AreaEnterExitScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static AreaEnterExitScriptEvent instance;
    public PlayerTag currentPlayer;
    public AreaContainmentObject area;
    public boolean isEntering;
    public Location to;
    public boolean doTrackAll = false;
    public String[] exactTracked = null;
    public ScriptEvent.MatchHelper[] matchers = null;
    public static HashMap<UUID, HashSet<String>> playersInArea;

    public AreaEnterExitScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventLower.startsWith("player enters") && !path.eventLower.startsWith("player exits")) {
            return false;
        }
        if (path.eventArgLowerAt(2).equals("biome") || this.exactMatchesEnum(path.eventArgLowerAt(2), (Enum<?>[])Biome.values())) {
            return false;
        }
        if (this.exactMatchEntity(path.eventArgLowerAt(2))) {
            return false;
        }
        return !path.eventArgLowerAt(2).equals("bed") && !path.eventArgLowerAt(2).equals("portal");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (this.isEntering && !path.eventArgLowerAt(1).equals("enters")) {
            return false;
        }
        if (!this.isEntering && !path.eventArgLowerAt(1).equals("exits")) {
            return false;
        }
        String areaName = path.eventArgLowerAt(2);
        if (areaName.equals("notable")) {
            areaName = path.eventArgLowerAt(3);
        }
        if (areaName.equals("cuboid") ? !(this.area instanceof CuboidTag) : (areaName.equals("ellipsoid") ? !(this.area instanceof EllipsoidTag) : !this.runGenericCheck(areaName, this.area.getNoteName()))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "AreaEnterExit";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.currentPlayer, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("area")) {
            return this.area;
        }
        if (name.equals("cause")) {
            String cause = this.currentEvent instanceof PlayerJoinEvent ? "JOIN" : (this.currentEvent instanceof PlayerQuitEvent ? "QUIT" : (this.currentEvent instanceof PlayerChangedWorldEvent ? "WORLD_CHANGE" : (this.currentEvent instanceof PlayerTeleportEvent ? "TELEPORT" : (this.currentEvent instanceof VehicleMoveEvent ? "VEHICLE" : (this.currentEvent instanceof PlayerMoveEvent ? "WALK" : "UNKNOWN")))));
            return new ElementTag(cause);
        }
        if (name.equals("to")) {
            return new LocationTag(this.to);
        }
        if (name.equals("from")) {
            if (this.currentEvent instanceof PlayerMoveEvent) {
                return new LocationTag(((PlayerMoveEvent)this.currentEvent).getFrom());
            }
            if (this.currentEvent instanceof VehicleMoveEvent) {
                return new LocationTag(((VehicleMoveEvent)this.currentEvent).getFrom());
            }
            return new LocationTag(this.currentPlayer.getLocation());
        }
        return super.getContext(name);
    }

    @Override
    public void init() {
        super.init();
        this.doTrackAll = false;
        boolean needsMatchers = false;
        HashSet<String> exacts = new HashSet<String>();
        ArrayList<ScriptEvent.MatchHelper> matchList = new ArrayList<ScriptEvent.MatchHelper>();
        for (ScriptEvent.ScriptPath path : this.eventPaths) {
            String area = path.eventArgLowerAt(2);
            if (area.equals("notable")) {
                area = path.eventArgLowerAt(3);
            }
            if (area.equals("cuboid")) {
                this.doTrackAll = true;
                break;
            }
            if (area.equals("ellipsoid")) {
                this.doTrackAll = true;
                break;
            }
            ScriptEvent.MatchHelper matcher = AreaEnterExitScriptEvent.createMatcher(area);
            if (matcher instanceof ScriptEvent.AlwaysMatchHelper) {
                this.doTrackAll = true;
                break;
            }
            if (!needsMatchers && matcher instanceof ScriptEvent.ExactMatchHelper) {
                exacts.add(area);
            } else {
                needsMatchers = true;
            }
            matchList.add(matcher);
        }
        this.exactTracked = needsMatchers ? null : exacts.toArray(new String[0]);
        this.matchers = needsMatchers ? matchList.toArray(new ScriptEvent.MatchHelper[0]) : null;
    }

    @Override
    public void cancellationChanged() {
        if (this.cancelled) {
            HashSet<String> inAreas = playersInArea.get(this.currentPlayer.getOfflinePlayer().getUniqueId());
            if (this.isEntering) {
                inAreas.remove(CoreUtilities.toLowerCase(this.area.getNoteName()));
            } else {
                inAreas.add(CoreUtilities.toLowerCase(this.area.getNoteName()));
            }
        }
        super.cancellationChanged();
    }

    public boolean anyMatch(String name) {
        if (this.doTrackAll) {
            return true;
        }
        for (ScriptEvent.MatchHelper matcher : this.matchers) {
            if (!matcher.doesMatch(name)) continue;
            return true;
        }
        return false;
    }

    public void processSingle(AreaContainmentObject obj, Player player, HashSet<String> inAreas, Location pos, Event eventCause) {
        boolean wasContained;
        boolean containedNow = obj.doesContainLocation(pos);
        boolean bl = wasContained = inAreas != null && inAreas.contains(obj.getNoteName());
        if (containedNow == wasContained) {
            return;
        }
        if (containedNow) {
            inAreas.add(obj.getNoteName());
        } else {
            inAreas.remove(obj.getNoteName());
        }
        this.currentPlayer = new PlayerTag(player);
        this.isEntering = containedNow;
        this.area = obj;
        this.to = pos;
        this.fire(eventCause);
    }

    public void processNewPosition(Player player, Location pos, Event eventCause) {
        if (EntityTag.isNPC((Entity)player)) {
            return;
        }
        HashSet<String> inAreas = playersInArea.get(player.getUniqueId());
        if (inAreas == null) {
            inAreas = new HashSet();
            playersInArea.put(player.getUniqueId(), inAreas);
        }
        if (this.doTrackAll || this.matchers != null) {
            for (CuboidTag cuboid : NotableManager.getAllType(CuboidTag.class)) {
                if (!this.anyMatch(cuboid.noteName)) continue;
                this.processSingle(cuboid, player, inAreas, pos, eventCause);
            }
            for (EllipsoidTag ellipsoid : NotableManager.getAllType(EllipsoidTag.class)) {
                if (!this.anyMatch(ellipsoid.noteName)) continue;
                this.processSingle(ellipsoid, player, inAreas, pos, eventCause);
            }
        } else {
            for (String name : this.exactTracked) {
                Notable obj = NotableManager.getSavedObject(name);
                if (!(obj instanceof AreaContainmentObject)) {
                    Debug.echoError("Invalid area enter/exit event area '" + name + "'");
                    continue;
                }
                this.processSingle((AreaContainmentObject)((Object)obj), player, inAreas, pos, eventCause);
            }
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.processNewPosition(event.getPlayer(), new Location(event.getPlayer().getWorld(), 1.0E7, 1.0E7, 1.0E7), (Event)event);
        playersInArea.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        this.processNewPosition(event.getPlayer(), event.getPlayer().getLocation(), (Event)event);
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        if (LocationTag.isSameBlock(event.getFrom(), event.getTo())) {
            return;
        }
        this.processNewPosition(event.getPlayer(), event.getTo(), (Event)event);
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent event) {
        this.processNewPosition(event.getPlayer(), event.getTo(), (Event)event);
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        this.processNewPosition(event.getPlayer(), event.getPlayer().getLocation(), (Event)event);
    }

    @EventHandler
    public void onVehicleMove(VehicleMoveEvent event) {
        if (LocationTag.isSameBlock(event.getFrom(), event.getTo())) {
            return;
        }
        for (Entity entity : event.getVehicle().getPassengers()) {
            if (!EntityTag.isPlayer(entity)) continue;
            this.processNewPosition((Player)entity, event.getTo(), (Event)event);
        }
    }

    static {
        playersInArea = new HashMap();
    }
}

