/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.flags;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.events.core.FlagSmartEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.events.OldEventManager;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.configuration.ConfigurationSection;

public class FlagManager {
    private Denizen denizen;

    public FlagManager(Denizen denizen) {
        this.denizen = denizen;
    }

    public static boolean playerHasFlag(dPlayer player, String flagName) {
        if (player == null || flagName == null) {
            return false;
        }
        return DenizenAPI.getCurrentInstance().flagManager().getPlayerFlag(player, flagName).size() > 0;
    }

    public static boolean entityHasFlag(dEntity entity, String flagName) {
        if (entity == null || flagName == null) {
            return false;
        }
        return DenizenAPI.getCurrentInstance().flagManager().getEntityFlag(entity, flagName).size() > 0;
    }

    public static boolean npcHasFlag(dNPC npc, String flagName) {
        if (npc == null || flagName == null) {
            return false;
        }
        return DenizenAPI.getCurrentInstance().flagManager().getNPCFlag(npc.getId(), flagName).size() > 0;
    }

    public static boolean serverHasFlag(String flagName) {
        if (flagName == null) {
            return false;
        }
        return DenizenAPI.getCurrentInstance().flagManager().getGlobalFlag(flagName).size() > 0;
    }

    public static void clearNPCFlags(int npcid) {
        DenizenAPI.getCurrentInstance().getSaves().set("NPCs." + npcid, null);
    }

    public static void clearEntityFlags(dEntity entity) {
        DenizenAPI.getCurrentInstance().getSaves().set("Entities." + entity.getSaveName(), null);
    }

    public Flag getNPCFlag(int npcid, String flagName) {
        return new Flag("NPCs." + npcid + ".Flags." + flagName.toUpperCase(), flagName, "n@" + npcid);
    }

    public Flag getGlobalFlag(String flagName) {
        return new Flag("Global.Flags." + flagName.toUpperCase(), flagName, "SERVER");
    }

    public Flag getPlayerFlag(dPlayer player, String flagName) {
        if (player == null) {
            return new Flag("players.00.UNKNOWN.Flags." + flagName.toUpperCase(), flagName, "p@null");
        }
        return new Flag("Players." + player.getSaveName() + ".Flags." + flagName.toUpperCase(), flagName, player.identify());
    }

    public Flag getEntityFlag(dEntity entity, String flagName) {
        if (entity == null) {
            return new Flag("Entities.00.UNKNOWN.Flags." + flagName.toUpperCase(), flagName, "p@null");
        }
        return new Flag("Entities." + entity.getSaveName() + ".Flags." + flagName.toUpperCase(), flagName, entity.identify());
    }

    public Flag getPlayerFlag(UUID player, String flagName) {
        if (player == null) {
            return new Flag("players.00.UNKNOWN.Flags." + flagName.toUpperCase(), flagName, "p@null");
        }
        String baseID = player.toString().toUpperCase().replace("-", "");
        return new Flag("Players." + baseID.substring(0, 2) + "." + baseID + ".Flags." + flagName.toUpperCase(), flagName, "p@" + player.toString());
    }

    public Set<String> listNPCFlags(int npcid) {
        ConfigurationSection section = this.denizen.getSaves().getConfigurationSection("NPCs." + npcid + ".Flags");
        return section != null ? this._filterExpirations(section.getValues(true).keySet()) : null;
    }

    public void shrinkGlobalFlags(Collection<String> set) {
        for (String str : new HashSet<String>(set)) {
            if (FlagManager.serverHasFlag(str)) continue;
            set.remove(str);
        }
    }

    public void shrinkPlayerFlags(dPlayer player, Collection<String> set) {
        for (String str : new HashSet<String>(set)) {
            if (FlagManager.playerHasFlag(player, str)) continue;
            set.remove(str);
        }
    }

    public void shrinkEntityFlags(dEntity entity, Collection<String> set) {
        for (String str : new HashSet<String>(set)) {
            if (FlagManager.entityHasFlag(entity, str)) continue;
            set.remove(str);
        }
    }

    public Set<String> listGlobalFlags() {
        ConfigurationSection section = this.denizen.getSaves().getConfigurationSection("Global.Flags");
        return section != null ? this._filterExpirations(section.getValues(true).keySet()) : null;
    }

    public Set<String> listPlayerFlags(dPlayer player) {
        ConfigurationSection section = this.denizen.getSaves().getConfigurationSection("Players." + player.getSaveName() + ".Flags");
        return section != null ? this._filterExpirations(section.getValues(true).keySet()) : null;
    }

    public Set<String> listEntityFlags(dEntity entity) {
        ConfigurationSection section = this.denizen.getSaves().getConfigurationSection("Entities." + entity.getSaveName() + ".Flags");
        return section != null ? this._filterExpirations(section.getValues(true).keySet()) : null;
    }

    public Set<String> _filterExpirations(Set<String> flagKeys) {
        Iterator<String> iter = flagKeys.iterator();
        while (iter.hasNext()) {
            if (!iter.next().endsWith("-expiration")) continue;
            iter.remove();
        }
        return flagKeys;
    }

    public class Value {
        private List<String> values;
        private int index = -1;

        private Value(List<String> values) {
            this.values = values;
            if (this.values == null) {
                this.values = new ArrayList<String>();
            }
        }

        private void adjustIndex() {
            if (this.index < 0) {
                this.index = this.size() - 1;
            }
        }

        public boolean asBoolean() {
            this.adjustIndex();
            try {
                return !this.values.get(this.index).equalsIgnoreCase("FALSE");
            }
            catch (Exception e) {
                return false;
            }
        }

        public double asDouble() {
            this.adjustIndex();
            try {
                return Double.valueOf(this.values.get(this.index));
            }
            catch (Exception e) {
                return 0.0;
            }
        }

        public int asInteger() {
            this.adjustIndex();
            try {
                return Double.valueOf(this.values.get(this.index)).intValue();
            }
            catch (Exception e) {
                return 0;
            }
        }

        public String asCommaSeparatedList() {
            this.adjustIndex();
            String returnList = "";
            for (String string : this.values) {
                returnList = returnList + string + ", ";
            }
            return returnList.substring(0, returnList.length() - 2);
        }

        public dList asList() {
            this.adjustIndex();
            return new dList(this.values);
        }

        public dList asList(String prefix) {
            this.adjustIndex();
            return new dList(this.values, prefix);
        }

        public String asString() {
            this.adjustIndex();
            try {
                return this.values.get(this.index);
            }
            catch (Exception e) {
                return "";
            }
        }

        public int asSize() {
            this.adjustIndex();
            return this.values.size();
        }

        public Object asAutoDetectedObject() {
            this.adjustIndex();
            String arg = this.values.get(this.index);
            try {
                if (aH.matchesInteger(arg)) {
                    return aH.getIntegerFrom(arg);
                }
                if (aH.matchesDouble(arg)) {
                    return aH.getDoubleFrom(arg);
                }
                if (arg.equalsIgnoreCase("true")) {
                    return true;
                }
                if (arg.equalsIgnoreCase("false")) {
                    return false;
                }
                if (arg.contains("|")) {
                    ArrayList<String> toList = new ArrayList<String>();
                    return new dList((List<String>)toList);
                }
                return arg;
            }
            catch (Exception e) {
                return "";
            }
        }

        private Value get(int i) {
            this.index = i - 1;
            this.adjustIndex();
            return this;
        }

        public boolean isEmpty() {
            if (this.values.isEmpty()) {
                return true;
            }
            this.adjustIndex();
            if (this.size() < this.index + 1) {
                return true;
            }
            return this.values.get(this.index).equals("");
        }

        private int size() {
            return this.values.size();
        }
    }

    public class Flag {
        private Value value;
        private String flagPath;
        private String flagName;
        private String flagOwner;
        private long expiration = -1L;
        private boolean valid = true;

        Flag(String flagPath, String flagName, String flagOwner) {
            this.flagPath = flagPath;
            this.flagName = flagName;
            this.flagOwner = flagOwner;
            this.rebuild();
        }

        public boolean contains(String stringValue) {
            if (this.checkExpired()) {
                return false;
            }
            for (String val : this.value.values) {
                if (val.equalsIgnoreCase(stringValue)) {
                    return true;
                }
                try {
                    if (!Double.valueOf(val).equals(Double.valueOf(stringValue))) continue;
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            return false;
        }

        public boolean StillValid() {
            return this.valid;
        }

        public List<String> values() {
            this.checkExpired();
            return this.value.values;
        }

        public Value get(int index) {
            this.checkExpired();
            return this.value.get(index);
        }

        public void clear() {
            String OldOwner = this.flagOwner;
            String OldName = this.flagName;
            dObject.ObjectAttributable OldValue = this.value.size() > 1 ? new dList(FlagManager.this.denizen.getSaves().getStringList(this.flagPath)) : (this.value.size() == 1 ? new Element(this.value.get(0).asString()) : Element.valueOf("null"));
            FlagManager.this.denizen.getSaves().set(this.flagPath, null);
            FlagManager.this.denizen.getSaves().set(this.flagPath + "-expiration", null);
            this.valid = false;
            this.rebuild();
            if (FlagSmartEvent.IsActive()) {
                ArrayList<String> world_script_events = new ArrayList<String>();
                HashMap<String, dObject> context = new HashMap<String, dObject>();
                dPlayer player = null;
                if (dPlayer.matches(OldOwner)) {
                    player = dPlayer.valueOf(OldOwner);
                }
                dNPC npc = null;
                if (Depends.citizens != null && dNPC.matches(OldOwner)) {
                    npc = dNPC.valueOf(OldOwner);
                }
                String type = player != null ? "player" : (npc != null ? "npc" : "server");
                world_script_events.add(type + " flag cleared");
                world_script_events.add(type + " flag " + OldName + " cleared");
                context.put("owner", new Element(OldOwner));
                context.put("name", new Element(OldName));
                context.put("type", new Element(type));
                context.put("old_value", (dObject)((Object)OldValue));
                world_script_events.add("flag cleared");
                OldEventManager.doEvents(world_script_events, new BukkitScriptEntryData(player, npc), context);
            }
        }

        public Value getFirst() {
            this.checkExpired();
            return this.value.get(1);
        }

        public Value getLast() {
            this.checkExpired();
            return this.value.get(this.value.size());
        }

        public void set(Object obj) {
            this.set(obj, -1);
        }

        public void set(Object obj, int index) {
            this.checkExpired();
            if (index < 0) {
                this.value.values.clear();
                this.value.values.add((String)obj);
            } else if (this.size() == 0) {
                this.value.values.add((String)obj);
            } else if (index > 0) {
                if (this.value.values.size() > index - 1) {
                    this.value.values.remove(index - 1);
                    this.value.values.add(index - 1, (String)obj);
                } else {
                    this.value.values.add((String)obj);
                }
            }
            this.valid = true;
            this.save();
            this.rebuild();
        }

        public int add(Object obj) {
            this.checkExpired();
            this.value.values.add((String)obj);
            this.valid = true;
            this.save();
            this.rebuild();
            return this.size();
        }

        public int split(Object obj) {
            this.checkExpired();
            dList split = dList.valueOf(obj.toString());
            if (split.size() > 0) {
                for (String val : split) {
                    if (val.length() <= 0) continue;
                    this.value.values.add(val);
                }
                this.save();
                this.rebuild();
            }
            return this.size();
        }

        public int splitNew(Object obj) {
            this.checkExpired();
            dList split = dList.valueOf(obj.toString());
            if (split.size() > 0) {
                this.value.values.clear();
                for (String val : split) {
                    if (val.length() <= 0) continue;
                    this.value.values.add(val);
                }
                this.save();
                this.rebuild();
            } else {
                this.clear();
            }
            return this.size();
        }

        public void remove(Object obj) {
            this.remove(obj, -1);
        }

        public void remove(Object obj, int index) {
            this.checkExpired();
            if (index <= 0 && obj != null) {
                int x = 0;
                for (String val : this.value.values) {
                    block8: {
                        if (val.equalsIgnoreCase(String.valueOf(obj))) {
                            this.value.values.remove(x);
                            break;
                        }
                        try {
                            if (!Double.valueOf(val).equals(Double.valueOf((String)obj))) break block8;
                            this.value.values.remove(x);
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++x;
                }
            } else if (index <= this.size()) {
                this.value.values.remove(index - 1);
            }
            this.valid = true;
            this.save();
            this.rebuild();
        }

        public void setExpiration(Long expiration) {
            this.valid = true;
            this.expiration = expiration;
            this.save();
        }

        public int size() {
            this.checkExpired();
            return this.value.size();
        }

        public void save() {
            String OldOwner = this.flagOwner;
            String OldName = this.flagName;
            List oldValueList = FlagManager.this.denizen.getSaves().getStringList(this.flagPath);
            dList OldValue = oldValueList.size() > 1 ? new dList(oldValueList) : (oldValueList.size() == 1 ? new Element((String)oldValueList.get(0)) : Element.valueOf("null"));
            FlagManager.this.denizen.getSaves().set(this.flagPath, (Object)this.value.values);
            FlagManager.this.denizen.getSaves().set(this.flagPath + "-expiration", this.expiration > 0L ? Long.valueOf(this.expiration) : null);
            this.rebuild();
            if (FlagSmartEvent.IsActive()) {
                ArrayList<String> world_script_events = new ArrayList<String>();
                HashMap<String, dObject> context = new HashMap<String, dObject>();
                dPlayer player = null;
                if (dPlayer.matches(OldOwner)) {
                    player = dPlayer.valueOf(OldOwner);
                }
                dNPC npc = null;
                if (Depends.citizens != null && dNPC.matches(OldOwner)) {
                    npc = dNPC.valueOf(OldOwner);
                }
                dEntity entity = null;
                if (dEntity.matches(OldOwner)) {
                    entity = dEntity.valueOf(OldOwner);
                }
                String type = player != null ? "player" : (npc != null ? "npc" : (entity != null ? "entity" : "server"));
                world_script_events.add(type + " flag changed");
                world_script_events.add(type + " flag " + OldName + " changed");
                context.put("owner", Element.valueOf(OldOwner));
                context.put("name", Element.valueOf(OldName));
                context.put("type", Element.valueOf(type));
                context.put("old_value", OldValue);
                world_script_events.add("flag changed");
                OldEventManager.doEvents(world_script_events, new BukkitScriptEntryData(player, npc), context);
            }
        }

        public String toString() {
            this.checkExpired();
            return this.flagOwner.equalsIgnoreCase("SERVER") ? "fl@" + this.flagName : "fl[" + this.flagOwner + "]@" + this.flagName;
        }

        public boolean checkExpired() {
            this.rebuild();
            if (FlagManager.this.denizen.getSaves().contains(this.flagPath + "-expiration") && this.expiration > 1L && this.expiration < DenizenCore.currentTimeMillis) {
                String OldOwner = this.flagOwner;
                String OldName = this.flagName;
                dObject.ObjectAttributable OldValue = this.value.size() > 1 ? new dList(FlagManager.this.denizen.getSaves().getStringList(this.flagPath)) : (this.value.size() == 1 ? new Element(this.value.get(0).asString()) : Element.valueOf("null"));
                FlagManager.this.denizen.getSaves().set(this.flagPath + "-expiration", null);
                FlagManager.this.denizen.getSaves().set(this.flagPath, null);
                this.valid = false;
                this.rebuild();
                if (FlagSmartEvent.IsActive()) {
                    ArrayList<String> world_script_events = new ArrayList<String>();
                    HashMap<String, dObject> context = new HashMap<String, dObject>();
                    dPlayer player = null;
                    if (dPlayer.matches(OldOwner)) {
                        player = dPlayer.valueOf(OldOwner);
                    }
                    dNPC npc = null;
                    if (Depends.citizens != null && dNPC.matches(OldOwner)) {
                        npc = dNPC.valueOf(OldOwner);
                    }
                    dEntity entity = null;
                    if (dEntity.matches(OldOwner)) {
                        entity = dEntity.valueOf(OldOwner);
                    }
                    String type = player != null ? "player" : (npc != null ? "npc" : (entity != null ? "entity" : "server"));
                    world_script_events.add(type + " flag expires");
                    world_script_events.add(type + " flag " + OldName + " expires");
                    context.put("owner", Element.valueOf(OldOwner));
                    context.put("name", Element.valueOf(OldName));
                    context.put("type", Element.valueOf(type));
                    context.put("old_value", (dObject)((Object)OldValue));
                    world_script_events.add("flag expires");
                    OldEventManager.doEvents(world_script_events, new BukkitScriptEntryData(player, npc), context);
                }
                return true;
            }
            return false;
        }

        public Duration expiration() {
            return new Duration((double)(this.expiration - DenizenCore.currentTimeMillis) / 1000.0);
        }

        @Deprecated
        public String expirationTime() {
            this.rebuild();
            long seconds = (this.expiration - DenizenCore.currentTimeMillis) / 1000L;
            long days = seconds / 86400L;
            long hours = (seconds - days * 86400L) / 3600L;
            long minutes = (seconds - days * 86400L - hours * 3600L) / 60L;
            seconds = seconds - days * 86400L - hours * 3600L - minutes * 60L;
            String timeString = "";
            if (days > 0L) {
                timeString = String.valueOf(days) + "d ";
            }
            if (hours > 0L) {
                timeString = timeString + String.valueOf(hours) + "h ";
            }
            if (minutes > 0L && days == 0L) {
                timeString = timeString + String.valueOf(minutes) + "m ";
            }
            if (seconds > 0L && minutes < 10L && hours == 0L && days == 0L) {
                timeString = timeString + String.valueOf(seconds) + "s";
            }
            return timeString.trim();
        }

        public Flag rebuild() {
            ArrayList<String> cval;
            if (FlagManager.this.denizen.getSaves().contains(this.flagPath + "-expiration")) {
                this.expiration = FlagManager.this.denizen.getSaves().getLong(this.flagPath + "-expiration");
            }
            if ((cval = FlagManager.this.denizen.getSaves().getStringList(this.flagPath)) == null) {
                cval = new ArrayList<String>();
                cval.add(FlagManager.this.denizen.getSaves().getString(this.flagPath, ""));
            }
            this.value = new Value(cval);
            return this;
        }

        public boolean isEmpty() {
            return this.value.isEmpty();
        }

        public void doAction(Action action, Element value, Integer index) {
            String val;
            String string = val = value != null ? value.asString() : null;
            if (index == null) {
                index = -1;
            }
            if (action == null) {
                return;
            }
            switch (action) {
                case INCREASE: 
                case DECREASE: 
                case MULTIPLY: 
                case DIVIDE: {
                    double currentValue = this.get(index).asDouble();
                    this.set(CoreUtilities.doubleToString(this.math(currentValue, Double.valueOf(value.asString()), action)), index);
                    break;
                }
                case SET_BOOLEAN: {
                    this.set("true", index);
                    break;
                }
                case SET_VALUE: {
                    this.set(val, index);
                    break;
                }
                case INSERT: {
                    this.add(val);
                    break;
                }
                case REMOVE: {
                    this.remove(val, index);
                    break;
                }
                case SPLIT: {
                    this.split(val);
                    break;
                }
                case SPLIT_NEW: {
                    this.splitNew(val);
                    break;
                }
                case DELETE: {
                    this.clear();
                }
            }
        }

        private double math(double currentValue, double value, Action flagAction) {
            switch (flagAction) {
                case INCREASE: {
                    return currentValue + value;
                }
                case DECREASE: {
                    return currentValue - value;
                }
                case MULTIPLY: {
                    return currentValue * value;
                }
                case DIVIDE: {
                    return currentValue / value;
                }
            }
            return 0.0;
        }
    }

    public static enum Action {
        SET_VALUE,
        SET_BOOLEAN,
        INCREASE,
        DECREASE,
        MULTIPLY,
        DIVIDE,
        INSERT,
        REMOVE,
        SPLIT,
        SPLIT_NEW,
        DELETE;

    }
}

