/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_16.helpers;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.PacketHelper;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.JNBTListTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.nms.v1_16.Handler;
import com.denizenscript.denizen.nms.v1_16.impl.SidebarImpl;
import com.denizenscript.denizen.nms.v1_16.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.mojang.datafixers.util.Pair;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.server.v1_16_R3.Block;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.DataWatcher;
import net.minecraft.server.v1_16_R3.DataWatcherObject;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityCaveSpider;
import net.minecraft.server.v1_16_R3.EntityCreeper;
import net.minecraft.server.v1_16_R3.EntityEnderman;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.EntityLiving;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.EntitySpider;
import net.minecraft.server.v1_16_R3.EntityTrackerEntry;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.EnumHand;
import net.minecraft.server.v1_16_R3.IChatBaseComponent;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketPlayInClientCommand;
import net.minecraft.server.v1_16_R3.PacketPlayOutAbilities;
import net.minecraft.server.v1_16_R3.PacketPlayOutBlockAction;
import net.minecraft.server.v1_16_R3.PacketPlayOutBlockBreakAnimation;
import net.minecraft.server.v1_16_R3.PacketPlayOutCamera;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_16_R3.PacketPlayOutExperience;
import net.minecraft.server.v1_16_R3.PacketPlayOutGameStateChange;
import net.minecraft.server.v1_16_R3.PacketPlayOutOpenBook;
import net.minecraft.server.v1_16_R3.PacketPlayOutOpenSignEditor;
import net.minecraft.server.v1_16_R3.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_16_R3.PacketPlayOutPlayerListHeaderFooter;
import net.minecraft.server.v1_16_R3.PacketPlayOutScoreboardTeam;
import net.minecraft.server.v1_16_R3.PacketPlayOutSetSlot;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_16_R3.PacketPlayOutTileEntityData;
import net.minecraft.server.v1_16_R3.PacketPlayOutTitle;
import net.minecraft.server.v1_16_R3.PacketPlayOutUpdateHealth;
import net.minecraft.server.v1_16_R3.PacketPlayOutWorldBorder;
import net.minecraft.server.v1_16_R3.PlayerChunkMap;
import net.minecraft.server.v1_16_R3.ScoreboardTeam;
import net.minecraft.server.v1_16_R3.ScoreboardTeamBase;
import net.minecraft.server.v1_16_R3.TileEntity;
import net.minecraft.server.v1_16_R3.TileEntitySign;
import net.minecraft.server.v1_16_R3.World;
import net.minecraft.server.v1_16_R3.WorldBorder;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.block.banner.Pattern;
import org.bukkit.craftbukkit.v1_16_R3.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class PacketHelperImpl
implements PacketHelper {
    public static final DataWatcherObject<Float> ENTITY_HUMAN_DATA_WATCHER_ABSORPTION = (DataWatcherObject)ReflectionHelper.getFieldValue(EntityHuman.class, "c", null);
    public static final DataWatcherObject<Byte> ENTITY_DATA_WATCHER_FLAGS = (DataWatcherObject)ReflectionHelper.getFieldValue(Entity.class, "S", null);
    public static final MethodHandle ABILITIES_PACKET_FOV_SETTER = ReflectionHelper.getFinalSetter(PacketPlayOutAbilities.class, "f");
    public static MethodHandle ENTITY_METADATA_EID_SETTER = ReflectionHelper.getFinalSetter(PacketPlayOutEntityMetadata.class, "a");
    public static MethodHandle ENTITY_METADATA_LIST_SETTER = ReflectionHelper.getFinalSetter(PacketPlayOutEntityMetadata.class, "b");
    public static DataWatcherObject<Optional<IChatBaseComponent>> ENTITY_CUSTOM_NAME_METADATA;
    public static DataWatcherObject<Boolean> ENTITY_CUSTOM_NAME_VISIBLE_METADATA;
    public static Field ENTITY_TRACKER_ENTRY_GETTER;
    public static HashMap<UUID, HashMap<UUID, ScoreboardTeam>> noCollideTeamMap;

    @Override
    public void setFakeAbsorption(Player player, float value) {
        DataWatcher dw = new DataWatcher(null);
        dw.register(ENTITY_HUMAN_DATA_WATCHER_ABSORPTION, (Object)Float.valueOf(value));
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutEntityMetadata(player.getEntityId(), dw, true));
    }

    @Override
    public void resetWorldBorder(Player player) {
        WorldBorder wb = ((CraftWorld)player.getWorld()).getHandle().getWorldBorder();
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutWorldBorder(wb, PacketPlayOutWorldBorder.EnumWorldBorderAction.INITIALIZE));
    }

    @Override
    public void setWorldBorder(Player player, Location center, double size, double currSize, long time, int warningDistance, int warningTime) {
        WorldBorder wb = new WorldBorder();
        wb.world = ((CraftWorld)player.getWorld()).getHandle();
        wb.setCenter(center.getX(), center.getZ());
        wb.setWarningDistance(warningDistance);
        wb.setWarningTime(warningTime);
        if (time > 0L) {
            wb.transitionSizeBetween(currSize, size, time);
        } else {
            wb.setSize(size);
        }
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutWorldBorder(wb, PacketPlayOutWorldBorder.EnumWorldBorderAction.INITIALIZE));
    }

    @Override
    public void setSlot(Player player, int slot, ItemStack itemStack, boolean playerOnly) {
        int windowId = playerOnly ? 0 : ((CraftPlayer)player).getHandle().activeContainer.windowId;
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutSetSlot(windowId, slot, CraftItemStack.asNMSCopy((ItemStack)itemStack)));
    }

    @Override
    public void setFieldOfView(Player player, float fov) {
        PacketPlayOutAbilities packet = new PacketPlayOutAbilities(((CraftPlayer)player).getHandle().abilities);
        if (!Float.isNaN(fov)) {
            try {
                ABILITIES_PACKET_FOV_SETTER.invoke(packet, fov);
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
        }
        PacketHelperImpl.sendPacket(player, (Packet)packet);
    }

    @Override
    public void respawn(Player player) {
        ((CraftPlayer)player).getHandle().playerConnection.a(new PacketPlayInClientCommand(PacketPlayInClientCommand.EnumClientCommand.PERFORM_RESPAWN));
    }

    @Override
    public void setVision(Player player, EntityType entityType) {
        EntityCreeper entity;
        if (entityType == EntityType.CREEPER) {
            entity = new EntityCreeper(EntityTypes.CREEPER, (World)((CraftWorld)player.getWorld()).getHandle());
        } else if (entityType == EntityType.SPIDER) {
            entity = new EntitySpider(EntityTypes.SPIDER, (World)((CraftWorld)player.getWorld()).getHandle());
        } else if (entityType == EntityType.CAVE_SPIDER) {
            entity = new EntityCaveSpider(EntityTypes.CAVE_SPIDER, (World)((CraftWorld)player.getWorld()).getHandle());
        } else if (entityType == EntityType.ENDERMAN) {
            entity = new EntityEnderman(EntityTypes.ENDERMAN, (World)((CraftWorld)player.getWorld()).getHandle());
        } else {
            return;
        }
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutSpawnEntityLiving((EntityLiving)entity));
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutCamera((Entity)entity));
        ((CraftServer)Bukkit.getServer()).getHandle().moveToWorld(((CraftPlayer)player).getHandle(), ((CraftWorld)player.getWorld()).getHandle(), true, player.getLocation(), false);
    }

    @Override
    public void showDemoScreen(Player player) {
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.f, 0.0f));
    }

    @Override
    public void showBlockAction(Player player, Location location, int action, int state) {
        BlockPosition position = new BlockPosition(location.getX(), location.getY(), location.getZ());
        Block block = ((CraftWorld)location.getWorld()).getHandle().getType(position).getBlock();
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutBlockAction(position, block, action, state));
    }

    @Override
    public void showBlockCrack(Player player, int id, Location location, int progress) {
        BlockPosition position = new BlockPosition(location.getX(), location.getY(), location.getZ());
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutBlockBreakAnimation(id, position, progress));
    }

    @Override
    public void showTileEntityData(Player player, Location location, int action, CompoundTag compoundTag) {
        BlockPosition position = new BlockPosition(location.getX(), location.getY(), location.getZ());
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutTileEntityData(position, action, ((CompoundTagImpl)compoundTag).toNMSTag()));
    }

    @Override
    public void showBannerUpdate(Player player, Location location, DyeColor base, List<Pattern> patterns) {
        ArrayList<CompoundTag> nbtPatterns = new ArrayList<CompoundTag>();
        for (Pattern pattern : patterns) {
            nbtPatterns.add(NMSHandler.getInstance().createCompoundTag(new HashMap<String, Tag>()).createBuilder().putInt("Color", pattern.getColor().getDyeData()).putString("Pattern", pattern.getPattern().getIdentifier()).build());
        }
        CompoundTag compoundTag = NMSHandler.getBlockHelper().getNbtData(location.getBlock()).createBuilder().put("Patterns", new JNBTListTag(CompoundTag.class, nbtPatterns)).build();
        this.showTileEntityData(player, location, 3, compoundTag);
    }

    @Override
    public void showTabListHeaderFooter(Player player, String header, String footer) {
        PacketPlayOutPlayerListHeaderFooter packet = new PacketPlayOutPlayerListHeaderFooter();
        packet.header = Handler.componentToNMS(FormattedTextHelper.parse(header, ChatColor.WHITE));
        packet.footer = Handler.componentToNMS(FormattedTextHelper.parse(footer, ChatColor.WHITE));
        PacketHelperImpl.sendPacket(player, (Packet)packet);
    }

    @Override
    public void resetTabListHeaderFooter(Player player) {
        this.showTabListHeaderFooter(player, "", "");
    }

    @Override
    public void showTitle(Player player, String title, String subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutTitle(fadeInTicks, stayTicks, fadeOutTicks));
        if (title != null) {
            PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutTitle(PacketPlayOutTitle.EnumTitleAction.TITLE, (IChatBaseComponent)Handler.componentToNMS(FormattedTextHelper.parse(title, ChatColor.WHITE))));
        }
        if (subtitle != null) {
            PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutTitle(PacketPlayOutTitle.EnumTitleAction.SUBTITLE, (IChatBaseComponent)Handler.componentToNMS(FormattedTextHelper.parse(subtitle, ChatColor.WHITE))));
        }
    }

    @Override
    public void showEquipment(Player player, LivingEntity entity, EquipmentSlot equipmentSlot, ItemStack itemStack) {
        Pair pair = new Pair((Object)CraftEquipmentSlot.getNMS((EquipmentSlot)equipmentSlot), (Object)CraftItemStack.asNMSCopy((ItemStack)itemStack));
        ArrayList<Pair> pairList = new ArrayList<Pair>();
        pairList.add(pair);
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutEntityEquipment(entity.getEntityId(), pairList));
    }

    @Override
    public void resetEquipment(Player player, LivingEntity entity) {
        EntityEquipment equipment = entity.getEquipment();
        this.showEquipment(player, entity, EquipmentSlot.HAND, equipment.getItemInMainHand());
        this.showEquipment(player, entity, EquipmentSlot.OFF_HAND, equipment.getItemInOffHand());
        this.showEquipment(player, entity, EquipmentSlot.HEAD, equipment.getHelmet());
        this.showEquipment(player, entity, EquipmentSlot.CHEST, equipment.getChestplate());
        this.showEquipment(player, entity, EquipmentSlot.LEGS, equipment.getLeggings());
        this.showEquipment(player, entity, EquipmentSlot.FEET, equipment.getBoots());
    }

    @Override
    public void openBook(Player player, EquipmentSlot hand) {
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutOpenBook(hand == EquipmentSlot.OFF_HAND ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND));
    }

    @Override
    public void showHealth(Player player, float health, int food, float saturation) {
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutUpdateHealth(health, food, saturation));
    }

    @Override
    public void resetHealth(Player player) {
        this.showHealth(player, (float)player.getHealth(), player.getFoodLevel(), player.getSaturation());
    }

    @Override
    public void showExperience(Player player, float experience, int level) {
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutExperience(experience, 0, level));
    }

    @Override
    public void resetExperience(Player player) {
        this.showExperience(player, player.getExp(), player.getLevel());
    }

    @Override
    public boolean showSignEditor(Player player, Location location) {
        TileEntity tileEntity = ((CraftWorld)location.getWorld()).getHandle().getTileEntity(new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()));
        if (tileEntity instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)tileEntity;
            PacketHelperImpl.sendPacket(player, (Packet)sign.getUpdatePacket());
            sign.isEditable = true;
            sign.a((EntityHuman)((CraftPlayer)player).getHandle());
            PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutOpenSignEditor(sign.getPosition()));
            return true;
        }
        return false;
    }

    @Override
    public void forceSpectate(Player player, org.bukkit.entity.Entity entity) {
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutCamera(((CraftEntity)entity).getHandle()));
    }

    @Override
    public void sendRename(Player player, org.bukkit.entity.Entity entity, String name, boolean listMode) {
        try {
            if (entity.getType() == EntityType.PLAYER) {
                if (listMode) {
                    PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_DISPLAY_NAME, new EntityPlayer[]{((CraftPlayer)player).getHandle()}));
                } else {
                    PlayerChunkMap tracker = ((WorldServer)((CraftEntity)entity).getHandle().world).getChunkProvider().playerChunkMap;
                    PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)tracker.trackedEntities.get(entity.getEntityId());
                    if (entityTracker != null) {
                        try {
                            EntityTrackerEntry entry = (EntityTrackerEntry)ENTITY_TRACKER_ENTRY_GETTER.get(entityTracker);
                            if (entry != null) {
                                entry.a(((CraftPlayer)player).getHandle());
                                entry.b(((CraftPlayer)player).getHandle());
                            }
                        }
                        catch (Throwable ex) {
                            Debug.echoError(ex);
                        }
                    }
                }
                return;
            }
            PacketPlayOutEntityMetadata packet = new PacketPlayOutEntityMetadata();
            ENTITY_METADATA_EID_SETTER.invoke(packet, entity.getEntityId());
            ArrayList<DataWatcher.Item> list = new ArrayList<DataWatcher.Item>();
            list.add(new DataWatcher.Item(ENTITY_CUSTOM_NAME_METADATA, Optional.of(Handler.componentToNMS(FormattedTextHelper.parse(name, ChatColor.WHITE)))));
            list.add(new DataWatcher.Item(ENTITY_CUSTOM_NAME_VISIBLE_METADATA, (Object)true));
            ENTITY_METADATA_LIST_SETTER.invoke(packet, list);
            PacketHelperImpl.sendPacket(player, (Packet)packet);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public void generateNoCollideTeam(Player player, UUID noCollide) {
        this.removeNoCollideTeam(player, noCollide);
        ScoreboardTeam team = new ScoreboardTeam(SidebarImpl.dummyScoreboard, Utilities.generateRandomColors(8));
        team.getPlayerNameSet().add(noCollide.toString());
        team.setCollisionRule(ScoreboardTeamBase.EnumTeamPush.NEVER);
        HashMap<UUID, Object> map = noCollideTeamMap.get(player.getUniqueId());
        if (map == null) {
            map = new HashMap();
            noCollideTeamMap.put(player.getUniqueId(), map);
        }
        map.put(noCollide, team);
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutScoreboardTeam(team, 0));
    }

    @Override
    public void removeNoCollideTeam(Player player, UUID noCollide) {
        if (noCollide == null || !player.isOnline()) {
            noCollideTeamMap.remove(player.getUniqueId());
            return;
        }
        HashMap<UUID, ScoreboardTeam> map = noCollideTeamMap.get(player.getUniqueId());
        if (map == null) {
            return;
        }
        ScoreboardTeam team = map.remove(noCollide);
        if (team != null) {
            PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutScoreboardTeam(team, 1));
        }
        if (map.isEmpty()) {
            noCollideTeamMap.remove(player.getUniqueId());
        }
    }

    @Override
    public void sendEntityMetadataFlagsUpdate(Player player) {
        DataWatcher dw = new DataWatcher(null);
        dw.register(ENTITY_DATA_WATCHER_FLAGS, ((CraftPlayer)player).getHandle().getDataWatcher().get(ENTITY_DATA_WATCHER_FLAGS));
        PacketHelperImpl.sendPacket(player, (Packet)new PacketPlayOutEntityMetadata(player.getEntityId(), dw, true));
    }

    public static void sendPacket(Player player, Packet packet) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket(packet);
    }

    static {
        try {
            ENTITY_CUSTOM_NAME_METADATA = (DataWatcherObject)ReflectionHelper.getFieldValue(Entity.class, "aq", null);
            ENTITY_CUSTOM_NAME_VISIBLE_METADATA = (DataWatcherObject)ReflectionHelper.getFieldValue(Entity.class, "ar", null);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        ENTITY_TRACKER_ENTRY_GETTER = ReflectionHelper.getFields(PlayerChunkMap.EntityTracker.class).get("trackerEntry");
        noCollideTeamMap = new HashMap();
    }
}

