/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.objects.AreaContainmentObject;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.objects.notable.NotableManager;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.Note;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class CuboidTag
implements ObjectTag,
Cloneable,
Notable,
Adjustable,
AreaContainmentObject {
    public List<LocationPair> pairs = new ArrayList<LocationPair>();
    public String noteName = null;
    String prefix = "Cuboid";
    public static ObjectTagProcessor<CuboidTag> tagProcessor = new ObjectTagProcessor();

    public CuboidTag clone() {
        CuboidTag cuboid;
        try {
            cuboid = (CuboidTag)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            com.denizenscript.denizen.utilities.debugging.Debug.echoError(ex);
            cuboid = new CuboidTag();
        }
        cuboid.noteName = null;
        cuboid.pairs = new ArrayList<LocationPair>(this.pairs.size());
        for (LocationPair pair : this.pairs) {
            cuboid.pairs.add(new LocationPair(pair.low.clone(), pair.high.clone()));
        }
        return cuboid;
    }

    public static List<CuboidTag> getNotableCuboidsContaining(Location location) {
        ArrayList<CuboidTag> cuboids = new ArrayList<CuboidTag>();
        for (CuboidTag cuboid : NotableManager.getAllType(CuboidTag.class)) {
            if (!cuboid.isInsideCuboid(location)) continue;
            cuboids.add(cuboid);
        }
        return cuboids;
    }

    @Deprecated
    public static CuboidTag valueOf(String string) {
        return CuboidTag.valueOf(string, null);
    }

    @Fetchable(value="cu")
    public static CuboidTag valueOf(String string, TagContext context) {
        Notable noted;
        if (string == null) {
            return null;
        }
        if (CoreUtilities.toLowerCase(string).startsWith("cu@")) {
            string = string.substring("cu@".length());
        }
        if (CoreUtilities.contains(string, '|')) {
            ListTag positions = ListTag.valueOf(string, context);
            if (positions.size() > 1 && LocationTag.matches(positions.get(0)) && LocationTag.matches(positions.get(1))) {
                if (positions.size() % 2 != 0) {
                    if (context == null || context.showErrors()) {
                        com.denizenscript.denizen.utilities.debugging.Debug.echoError("valueOf CuboidTag returning null (Uneven number of locations): '" + string + "'.");
                    }
                    return null;
                }
                CuboidTag toReturn = new CuboidTag();
                for (int i = 0; i < positions.size(); i += 2) {
                    LocationTag pos_1 = LocationTag.valueOf(positions.get(i), context);
                    LocationTag pos_2 = LocationTag.valueOf(positions.get(i + 1), context);
                    if (pos_1 == null || pos_2 == null) {
                        if (context == null || context.showErrors()) {
                            com.denizenscript.denizen.utilities.debugging.Debug.echoError("valueOf in CuboidTag returning null (null locations): '" + string + "'.");
                        }
                        return null;
                    }
                    if (pos_1.getWorldName() == null || pos_2.getWorldName() == null) {
                        if (context == null || context.showErrors()) {
                            com.denizenscript.denizen.utilities.debugging.Debug.echoError("valueOf in CuboidTag returning null (null worlds): '" + string + "'.");
                        }
                        return null;
                    }
                    toReturn.addPair(pos_1, pos_2);
                }
                if (toReturn.pairs.size() > 0) {
                    return toReturn;
                }
            }
        } else if (CoreUtilities.contains(string, ',')) {
            List<String> subStrs = CoreUtilities.split(string, ',');
            if (subStrs.size() < 7 || (subStrs.size() - 1) % 6 != 0) {
                if (context == null || context.showErrors()) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError("valueOf CuboidTag returning null (Improper number of commas): '" + string + "'.");
                }
                return null;
            }
            CuboidTag toReturn = new CuboidTag();
            String worldName = subStrs.get(0);
            if (worldName.startsWith("w@")) {
                worldName = worldName.substring("w@".length());
            }
            try {
                for (int i = 0; i < subStrs.size() - 1; i += 6) {
                    LocationTag locationOne = new LocationTag(CuboidTag.parseRoundDouble(subStrs.get(i + 1)), CuboidTag.parseRoundDouble(subStrs.get(i + 2)), CuboidTag.parseRoundDouble(subStrs.get(i + 3)), worldName);
                    LocationTag locationTwo = new LocationTag(CuboidTag.parseRoundDouble(subStrs.get(i + 4)), CuboidTag.parseRoundDouble(subStrs.get(i + 5)), CuboidTag.parseRoundDouble(subStrs.get(i + 6)), worldName);
                    toReturn.addPair(locationOne, locationTwo);
                }
            }
            catch (NumberFormatException ex) {
                if (context == null || context.showErrors()) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError("valueOf CuboidTag returning null (Improper number value inputs): '" + ex.getMessage() + "'.");
                }
                return null;
            }
            if (toReturn.pairs.size() > 0) {
                return toReturn;
            }
        }
        if ((noted = NotableManager.getSavedObject(string)) instanceof CuboidTag) {
            return (CuboidTag)noted;
        }
        if (context == null || context.showErrors()) {
            com.denizenscript.denizen.utilities.debugging.Debug.echoError("Minor: valueOf CuboidTag returning null: " + string);
        }
        return null;
    }

    public static double parseRoundDouble(String str) {
        return Math.floor(Double.parseDouble(str));
    }

    public static boolean matches(String string) {
        return CuboidTag.valueOf(string, CoreUtilities.noDebugContext) != null;
    }

    @Override
    public ObjectTag duplicate() {
        if (this.noteName != null) {
            return this;
        }
        return this.clone();
    }

    public int hashCode() {
        if (this.noteName != null) {
            return this.noteName.hashCode();
        }
        return this.pairs.size() + this.pairs.get((int)0).low.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof CuboidTag)) {
            return false;
        }
        CuboidTag cuboid2 = (CuboidTag)other;
        if (cuboid2.pairs.size() != this.pairs.size()) {
            return false;
        }
        if (this.noteName == null != (cuboid2.noteName == null)) {
            return false;
        }
        if (this.noteName != null && !this.noteName.equals(cuboid2.noteName)) {
            return false;
        }
        for (int i = 0; i < this.pairs.size(); ++i) {
            LocationPair pair1 = this.pairs.get(i);
            LocationPair pair2 = cuboid2.pairs.get(i);
            if (!pair1.low.getWorldName().equals(pair2.low.getWorldName())) {
                return false;
            }
            if (pair1.low.distanceSquared(pair2.low) >= 0.5) {
                return false;
            }
            if (!(pair1.high.distanceSquared(pair2.high) >= 0.5)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getNoteName() {
        return this.noteName;
    }

    @Override
    public boolean doesContainLocation(Location loc) {
        return this.isInsideCuboid(loc);
    }

    public CuboidTag() {
    }

    public CuboidTag(Location point_1, Location point_2) {
        this.addPair(new LocationTag(point_1), new LocationTag(point_2));
    }

    public void addPair(LocationTag point_1, LocationTag point_2) {
        if (point_1.getWorld() != point_2.getWorld()) {
            com.denizenscript.denizen.utilities.debugging.Debug.echoError("Tried to make cross-world cuboid!");
            return;
        }
        if (this.pairs.size() > 0 && point_1.getWorld() != this.getWorld()) {
            com.denizenscript.denizen.utilities.debugging.Debug.echoError("Tried to make cross-world cuboid set!");
            return;
        }
        LocationPair pair = new LocationPair(point_1, point_2);
        this.pairs.add(pair);
    }

    public static boolean isBetween(double a, double b, double c) {
        return b > a ? c >= a && c < b : c >= b && c < a;
    }

    public boolean isInsideCuboid(Location location) {
        if (location.getWorld() == null) {
            return false;
        }
        for (LocationPair pair : this.pairs) {
            if (!location.getWorld().getName().equals(pair.low.getWorldName()) || !CuboidTag.isBetween(pair.low.getBlockX(), pair.high.getBlockX() + 1, location.getBlockX()) || !CuboidTag.isBetween(pair.low.getBlockY(), pair.high.getBlockY() + 1, location.getBlockY()) || !CuboidTag.isBetween(pair.low.getBlockZ(), pair.high.getBlockZ() + 1, location.getBlockZ())) continue;
            return true;
        }
        return false;
    }

    public ListTag getShell() {
        int max = Settings.blockTagsMaxBlocks();
        int index = 0;
        ListTag list = new ListTag();
        for (LocationPair pair : this.pairs) {
            int z;
            LocationTag low = pair.low;
            LocationTag high = pair.high;
            int y_distance = pair.yDistance();
            int z_distance = pair.zDistance();
            int x_distance = pair.xDistance();
            for (int x = 0; x < x_distance; ++x) {
                for (int y = 0; y < y_distance; ++y) {
                    list.addObject(new LocationTag(low.getWorld(), (double)(low.getBlockX() + x), (double)(low.getBlockY() + y), low.getBlockZ()));
                    list.addObject(new LocationTag(low.getWorld(), (double)(low.getBlockX() + x), (double)(low.getBlockY() + y), high.getBlockZ()));
                    if (++index <= max) continue;
                    return list;
                }
                for (z = 0; z < z_distance; ++z) {
                    list.addObject(new LocationTag(low.getWorld(), (double)(low.getBlockX() + x), (double)low.getBlockY(), low.getBlockZ() + z));
                    list.addObject(new LocationTag(low.getWorld(), (double)(low.getBlockX() + x), (double)high.getBlockY(), low.getBlockZ() + z));
                    if (++index <= max) continue;
                    return list;
                }
            }
            for (int y = 0; y < y_distance; ++y) {
                for (z = 0; z < z_distance; ++z) {
                    list.addObject(new LocationTag(low.getWorld(), (double)low.getBlockX(), (double)(low.getBlockY() + y), low.getBlockZ() + z));
                    list.addObject(new LocationTag(low.getWorld(), (double)high.getBlockX(), (double)(low.getBlockY() + y), low.getBlockZ() + z));
                    if (++index <= max) continue;
                    return list;
                }
            }
        }
        return list;
    }

    public ListTag getOutline() {
        int max = Settings.blockTagsMaxBlocks();
        int index = 0;
        ListTag list = new ListTag();
        for (LocationPair pair : this.pairs) {
            LocationTag loc_1 = pair.low;
            LocationTag loc_2 = pair.high;
            int y_distance = pair.yDistance();
            int z_distance = pair.zDistance();
            int x_distance = pair.xDistance();
            for (int y = loc_1.getBlockY(); y < loc_1.getBlockY() + y_distance; ++y) {
                list.addObject(new LocationTag(loc_1.getWorld(), (double)loc_1.getBlockX(), (double)y, loc_1.getBlockZ()));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)loc_2.getBlockX(), (double)y, loc_2.getBlockZ()));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)loc_1.getBlockX(), (double)y, loc_2.getBlockZ()));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)loc_2.getBlockX(), (double)y, loc_1.getBlockZ()));
                if (++index <= max) continue;
                return list;
            }
            for (int x = loc_1.getBlockX(); x < loc_1.getBlockX() + x_distance; ++x) {
                list.addObject(new LocationTag(loc_1.getWorld(), (double)x, (double)loc_1.getBlockY(), loc_1.getBlockZ()));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)x, (double)loc_1.getBlockY(), loc_2.getBlockZ()));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)x, (double)loc_2.getBlockY(), loc_2.getBlockZ()));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)x, (double)loc_2.getBlockY(), loc_1.getBlockZ()));
                if (++index <= max) continue;
                return list;
            }
            for (int z = loc_1.getBlockZ(); z < loc_1.getBlockZ() + z_distance; ++z) {
                list.addObject(new LocationTag(loc_1.getWorld(), (double)loc_1.getBlockX(), (double)loc_1.getBlockY(), z));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)loc_2.getBlockX(), (double)loc_2.getBlockY(), z));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)loc_1.getBlockX(), (double)loc_2.getBlockY(), z));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)loc_2.getBlockX(), (double)loc_1.getBlockY(), z));
                if (++index <= max) continue;
                return list;
            }
            list.addObject(pair.high);
        }
        return list;
    }

    public ListTag getBlocks(Attribute attribute) {
        return this.getBlocks(null, attribute);
    }

    private boolean matchesMaterialList(Location loc, List<MaterialTag> materials, Attribute attribute) {
        if (materials == null) {
            return true;
        }
        MaterialTag mat = new MaterialTag(new LocationTag(loc).getBlockForTag(attribute));
        for (MaterialTag material : materials) {
            if (!mat.equals(material) && mat.getMaterial() != material.getMaterial()) continue;
            return true;
        }
        return false;
    }

    public ListTag getBlocks(List<MaterialTag> materials, Attribute attribute) {
        List<LocationTag> locs = this.getBlocks_internal(materials, attribute);
        ListTag list = new ListTag();
        for (LocationTag loc : locs) {
            list.addObject(loc);
        }
        return list;
    }

    public List<LocationTag> getBlocks_internal(List<MaterialTag> materials, Attribute attribute) {
        if (materials == null) {
            return this.getBlockLocationsUnfiltered(true);
        }
        int max = Settings.blockTagsMaxBlocks();
        ArrayList<LocationTag> list = new ArrayList<LocationTag>();
        int index = 0;
        for (LocationPair pair : this.pairs) {
            LocationTag loc_1 = pair.low;
            int y_distance = pair.yDistance();
            int z_distance = pair.zDistance();
            int x_distance = pair.xDistance();
            for (int x = 0; x != x_distance + 1; ++x) {
                for (int y = 0; y != y_distance + 1; ++y) {
                    for (int z = 0; z != z_distance + 1; ++z) {
                        LocationTag loc = new LocationTag(loc_1.clone().add(x, y, z));
                        if (loc.getY() < 0.0 || loc.getY() > 255.0) continue;
                        if (this.matchesMaterialList(loc, materials, attribute)) {
                            list.add(loc);
                        }
                        if (++index <= max) continue;
                        return list;
                    }
                }
            }
        }
        return list;
    }

    public List<LocationTag> getBlockLocationsUnfiltered(boolean doMax) {
        int max = doMax ? Settings.blockTagsMaxBlocks() : Integer.MAX_VALUE;
        ArrayList<LocationTag> list = new ArrayList<LocationTag>();
        int index = 0;
        for (LocationPair pair : this.pairs) {
            LocationTag loc_1 = pair.low;
            int y_distance = pair.yDistance();
            int z_distance = pair.zDistance();
            int x_distance = pair.xDistance();
            for (int x = 0; x <= x_distance; ++x) {
                for (int z = 0; z <= z_distance; ++z) {
                    for (int y = 0; y <= y_distance; ++y) {
                        LocationTag loc = new LocationTag(loc_1.clone().add(x, y, z));
                        list.add(loc);
                        if (++index <= max) continue;
                        return list;
                    }
                }
            }
        }
        return list;
    }

    public ListTag getSpawnableBlocks(Attribute attribute) {
        return this.getSpawnableBlocks(null, attribute);
    }

    public ListTag getSpawnableBlocks(List<MaterialTag> mats, Attribute attribute) {
        int max = Settings.blockTagsMaxBlocks();
        ListTag list = new ListTag();
        int index = 0;
        for (LocationPair pair : this.pairs) {
            LocationTag loc_1 = pair.low;
            int y_distance = pair.yDistance();
            int z_distance = pair.zDistance();
            int x_distance = pair.xDistance();
            for (int x = 0; x != x_distance + 1; ++x) {
                for (int y = 0; y != y_distance + 1; ++y) {
                    for (int z = 0; z != z_distance + 1; ++z) {
                        LocationTag loc = new LocationTag(loc_1.clone().add(x, y, z));
                        if (loc.getBlockTypeForTag(attribute).isAir() && new LocationTag(loc.clone().add(0.0, 1.0, 0.0)).getBlockTypeForTag(attribute).isAir() && (mats == null ? new LocationTag(loc.clone().add(0.0, -1.0, 0.0)).getBlockTypeForTag(attribute).isSolid() : this.matchesMaterialList(loc.clone().add(0.0, -1.0, 0.0), mats, attribute))) {
                            loc.add(0.5, 0.0, 0.5);
                            list.addObject(loc);
                        }
                        if (++index <= max) continue;
                        return list;
                    }
                }
            }
        }
        return list;
    }

    public World getWorld() {
        if (this.pairs.isEmpty()) {
            return null;
        }
        return this.pairs.get((int)0).high.getWorld();
    }

    public LocationTag getHigh(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.pairs.size()) {
            return null;
        }
        return this.pairs.get((int)index).high;
    }

    public LocationTag getLow(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.pairs.size()) {
            return null;
        }
        return this.pairs.get((int)index).low;
    }

    @Override
    public boolean isUnique() {
        return NotableManager.isSaved(this);
    }

    @Override
    @Note(value="Cuboids")
    public String getSaveObject() {
        return this.identifyFull().substring(3);
    }

    @Override
    public void makeUnique(String id) {
        CuboidTag toNote = this.clone();
        toNote.noteName = id;
        NotableManager.saveAs(toNote, id);
    }

    @Override
    public void forget() {
        this.noteName = null;
        NotableManager.remove(this);
    }

    @Override
    public String getObjectType() {
        return "cuboid";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public CuboidTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debuggable() {
        if (this.isUnique()) {
            return "cu@" + NotableManager.getSavedId(this) + " <GR>(" + this.identifyFull() + ")";
        }
        return this.identifyFull();
    }

    @Override
    public String identify() {
        if (this.isUnique()) {
            return "cu@" + NotableManager.getSavedId(this);
        }
        return this.identifyFull();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String identifyFull() {
        StringBuilder sb = new StringBuilder();
        sb.append("cu@").append(this.pairs.get((int)0).low.getWorldName());
        for (LocationPair pair : this.pairs) {
            sb.append(',').append(pair.low.getBlockX()).append(',').append(pair.low.getBlockY()).append(',').append(pair.low.getBlockZ()).append(',').append(pair.high.getBlockX()).append(',').append(pair.high.getBlockY()).append(',').append(pair.high.getBlockZ());
        }
        return sb.toString();
    }

    public String toString() {
        return this.identify();
    }

    public static void registerTags() {
        CuboidTag.registerTag("random", (attribute, cuboid) -> {
            LocationPair pair = cuboid.pairs.get(CoreUtilities.getRandom().nextInt(cuboid.pairs.size()));
            Vector range = pair.high.toVector().subtract(pair.low.toVector()).add(new Vector(1, 1, 1));
            range.setX(CoreUtilities.getRandom().nextInt(range.getBlockX()));
            range.setY(CoreUtilities.getRandom().nextInt(range.getBlockY()));
            range.setZ(CoreUtilities.getRandom().nextInt(range.getBlockZ()));
            LocationTag out = pair.low.clone();
            out.add(range);
            return out;
        }, new String[0]);
        CuboidTag.registerTag("blocks", (attribute, cuboid) -> {
            if (attribute.hasContext(1)) {
                return new ListTag(cuboid.getBlocks(attribute.contextAsType(1, ListTag.class).filter(MaterialTag.class, attribute.context), attribute));
            }
            return new ListTag(cuboid.getBlocks(attribute));
        }, "get_blocks");
        CuboidTag.registerTag("members_size", (attribute, cuboid) -> new ElementTag(cuboid.pairs.size()), new String[0]);
        CuboidTag.registerTag("spawnable_blocks", (attribute, cuboid) -> {
            if (attribute.hasContext(1)) {
                return new ListTag(cuboid.getSpawnableBlocks(attribute.contextAsType(1, ListTag.class).filter(MaterialTag.class, attribute.context), attribute));
            }
            return new ListTag(cuboid.getSpawnableBlocks(attribute));
        }, "get_spawnable_blocks");
        CuboidTag.registerTag("shell", (attribute, cuboid) -> cuboid.getShell(), new String[0]);
        CuboidTag.registerTag("outline", (attribute, cuboid) -> cuboid.getOutline(), "get_outline");
        CuboidTag.registerTag("intersects", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag CuboidTag.intersects[...] must have a value.");
                return null;
            }
            CuboidTag cub2 = attribute.contextAsType(1, CuboidTag.class);
            if (cub2 != null) {
                boolean intersects = false;
                block0: for (LocationPair pair : cuboid.pairs) {
                    for (LocationPair pair2 : cub2.pairs) {
                        if (!pair.low.getWorld().getName().equalsIgnoreCase(pair2.low.getWorld().getName())) {
                            return new ElementTag("false");
                        }
                        if (!(pair2.low.getX() <= pair.high.getX()) || !(pair2.low.getY() <= pair.high.getY()) || !(pair2.low.getZ() <= pair.high.getZ()) || !(pair2.high.getX() >= pair.low.getX()) || !(pair2.high.getY() >= pair.low.getY()) || !(pair2.high.getZ() >= pair.low.getZ())) continue;
                        intersects = true;
                        break block0;
                    }
                }
                return new ElementTag(intersects);
            }
            return null;
        }, new String[0]);
        CuboidTag.registerTag("contains_location", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag CuboidTag.contains_location[...] must have a value.");
                return null;
            }
            LocationTag loc = attribute.contextAsType(1, LocationTag.class);
            return new ElementTag(cuboid.isInsideCuboid(loc));
        }, new String[0]);
        CuboidTag.registerTag("is_within", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag CuboidTag.is_within[...] must have a value.");
                return null;
            }
            CuboidTag cub2 = attribute.contextAsType(1, CuboidTag.class);
            if (cub2 != null) {
                boolean contains = true;
                for (LocationPair pair2 : cuboid.pairs) {
                    boolean contained = false;
                    for (LocationPair pair : cub2.pairs) {
                        if (!pair.low.getWorld().getName().equalsIgnoreCase(pair2.low.getWorld().getName())) {
                            if (Debug.verbose) {
                                com.denizenscript.denizen.utilities.debugging.Debug.log("Worlds don't match!");
                            }
                            return new ElementTag("false");
                        }
                        if (!(pair2.low.getX() >= pair.low.getX()) || !(pair2.low.getY() >= pair.low.getY()) || !(pair2.low.getZ() >= pair.low.getZ()) || !(pair2.high.getX() <= pair.high.getX()) || !(pair2.high.getY() <= pair.high.getY()) || !(pair2.high.getZ() <= pair.high.getZ())) continue;
                        contained = true;
                        break;
                    }
                    if (contained) continue;
                    contains = false;
                    break;
                }
                return new ElementTag(contains);
            }
            return null;
        }, new String[0]);
        CuboidTag.registerTag("list_members", (attribute, cuboid) -> {
            List<LocationPair> pairs = cuboid.pairs;
            ListTag list = new ListTag();
            for (LocationPair pair : pairs) {
                list.addObject(new CuboidTag(pair.low, pair.high));
            }
            return list;
        }, new String[0]);
        CuboidTag.registerTag("get", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag CuboidTag.get[...] must have a value.");
                return null;
            }
            int member = attribute.getIntContext(1);
            if (member < 1) {
                member = 1;
            }
            if (member > cuboid.pairs.size()) {
                member = cuboid.pairs.size();
            }
            LocationPair pair = cuboid.pairs.get(member - 1);
            return new CuboidTag(pair.low, pair.high);
        }, "member", "get_member");
        CuboidTag.registerTag("set", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag CuboidTag.set[...] must have a value.");
                return null;
            }
            CuboidTag subCuboid = attribute.contextAsType(1, CuboidTag.class);
            if (!attribute.startsWith("at", 2)) {
                attribute.echoError("The tag CuboidTag.set[...] must be followed by an 'at'.");
                return null;
            }
            if (!attribute.hasContext(2)) {
                attribute.echoError("The tag CuboidTag.set[...].at[...] must have an 'at' value.");
                return null;
            }
            int member = attribute.getIntContext(2);
            if (member < 1) {
                member = 1;
            }
            if (member > cuboid.pairs.size()) {
                member = cuboid.pairs.size();
            }
            attribute.fulfill(1);
            LocationPair pair = subCuboid.pairs.get(0);
            CuboidTag cloned = cuboid.clone();
            cloned.pairs.set(member - 1, new LocationPair(pair.low, pair.high));
            return cloned;
        }, new String[0]);
        CuboidTag.registerTag("add_member", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag CuboidTag.add_member[...] must have a value.");
                return null;
            }
            cuboid = cuboid.clone();
            int member = cuboid.pairs.size() + 1;
            if (attribute.startsWith("at", 2)) {
                if (!attribute.hasContext(2)) {
                    attribute.echoError("The tag CuboidTag.add_member[...].at[...] must have an 'at' value.");
                    return null;
                }
                member = attribute.getIntContext(2);
                attribute.fulfill(1);
            }
            if (member < 1) {
                member = 1;
            }
            if (member > cuboid.pairs.size() + 1) {
                member = cuboid.pairs.size() + 1;
            }
            if (attribute.getContext(1).startsWith("li@")) {
                for (CuboidTag subCuboid : attribute.contextAsType(1, ListTag.class).filter(CuboidTag.class, attribute.context)) {
                    LocationPair pair = subCuboid.pairs.get(0);
                    cuboid.pairs.add(member - 1, new LocationPair(pair.low, pair.high));
                    ++member;
                }
            } else {
                CuboidTag subCuboid = attribute.contextAsType(1, CuboidTag.class);
                LocationPair pair = subCuboid.pairs.get(0);
                cuboid.pairs.add(member - 1, new LocationPair(pair.low, pair.high));
            }
            return cuboid;
        }, new String[0]);
        CuboidTag.registerTag("remove_member", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag CuboidTag.remove_member[...] must have a value.");
                return null;
            }
            cuboid = cuboid.clone();
            int member = attribute.getIntContext(1);
            if (member < 1) {
                member = 1;
            }
            if (member > cuboid.pairs.size() + 1) {
                member = cuboid.pairs.size() + 1;
            }
            cuboid.pairs.remove(member - 1);
            return cuboid;
        }, new String[0]);
        CuboidTag.registerTag("center", (attribute, cuboid) -> {
            LocationPair pair;
            if (!attribute.hasContext(1)) {
                pair = cuboid.pairs.get(0);
            } else {
                int member = attribute.getIntContext(1);
                if (member < 1) {
                    member = 1;
                }
                if (member > cuboid.pairs.size()) {
                    member = cuboid.pairs.size();
                }
                pair = cuboid.pairs.get(member - 1);
            }
            LocationTag base = pair.high.clone().add(pair.low).add(1.0, 1.0, 1.0);
            base.setX(base.getX() / 2.0);
            base.setY(base.getY() / 2.0);
            base.setZ(base.getZ() / 2.0);
            return base;
        }, new String[0]);
        CuboidTag.registerTag("volume", (attribute, cuboid) -> {
            LocationPair pair = cuboid.pairs.get(0);
            Location base = pair.high.clone().subtract(pair.low.clone()).add(1.0, 1.0, 1.0);
            return new ElementTag(base.getX() * base.getY() * base.getZ());
        }, new String[0]);
        CuboidTag.registerTag("size", (attribute, cuboid) -> {
            LocationPair pair;
            if (!attribute.hasContext(1)) {
                pair = cuboid.pairs.get(0);
            } else {
                int member = attribute.getIntContext(1);
                if (member < 1) {
                    member = 1;
                }
                if (member > cuboid.pairs.size()) {
                    member = cuboid.pairs.size();
                }
                pair = cuboid.pairs.get(member - 1);
            }
            Location base = pair.high.clone().subtract(pair.low.clone()).add(1.0, 1.0, 1.0);
            return new LocationTag(base);
        }, new String[0]);
        CuboidTag.registerTag("max", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                return cuboid.pairs.get((int)0).high;
            }
            int member = attribute.getIntContext(1);
            if (member < 1) {
                member = 1;
            }
            if (member > cuboid.pairs.size()) {
                member = cuboid.pairs.size();
            }
            return cuboid.pairs.get((int)(member - 1)).high;
        }, new String[0]);
        CuboidTag.registerTag("world", (attribute, cuboid) -> new WorldTag(cuboid.pairs.get((int)0).low.getWorld()), new String[0]);
        CuboidTag.registerTag("min", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                return cuboid.pairs.get((int)0).low;
            }
            int member = attribute.getIntContext(1);
            if (member < 1) {
                member = 1;
            }
            if (member > cuboid.pairs.size()) {
                member = cuboid.pairs.size();
            }
            return cuboid.pairs.get((int)(member - 1)).low;
        }, new String[0]);
        CuboidTag.registerTag("shift", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag CuboidTag.shift[...] must have a value.");
                return null;
            }
            LocationTag vector = attribute.contextAsType(1, LocationTag.class);
            if (vector != null) {
                return cuboid.shifted(vector);
            }
            return null;
        }, new String[0]);
        CuboidTag.registerTag("include", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag CuboidTag.include[...] must have a value.");
                return null;
            }
            CuboidTag newCuboid = CuboidTag.valueOf(attribute.getContext(1), CoreUtilities.noDebugContext);
            if (newCuboid != null) {
                return cuboid.including(newCuboid.getLow(0)).including(newCuboid.getHigh(0));
            }
            LocationTag loc = attribute.contextAsType(1, LocationTag.class);
            if (loc != null) {
                return cuboid.including(loc);
            }
            return null;
        }, new String[0]);
        CuboidTag.registerTag("include_x", (attribute, cuboid) -> {
            cuboid = cuboid.clone();
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag CuboidTag.include_x[...] must have a value.");
                return null;
            }
            double x = attribute.getDoubleContext(1);
            if (x < cuboid.pairs.get((int)0).low.getX()) {
                cuboid.pairs.get((int)0).low = new LocationTag(cuboid.pairs.get((int)0).low.getWorld(), x, cuboid.pairs.get((int)0).low.getY(), cuboid.pairs.get((int)0).low.getZ());
            }
            if (x > cuboid.pairs.get((int)0).high.getX()) {
                cuboid.pairs.get((int)0).high = new LocationTag(cuboid.pairs.get((int)0).high.getWorld(), x, cuboid.pairs.get((int)0).high.getY(), cuboid.pairs.get((int)0).high.getZ());
            }
            return cuboid;
        }, new String[0]);
        CuboidTag.registerTag("include_y", (attribute, cuboid) -> {
            cuboid = cuboid.clone();
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag CuboidTag.include_y[...] must have a value.");
                return null;
            }
            double y = attribute.getDoubleContext(1);
            if (y < cuboid.pairs.get((int)0).low.getY()) {
                cuboid.pairs.get((int)0).low = new LocationTag(cuboid.pairs.get((int)0).low.getWorld(), cuboid.pairs.get((int)0).low.getX(), y, cuboid.pairs.get((int)0).low.getZ());
            }
            if (y > cuboid.pairs.get((int)0).high.getY()) {
                cuboid.pairs.get((int)0).high = new LocationTag(cuboid.pairs.get((int)0).high.getWorld(), cuboid.pairs.get((int)0).high.getX(), y, cuboid.pairs.get((int)0).high.getZ());
            }
            return cuboid;
        }, new String[0]);
        CuboidTag.registerTag("include_z", (attribute, cuboid) -> {
            cuboid = cuboid.clone();
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag CuboidTag.include_z[...] must have a value.");
                return null;
            }
            double z = attribute.getDoubleContext(1);
            if (z < cuboid.pairs.get((int)0).low.getZ()) {
                cuboid.pairs.get((int)0).low = new LocationTag(cuboid.pairs.get((int)0).low.getWorld(), cuboid.pairs.get((int)0).low.getX(), cuboid.pairs.get((int)0).low.getY(), z);
            }
            if (z > cuboid.pairs.get((int)0).high.getZ()) {
                cuboid.pairs.get((int)0).high = new LocationTag(cuboid.pairs.get((int)0).high.getWorld(), cuboid.pairs.get((int)0).high.getX(), cuboid.pairs.get((int)0).high.getY(), z);
            }
            return cuboid;
        }, new String[0]);
        CuboidTag.registerTag("with_world", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag CuboidTag.with_world[...] must have a value.");
                return null;
            }
            WorldTag world = attribute.contextAsType(1, WorldTag.class);
            if (world == null) {
                attribute.echoError("World '" + attribute.getContext(1) + "' does not exist.");
                return null;
            }
            CuboidTag newCuboid = cuboid.clone();
            for (LocationPair pair : newCuboid.pairs) {
                pair.low.setWorld(world.getWorld());
                pair.high.setWorld(world.getWorld());
            }
            return newCuboid;
        }, new String[0]);
        CuboidTag.registerTag("with_min", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag CuboidTag.with_min[...] must have a value.");
                return null;
            }
            LocationTag location = attribute.contextAsType(1, LocationTag.class);
            return new CuboidTag(location, cuboid.pairs.get((int)0).high);
        }, new String[0]);
        CuboidTag.registerTag("with_max", (attribute, cuboid) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag CuboidTag.with_max[...] must have a value.");
                return null;
            }
            LocationTag location = attribute.contextAsType(1, LocationTag.class);
            return new CuboidTag(location, cuboid.pairs.get((int)0).low);
        }, new String[0]);
        CuboidTag.registerTag("expand", (attribute, cuboid) -> {
            Vector expandBy;
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag CuboidTag.expand[...] must have a value.");
                return null;
            }
            if (ArgumentHelper.matchesInteger(attribute.getContext(1))) {
                int val = attribute.getIntContext(1);
                expandBy = new Vector(val, val, val);
            } else {
                expandBy = attribute.contextAsType(1, LocationTag.class).toVector();
            }
            LocationPair pair = cuboid.pairs.get(0);
            return new CuboidTag(pair.low.clone().subtract(expandBy), pair.high.clone().add(expandBy));
        }, new String[0]);
        CuboidTag.registerTag("players", (attribute, cuboid) -> {
            ArrayList<PlayerTag> players = new ArrayList<PlayerTag>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!cuboid.isInsideCuboid(player.getLocation())) continue;
                players.add(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player));
            }
            return new ListTag((Collection<? extends ObjectTag>)players);
        }, "list_players");
        if (Depends.citizens != null) {
            CuboidTag.registerTag("npcs", (attribute, cuboid) -> {
                ArrayList<NPCTag> npcs = new ArrayList<NPCTag>();
                for (NPC npc : CitizensAPI.getNPCRegistry()) {
                    NPCTag dnpc = new NPCTag(npc);
                    if (!cuboid.isInsideCuboid(dnpc.getLocation())) continue;
                    npcs.add(dnpc);
                }
                return new ListTag((Collection<? extends ObjectTag>)npcs);
            }, "list_npcs");
        }
        CuboidTag.registerTag("entities", (attribute, cuboid) -> {
            ArrayList<EntityTag> entities = new ArrayList<EntityTag>();
            ListTag types = new ListTag();
            if (attribute.hasContext(1)) {
                types = attribute.contextAsType(1, ListTag.class);
            }
            block0: for (Entity ent : new WorldTag(cuboid.getWorld()).getEntitiesForTag()) {
                EntityTag current = new EntityTag(ent);
                if (!cuboid.isInsideCuboid(ent.getLocation())) continue;
                if (!types.isEmpty()) {
                    for (String type : types) {
                        if (!current.identifySimpleType().equalsIgnoreCase(type)) continue;
                        entities.add(current);
                        continue block0;
                    }
                    continue;
                }
                entities.add(new EntityTag(ent));
            }
            return new ListTag((Collection<? extends ObjectTag>)entities);
        }, "list_entities");
        CuboidTag.registerTag("living_entities", (attribute, cuboid) -> {
            ArrayList<EntityTag> entities = new ArrayList<EntityTag>();
            for (Entity ent : cuboid.getWorld().getLivingEntities()) {
                if (!cuboid.isInsideCuboid(ent.getLocation()) || EntityTag.isCitizensNPC(ent)) continue;
                entities.add(new EntityTag(ent));
            }
            return new ListTag((Collection<? extends ObjectTag>)entities);
        }, "list_living_entities");
        CuboidTag.registerTag("chunks", (attribute, cuboid) -> {
            ListTag chunks = new ListTag();
            for (LocationPair pair : cuboid.pairs) {
                int minY = pair.low.getBlockY();
                ChunkTag minChunk = new ChunkTag(pair.low);
                int minX = minChunk.getX();
                int minZ = minChunk.getZ();
                if (!cuboid.isInsideCuboid(new Location(cuboid.getWorld(), (double)(minChunk.getX() * 16), (double)minY, (double)(minChunk.getZ() * 16)))) {
                    ++minX;
                    ++minZ;
                }
                ChunkTag maxChunk = new ChunkTag(pair.high);
                int maxX = maxChunk.getX();
                int maxZ = maxChunk.getZ();
                if (cuboid.isInsideCuboid(new Location(cuboid.getWorld(), (double)(maxChunk.getX() * 16 + 15), (double)minY, (double)(maxChunk.getZ() * 16 + 15)))) {
                    ++maxX;
                    ++maxZ;
                }
                for (int x = minX; x < maxX; ++x) {
                    for (int z = minZ; z < maxZ; ++z) {
                        chunks.addObject(new ChunkTag(new WorldTag(cuboid.getWorld()), x, z));
                    }
                }
            }
            return chunks.deduplicate();
        }, "list_chunks");
        CuboidTag.registerTag("partial_chunks", (attribute, cuboid) -> {
            ListTag chunks = new ListTag();
            for (LocationPair pair : cuboid.pairs) {
                ChunkTag minChunk = new ChunkTag(pair.low);
                ChunkTag maxChunk = new ChunkTag(pair.high);
                for (int x = minChunk.getX(); x <= maxChunk.getX(); ++x) {
                    for (int z = minChunk.getZ(); z <= maxChunk.getZ(); ++z) {
                        chunks.addObject(new ChunkTag(new WorldTag(cuboid.getWorld()), x, z));
                    }
                }
            }
            return chunks;
        }, "list_partial_chunks");
        CuboidTag.registerTag("note_name", (attribute, cuboid) -> {
            String notname = NotableManager.getSavedId(cuboid);
            if (notname == null) {
                return null;
            }
            return new ElementTag(notname);
        }, "notable_name");
        CuboidTag.registerTag("full", (attribute, cuboid) -> {
            Deprecations.cuboidFullTag.warn(attribute.context);
            return new ElementTag(cuboid.identifyFull());
        }, new String[0]);
    }

    public CuboidTag shifted(LocationTag vec) {
        CuboidTag cuboid = this.clone();
        LocationTag low = cuboid.pairs.get((int)0).low.clone().add(vec);
        LocationTag high = cuboid.pairs.get((int)0).high.clone().add(vec);
        cuboid.pairs.get(0).regenerate(low, high);
        return cuboid;
    }

    public CuboidTag including(Location loc) {
        loc = loc.clone();
        CuboidTag cuboid = this.clone();
        LocationTag low = cuboid.pairs.get((int)0).low;
        LocationTag high = cuboid.pairs.get((int)0).high;
        if (loc.getX() < low.getX()) {
            low = new LocationTag(low.getWorld(), loc.getX(), low.getY(), low.getZ());
        }
        if (loc.getY() < low.getY()) {
            low = new LocationTag(low.getWorld(), low.getX(), loc.getY(), low.getZ());
        }
        if (loc.getZ() < low.getZ()) {
            low = new LocationTag(low.getWorld(), low.getX(), low.getY(), loc.getZ());
        }
        if (loc.getX() > high.getX()) {
            high = new LocationTag(high.getWorld(), loc.getX(), high.getY(), high.getZ());
        }
        if (loc.getY() > high.getY()) {
            high = new LocationTag(high.getWorld(), high.getX(), loc.getY(), high.getZ());
        }
        if (loc.getZ() > high.getZ()) {
            high = new LocationTag(high.getWorld(), high.getX(), high.getY(), loc.getZ());
        }
        cuboid.pairs.get(0).regenerate(low, high);
        return cuboid;
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<CuboidTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        if (NotableManager.isExactSavedObject(this)) {
            com.denizenscript.denizen.utilities.debugging.Debug.echoError("Cannot apply properties to noted objects.");
            return;
        }
        this.adjust(mechanism);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        LocationPair pair;
        CuboidTag subCuboid;
        int member;
        int comma;
        String value;
        if (mechanism.matches("set_member")) {
            value = mechanism.getValue().asString();
            comma = value.indexOf(44);
            member = 1;
            if (comma > 0 && !value.startsWith("cu@")) {
                member = new ElementTag(value.substring(0, comma)).asInt();
                value = value.substring(comma + 1);
            }
            subCuboid = CuboidTag.valueOf(value, mechanism.context);
            if (member < 1) {
                member = 1;
            }
            if (member > this.pairs.size()) {
                member = this.pairs.size();
            }
            pair = subCuboid.pairs.get(0);
            this.pairs.set(member - 1, new LocationPair(pair.low, pair.high));
        }
        if (mechanism.matches("add_member")) {
            value = mechanism.getValue().asString();
            comma = value.indexOf(44);
            member = this.pairs.size() + 1;
            if (comma > 0 && !value.startsWith("cu@")) {
                member = new ElementTag(value.substring(0, comma)).asInt();
                value = value.substring(comma + 1);
            }
            subCuboid = CuboidTag.valueOf(value, mechanism.context);
            if (member < 1) {
                member = 1;
            }
            if (member > this.pairs.size()) {
                member = this.pairs.size();
            }
            pair = subCuboid.pairs.get(0);
            this.pairs.add(member - 1, new LocationPair(pair.low, pair.high));
        }
        if (mechanism.matches("remove_member") && mechanism.requireInteger()) {
            int member2 = mechanism.getValue().asInt();
            if (member2 < 1) {
                member2 = 1;
            }
            if (member2 > this.pairs.size()) {
                member2 = this.pairs.size();
            }
            this.pairs.remove(member2 - 1);
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }

    public static class LocationPair {
        public LocationTag low;
        public LocationTag high;

        public int xDistance() {
            return this.high.getBlockX() - this.low.getBlockX();
        }

        public int yDistance() {
            return this.high.getBlockY() - this.low.getBlockY();
        }

        public int zDistance() {
            return this.high.getBlockZ() - this.low.getBlockZ();
        }

        public LocationPair(LocationTag point_1, LocationTag point_2) {
            this.regenerate(point_1, point_2);
        }

        public void regenerate(LocationTag point_1, LocationTag point_2) {
            String world = point_1.getWorldName();
            int x_high = point_1.getBlockX() >= point_2.getBlockX() ? point_1.getBlockX() : point_2.getBlockX();
            int x_low = point_1.getBlockX() <= point_2.getBlockX() ? point_1.getBlockX() : point_2.getBlockX();
            int y_high = point_1.getBlockY() >= point_2.getBlockY() ? point_1.getBlockY() : point_2.getBlockY();
            int y_low = point_1.getBlockY() <= point_2.getBlockY() ? point_1.getBlockY() : point_2.getBlockY();
            int z_high = point_1.getBlockZ() >= point_2.getBlockZ() ? point_1.getBlockZ() : point_2.getBlockZ();
            int z_low = point_1.getBlockZ() <= point_2.getBlockZ() ? point_1.getBlockZ() : point_2.getBlockZ();
            this.low = new LocationTag(x_low, (double)y_low, (double)z_low, world);
            this.high = new LocationTag(x_high, (double)y_high, (double)z_high, world);
        }
    }
}

