/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events;

import java.util.List;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEllipsoid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Vehicle;

public abstract class BukkitScriptEvent
extends ScriptEvent {
    private static final String ASTERISK_QUOTED = Pattern.quote("*");

    public boolean runInCheck(ScriptContainer scriptContainer, String s, String lower, Location location) {
        return this.runInCheck(scriptContainer, s, lower, location, "in");
    }

    public boolean runInCheck(ScriptContainer scriptContainer, String s, String lower, Location location, String innote) {
        int index;
        List<String> data = CoreUtilities.split(lower, ' ');
        for (index = 0; index < data.size() && !data.get(index).equals(innote); ++index) {
        }
        if (index >= data.size()) {
            return true;
        }
        String it = CoreUtilities.getXthArg(index + 1, lower);
        if (it.equals("notable")) {
            String subit = CoreUtilities.getXthArg(index + 2, lower);
            if (subit.equals("cuboid")) {
                return dCuboid.getNotableCuboidsContaining(location).size() > 0;
            }
            if (subit.equals("ellipsoid")) {
                return dEllipsoid.getNotableEllipsoidsContaining(location).size() > 0;
            }
            dB.echoError("Invalid event 'IN ...' check [" + this.getName() + "] ('in notable ???'): '" + s + "' for " + scriptContainer.getName());
            return false;
        }
        if (dWorld.matches(it)) {
            return CoreUtilities.toLowerCase(location.getWorld().getName()).equals(it);
        }
        if (dCuboid.matches(it)) {
            dCuboid cuboid = dCuboid.valueOf(it);
            return cuboid.isInsideCuboid(location);
        }
        if (dEllipsoid.matches(it)) {
            dEllipsoid ellipsoid = dEllipsoid.valueOf(it);
            return ellipsoid.contains(location);
        }
        dB.echoError("Invalid event 'IN ...' check [" + this.getName() + "] ('in ???'): '" + s + "' for " + scriptContainer.getName());
        return false;
    }

    public boolean tryLocation(dLocation location, String comparedto) {
        if (comparedto == null || comparedto.length() == 0) {
            dB.echoError("Null or empty location string to compare");
            return false;
        }
        if (comparedto.equals("notable")) {
            return true;
        }
        comparedto = "l@" + comparedto;
        dLocation loc = dLocation.valueOf(comparedto);
        if (loc == null) {
            dB.echoError("Invalid location in location comparison string: " + comparedto);
            return false;
        }
        return loc.getBlock().equals(location.getBlock());
    }

    public boolean runWithCheck(ScriptContainer scriptContainer, String s, String lower, dItem held) {
        String with = BukkitScriptEvent.getSwitch(lower, "with");
        if (with != null) {
            if (with.equals("item")) {
                return true;
            }
            dItem it = dItem.valueOf(with);
            if (it == null) {
                dB.echoError("Invalid WITH item in " + this.getName() + " for '" + s + "' in " + scriptContainer.getName());
                return false;
            }
            if (held == null || !this.tryItem(held, with)) {
                return false;
            }
        }
        return true;
    }

    public String regexHandle(String input) {
        if (input.startsWith("regex:")) {
            return input.substring("regex:".length());
        }
        if (input.contains("*")) {
            return Pattern.quote(input).replace(ASTERISK_QUOTED, "(.*)");
        }
        return null;
    }

    public boolean equalityCheck(String input, String compared, String regexed) {
        return (input = CoreUtilities.toLowerCase(input)).equals(compared) || regexed != null && input.matches(regexed);
    }

    public boolean tryItem(dItem item, String comparedto) {
        if (comparedto == null || comparedto.isEmpty() || item == null) {
            return false;
        }
        if ((comparedto = CoreUtilities.toLowerCase(comparedto)).equals("item")) {
            return true;
        }
        if (comparedto.equals("potion") && CoreUtilities.toLowerCase(item.getItemStack().getType().name()).contains("potion")) {
            return true;
        }
        dMaterial quickOf = dMaterial.quickOfNamed(comparedto);
        if (quickOf != null) {
            dMaterial mat = item.getMaterial();
            if (quickOf.getMaterial() != mat.getMaterial()) {
                return false;
            }
            if (quickOf.equals(mat)) {
                return true;
            }
        }
        String regexd = this.regexHandle(comparedto);
        item = new dItem(item.getItemStack().clone());
        item.setAmount(1);
        if (this.equalityCheck(item.identifyNoIdentifier(), comparedto, regexd)) {
            return true;
        }
        if (this.equalityCheck(item.identifyMaterialNoIdentifier(), comparedto, regexd)) {
            return true;
        }
        if (this.equalityCheck(item.identifySimpleNoIdentifier(), comparedto, regexd)) {
            return true;
        }
        if (this.equalityCheck(item.identifyNoIdentifier(), comparedto, regexd)) {
            return true;
        }
        item.setDurability((short)0);
        return this.equalityCheck(item.identifyMaterialNoIdentifier(), comparedto, regexd);
    }

    public boolean tryMaterial(dMaterial mat, String comparedto) {
        if (comparedto == null || comparedto.isEmpty() || mat == null) {
            return false;
        }
        if ((comparedto = CoreUtilities.toLowerCase(comparedto)).equals("block") || comparedto.equals("material")) {
            return true;
        }
        dMaterial quickOf = dMaterial.quickOfNamed(comparedto);
        if (quickOf != null) {
            if (quickOf.getMaterial() != mat.getMaterial()) {
                return false;
            }
            if (quickOf.equals(mat)) {
                return true;
            }
        }
        String regexd = this.regexHandle(comparedto);
        if (this.equalityCheck(mat.realName(), comparedto, regexd)) {
            return true;
        }
        if (this.equalityCheck(mat.identifyNoIdentifier(), comparedto, regexd)) {
            return true;
        }
        if (this.equalityCheck(mat.identifySimpleNoIdentifier(), comparedto, regexd)) {
            return true;
        }
        return this.equalityCheck(mat.identifyFullNoIdentifier(), comparedto, regexd);
    }

    public boolean tryEntity(dEntity entity, String comparedto) {
        if (comparedto == null || comparedto.isEmpty() || entity == null) {
            return false;
        }
        Entity bEntity = entity.getBukkitEntity();
        if ((comparedto = CoreUtilities.toLowerCase(comparedto)).equals("entity")) {
            return true;
        }
        if (comparedto.equals("npc")) {
            return entity.isCitizensNPC();
        }
        if (comparedto.equals("player")) {
            return entity.isPlayer();
        }
        if (comparedto.equals("vehicle")) {
            return bEntity instanceof Vehicle;
        }
        if (comparedto.equals("projectile")) {
            return bEntity instanceof Projectile;
        }
        if (comparedto.equals("hanging")) {
            return bEntity instanceof Hanging;
        }
        String regexd = this.regexHandle(comparedto);
        if (entity.getEntityScript() != null && this.equalityCheck(entity.getEntityScript(), comparedto, regexd)) {
            return true;
        }
        return this.equalityCheck(entity.getEntityType().getLowercaseName(), comparedto, regexd);
    }
}

