/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.Material;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class EntityItem
implements Property {
    public static final String[] handledTags = new String[]{"item"};
    public static final String[] handledMechs = new String[]{"item"};
    EntityTag item;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && (((EntityTag)entity).getBukkitEntityType() == EntityType.DROPPED_ITEM || ((EntityTag)entity).getBukkitEntityType() == EntityType.ENDERMAN || ((EntityTag)entity).getBukkitEntityType() == EntityType.TRIDENT);
    }

    public static EntityItem getFrom(ObjectTag entity) {
        if (!EntityItem.describes(entity)) {
            return null;
        }
        return new EntityItem((EntityTag)entity);
    }

    private EntityItem(EntityTag entity) {
        this.item = entity;
    }

    public ItemTag getItem() {
        if (this.item.getBukkitEntity() instanceof Item) {
            return new ItemTag(((Item)this.item.getBukkitEntity()).getItemStack());
        }
        if (this.item.getBukkitEntityType() == EntityType.TRIDENT) {
            return new ItemTag(NMSHandler.getEntityHelper().getItemFromTrident(this.item.getBukkitEntity()));
        }
        Material mat = ((Enderman)this.item.getBukkitEntity()).getCarriedBlock().getMaterial();
        if (mat == null) {
            mat = Material.AIR;
        }
        return new ItemTag(mat);
    }

    @Override
    public String getPropertyString() {
        ItemTag item = this.getItem();
        if (item.getBukkitMaterial() != Material.AIR) {
            return item.identify();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "item";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("item")) {
            return this.getItem().getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("item") && mechanism.requireObject(ItemTag.class)) {
            ItemStack itemStack = mechanism.valueAsType(ItemTag.class).getItemStack();
            if (this.item.isCitizensNPC()) {
                this.item.getDenizenNPC().getCitizen().data().setPersistent("item-type-id", (Object)itemStack.getType().name());
            }
            if (this.item.getBukkitEntity() instanceof Item) {
                ((Item)this.item.getBukkitEntity()).setItemStack(itemStack);
            } else if (this.item.getBukkitEntityType() == EntityType.TRIDENT) {
                NMSHandler.getEntityHelper().setItemForTrident(this.item.getBukkitEntity(), itemStack);
            } else {
                NMSHandler.getEntityHelper().setCarriedItem((Enderman)this.item.getBukkitEntity(), itemStack);
            }
        }
    }
}

