/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore;

import com.denizenscript.denizencore.DenizenImplementation;
import com.denizenscript.denizencore.events.OldEventManager;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.events.core.DeltaTimeScriptEvent;
import com.denizenscript.denizencore.events.core.PreScriptReloadScriptEvent;
import com.denizenscript.denizencore.events.core.ReloadScriptsScriptEvent;
import com.denizenscript.denizencore.events.core.SystemTimeScriptEvent;
import com.denizenscript.denizencore.events.core.TickScriptEvent;
import com.denizenscript.denizencore.scripts.ScriptHelper;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.commands.CommandRegistry;
import com.denizenscript.denizencore.scripts.queues.ScriptEngine;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.LogInterceptor;
import com.denizenscript.denizencore.utilities.scheduling.Schedulable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class DenizenCore {
    public static final String VERSION;
    static CommandRegistry commandRegistry;
    static ScriptEngine scriptEngine;
    public static LogInterceptor logInterceptor;
    public static Thread MAIN_THREAD;
    public static long currentTimeMillis;
    static DenizenImplementation implementation;
    public static final List<Schedulable> scheduled;
    static int tMS;
    public static long serverTimeMillis;

    public static CommandRegistry getCommandRegistry() {
        return commandRegistry;
    }

    public static void setCommandRegistry(CommandRegistry registry) {
        commandRegistry = registry;
    }

    public static ScriptEngine getScriptEngine() {
        return scriptEngine;
    }

    public static DenizenImplementation getImplementation() {
        return implementation;
    }

    public static void init(DenizenImplementation implementation) {
        currentTimeMillis = System.currentTimeMillis();
        DenizenCore.implementation = implementation;
        MAIN_THREAD = Thread.currentThread();
        Debug.log("Initializing Denizen Core v" + VERSION + ", implementation for " + implementation.getImplementationName() + " version " + implementation.getImplementationVersion());
        scriptEngine = new ScriptEngine();
        ScriptEvent.registerCoreEvents();
    }

    public static void preloadScripts() {
        PreScriptReloadScriptEvent.instance.fire();
        ScriptEvent.worldContainers.clear();
        implementation.preScriptReload();
        ScriptHelper.resetError();
        ScriptHelper.reloadScripts();
    }

    public static void postLoadScripts() {
        try {
            ScriptRegistry.postLoadScripts();
            OldEventManager.scanWorldEvents();
            ScriptEvent.reload();
            implementation.onScriptReload();
        }
        catch (Exception ex) {
            implementation.debugMessage("Error loading scripts:");
            implementation.debugException(ex);
        }
    }

    public static void reloadScripts() {
        DenizenCore.preloadScripts();
        DenizenCore.postLoadScripts();
        ReloadScriptsScriptEvent.instance.hadError = ScriptHelper.hadError();
        ReloadScriptsScriptEvent.instance.fire();
        Debug.log("Scripts reloaded.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void schedule(Schedulable sched) {
        List<Schedulable> list = scheduled;
        synchronized (list) {
            scheduled.add(sched);
        }
    }

    static void oncePerSecond() {
        SystemTimeScriptEvent.instance.checkTime();
        DeltaTimeScriptEvent.instance.checkTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick(int ms_elapsed) {
        serverTimeMillis += (long)ms_elapsed;
        currentTimeMillis = System.currentTimeMillis();
        ++TickScriptEvent.instance.ticks;
        if (TickScriptEvent.instance.enabled) {
            TickScriptEvent.instance.fire();
        }
        tMS += ms_elapsed;
        while (tMS > 1000) {
            tMS -= 1000;
            DenizenCore.oncePerSecond();
        }
        List<Schedulable> list = scheduled;
        synchronized (list) {
            for (int i = 0; i < scheduled.size(); ++i) {
                if (scheduled.get(i).tick((float)ms_elapsed / 1000.0f)) continue;
                scheduled.remove(i--);
            }
        }
    }

    static {
        logInterceptor = new LogInterceptor();
        currentTimeMillis = System.currentTimeMillis();
        String version = "UNKNOWN";
        try {
            InputStream is = DenizenCore.class.getClassLoader().getResourceAsStream("denizencore.properties");
            if (is == null) {
                throw new FileNotFoundException("denizencore.properties not found in jar file");
            }
            Properties properties = new Properties();
            properties.load(is);
            version = properties.getProperty("version") + " (Build " + properties.getProperty("build") + ")";
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        VERSION = version;
        scheduled = new ArrayList<Schedulable>();
        tMS = 0;
        serverTimeMillis = 1L;
    }
}

