/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.npc.traits.SneakingTrait;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.Player;

public class SneakCommand
extends AbstractCommand {
    public static HashMap<UUID, HashMap<UUID, Boolean>> forceSetSneak = new HashMap();

    public SneakCommand() {
        this.setName("sneak");
        this.setSyntax("sneak [<entity>|...] ({start}/stop) (fake/stopfake) (for:<player>|...)");
        this.setRequiredArguments(1, 4);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matches("fake") && !scriptEntry.hasObject("fake") && !scriptEntry.hasObject("stopfake")) {
                scriptEntry.addObject("fake", new ElementTag(true));
                continue;
            }
            if (arg.matches("stopfake") && !scriptEntry.hasObject("fake") && !scriptEntry.hasObject("stopfake")) {
                scriptEntry.addObject("stopfake", new ElementTag(true));
                continue;
            }
            if ((arg.matches("start") || arg.matches("stop")) && !scriptEntry.hasObject("mode")) {
                scriptEntry.addObject("mode", arg.asElement());
                continue;
            }
            if (arg.matchesPrefix("for") && arg.matchesArgumentList(PlayerTag.class) && !scriptEntry.hasObject("for_players")) {
                scriptEntry.addObject("for_players", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            if (arg.matchesArgumentList(EntityTag.class) && !scriptEntry.hasObject("entities")) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Missing entities argument.");
        }
        scriptEntry.defaultObject("mode", new ElementTag("start"));
    }

    public static void updateFakeSneak(UUID entity, UUID player, boolean shouldSneak, boolean start) {
        HashMap<UUID, Boolean> subMap = forceSetSneak.get(entity);
        if (subMap == null) {
            if (!start) {
                return;
            }
            subMap = new HashMap();
            forceSetSneak.put(entity, subMap);
        }
        if (start) {
            subMap.put(player, shouldSneak);
        } else {
            subMap.remove(player);
            if (subMap.isEmpty()) {
                forceSetSneak.remove(entity);
            }
        }
    }

    public static Boolean shouldSneak(UUID entity, UUID player) {
        HashMap<UUID, Boolean> subMap = forceSetSneak.get(entity);
        if (subMap == null) {
            return null;
        }
        Boolean b = subMap.get(player);
        if (b != null) {
            return b;
        }
        return subMap.get(null);
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag fake = scriptEntry.getElement("fake");
        ElementTag stopfake = scriptEntry.getElement("stopfake");
        ElementTag mode = scriptEntry.getElement("mode");
        List forPlayers = (List)scriptEntry.getObject("for_players");
        List entities = (List)scriptEntry.getObject("entities");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), mode.debug() + ArgumentHelper.debugList("entities", entities) + (forPlayers != null ? ArgumentHelper.debugList("for_players", forPlayers) : "") + (fake != null ? fake.debug() : "") + (stopfake != null ? stopfake.debug() : ""));
        }
        boolean shouldSneak = mode.asString().equalsIgnoreCase("start");
        boolean shouldFake = fake != null && fake.asBoolean();
        boolean shouldStopFake = stopfake != null && stopfake.asBoolean();
        for (EntityTag entity : entities) {
            if (shouldFake || shouldStopFake) {
                if (forPlayers == null) {
                    SneakCommand.updateFakeSneak(entity.getUUID(), null, shouldSneak, shouldFake);
                    for (Player player : NMSHandler.getEntityHelper().getPlayersThatSee(entity.getBukkitEntity())) {
                        NMSHandler.getPacketHelper().sendEntityMetadataFlagsUpdate(player, entity.getBukkitEntity());
                    }
                    continue;
                }
                for (PlayerTag playerTag : forPlayers) {
                    SneakCommand.updateFakeSneak(entity.getUUID(), playerTag.getOfflinePlayer().getUniqueId(), shouldSneak, shouldFake);
                    NMSHandler.getPacketHelper().sendEntityMetadataFlagsUpdate(playerTag.getPlayerEntity(), entity.getBukkitEntity());
                }
                continue;
            }
            if (entity.isCitizensNPC()) {
                SneakingTrait trait = (SneakingTrait)entity.getDenizenNPC().getCitizen().getOrAddTrait(SneakingTrait.class);
                if (shouldSneak) {
                    trait.sneak();
                    continue;
                }
                trait.stand();
                continue;
            }
            if (entity.isSpawned()) {
                NMSHandler.getEntityHelper().setSneaking(entity.getBukkitEntity(), shouldSneak);
                continue;
            }
            Debug.echoError("Cannot make unspawned entity sneak.");
        }
    }
}

