/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.HashMap;

public class RateLimitCommand
extends AbstractCommand {
    public RateLimitCommand() {
        this.setName("ratelimit");
        this.setSyntax("ratelimit [<object>] [<duration>]");
        this.setRequiredArguments(2, 2);
        this.isProcedural = true;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matchesArgumentType(DurationTag.class) && !scriptEntry.hasObject("duration")) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("object")) {
                scriptEntry.addObject("object", new ElementTag(arg.getRawValue()));
                continue;
            }
            arg.reportUnhandled();
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        ElementTag object = scriptEntry.getElement("object");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), duration.debug() + object.debug());
        }
        if (scriptEntry.internal.specialProcessedData == null) {
            scriptEntry.internal.specialProcessedData = new HashMap(2);
        }
        HashMap map = (HashMap)scriptEntry.internal.specialProcessedData;
        String key = CoreUtilities.toLowerCase(object.asString());
        Long endTime = (Long)map.get(key);
        long curTime = DenizenCore.serverTimeMillis;
        if (endTime != null && curTime < endTime) {
            Debug.echoDebug((Debuggable)scriptEntry, "Rate limit applied with " + (endTime - curTime) + "ms left.");
            scriptEntry.getResidingQueue().clear();
            scriptEntry.getResidingQueue().stop();
            return;
        }
        map.put(key, curTime + duration.getMillis());
    }
}

