/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.core;

import com.denizenscript.denizen.scripts.containers.core.InteractScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptHelper;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import org.bukkit.event.Listener;

public class ZapCommand
extends AbstractCommand
implements Listener {
    public ZapCommand() {
        this.setName("zap");
        this.setSyntax("zap (<script>) [<step>] (<duration>)");
        this.setRequiredArguments(0, 3);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("script") && !scriptEntry.hasObject("step") && arg.hasPrefix() && arg.getPrefix().matchesArgumentType(ScriptTag.class)) {
                scriptEntry.addObject("script", arg.getPrefix().asType(ScriptTag.class));
                scriptEntry.addObject("step", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("script") && arg.matchesArgumentType(ScriptTag.class) && !arg.matchesPrefix("step")) {
                scriptEntry.addObject("script", arg.asType(ScriptTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("step")) {
                scriptEntry.addObject("step", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("script", scriptEntry.getScript());
        if (!Utilities.entryHasPlayer(scriptEntry) || !Utilities.getEntryPlayer(scriptEntry).isValid()) {
            throw new InvalidArgumentsException("Must have player context!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ScriptTag script = (ScriptTag)scriptEntry.getObjectTag("script");
        DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), Utilities.getEntryPlayer(scriptEntry).debug() + script.debug() + (scriptEntry.hasObject("step") ? scriptEntry.getElement("step").debug() : ArgumentHelper.debugObj("step", "++ (inc)")) + (duration != null ? duration.debug() : ""));
        }
        String step = scriptEntry.hasObject("step") ? scriptEntry.getElement("step").asString() : null;
        String currentStep = InteractScriptHelper.getCurrentStep(Utilities.getEntryPlayer(scriptEntry), script.getName());
        if (step == null) {
            step = ArgumentHelper.matchesInteger(currentStep) ? String.valueOf(Integer.parseInt(currentStep) + 1) : "1";
        } else if (step.equals("*")) {
            step = ((InteractScriptContainer)script.getContainer()).getDefaultStepName();
        }
        if (step.equalsIgnoreCase(currentStep)) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Zapping to own current step!");
            return;
        }
        TimeTag expiration = null;
        if (duration != null && duration.getSeconds() > 0.0) {
            expiration = new TimeTag(TimeTag.now().millis() + duration.getMillis());
        }
        Utilities.getEntryPlayer(scriptEntry).getFlagTracker().setFlag("__interact_step." + script.getName(), new ElementTag(step), expiration);
    }
}

