/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.objects.AreaContainmentObject;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.objects.notable.NotableManager;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.flags.LocationFlagSearchHelper;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.flags.SavableMapFlagTracker;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.Note;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PolygonTag
implements ObjectTag,
Cloneable,
Notable,
Adjustable,
AreaContainmentObject,
FlaggableObject {
    public WorldTag world;
    public double yMin = 0.0;
    public double yMax = 0.0;
    public List<Corner> corners = new ArrayList<Corner>();
    public Corner boxMin = new Corner();
    public Corner boxMax = new Corner();
    public String noteName = null;
    public AbstractFlagTracker flagTracker = null;
    String prefix = "Polygon";
    public static ObjectTagProcessor<PolygonTag> tagProcessor = new ObjectTagProcessor();

    public PolygonTag(WorldTag world) {
        this.world = world;
    }

    public PolygonTag(WorldTag world, double yMin, double yMax, List<Corner> corners) {
        this.world = world;
        this.yMin = yMin;
        this.yMax = yMax;
        for (Corner corner : corners) {
            this.corners.add(new Corner(corner.x, corner.z));
        }
        this.recalculateBox();
    }

    public void recalculateBox() {
        if (this.corners.size() == 0) {
            return;
        }
        Corner firstCorner = this.corners.get(0);
        this.boxMin.x = firstCorner.x;
        this.boxMin.z = firstCorner.z;
        this.boxMax.x = firstCorner.x;
        this.boxMax.z = firstCorner.z;
        for (Corner corner : this.corners) {
            this.recalculateToFit(corner);
        }
    }

    public void recalculateToFit(Corner corner) {
        this.boxMin.x = Math.min(this.boxMin.x, corner.x);
        this.boxMin.z = Math.min(this.boxMin.z, corner.z);
        this.boxMax.x = Math.max(this.boxMax.x, corner.x);
        this.boxMax.z = Math.max(this.boxMax.z, corner.z);
    }

    public PolygonTag clone() {
        return new PolygonTag(this.world, this.yMin, this.yMax, this.corners);
    }

    @Fetchable(value="polygon")
    public static PolygonTag valueOf(String string, TagContext context) {
        Notable saved;
        if (string.startsWith("polygon@")) {
            string = string.substring("polygon@".length());
        }
        if ((saved = NotableManager.getSavedObject(string)) instanceof PolygonTag) {
            return (PolygonTag)saved;
        }
        List<String> parts = CoreUtilities.split(string, ',');
        if (parts.size() < 3) {
            return null;
        }
        WorldTag world = new WorldTag(parts.get(0));
        for (int i = 1; i < parts.size(); ++i) {
            if (ArgumentHelper.matchesDouble(parts.get(i))) continue;
            return null;
        }
        PolygonTag toReturn = new PolygonTag(world);
        toReturn.yMin = Double.parseDouble(parts.get(1));
        toReturn.yMax = Double.parseDouble(parts.get(2));
        for (int i = 3; i < parts.size(); i += 2) {
            Corner corner = new Corner(Double.parseDouble(parts.get(i)), Double.parseDouble(parts.get(i + 1)));
            toReturn.corners.add(corner);
        }
        toReturn.recalculateBox();
        return toReturn;
    }

    public static boolean matches(String string) {
        return PolygonTag.valueOf(string, CoreUtilities.noDebugContext) != null;
    }

    @Override
    public ObjectTag duplicate() {
        if (this.noteName != null) {
            return this;
        }
        return this.clone();
    }

    public int hashCode() {
        if (this.noteName != null) {
            return this.noteName.hashCode();
        }
        return (int)(this.boxMin.x + this.boxMin.z * 7.0 + this.boxMax.x * 29.0 + this.boxMax.z * 61.0);
    }

    public boolean equals(Object other) {
        if (!(other instanceof PolygonTag)) {
            return false;
        }
        PolygonTag poly2 = (PolygonTag)other;
        if (poly2.corners.size() != this.corners.size()) {
            return false;
        }
        if (this.noteName == null != (poly2.noteName == null)) {
            return false;
        }
        if (this.noteName != null && !this.noteName.equals(poly2.noteName)) {
            return false;
        }
        if (!this.world.getName().equals(poly2.world.getName())) {
            return false;
        }
        if (this.yMin != poly2.yMin || this.yMax != poly2.yMax) {
            return false;
        }
        for (int i = 0; i < this.corners.size(); ++i) {
            Corner corner1 = this.corners.get(i);
            Corner corner2 = poly2.corners.get(i);
            if (corner1.x == corner2.x && corner1.z == corner2.z) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getNoteName() {
        return this.noteName;
    }

    public static List<PolygonTag> getNotedPolygonsContaining(Location location) {
        ArrayList<PolygonTag> polygons = new ArrayList<PolygonTag>();
        for (PolygonTag polygon : NotableManager.getAllType(PolygonTag.class)) {
            if (!polygon.doesContainLocation(location)) continue;
            polygons.add(polygon);
        }
        return polygons;
    }

    @Override
    public boolean doesContainLocation(Location loc) {
        if (loc.getWorld() == null) {
            return false;
        }
        if (!loc.getWorld().getName().equals(this.world.getName())) {
            return false;
        }
        double x = loc.getX();
        double z = loc.getZ();
        if (x < this.boxMin.x || x > this.boxMax.x || z < this.boxMin.z || z > this.boxMax.z) {
            return false;
        }
        double y = loc.getY();
        if (y < this.yMin || y > this.yMax) {
            return false;
        }
        boolean isInside = false;
        for (int i = 0; i < this.corners.size(); ++i) {
            Corner start = this.corners.get(i);
            Corner end = i + 1 == this.corners.size() ? this.corners.get(0) : this.corners.get(i + 1);
            if (start.z > z == end.z > z || !(x < (end.x - start.x) * (z - start.z) / (end.z - start.z) + start.x)) continue;
            isInside = !isInside;
        }
        return isInside;
    }

    public List<LocationTag> generateFlatBlockShell(double y) {
        int max = Settings.blockTagsMaxBlocks();
        ArrayList<LocationTag> toOutput = new ArrayList<LocationTag>();
        int x = (int)Math.floor(this.boxMin.x);
        while ((double)x < this.boxMax.x) {
            int z = (int)Math.floor(this.boxMin.z);
            while ((double)z < this.boxMax.z) {
                LocationTag possible = new LocationTag((double)x + 0.5, y, (double)z + 0.5, this.world.getName());
                if (this.doesContainLocation(possible)) {
                    toOutput.add(possible);
                }
                if (--max <= 0) {
                    return toOutput;
                }
                ++z;
            }
            ++x;
        }
        return toOutput;
    }

    public ListTag getShell() {
        int max = Settings.blockTagsMaxBlocks();
        ListTag addTo = new ListTag();
        List<LocationTag> flatShell = this.generateFlatBlockShell(this.yMin);
        for (LocationTag loc : flatShell) {
            addTo.addObject(loc.clone());
        }
        if ((max -= flatShell.size()) <= 0) {
            return addTo;
        }
        for (LocationTag loc : flatShell) {
            LocationTag newLoc = loc.clone();
            newLoc.setY(this.yMax);
            addTo.addObject(newLoc);
        }
        if ((max -= flatShell.size()) <= 0) {
            return addTo;
        }
        int per = (int)(this.yMax - this.yMin);
        if (per == 0) {
            return addTo;
        }
        for (int i = 0; i < this.corners.size(); ++i) {
            Corner start = this.corners.get(i);
            Corner end = i + 1 == this.corners.size() ? this.corners.get(0) : this.corners.get(i + 1);
            double xMove = end.x - start.x;
            double zMove = end.z - start.z;
            double len = Math.sqrt(xMove * xMove + zMove * zMove);
            if (len < 0.1) continue;
            xMove /= len;
            zMove /= len;
            double xSpot = start.x;
            double zSpot = start.z;
            if ((max -= (int)(len + 1.0)) <= 0) {
                return addTo;
            }
            int j = 0;
            while ((double)j < len) {
                for (double y = this.yMin + 1.0; y < this.yMax; y += 1.0) {
                    addTo.addObject(new LocationTag(xSpot, y, zSpot, this.world.getName()));
                }
                if ((max -= per) <= 0) {
                    return addTo;
                }
                xSpot += xMove;
                zSpot += zMove;
                ++j;
            }
        }
        return addTo;
    }

    public ListTag getBlocks(List<MaterialTag> materials, Attribute attribute) {
        int max = Settings.blockTagsMaxBlocks();
        ListTag addTo = new ListTag();
        List<LocationTag> flatShell = this.generateFlatBlockShell(this.yMin);
        for (double y = this.yMin; y < this.yMax; y += 1.0) {
            for (LocationTag loc : flatShell) {
                LocationTag newLoc = loc.clone();
                newLoc.setY(y);
                if (!CuboidTag.matchesMaterialList(newLoc, materials, attribute)) continue;
                addTo.addObject(newLoc);
            }
            if ((max -= flatShell.size()) > 0) continue;
            return addTo;
        }
        return addTo;
    }

    public void addOutline2D(double y, ListTag addTo) {
        int max = Settings.blockTagsMaxBlocks();
        for (int i = 0; i < this.corners.size(); ++i) {
            Corner start = this.corners.get(i);
            Corner end = i + 1 == this.corners.size() ? this.corners.get(0) : this.corners.get(i + 1);
            double xMove = end.x - start.x;
            double zMove = end.z - start.z;
            double len = Math.sqrt(xMove * xMove + zMove * zMove);
            if (len < 0.1) continue;
            xMove /= len;
            zMove /= len;
            double xSpot = start.x;
            double zSpot = start.z;
            if ((max -= (int)(len + 1.0)) <= 0) {
                return;
            }
            int j = 0;
            while ((double)j < len) {
                addTo.addObject(new LocationTag(xSpot, y, zSpot, this.world.getName()));
                xSpot += xMove;
                zSpot += zMove;
                ++j;
            }
        }
    }

    public ListTag getOutline() {
        int max = Settings.blockTagsMaxBlocks();
        ListTag output = new ListTag();
        this.addOutline2D(this.yMin, output);
        if (max <= output.size()) {
            return output;
        }
        if (this.yMin != this.yMax) {
            this.addOutline2D(this.yMax, output);
        }
        if ((max -= output.size()) <= 0) {
            return output;
        }
        int per = (int)(this.yMax - this.yMin);
        if (per == 0) {
            return output;
        }
        for (Corner corner : this.corners) {
            for (double y = this.yMin + 1.0; y < this.yMax; y += 1.0) {
                output.addObject(new LocationTag(corner.x, y, corner.z, this.world.getName()));
            }
            if ((max -= per) > 0) continue;
            return output;
        }
        return output;
    }

    @Override
    public boolean isUnique() {
        return NotableManager.isSaved(this);
    }

    @Override
    @Note(value="Polygons")
    public Object getSaveObject() {
        YamlConfiguration section = new YamlConfiguration();
        section.set("object", (Object)this.identifyFull());
        section.set("flags", (Object)this.flagTracker.toString());
        return section;
    }

    @Override
    public void makeUnique(String id) {
        PolygonTag toNote = this.clone();
        toNote.noteName = id;
        toNote.flagTracker = new SavableMapFlagTracker();
        NotableManager.saveAs(toNote, id);
    }

    @Override
    public void forget() {
        this.noteName = null;
        this.flagTracker = null;
        NotableManager.remove(this);
    }

    @Override
    public String getObjectType() {
        return "polygon";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public PolygonTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debuggable() {
        if (this.isUnique()) {
            return "polygon@" + NotableManager.getSavedId(this) + " <GR>(" + this.identifyFull() + ")";
        }
        return this.identifyFull();
    }

    @Override
    public String identify() {
        if (this.isUnique()) {
            return "polygon@" + NotableManager.getSavedId(this);
        }
        return this.identifyFull();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String identifyFull() {
        StringBuilder sb = new StringBuilder();
        sb.append("polygon@").append(this.world.getName()).append(",").append(this.yMin).append(",").append(this.yMax).append(",");
        for (Corner corner : this.corners) {
            sb.append(corner.x).append(",").append(corner.z).append(",");
        }
        if (this.corners.size() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public AbstractFlagTracker getFlagTracker() {
        return this.flagTracker;
    }

    @Override
    public void reapplyTracker(AbstractFlagTracker tracker) {
        if (this.noteName != null) {
            this.flagTracker = tracker;
        }
    }

    @Override
    public String getReasonNotFlaggable() {
        if (this.noteName == null) {
            return "the area is not noted - only noted areas can hold flags";
        }
        return "unknown reason - something went wrong";
    }

    public static void registerTags() {
        AbstractFlagTracker.registerFlagHandlers(tagProcessor);
        PolygonTag.registerTag("contains", (attribute, polygon) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("PolygonTag.contains[...] tag must have an input.");
                return null;
            }
            LocationTag toCheck = attribute.contextAsType(1, LocationTag.class);
            return new ElementTag(polygon.doesContainLocation(toCheck));
        }, new String[0]);
        PolygonTag.registerTag("bounding_box", (attribute, polygon) -> {
            LocationTag min = new LocationTag(Math.floor(polygon.boxMin.x), Math.floor(polygon.yMin), Math.floor(polygon.boxMin.z), polygon.world.getName());
            LocationTag max = new LocationTag(Math.ceil(polygon.boxMax.x), Math.ceil(polygon.yMax), Math.ceil(polygon.boxMax.z), polygon.world.getName());
            return new CuboidTag(min, max);
        }, new String[0]);
        PolygonTag.registerTag("max_y", (attribute, polygon) -> new ElementTag(polygon.yMax), new String[0]);
        PolygonTag.registerTag("min_y", (attribute, polygon) -> new ElementTag(polygon.yMin), new String[0]);
        PolygonTag.registerTag("world", (attribute, polygon) -> polygon.world, new String[0]);
        PolygonTag.registerTag("players", (attribute, polygon) -> {
            ArrayList<PlayerTag> players = new ArrayList<PlayerTag>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!polygon.doesContainLocation(player.getLocation())) continue;
                players.add(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player));
            }
            return new ListTag((Collection<? extends ObjectTag>)players);
        }, new String[0]);
        if (Depends.citizens != null) {
            PolygonTag.registerTag("npcs", (attribute, polygon) -> {
                ArrayList<NPCTag> npcs = new ArrayList<NPCTag>();
                for (NPC npc : CitizensAPI.getNPCRegistry()) {
                    NPCTag dnpc = new NPCTag(npc);
                    if (!polygon.doesContainLocation(dnpc.getLocation())) continue;
                    npcs.add(dnpc);
                }
                return new ListTag((Collection<? extends ObjectTag>)npcs);
            }, new String[0]);
        }
        PolygonTag.registerTag("entities", (attribute, polygon) -> {
            ArrayList<EntityTag> entities = new ArrayList<EntityTag>();
            ListTag types = new ListTag();
            if (attribute.hasContext(1)) {
                types = attribute.contextAsType(1, ListTag.class);
            }
            block0: for (Entity ent : polygon.world.getEntitiesForTag()) {
                EntityTag current = new EntityTag(ent);
                if (!polygon.doesContainLocation(ent.getLocation())) continue;
                if (!types.isEmpty()) {
                    for (String type : types) {
                        if (!current.identifySimpleType().equalsIgnoreCase(type)) continue;
                        entities.add(current);
                        continue block0;
                    }
                    continue;
                }
                entities.add(new EntityTag(ent));
            }
            return new ListTag((Collection<? extends ObjectTag>)entities);
        }, new String[0]);
        PolygonTag.registerTag("living_entities", (attribute, polygon) -> {
            ArrayList<EntityTag> entities = new ArrayList<EntityTag>();
            for (Entity ent : polygon.world.getWorld().getLivingEntities()) {
                if (!polygon.doesContainLocation(ent.getLocation()) || EntityTag.isCitizensNPC(ent)) continue;
                entities.add(new EntityTag(ent));
            }
            return new ListTag((Collection<? extends ObjectTag>)entities);
        }, new String[0]);
        PolygonTag.registerTag("note_name", (attribute, polygon) -> {
            String noteName = NotableManager.getSavedId(polygon);
            if (noteName == null) {
                return null;
            }
            return new ElementTag(noteName);
        }, new String[0]);
        PolygonTag.registerTag("corners", (attribute, polygon) -> {
            ListTag list = new ListTag();
            for (Corner corner : polygon.corners) {
                list.addObject(new LocationTag(corner.x, polygon.yMin, corner.z, polygon.world.getName()));
            }
            return list;
        }, new String[0]);
        PolygonTag.registerTag("shift", (attribute, polygon) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("PolygonTag.shift[...] tag must have an input.");
                return null;
            }
            LocationTag shift = attribute.contextAsType(1, LocationTag.class);
            PolygonTag toReturn = polygon.clone();
            toReturn.yMin += shift.getY();
            toReturn.yMax += shift.getY();
            for (Corner corner : toReturn.corners) {
                corner.x += shift.getX();
                corner.z += shift.getZ();
            }
            toReturn.boxMin.x += shift.getX();
            toReturn.boxMin.z += shift.getZ();
            toReturn.boxMax.x += shift.getX();
            toReturn.boxMax.z += shift.getZ();
            return toReturn;
        }, new String[0]);
        PolygonTag.registerTag("with_corner", (attribute, polygon) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("PolygonTag.with_corner[...] tag must have an input.");
                return null;
            }
            LocationTag corner = attribute.contextAsType(1, LocationTag.class);
            PolygonTag toReturn = polygon.clone();
            Corner added = new Corner(corner.getX(), corner.getZ());
            toReturn.corners.add(added);
            toReturn.recalculateToFit(added);
            return toReturn;
        }, new String[0]);
        PolygonTag.registerTag("with_y_min", (attribute, polygon) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("PolygonTag.with_y_min[...] tag must have an input.");
                return null;
            }
            PolygonTag toReturn = polygon.clone();
            toReturn.yMin = attribute.getDoubleContext(1);
            return toReturn;
        }, new String[0]);
        PolygonTag.registerTag("with_y_max", (attribute, polygon) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("PolygonTag.with_y_max[...] tag must have an input.");
                return null;
            }
            PolygonTag toReturn = polygon.clone();
            toReturn.yMax = attribute.getDoubleContext(1);
            return toReturn;
        }, new String[0]);
        PolygonTag.registerTag("with_world", (attribute, polygon) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("PolygonTag.with_world[...] tag must have an input.");
                return null;
            }
            PolygonTag toReturn = polygon.clone();
            toReturn.world = attribute.contextAsType(1, WorldTag.class);
            if (toReturn.world == null) {
                return null;
            }
            return toReturn;
        }, new String[0]);
        PolygonTag.registerTag("include_y", (attribute, polygon) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("PolygonTag.include_y[...] tag must have an input.");
                return null;
            }
            PolygonTag toReturn = polygon.clone();
            double y = attribute.getDoubleContext(1);
            toReturn.yMin = Math.min(y, toReturn.yMin);
            toReturn.yMax = Math.max(y, toReturn.yMax);
            return toReturn;
        }, new String[0]);
        PolygonTag.registerTag("outline_2d", (attribute, polygon) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("PolygonTag.outline_2d[...] tag must have an input.");
                return null;
            }
            double y = attribute.getDoubleContext(1);
            ListTag output = new ListTag();
            polygon.addOutline2D(y, output);
            return output;
        }, new String[0]);
        PolygonTag.registerTag("outline", (attribute, polygon) -> polygon.getOutline(), new String[0]);
        PolygonTag.registerTag("shell", (attribute, polygon) -> polygon.getShell(), new String[0]);
        PolygonTag.registerTag("blocks", (attribute, polygon) -> {
            List<MaterialTag> materials = null;
            if (attribute.hasContext(1)) {
                materials = attribute.contextAsType(1, ListTag.class).filter(MaterialTag.class, attribute.context);
            }
            return polygon.getBlocks(materials, attribute);
        }, new String[0]);
        PolygonTag.registerTag("blocks_flagged", (attribute, polygon) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("PolygonTag.blocks_flagged[...] must have an input value.");
                return null;
            }
            String flagName = CoreUtilities.toLowerCase(attribute.getContext(1));
            ListTag blocks = new ListTag();
            int chunkMinX = (int)Math.floor(polygon.boxMin.x) >> 4;
            int chunkMinZ = (int)Math.floor(polygon.boxMin.z) >> 4;
            int chunkMaxX = (int)Math.ceil(polygon.boxMax.x) >> 4;
            int chunkMaxZ = (int)Math.ceil(polygon.boxMax.z) >> 4;
            ChunkTag testChunk = new ChunkTag(polygon.world, chunkMinX, chunkMinZ);
            for (int x = chunkMinX; x <= chunkMaxX; ++x) {
                testChunk.chunkX = x;
                for (int z = chunkMinZ; z <= chunkMaxZ; ++z) {
                    testChunk.chunkZ = z;
                    testChunk.cachedChunk = null;
                    if (!testChunk.isLoadedSafe()) continue;
                    LocationFlagSearchHelper.getFlaggedLocations(testChunk.getChunk(), flagName, loc -> {
                        if (polygon.doesContainLocation((Location)loc)) {
                            blocks.addObject(new LocationTag((Location)loc));
                        }
                    });
                }
            }
            return blocks;
        }, new String[0]);
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<PolygonTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        if (NotableManager.isExactSavedObject(this)) {
            Debug.echoError("Cannot apply properties to noted objects.");
            return;
        }
        this.adjust(mechanism);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("add_corner") && mechanism.requireObject(LocationTag.class)) {
            LocationTag loc = mechanism.valueAsType(LocationTag.class);
            Corner newCorner = new Corner(loc.getX(), loc.getZ());
            this.corners.add(newCorner);
            this.recalculateToFit(newCorner);
        }
    }

    public static class Corner {
        public double x;
        public double z;

        public Corner() {
        }

        public Corner(double x, double z) {
            this.x = x;
            this.z = z;
        }
    }
}

