/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.scripts.commands.entity.RemoveCommand;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.flags.PlayerFlagHandler;
import com.denizenscript.denizencore.flags.MapTagBasedFlagTracker;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.scripts.ScriptHelper;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.FutureWarning;
import java.nio.charset.Charset;
import org.bukkit.configuration.file.FileConfiguration;

public class Settings {
    private static boolean cache_showDebug = true;
    private static boolean cache_overrideHelp;
    private static boolean cache_useDefaultScriptPath;
    private static boolean cache_showExHelp;
    private static boolean cache_showExDebug;
    private static boolean cache_allowConsoleRedirection;
    private static boolean cache_canRecordStats;
    private static boolean cache_defaultDebugMode;
    private static boolean cache_healthTraitEnabledByDefault;
    private static boolean cache_healthTraitAnimatedDeathEnabled;
    private static boolean cache_healthTraitRespawnEnabled;
    private static boolean cache_allowWebget;
    private static boolean cache_allowFilecopy;
    private static boolean cache_allowDelete;
    private static boolean cache_allowServerStop;
    private static boolean cache_allowServerRestart;
    private static boolean cache_allowLogging;
    private static boolean cache_allowStrangeYAMLSaves;
    private static boolean cache_healthTraitBlockDrops;
    private static boolean cache_chatAsynchronous;
    private static boolean cache_chatMustSeeNPC;
    private static boolean cache_chatMustLookAtNPC;
    private static boolean cache_chatGloballyIfFailedChatTriggers;
    private static boolean cache_chatGloballyIfNoChatTriggers;
    private static boolean cache_chatGloballyIfUninteractable;
    private static boolean cache_worldScriptChatEventAsynchronous;
    private static boolean cache_tagTimeoutSilent;
    private static boolean cache_packetInterception;
    private static boolean cache_tagTimeoutUnsafe;
    private static String cache_getAlternateScriptPath;
    private static String cache_scriptQueueSpeed;
    private static String cache_healthTraitRespawnDelay;
    private static String cache_engageTimeoutInSeconds;
    private static String cache_chatMultipleTargetsFormat;
    private static String cache_chatNoTargetFormat;
    private static String cache_chatToTargetFormat;
    private static String cache_chatWithTargetToBystandersFormat;
    private static String cache_chatWithTargetsToBystandersFormat;
    private static String cache_chatToNpcFormat;
    private static String cache_chatToNpcOverheardFormat;
    private static String cache_interactQueueSpeed;
    private static String cache_limitPath;
    private static String cache_scriptEncoding;
    private static String cache_debugPrefix;
    private static int cache_consoleWidth;
    private static int cache_trimLength;
    private static int cache_whileMaxLoops;
    private static int cache_blockTagsMaxBlocks;
    private static int cache_chatHistoryMaxMessages;
    private static int cache_tagTimeout;
    private static int cache_debugLimitPerTick;
    private static long cache_warningRate;
    private static double cache_chatBystandersRange;
    private static double cache_chatToNpcOverhearingRange;
    private static DurationTag cache_worldScriptTimeEventFrequency;

    public static void refillCache() {
        FileConfiguration config = Denizen.getInstance().getConfig();
        Debug.showDebug = cache_showDebug = config.getBoolean("Debug.Show", true);
        com.denizenscript.denizencore.utilities.debugging.Debug.verbose = config.getBoolean("Debug.Verbose", false);
        com.denizenscript.denizencore.utilities.debugging.Debug.showLoading = config.getBoolean("Debug.Show loading info", false);
        cache_overrideHelp = config.getBoolean("Debug.Override help", true);
        cache_useDefaultScriptPath = config.getBoolean("Scripts location.Use default script folder", true);
        cache_showExHelp = config.getBoolean("Debug.Ex command help", true);
        cache_showExDebug = config.getBoolean("Debug.Ex command debug", true);
        cache_getAlternateScriptPath = config.getString("Scripts location.Alternative folder path", "plugins/Denizen");
        cache_scriptEncoding = config.getString("Scripts.Encoding", "default");
        if (cache_scriptEncoding.equalsIgnoreCase("default")) {
            ScriptHelper.encoding = null;
        } else {
            try {
                ScriptHelper.encoding = Charset.forName(cache_scriptEncoding).newDecoder();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        cache_consoleWidth = config.getInt("Debug.Line length", 128);
        cache_trimLength = config.getInt("Debug.Trim length limit", 1024);
        cache_allowConsoleRedirection = config.getBoolean("Debug.Allow console redirection", false);
        cache_canRecordStats = config.getBoolean("Debug.Stats", true);
        cache_defaultDebugMode = config.getBoolean("Debug.Container default", true);
        cache_debugLimitPerTick = config.getInt("Debug.Limit per tick", 5000);
        cache_debugPrefix = config.getString("Debug.Prefix", "");
        FutureWarning.futureWarningsEnabled = config.getBoolean("Debug.Show future warnings", false);
        cache_scriptQueueSpeed = config.getString("Scripts.Queue speed", "instant");
        cache_interactQueueSpeed = config.getString("Scripts.Interact.Queue speed", "0.5s");
        cache_healthTraitEnabledByDefault = config.getBoolean("Traits.Health.Enabled", false);
        cache_healthTraitRespawnEnabled = config.getBoolean("Traits.Health.Respawn.Enabled", true);
        cache_healthTraitAnimatedDeathEnabled = config.getBoolean("Traits.Health.Animated death.Enabled", true);
        cache_healthTraitRespawnDelay = config.getString("Traits.Health.Respawn.Delay", "10s");
        cache_healthTraitBlockDrops = config.getBoolean("Traits.Health.Block drops", false);
        cache_engageTimeoutInSeconds = config.getString("Commands.Engage.Timeout", "150s");
        cache_whileMaxLoops = config.getInt("Commands.While.Max loops", 10000);
        cache_allowWebget = config.getBoolean("Commands.Webget.Allow", true);
        cache_allowFilecopy = config.getBoolean("Commands.Filecopy.Allow copying files", true);
        cache_allowDelete = config.getBoolean("Commands.Delete.Allow file deletion", true);
        cache_allowServerStop = config.getBoolean("Commands.Restart.Allow server stop", false);
        cache_allowServerRestart = config.getBoolean("Commands.Restart.Allow server restart", true);
        cache_allowLogging = config.getBoolean("Commands.Log.Allow logging", true);
        cache_allowStrangeYAMLSaves = config.getBoolean("Commands.Yaml.Allow saving outside folder", false);
        cache_limitPath = config.getString("Commands.Yaml.Limit path", "none");
        cache_chatMultipleTargetsFormat = config.getString("Commands.Chat.Options.Multiple targets format", "%target%, %target%, %target%, and others");
        cache_chatBystandersRange = config.getDouble("Commands.Chat.Options.Range for bystanders", 5.0);
        cache_chatNoTargetFormat = config.getString("Commands.Chat.Formats.No target", "[<[talker].name>]: <[message]>");
        cache_chatToTargetFormat = config.getString("Commands.Chat.Formats.To target", "[<[talker].name>] -> You: <[message]>");
        cache_chatWithTargetToBystandersFormat = config.getString("Commands.Chat.Formats.With target to bystanders", "[<[talker].name>] -> <[target].name>: <[message]>");
        cache_chatWithTargetsToBystandersFormat = config.getString("Commands.Chat.Formats.With targets to bystanders", "[<[talker].name>] -> [<[targets]>]: <[message]>");
        cache_chatAsynchronous = config.getBoolean("Triggers.Chat.Use asynchronous event", false);
        cache_chatToNpcFormat = config.getString("Triggers.Chat.Formats.Player to NPC", "You -> <npc.nickname>: <text>");
        cache_chatToNpcOverheardFormat = config.getString("Triggers.Chat.Formats.Player to NPC overheard", "<player.name> -> <npc.nickname>: <text>");
        cache_chatToNpcOverhearingRange = config.getDouble("Triggers.Chat.Overhearing range", 4.0);
        cache_chatMustSeeNPC = config.getBoolean("Triggers.Chat.Prerequisites.Must be able to see NPC", true);
        cache_chatMustLookAtNPC = config.getBoolean("Triggers.Chat.Prerequisites.Must be looking in direction of NPC", true);
        cache_chatGloballyIfFailedChatTriggers = config.getBoolean("Triggers.Chat.Appears globally.If triggers failed", false);
        cache_chatGloballyIfNoChatTriggers = config.getBoolean("Triggers.Chat.Appears globally.If triggers missing", true);
        cache_chatGloballyIfUninteractable = config.getBoolean("Triggers.Chat.Appears globally.If NPC uninteractable", true);
        cache_worldScriptChatEventAsynchronous = config.getBoolean("Scripts.World.Events.On player chats.Use asynchronous event", false);
        cache_worldScriptTimeEventFrequency = DurationTag.valueOf(config.getString("Scripts.World.Events.On time changes.Frequency of check", "250t"), CoreUtilities.basicContext);
        cache_blockTagsMaxBlocks = config.getInt("Tags.Block tags.Max blocks", 1000000);
        cache_chatHistoryMaxMessages = config.getInt("Tags.Chat history.Max messages", 10);
        cache_tagTimeout = config.getInt("Tags.Timeout", 10);
        cache_tagTimeoutSilent = config.getBoolean("Tags.Timeout when silent", false);
        cache_tagTimeoutUnsafe = config.getBoolean("Tags.Timeout when unsafe", false);
        cache_warningRate = config.getLong("Tags.Warning rate", 10000L);
        cache_packetInterception = config.getBoolean("Packets.Interception", true);
        PlayerFlagHandler.cacheTimeoutSeconds = config.getLong("Saves.Offline player cache timeout", 300L);
        PlayerFlagHandler.asyncPreload = config.getBoolean("Saves.Load async on login", true);
        MapTagBasedFlagTracker.skipAllCleanings = config.getBoolean("Saves.Skip flag cleaning", false);
        RemoveCommand.alwaysWarnOnMassRemove = config.getBoolean("Commands.Remove.Always warn on mass delete", false);
    }

    public static boolean useDefaultScriptPath() {
        return cache_useDefaultScriptPath;
    }

    public static String getAlternateScriptPath() {
        return cache_getAlternateScriptPath;
    }

    public static String scriptEncoding() {
        return cache_scriptEncoding;
    }

    public static boolean showDebug() {
        return cache_showDebug;
    }

    public static boolean overrideHelp() {
        return cache_overrideHelp;
    }

    public static int consoleWidth() {
        return cache_consoleWidth;
    }

    public static int trimLength() {
        return cache_trimLength;
    }

    public static boolean showExHelp() {
        return cache_showExHelp;
    }

    public static boolean showExDebug() {
        return cache_showExDebug;
    }

    public static boolean allowConsoleRedirection() {
        return cache_allowConsoleRedirection;
    }

    public static boolean canRecordStats() {
        return cache_canRecordStats;
    }

    public static boolean defaultDebugMode() {
        return cache_defaultDebugMode;
    }

    public static int debugLimitPerTick() {
        return cache_debugLimitPerTick;
    }

    public static String debugPrefix() {
        return cache_debugPrefix;
    }

    public static String scriptQueueSpeed() {
        return cache_scriptQueueSpeed;
    }

    public static String interactQueueSpeed() {
        return cache_interactQueueSpeed;
    }

    public static boolean healthTraitEnabledByDefault() {
        return cache_healthTraitEnabledByDefault;
    }

    public static boolean healthTraitBlockDrops() {
        return cache_healthTraitBlockDrops;
    }

    public static boolean healthTraitRespawnEnabled() {
        return cache_healthTraitRespawnEnabled;
    }

    public static boolean healthTraitAnimatedDeathEnabled() {
        return cache_healthTraitAnimatedDeathEnabled;
    }

    public static String healthTraitRespawnDelay() {
        return cache_healthTraitRespawnDelay;
    }

    public static boolean triggerEnabled(String triggerName) {
        return Denizen.getInstance().getConfig().getBoolean("Triggers." + String.valueOf(triggerName.charAt(0)).toUpperCase() + CoreUtilities.toLowerCase(triggerName.substring(1)) + ".Enabled", true);
    }

    public static double triggerDefaultCooldown(String triggerName) {
        return DurationTag.valueOf(Denizen.getInstance().getConfig().getString("Triggers." + String.valueOf(triggerName.charAt(0)).toUpperCase() + CoreUtilities.toLowerCase(triggerName.substring(1)) + ".Cooldown", "5s"), CoreUtilities.basicContext).getSeconds();
    }

    public static double triggerDefaultRange(String triggerName) {
        return Denizen.getInstance().getConfig().getDouble("Triggers." + String.valueOf(triggerName.charAt(0)).toUpperCase() + CoreUtilities.toLowerCase(triggerName.substring(1)) + ".Range", -1.0);
    }

    public static String triggerDefaultCooldownType(String triggerName) {
        return Denizen.getInstance().getConfig().getString("Triggers." + String.valueOf(triggerName.charAt(0)).toUpperCase() + CoreUtilities.toLowerCase(triggerName.substring(1)) + ".Cooldown Type", "Player");
    }

    public static String engageTimeoutInSeconds() {
        return cache_engageTimeoutInSeconds;
    }

    public static int whileMaxLoops() {
        return cache_whileMaxLoops;
    }

    public static boolean allowWebget() {
        return cache_allowWebget;
    }

    public static boolean allowStupids() {
        return Settings.allowStupid1() && Settings.allowStupid2() && Settings.allowStupid3();
    }

    public static boolean allowStupid1() {
        return Denizen.getInstance().getConfig().getBoolean("Commands.General.Allow unrestricted file access", false);
    }

    public static boolean allowStupid2() {
        return Denizen.getInstance().getConfig().getBoolean("Commands.General.Confirm allowing unrestricted file access", false);
    }

    public static boolean allowStupid3() {
        return Denizen.getInstance().getConfig().getBoolean("Commands.General.Unrestricted file access is very bad and dangerous are you sure you want that", false);
    }

    public static boolean allowStupidx() {
        return Denizen.getInstance().getConfig().getBoolean("Commands.General.Don't change this unrestricted file access option though", false);
    }

    public static boolean allowFilecopy() {
        return cache_allowFilecopy;
    }

    public static boolean allowDelete() {
        return cache_allowDelete;
    }

    public static boolean allowServerStop() {
        return cache_allowServerStop;
    }

    public static boolean allowServerRestart() {
        return cache_allowServerRestart;
    }

    public static boolean allowLogging() {
        return cache_allowLogging;
    }

    public static boolean allowStrangeYAMLSaves() {
        return cache_allowStrangeYAMLSaves;
    }

    public static String fileLimitPath() {
        return cache_limitPath;
    }

    public static String chatMultipleTargetsFormat() {
        return cache_chatMultipleTargetsFormat;
    }

    public static double chatBystandersRange() {
        return cache_chatBystandersRange;
    }

    public static String chatNoTargetFormat() {
        return cache_chatNoTargetFormat;
    }

    public static String chatToTargetFormat() {
        return cache_chatToTargetFormat;
    }

    public static String chatWithTargetToBystandersFormat() {
        return cache_chatWithTargetToBystandersFormat;
    }

    public static String chatWithTargetsToBystandersFormat() {
        return cache_chatWithTargetsToBystandersFormat;
    }

    public static boolean chatAsynchronous() {
        return cache_chatAsynchronous;
    }

    public static String chatToNpcFormat() {
        return cache_chatToNpcFormat;
    }

    public static String chatToNpcOverheardFormat() {
        return cache_chatToNpcOverheardFormat;
    }

    public static double chatToNpcOverhearingRange() {
        return cache_chatToNpcOverhearingRange;
    }

    public static boolean chatMustSeeNPC() {
        return cache_chatMustSeeNPC;
    }

    public static boolean chatMustLookAtNPC() {
        return cache_chatMustLookAtNPC;
    }

    public static boolean chatGloballyIfFailedChatTriggers() {
        return cache_chatGloballyIfFailedChatTriggers;
    }

    public static boolean chatGloballyIfNoChatTriggers() {
        return cache_chatGloballyIfNoChatTriggers;
    }

    public static boolean chatGloballyIfUninteractable() {
        return cache_chatGloballyIfUninteractable;
    }

    public static boolean worldScriptChatEventAsynchronous() {
        return cache_worldScriptChatEventAsynchronous;
    }

    public static DurationTag worldScriptTimeEventFrequency() {
        return cache_worldScriptTimeEventFrequency;
    }

    public static int blockTagsMaxBlocks() {
        return cache_blockTagsMaxBlocks;
    }

    public static int chatHistoryMaxMessages() {
        return cache_chatHistoryMaxMessages;
    }

    public static int tagTimeout() {
        return cache_tagTimeout;
    }

    public static boolean tagTimeoutSilent() {
        return cache_tagTimeoutSilent;
    }

    public static boolean tagTimeoutUnsafe() {
        return cache_tagTimeoutUnsafe;
    }

    public static long warningRate() {
        return cache_warningRate;
    }

    public static boolean packetInterception() {
        return cache_packetInterception;
    }

    static {
        cache_consoleWidth = 128;
        cache_trimLength = 1024;
    }
}

