/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.world;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.SpawnChangeEvent;

public class SpawnChangeScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static SpawnChangeScriptEvent instance;
    public SpawnChangeEvent event;

    public SpawnChangeScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("spawn changes");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (path.switches.containsKey("world") && !this.tryWorld(new WorldTag(this.event.getWorld()), path.switches.get("world"))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "SpawnChange";
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("world")) {
            return new WorldTag(this.event.getWorld());
        }
        if (name.equals("old_location")) {
            return new LocationTag(this.event.getPreviousLocation());
        }
        if (name.equals("new_location")) {
            return new LocationTag(this.event.getWorld().getSpawnLocation());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onSpawnChange(SpawnChangeEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

