/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptBuilder;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.scripts.commands.Holdable;
import net.aufdemrand.denizencore.scripts.commands.core.DetermineCommand;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizencore.scripts.queues.core.TimedQueue;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;

public class RunCommand
extends AbstractCommand
implements Holdable {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matchesPrefix("i", "id")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            if (arg.matchesPrefix("a", "as") && arg.matchesArgumentType(dPlayer.class)) {
                ((BukkitScriptEntryData)scriptEntry.entryData).setPlayer(arg.asType(dPlayer.class));
                dB.echoError(scriptEntry.getResidingQueue(), "Run as:<player> is outdated, use player:<player>");
                continue;
            }
            if (arg.matchesPrefix("a", "as") && arg.matchesArgumentType(dNPC.class)) {
                ((BukkitScriptEntryData)scriptEntry.entryData).setNPC(arg.asType(dNPC.class));
                dB.echoError(scriptEntry.getResidingQueue(), "Run as:<npc> is outdated, use npc:<npc>");
                continue;
            }
            if (arg.matchesPrefix("a", "as")) {
                dB.echoError(scriptEntry.getResidingQueue(), "Specified target was not attached. Value must contain a valid PLAYER or NPC object.");
                continue;
            }
            if (arg.matchesPrefix("d", "def", "define", "c", "context")) {
                scriptEntry.addObject("definitions", arg.asElement());
                continue;
            }
            if (arg.matches("instant", "instantly")) {
                scriptEntry.addObject("instant", new Element(true));
                continue;
            }
            if (arg.matchesPrefix("delay") && arg.matchesArgumentType(Duration.class)) {
                scriptEntry.addObject("delay", arg.asType(Duration.class));
                continue;
            }
            if (arg.matches("local", "locally")) {
                scriptEntry.addObject("local", new Element("true"));
                scriptEntry.addObject("script", scriptEntry.getScript());
                continue;
            }
            if (!scriptEntry.hasObject("script") && arg.matchesArgumentType(dScript.class) && !arg.matchesPrefix("p", "path")) {
                scriptEntry.addObject("script", arg.asType(dScript.class));
                continue;
            }
            if (!scriptEntry.hasObject("speed") && arg.matchesPrefix("speed") && arg.matchesArgumentType(Duration.class)) {
                scriptEntry.addObject("speed", arg.asType(Duration.class));
                continue;
            }
            if (!scriptEntry.hasObject("path")) {
                scriptEntry.addObject("path", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("script") && !scriptEntry.hasObject("local")) {
            throw new InvalidArgumentsException("Must define a SCRIPT to be run.");
        }
        if (!scriptEntry.hasObject("path") && scriptEntry.hasObject("local")) {
            throw new InvalidArgumentsException("Must specify a PATH.");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        ScriptQueue queue;
        String id;
        List<ScriptEntry> entries;
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), (scriptEntry.hasObject("script") ? scriptEntry.getdObject("script").debug() : scriptEntry.getScript().debug()) + (scriptEntry.hasObject("instant") ? scriptEntry.getdObject("instant").debug() : "") + (scriptEntry.hasObject("path") ? scriptEntry.getElement("path").debug() : "") + (scriptEntry.hasObject("local") ? scriptEntry.getElement("local").debug() : "") + (scriptEntry.hasObject("delay") ? scriptEntry.getdObject("delay").debug() : "") + (scriptEntry.hasObject("id") ? scriptEntry.getdObject("id").debug() : "") + (scriptEntry.hasObject("definitions") ? scriptEntry.getdObject("definitions").debug() : "") + (scriptEntry.hasObject("speed") ? scriptEntry.getdObject("speed").debug() : ""));
        }
        dScript script = (dScript)scriptEntry.getdObject("script");
        if (scriptEntry.hasObject("local")) {
            entries = scriptEntry.getScript().getContainer().getEntries(scriptEntry.entryData.clone(), scriptEntry.getElement("path").asString());
            script = scriptEntry.getScript();
        } else {
            entries = scriptEntry.hasObject("path") && scriptEntry.getObject("path") != null ? script.getContainer().getEntries(scriptEntry.entryData.clone(), scriptEntry.getElement("path").asString()) : script.getContainer().getBaseEntries(scriptEntry.entryData.clone());
        }
        if (entries == null) {
            dB.echoError(scriptEntry.getResidingQueue(), "Script run failed (invalid path or script name)!");
            return;
        }
        String string = id = scriptEntry.hasObject("id") ? scriptEntry.getElement("id").asString() : ScriptQueue.getNextId(script.getContainer().getName());
        if (scriptEntry.hasObject("instant")) {
            queue = InstantQueue.getQueue(id).addEntries(entries);
        } else if (scriptEntry.hasObject("speed")) {
            Duration speed = (Duration)scriptEntry.getdObject("speed");
            queue = ((TimedQueue)TimedQueue.getQueue(id).addEntries(entries)).setSpeed(speed.getTicks());
        } else {
            long ticks;
            queue = script != null && script.getContainer().contains("SPEED") ? ((ticks = Duration.valueOf(script.getContainer().getString("SPEED", "0")).getTicks()) > 0L ? ((TimedQueue)TimedQueue.getQueue(id).addEntries(entries)).setSpeed(ticks) : InstantQueue.getQueue(id).addEntries(entries)) : TimedQueue.getQueue(id).addEntries(entries);
        }
        if (scriptEntry.hasObject("delay")) {
            queue.delayUntil(DenizenCore.serverTimeMillis + ((Duration)scriptEntry.getObject("delay")).getMillis());
        }
        if (scriptEntry.hasObject("definitions")) {
            int x = 1;
            Element raw_defintions = scriptEntry.getElement("definitions");
            dList definitions = dList.valueOf(raw_defintions.asString());
            String[] definition_names = null;
            try {
                String str;
                if (script != null && script.getContainer() != null && (str = script.getContainer().getString("definitions")) != null) {
                    definition_names = str.split("\\|");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (String definition : definitions) {
                String name = definition_names != null && definition_names.length >= x ? definition_names[x - 1].trim() : String.valueOf(x);
                queue.addDefinition(name, definition);
                dB.echoDebug((Debuggable)scriptEntry, "Adding definition %" + name + "% as " + definition);
                ++x;
            }
            queue.addDefinition("raw_context", raw_defintions.asString());
        }
        if (scriptEntry.shouldWaitFor()) {
            final ScriptEntry se = scriptEntry;
            queue.callBack(new Runnable(){

                @Override
                public void run() {
                    se.setFinished(true);
                }
            });
        }
        long reqId = DetermineCommand.getNewId();
        queue.setReqId(reqId);
        ScriptBuilder.addObjectToEntries(entries, "reqid", reqId);
        scriptEntry.addObject("created_queue", queue);
        queue.start();
    }
}

