/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.plugin.Plugin;

public class EntityBreedScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityBreedScriptEvent instance;
    private dEntity entity;
    private dEntity breeder;
    private dEntity father;
    private dEntity mother;
    private dItem item;
    private int experience;
    public EntityBreedEvent event;

    public EntityBreedScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.getXthArg(1, CoreUtilities.toLowerCase(s)).equals("breeds");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        if (!this.tryEntity(this.entity, CoreUtilities.getXthArg(0, lower))) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.entity.getLocation());
    }

    @Override
    public String getName() {
        return "EntityBreeds";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        EntityBreedEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (aH.matchesInteger(determination)) {
            this.experience = aH.getIntegerFrom(determination);
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(null, null);
    }

    @Override
    public dObject getContext(String name) {
        switch (name) {
            case "child": {
                return this.entity;
            }
            case "breeder": {
                return this.breeder;
            }
            case "father": {
                return this.father;
            }
            case "mother": {
                return this.mother;
            }
            case "item": {
                return this.item;
            }
            case "experience": {
                return new Element(this.experience);
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityBreeds(EntityBreedEvent event) {
        LivingEntity entity = event.getEntity();
        this.entity = new dEntity((Entity)entity);
        this.breeder = new dEntity((Entity)event.getBreeder());
        this.father = new dEntity((Entity)event.getFather());
        this.mother = new dEntity((Entity)event.getMother());
        this.item = new dItem(event.getBredWith());
        this.experience = event.getExperience();
        boolean wasCancelled = this.cancelled = event.isCancelled();
        this.event = event;
        dEntity.rememberEntity((Entity)entity);
        this.fire();
        dEntity.forgetEntity((Entity)entity);
        event.setCancelled(this.cancelled);
        event.setExperience(this.experience);
        if (this.cancelled && !wasCancelled) {
            NMSHandler.getInstance().getEntityHelper().setBreeding((Animals)this.father.getLivingEntity(), false);
            NMSHandler.getInstance().getEntityHelper().setBreeding((Animals)this.mother.getLivingEntity(), false);
        }
    }
}

