/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerEggThrowEvent;
import org.bukkit.plugin.Plugin;

public class PlayerThrowsEggScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerThrowsEggScriptEvent instance;
    public dEntity egg;
    public Boolean is_hatching;
    private EntityType type;
    public PlayerEggThrowEvent event;

    public PlayerThrowsEggScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("player throws") && lower.contains("egg");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        if (CoreUtilities.getXthArg(2, lower).equals("hatching") && !this.is_hatching.booleanValue()) {
            return false;
        }
        if (CoreUtilities.getXthArg(2, lower).equals("non-hatching") && this.is_hatching.booleanValue()) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.egg.getLocation());
    }

    @Override
    public String getName() {
        return "PlayerThrowsEgg";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        PlayerEggThrowEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        String lower = CoreUtilities.toLowerCase(determination);
        if (dEntity.matches(lower)) {
            this.is_hatching = true;
            this.type = dEntity.valueOf(determination).getBukkitEntityType();
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(new dPlayer(this.event.getPlayer()), null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("is_hatching")) {
            return new Element(this.is_hatching);
        }
        if (name.equals("egg")) {
            return this.egg;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerThrowsEgg(PlayerEggThrowEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        dB.log("Is this even firing?");
        this.is_hatching = event.isHatching();
        Egg eggEntity = event.getEgg();
        dEntity.rememberEntity((Entity)eggEntity);
        this.egg = new dEntity((Entity)event.getEgg());
        this.type = event.getHatchingType();
        this.event = event;
        this.cancelled = false;
        this.fire();
        if (this.cancelled) {
            this.is_hatching = false;
        }
        dEntity.forgetEntity((Entity)eggEntity);
        event.setHatching(this.is_hatching.booleanValue());
        event.setHatchingType(this.type);
    }
}

