/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.HoverFormatHelper;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.KeybindComponent;
import net.md_5.bungee.api.chat.ScoreComponent;
import net.md_5.bungee.api.chat.SelectorComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;

public class FormattedTextHelper {
    public static final String RESET = ChatColor.RESET.toString();
    public static AsciiMatcher allowedCharCodes = new AsciiMatcher("0123456789abcdefABCDEFklmnorxKLMNORX[");
    public static AsciiMatcher hexMatcher = new AsciiMatcher("0123456789abcdefABCDEF");
    public static AsciiMatcher colorCodesOrReset = new AsciiMatcher("0123456789abcdefABCDEFrR");
    public static AsciiMatcher colorCodeInvalidator = new AsciiMatcher("0123456789abcdefABCDEFrRxX");

    public static String escape(String input) {
        return input.replace("&", "&amp").replace(";", "&sc").replace("[", "&lb").replace("]", "&rb").replace(String.valueOf('\u00a7'), "&ss");
    }

    public static String unescape(String input) {
        return input.replace("&sc", ";").replace("&lb", "[").replace("&rb", "]").replace("&ss", String.valueOf('\u00a7')).replace("&amp", "&");
    }

    public static boolean hasRootFormat(BaseComponent component) {
        if (component.hasFormatting()) {
            return true;
        }
        if (!(component instanceof TextComponent)) {
            return false;
        }
        if (!((TextComponent)component).getText().isEmpty()) {
            return false;
        }
        List extra = component.getExtra();
        if (extra == null || extra.isEmpty()) {
            return false;
        }
        return FormattedTextHelper.hasRootFormat((BaseComponent)extra.get(0));
    }

    public static String stringify(BaseComponent[] components, ChatColor baseColor) {
        if (components.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(128 * components.length);
        if (FormattedTextHelper.hasRootFormat(components[0])) {
            builder.append(RESET);
        }
        for (BaseComponent component : components) {
            builder.append(FormattedTextHelper.stringify(component));
        }
        while (builder.toString().endsWith(RESET)) {
            builder.setLength(builder.length() - RESET.length());
        }
        return builder.toString();
    }

    public static boolean boolNotNull(Boolean bool) {
        return bool != null && bool != false;
    }

    public static String stringifyRGBSpigot(String hex) {
        while (hex.length() < 6) {
            hex = "0" + hex;
        }
        hex = "x" + hex;
        StringBuilder outColor = new StringBuilder();
        for (char c : hex.toCharArray()) {
            outColor.append('\u00a7').append(c);
        }
        return outColor.toString();
    }

    public static String stringify(BaseComponent component) {
        boolean hasClick;
        boolean hasHover;
        boolean hasInsertion;
        StringBuilder builder = new StringBuilder(128);
        ChatColor color = component.getColorRaw();
        if (color != null) {
            builder.append(color.toString());
        }
        if (FormattedTextHelper.boolNotNull(component.isBoldRaw())) {
            builder.append(ChatColor.BOLD.toString());
        }
        if (FormattedTextHelper.boolNotNull(component.isItalicRaw())) {
            builder.append(ChatColor.ITALIC.toString());
        }
        if (FormattedTextHelper.boolNotNull(component.isStrikethroughRaw())) {
            builder.append(ChatColor.STRIKETHROUGH.toString());
        }
        if (FormattedTextHelper.boolNotNull(component.isUnderlinedRaw())) {
            builder.append(ChatColor.UNDERLINE.toString());
        }
        if (FormattedTextHelper.boolNotNull(component.isObfuscatedRaw())) {
            builder.append(ChatColor.MAGIC.toString());
        }
        boolean bl = hasInsertion = component.getInsertion() != null;
        if (hasInsertion) {
            builder.append('\u00a7').append("[insertion=").append(FormattedTextHelper.escape(component.getInsertion())).append("]");
        }
        boolean bl2 = hasHover = component.getHoverEvent() != null;
        if (hasHover) {
            HoverEvent hover = component.getHoverEvent();
            builder.append('\u00a7').append("[hover=").append(hover.getAction().name()).append(";").append(FormattedTextHelper.escape(NMSHandler.getInstance().stringForHover(hover))).append("]");
        }
        boolean bl3 = hasClick = component.getClickEvent() != null;
        if (hasClick) {
            ClickEvent click = component.getClickEvent();
            builder.append('\u00a7').append("[click=").append(click.getAction().name()).append(";").append(FormattedTextHelper.escape(click.getValue())).append("]");
        }
        if (component instanceof TextComponent) {
            builder.append(((TextComponent)component).getText());
        } else if (component instanceof TranslatableComponent) {
            builder.append('\u00a7').append("[translate=").append(FormattedTextHelper.escape(((TranslatableComponent)component).getTranslate()));
            List with = ((TranslatableComponent)component).getWith();
            if (with != null) {
                for (BaseComponent withComponent : with) {
                    builder.append(";").append(FormattedTextHelper.escape(FormattedTextHelper.stringify(withComponent)));
                }
            }
            builder.append("]");
        } else if (component instanceof SelectorComponent) {
            builder.append('\u00a7').append("[selector=").append(FormattedTextHelper.escape(((SelectorComponent)component).getSelector())).append("]");
        } else if (component instanceof KeybindComponent) {
            builder.append('\u00a7').append("[keybind=").append(FormattedTextHelper.escape(((KeybindComponent)component).getKeybind())).append("]");
        } else if (component instanceof ScoreComponent) {
            builder.append('\u00a7').append("[score=").append(FormattedTextHelper.escape(((ScoreComponent)component).getName())).append(";").append(FormattedTextHelper.escape(((ScoreComponent)component).getObjective())).append(";").append(FormattedTextHelper.escape(((ScoreComponent)component).getValue())).append("]");
        }
        List after = component.getExtra();
        if (after != null) {
            for (BaseComponent afterComponent : after) {
                builder.append(FormattedTextHelper.stringify(afterComponent));
            }
        }
        if (hasClick) {
            builder.append("\u00a7[/click]");
        }
        if (hasHover) {
            builder.append("\u00a7[/hover]");
        }
        if (hasInsertion) {
            builder.append("\u00a7[/insertion]");
        }
        builder.append(RESET);
        String output = builder.toString();
        return FormattedTextHelper.cleanRedundantCodes(output);
    }

    public static TextComponent copyFormatToNewText(TextComponent last) {
        TextComponent toRet = new TextComponent();
        toRet.setObfuscated(last.isObfuscatedRaw());
        toRet.setBold(last.isBoldRaw());
        toRet.setStrikethrough(last.isStrikethroughRaw());
        toRet.setUnderlined(last.isUnderlinedRaw());
        toRet.setItalic(last.isItalicRaw());
        toRet.setColor(last.getColorRaw());
        return toRet;
    }

    public static BaseComponent[] parse(String str, ChatColor baseColor) {
        return FormattedTextHelper.parse(str, baseColor, true);
    }

    public static int findEndIndexFor(String base, String type, int startAt) {
        int layers = 1;
        int next;
        while ((next = base.indexOf(167, startAt)) != -1) {
            if (next + type.length() + 2 >= base.length()) {
                return -1;
            }
            if (base.startsWith("[" + type + "=", next + 1)) {
                ++layers;
            } else if (base.startsWith("[/" + type + "]", next + 1) && --layers == 0) {
                return next;
            }
            startAt = next + 1;
        }
        return -1;
    }

    public static String cleanRedundantCodes(String str) {
        int index = str.indexOf(167);
        if (index == -1) {
            return str;
        }
        int start = 0;
        StringBuilder output = new StringBuilder(str.length());
        while (index != -1) {
            output.append(str, start, index);
            start = index;
            if (index + 1 > str.length()) break;
            char symbol = str.charAt(index + 1);
            if (allowedCharCodes.isMatch(symbol)) {
                char nextSymbol;
                if (symbol == 'x' || symbol == 'X') {
                    index = str.indexOf(167, index + 14);
                    continue;
                }
                int nextIndex = str.indexOf(167, index + 1);
                if (colorCodesOrReset.isMatch(symbol) && nextIndex == index + 2 && nextIndex + 1 < str.length() && colorCodeInvalidator.isMatch(nextSymbol = str.charAt(nextIndex + 1))) {
                    start = index + 2;
                    index = nextIndex;
                    continue;
                }
            }
            index = str.indexOf(167, index + 1);
        }
        output.append(str, start, str.length());
        return output.toString();
    }

    public static TextComponent getCleanRef() {
        TextComponent reference = new TextComponent();
        reference.setBold(Boolean.valueOf(false));
        reference.setItalic(Boolean.valueOf(false));
        reference.setStrikethrough(Boolean.valueOf(false));
        reference.setUnderlined(Boolean.valueOf(false));
        reference.setObfuscated(Boolean.valueOf(false));
        return reference;
    }

    public static BaseComponent[] parseSimpleColorsOnly(String str) {
        TextComponent root = new TextComponent();
        int firstChar = str.indexOf(167);
        int lastStart = 0;
        if (firstChar > 0) {
            root.addExtra((BaseComponent)new TextComponent(str.substring(0, firstChar)));
            lastStart = firstChar;
        }
        TextComponent nextText = new TextComponent();
        while (firstChar != -1 && firstChar + 1 < str.length()) {
            char c = str.charAt(firstChar + 1);
            if (allowedCharCodes.isMatch(c)) {
                if (c == 'r' || c == 'R') {
                    nextText.setText(str.substring(lastStart, firstChar));
                    if (!nextText.getText().isEmpty()) {
                        root.addExtra((BaseComponent)nextText);
                    }
                    nextText = FormattedTextHelper.getCleanRef();
                    lastStart = firstChar + 2;
                } else if (c == 'X' || c == 'x' && firstChar + 13 < str.length()) {
                    StringBuilder color = new StringBuilder(12);
                    color.append("#");
                    for (int i = 1; i <= 6; ++i) {
                        if (str.charAt(firstChar + i * 2) != '\u00a7') {
                            color = null;
                            break;
                        }
                        char hexChar = str.charAt(firstChar + 1 + i * 2);
                        if (!hexMatcher.isMatch(hexChar)) {
                            color = null;
                            break;
                        }
                        color.append(hexChar);
                    }
                    if (color != null) {
                        nextText.setText(str.substring(lastStart, firstChar));
                        if (!nextText.getText().isEmpty()) {
                            root.addExtra((BaseComponent)nextText);
                        }
                        nextText = FormattedTextHelper.getCleanRef();
                        nextText.setColor(ChatColor.of((String)color.toString()));
                        lastStart = (firstChar += 12) + 2;
                    }
                } else if (colorCodesOrReset.isMatch(c)) {
                    nextText.setText(str.substring(lastStart, firstChar));
                    if (!nextText.getText().isEmpty()) {
                        root.addExtra((BaseComponent)nextText);
                    }
                    nextText = FormattedTextHelper.getCleanRef();
                    nextText.setColor(ChatColor.getByChar((char)c));
                    lastStart = firstChar + 2;
                } else {
                    nextText.setText(str.substring(lastStart, firstChar));
                    if (!nextText.getText().isEmpty()) {
                        root.addExtra((BaseComponent)nextText);
                    }
                    nextText = FormattedTextHelper.copyFormatToNewText(nextText);
                    if (c == 'k' || c == 'K') {
                        nextText.setObfuscated(Boolean.valueOf(true));
                    } else if (c == 'l' || c == 'L') {
                        nextText.setBold(Boolean.valueOf(true));
                    } else if (c == 'm' || c == 'M') {
                        nextText.setStrikethrough(Boolean.valueOf(true));
                    } else if (c == 'n' || c == 'N') {
                        nextText.setUnderlined(Boolean.valueOf(true));
                    } else if (c == 'o' || c == 'O') {
                        nextText.setItalic(Boolean.valueOf(true));
                    }
                    lastStart = firstChar + 2;
                }
            }
            firstChar = str.indexOf(167, firstChar + 1);
        }
        if (lastStart < str.length()) {
            nextText.setText(str.substring(lastStart));
            root.addExtra((BaseComponent)nextText);
        }
        return new BaseComponent[]{root};
    }

    public static BaseComponent[] parse(String str, ChatColor baseColor, boolean cleanBase) {
        int firstChar = (str = CoreUtilities.clearNBSPs(str)).indexOf(167);
        if (firstChar == -1) {
            TextComponent base = new TextComponent();
            base.addExtra((BaseComponent)new TextComponent(str));
            return new BaseComponent[]{base};
        }
        str = FormattedTextHelper.cleanRedundantCodes(str);
        if (cleanBase && str.length() < 512 && !str.contains("\u00a7[") && !str.contains("://")) {
            return FormattedTextHelper.parseSimpleColorsOnly(str);
        }
        TextComponent root = new TextComponent();
        TextComponent base = new TextComponent();
        if (cleanBase) {
            base.setBold(Boolean.valueOf(false));
            base.setItalic(Boolean.valueOf(false));
            base.setStrikethrough(Boolean.valueOf(false));
            base.setUnderlined(Boolean.valueOf(false));
            base.setObfuscated(Boolean.valueOf(false));
            base.setColor(baseColor);
            if (firstChar > 0) {
                root.addExtra((BaseComponent)new TextComponent(str.substring(0, firstChar)));
            }
        } else {
            base.setText(str.substring(0, firstChar));
        }
        root.addExtra((BaseComponent)base);
        str = str.substring(firstChar);
        char[] chars = str.toCharArray();
        int started = 0;
        TextComponent nextText = new TextComponent();
        TextComponent lastText = new TextComponent();
        for (int i = 0; i < chars.length; ++i) {
            String subStr;
            if (chars[i] == '\u00a7' && i + 1 < chars.length) {
                char code = chars[i + 1];
                if (!allowedCharCodes.isMatch(code)) continue;
                if (code == '[') {
                    int endBracket = str.indexOf(93, i + 2);
                    if (endBracket == -1) continue;
                    String innards = str.substring(i + 2, endBracket);
                    List<String> innardParts = CoreUtilities.split(innards, ';');
                    List<String> innardBase = CoreUtilities.split(innardParts.get(0), '=', 2);
                    innardParts.remove(0);
                    String innardType = CoreUtilities.toLowerCase(innardBase.get(0));
                    if (innardBase.size() == 2) {
                        BaseComponent subComponent;
                        int n;
                        nextText.setText(nextText.getText() + str.substring(started, i));
                        base.addExtra((BaseComponent)nextText);
                        TextComponent doublelasttext = lastText;
                        lastText = nextText;
                        nextText = FormattedTextHelper.copyFormatToNewText(lastText);
                        nextText.setText("");
                        if (innardType.equals("score") && innardParts.size() == 2) {
                            ScoreComponent component = new ScoreComponent(FormattedTextHelper.unescape(innardBase.get(1)), FormattedTextHelper.unescape(innardParts.get(0)), FormattedTextHelper.unescape(innardParts.get(1)));
                            lastText.addExtra((BaseComponent)component);
                        } else if (innardType.equals("keybind")) {
                            KeybindComponent component = new KeybindComponent();
                            component.setKeybind(FormattedTextHelper.unescape(innardBase.get(1)));
                            lastText.addExtra((BaseComponent)component);
                        } else if (innardType.equals("selector")) {
                            SelectorComponent component = new SelectorComponent(FormattedTextHelper.unescape(innardBase.get(1)));
                            lastText.addExtra((BaseComponent)component);
                        } else if (innardType.equals("translate")) {
                            TranslatableComponent component = new TranslatableComponent();
                            component.setTranslate(FormattedTextHelper.unescape(innardBase.get(1)));
                            for (String string : innardParts) {
                                BaseComponent[] baseComponentArray = FormattedTextHelper.parse(FormattedTextHelper.unescape(string), baseColor, false);
                                int n3 = baseComponentArray.length;
                                for (n = 0; n < n3; ++n) {
                                    subComponent = baseComponentArray[n];
                                    component.addWith(subComponent);
                                }
                            }
                            lastText.addExtra((BaseComponent)component);
                        } else if (innardType.equals("click") && innardParts.size() == 1) {
                            int endIndex = FormattedTextHelper.findEndIndexFor(str, "click", i + 5);
                            if (endIndex == -1) continue;
                            TextComponent clickableText = new TextComponent();
                            clickableText.setClickEvent(new ClickEvent(ClickEvent.Action.valueOf((String)innardBase.get(1).toUpperCase()), FormattedTextHelper.unescape(innardParts.get(0))));
                            for (BaseComponent subComponent2 : FormattedTextHelper.parse(str.substring(endBracket + 1, endIndex), baseColor, false)) {
                                clickableText.addExtra(subComponent2);
                            }
                            lastText.addExtra((BaseComponent)clickableText);
                            endBracket = endIndex + "&[/click".length();
                        } else if (innardType.equals("hover")) {
                            int endIndex = FormattedTextHelper.findEndIndexFor(str, "hover", i + 5);
                            if (endIndex == -1) continue;
                            TextComponent hoverableText = new TextComponent();
                            HoverEvent.Action action = HoverEvent.Action.valueOf((String)innardBase.get(1).toUpperCase());
                            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_16)) {
                                if (HoverFormatHelper.processHoverInput(action, hoverableText, innardParts.get(0))) {
                                    continue;
                                }
                            } else {
                                BaseComponent[] hoverValue;
                                if (action == HoverEvent.Action.SHOW_ITEM) {
                                    ItemTag item = ItemTag.valueOf(FormattedTextHelper.unescape(innardParts.get(0)), CoreUtilities.noDebugContext);
                                    if (item == null) continue;
                                    hoverValue = new BaseComponent[]{new TextComponent(NMSHandler.getItemHelper().getRawHoverText(item.getItemStack()))};
                                } else if (action == HoverEvent.Action.SHOW_ENTITY) {
                                    EntityTag entity = EntityTag.valueOf(FormattedTextHelper.unescape(innardParts.get(0)), CoreUtilities.basicContext);
                                    if (entity == null) continue;
                                    hoverValue = new BaseComponent[]{new TextComponent(NMSHandler.getEntityHelper().getRawHoverText(entity.getBukkitEntity()))};
                                } else {
                                    hoverValue = FormattedTextHelper.parse(FormattedTextHelper.unescape(innardParts.get(0)), baseColor, false);
                                }
                                hoverableText.setHoverEvent(new HoverEvent(action, hoverValue));
                            }
                            BaseComponent[] baseComponentArray = FormattedTextHelper.parse(str.substring(endBracket + 1, endIndex), baseColor, false);
                            int n2 = baseComponentArray.length;
                            for (n = 0; n < n2; ++n) {
                                subComponent = baseComponentArray[n];
                                hoverableText.addExtra(subComponent);
                            }
                            lastText.addExtra((BaseComponent)hoverableText);
                            endBracket = endIndex + "&[/hover".length();
                        } else if (innardType.equals("insertion")) {
                            int endIndex = str.indexOf("\u00a7[/insertion]", i);
                            int backupEndIndex = str.indexOf("\u00a7[insertion=", i + 5);
                            if (backupEndIndex > 0 && backupEndIndex < endIndex) {
                                endIndex = backupEndIndex;
                            }
                            if (endIndex == -1) continue;
                            TextComponent textComponent = new TextComponent();
                            textComponent.setInsertion(FormattedTextHelper.unescape(innardBase.get(1)));
                            BaseComponent[] baseComponentArray = FormattedTextHelper.parse(str.substring(endBracket + 1, endIndex), baseColor, false);
                            int n3 = baseComponentArray.length;
                            for (n = 0; n < n3; ++n) {
                                subComponent = baseComponentArray[n];
                                textComponent.addExtra(subComponent);
                            }
                            lastText.addExtra((BaseComponent)textComponent);
                            endBracket = endIndex + "&[/insertion".length();
                        } else if (innardType.equals("reset")) {
                            if (innardBase.get(1).length() == 1) {
                                char subCode = innardBase.get(1).charAt(0);
                                if (subCode == 'k' || subCode == 'K') {
                                    nextText.setObfuscated(Boolean.valueOf(false));
                                } else if (subCode == 'l' || subCode == 'L') {
                                    nextText.setBold(Boolean.valueOf(false));
                                } else if (subCode == 'm' || subCode == 'M') {
                                    nextText.setStrikethrough(Boolean.valueOf(false));
                                } else if (subCode == 'n' || subCode == 'N') {
                                    nextText.setUnderlined(Boolean.valueOf(false));
                                } else if (subCode == 'o' || subCode == 'O') {
                                    nextText.setItalic(Boolean.valueOf(false));
                                }
                            } else if (innardBase.get(1).equals("font")) {
                                nextText.setFont(doublelasttext.getFont());
                            } else {
                                nextText.setColor(doublelasttext.getColor());
                            }
                        } else if (innardType.equals("color")) {
                            String colorChar = innardBase.get(1);
                            if (colorChar.length() == 1) {
                                nextText.setColor(ChatColor.getByChar((char)colorChar.charAt(0)));
                            } else if (colorChar.length() == 7) {
                                nextText.setColor(ChatColor.of((String)colorChar));
                            }
                        } else if (innardType.equals("font")) {
                            nextText.setFont(innardBase.get(1));
                        } else if (Debug.verbose) {
                            Debug.echoError("Text parse issue: cannot interpret type '" + innardType + "' with " + innardParts.size() + " parts.");
                        }
                    }
                    i = endBracket;
                    started = endBracket + 1;
                    continue;
                }
                if (code == 'r' || code == 'R') {
                    nextText.setText(nextText.getText() + str.substring(started, i));
                    if (!nextText.getText().isEmpty()) {
                        base.addExtra((BaseComponent)nextText);
                    }
                    nextText = new TextComponent();
                    nextText.setColor(baseColor);
                } else if (colorCodesOrReset.isMatch(code)) {
                    nextText.setText(nextText.getText() + str.substring(started, i));
                    if (!nextText.getText().isEmpty()) {
                        base.addExtra((BaseComponent)nextText);
                    }
                    nextText = new TextComponent();
                    nextText.setColor(ChatColor.getByChar((char)code));
                } else {
                    if (code == 'x') {
                        if (i + 13 >= chars.length) continue;
                        StringBuilder color = new StringBuilder(12);
                        color.append("#");
                        for (int c = 1; c <= 6; ++c) {
                            if (chars[i + c * 2] != '\u00a7') {
                                color = null;
                                break;
                            }
                            char hexPart = chars[i + 1 + c * 2];
                            if (!hexMatcher.isMatch(hexPart)) {
                                color = null;
                                break;
                            }
                            color.append(hexPart);
                        }
                        if (color == null) continue;
                        nextText.setText(nextText.getText() + str.substring(started, i));
                        if (!nextText.getText().isEmpty()) {
                            base.addExtra((BaseComponent)nextText);
                        }
                        nextText = new TextComponent();
                        nextText.setColor(ChatColor.of((String)color.toString()));
                        started = (i += 13) + 1;
                        continue;
                    }
                    nextText.setText(nextText.getText() + str.substring(started, i));
                    if (!nextText.getText().isEmpty()) {
                        base.addExtra((BaseComponent)nextText);
                    }
                    nextText = FormattedTextHelper.copyFormatToNewText(nextText);
                    if (code == 'k' || code == 'K') {
                        nextText.setObfuscated(Boolean.valueOf(true));
                    } else if (code == 'l' || code == 'L') {
                        nextText.setBold(Boolean.valueOf(true));
                    } else if (code == 'm' || code == 'M') {
                        nextText.setStrikethrough(Boolean.valueOf(true));
                    } else if (code == 'n' || code == 'N') {
                        nextText.setUnderlined(Boolean.valueOf(true));
                    } else if (code == 'o' || code == 'O') {
                        nextText.setItalic(Boolean.valueOf(true));
                    }
                }
                started = ++i + 1;
                continue;
            }
            if (i + "https://a.".length() >= chars.length || chars[i] != 'h' || chars[i + 1] != 't' || chars[i + 2] != 't' || chars[i + 3] != 'p' || !(subStr = str.substring(i, i + "https://a.".length())).startsWith("https://") && !subStr.startsWith("http://")) continue;
            int nextSpace = CoreUtilities.indexOfAny(str, i, ' ', '\t', '\n');
            if (nextSpace == -1) {
                nextSpace = str.length();
            }
            String url = str.substring(i, nextSpace);
            nextText.setText(nextText.getText() + str.substring(started, i));
            base.addExtra((BaseComponent)nextText);
            lastText = nextText;
            nextText = new TextComponent(lastText);
            nextText.setText("");
            TextComponent clickableText = new TextComponent(url);
            clickableText.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
            lastText.addExtra((BaseComponent)clickableText);
            i = nextSpace;
            started = nextSpace;
        }
        nextText.setText(nextText.getText() + str.substring(started));
        if (!nextText.getText().isEmpty()) {
            base.addExtra((BaseComponent)nextText);
        }
        return new BaseComponent[]{cleanBase ? root : base};
    }
}

