/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.type.Sapling;
import org.bukkit.block.data.type.TurtleEgg;

public class MaterialAge
implements Property {
    public static final String[] handledMechs = new String[]{"age", "plant_growth"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        return material instanceof MaterialTag && ((MaterialTag)material).hasModernData() && (((MaterialTag)material).getModernData().data instanceof Ageable || ((MaterialTag)material).getModernData().data instanceof TurtleEgg || ((MaterialTag)material).getModernData().data instanceof Sapling);
    }

    public static MaterialAge getFrom(ObjectTag _material) {
        if (!MaterialAge.describes(_material)) {
            return null;
        }
        return new MaterialAge((MaterialTag)_material);
    }

    private MaterialAge(MaterialTag _material) {
        this.material = _material;
    }

    public static void registerTags() {
        PropertyParser.PropertyTag<MaterialAge> runnable = (attribute, material) -> new ElementTag(material.getMax());
        PropertyParser.registerTag("maximum_age", runnable, new String[0]);
        PropertyParser.registerTag("maximum_plant_growth", runnable, new String[0]);
        runnable = (attribute, material) -> new ElementTag(material.getCurrent());
        PropertyParser.registerTag("age", runnable, new String[0]);
        PropertyParser.registerTag("plant_growth", runnable, new String[0]);
    }

    public TurtleEgg getTurtleEgg() {
        return (TurtleEgg)this.material.getModernData().data;
    }

    public boolean isTurtleEgg() {
        return this.material.getModernData().data instanceof TurtleEgg;
    }

    public Sapling getSapling() {
        return (Sapling)this.material.getModernData().data;
    }

    public boolean isSapling() {
        return this.material.getModernData().data instanceof Sapling;
    }

    public Ageable getAgeable() {
        return (Ageable)this.material.getModernData().data;
    }

    public int getCurrent() {
        if (this.isTurtleEgg()) {
            return this.getTurtleEgg().getHatch();
        }
        if (this.isSapling()) {
            return this.getSapling().getStage();
        }
        return this.getAgeable().getAge();
    }

    public int getMax() {
        if (this.isTurtleEgg()) {
            return this.getTurtleEgg().getMaximumHatch();
        }
        if (this.isSapling()) {
            return this.getSapling().getMaximumStage();
        }
        return this.getAgeable().getMaximumAge();
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.getCurrent());
    }

    @Override
    public String getPropertyId() {
        return "age";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if ((mechanism.matches("age") || mechanism.matches("plant_growth")) && mechanism.requireInteger()) {
            int age = mechanism.getValue().asInt();
            if (age < 0 || age > this.getMax()) {
                mechanism.echoError("Age value '" + age + "' is not valid. Must be between 0 and " + this.getMax() + " for material '" + this.material.name() + "'.");
                return;
            }
            if (this.isTurtleEgg()) {
                this.getTurtleEgg().setHatch(age);
            } else if (this.isSapling()) {
                this.getSapling().setStage(age);
            } else {
                this.getAgeable().setAge(age);
            }
        }
    }
}

