/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.List;

public class InjectCommand
extends AbstractCommand {
    public InjectCommand() {
        this.setName("inject");
        this.setSyntax("inject (locally) [<script>] (path:<name>) (instantly)");
        this.setRequiredArguments(1, 4);
        this.isProcedural = true;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matches("instant", "instantly")) {
                scriptEntry.addObject("instant", new ElementTag(true));
                continue;
            }
            if (arg.matches("local", "locally")) {
                scriptEntry.addObject("local", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("script") && arg.matchesArgumentType(ScriptTag.class) && !arg.matchesPrefix("p", "path")) {
                scriptEntry.addObject("script", arg.asType(ScriptTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("path")) {
                ScriptTag script;
                int dotIndex;
                String path = arg.asElement().asString();
                if (!scriptEntry.hasObject("script") && (dotIndex = path.indexOf(46)) > 0 && (script = new ScriptTag(path.substring(0, dotIndex))).isValid()) {
                    scriptEntry.addObject("script", script);
                    path = path.substring(dotIndex + 1);
                }
                scriptEntry.addObject("path", new ElementTag(path));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("script") && !scriptEntry.hasObject("local")) {
            throw new InvalidArgumentsException("Must define a SCRIPT to be injected.");
        }
        if (scriptEntry.hasObject("local") && !scriptEntry.hasObject("path") && !scriptEntry.hasObject("script")) {
            throw new InvalidArgumentsException("Must specify a PATH.");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        List<ScriptEntry> entries;
        ScriptTag script = (ScriptTag)scriptEntry.getObjectTag("script");
        if (script == null) {
            script = scriptEntry.getScript();
        }
        ElementTag instant = scriptEntry.getElement("instant");
        ElementTag path = scriptEntry.getElement("path");
        ElementTag local = scriptEntry.getElement("local");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), script.debug() + (instant != null ? instant.debug() : "") + (path != null ? path.debug() : "") + (local != null ? local.debug() : ""));
        }
        if (local != null && local.asBoolean()) {
            String pathName = path != null ? path.asString() : script.getName();
            entries = scriptEntry.getScript().getContainer().getEntries(scriptEntry.entryData.clone(), pathName);
        } else {
            entries = path != null ? script.getContainer().getEntries(scriptEntry.entryData.clone(), path.asString()) : script.getContainer().getBaseEntries(scriptEntry.entryData.clone());
        }
        if (entries == null) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Script inject failed (invalid script path '" + path + "')!");
            return;
        }
        if (instant != null && instant.asBoolean()) {
            scriptEntry.getResidingQueue().runNow(entries);
        } else {
            scriptEntry.getResidingQueue().injectEntries(entries, 0);
        }
    }
}

