/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.events.bukkit.ScriptReloadEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptContainer;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptBuilder;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockCookEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;

public class ItemScriptHelper
implements Listener {
    public static final Map<String, ItemScriptContainer> item_scripts = new HashMap<String, ItemScriptContainer>();
    public static final Map<String, ItemScriptContainer> item_scripts_by_hash_id = new HashMap<String, ItemScriptContainer>();
    public static final Map<String, ItemScriptContainer> recipeIdToItemScript = new HashMap<String, ItemScriptContainer>();
    public static String ItemScriptHashID = ChatColor.RED.toString() + ChatColor.BLUE + ChatColor.BLACK;

    public ItemScriptHelper() {
        Denizen.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)Denizen.getInstance());
    }

    public static void removeDenizenRecipes() {
        recipeIdToItemScript.clear();
        NMSHandler.getItemHelper().clearDenizenRecipes();
    }

    public String getIdFor(ItemScriptContainer container, String type, int id) {
        String basicId = type + "_" + Utilities.cleanseNamespaceID(container.getName()) + "_" + id;
        if (!recipeIdToItemScript.containsKey(basicId)) {
            recipeIdToItemScript.put("denizen:" + basicId, container);
            return basicId;
        }
        int newNumber = 1;
        String newId = basicId + "_1";
        while (recipeIdToItemScript.containsKey(newId)) {
            newId = basicId + "_" + newNumber++;
        }
        recipeIdToItemScript.put("denizen:" + newId, container);
        return newId;
    }

    public static List<String> splitByNonBracketedSlashes(String str) {
        boolean brackets = false;
        int start = 0;
        ArrayList<String> output = new ArrayList<String>(4);
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '[') {
                brackets = true;
                continue;
            }
            if (c == ']') {
                brackets = false;
                continue;
            }
            if (c != '/' || brackets) continue;
            output.add(str.substring(start, i));
            start = i + 1;
        }
        output.add(str.substring(start));
        return output;
    }

    public ItemStack[] textToItemArray(ItemScriptContainer container, String text, boolean exact) {
        if (CoreUtilities.toLowerCase(text).equals("air")) {
            return new ItemStack[0];
        }
        List<String> ingredientText = ItemScriptHelper.splitByNonBracketedSlashes(text);
        ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>(ingredientText.size());
        for (int i = 0; i < ingredientText.size(); ++i) {
            String entry = ingredientText.get(i);
            if (ScriptEvent.isAdvancedMatchable(entry)) {
                boolean any = false;
                ScriptEvent.MatchHelper matcher = ScriptEvent.createMatcher(entry);
                for (Material material : Material.values()) {
                    if (!matcher.doesMatch(CoreUtilities.toLowerCase(material.name()))) continue;
                    outputItems.add(new ItemStack(material, 1));
                    any = true;
                }
                if (exact) {
                    for (ItemScriptContainer possibleContainer : item_scripts.values()) {
                        if (!matcher.doesMatch(CoreUtilities.toLowerCase(possibleContainer.getName()))) continue;
                        outputItems.add(possibleContainer.getCleanReference().getItemStack());
                        any = true;
                    }
                }
                if (any) continue;
                Debug.echoError("Invalid ItemTag ingredient (empty advanced matcher), recipe will not be registered for item script '" + container.getName() + "': " + entry);
                return null;
            }
            ItemTag ingredient = ItemTag.valueOf(entry, container);
            if (ingredient == null) {
                Debug.echoError("Invalid ItemTag ingredient, recipe will not be registered for item script '" + container.getName() + "': " + entry);
                return null;
            }
            outputItems.add(ingredient.getItemStack().clone());
        }
        return outputItems.toArray(new ItemStack[0]);
    }

    public void registerShapedRecipe(ItemScriptContainer container, ItemStack item, List<String> recipeList, String internalId, String group) {
        for (int n = 0; n < recipeList.size(); ++n) {
            recipeList.set(n, TagManager.tag(ScriptBuilder.stripLinePrefix(recipeList.get(n)), new BukkitTagContext(null, null, new ScriptTag(container))));
        }
        ArrayList<ItemStack[]> ingredients = new ArrayList<ItemStack[]>();
        ArrayList<Boolean> exacts = new ArrayList<Boolean>();
        int width = 1;
        for (String recipeRow : recipeList) {
            String[] elements = recipeRow.split("\\|", 3);
            if (width < 3 && elements.length == 3) {
                width = 3;
            }
            if (width < 2 && elements.length >= 2) {
                width = 2;
            }
            for (String element : elements) {
                boolean isExact;
                String itemText = element;
                boolean bl = isExact = !itemText.startsWith("material:");
                if (!isExact) {
                    itemText = itemText.substring("material:".length());
                }
                exacts.add(isExact);
                ItemStack[] items = this.textToItemArray(container, itemText, isExact);
                if (items == null) {
                    return;
                }
                ingredients.add(items);
            }
        }
        NamespacedKey key = new NamespacedKey("denizen", internalId);
        ShapedRecipe recipe = new ShapedRecipe(key, item);
        recipe.setGroup(group);
        String shape1 = "ABC".substring(0, width);
        String shape2 = "DEF".substring(0, width);
        String shape3 = "GHI".substring(0, width);
        String itemChars = shape1 + shape2 + shape3;
        recipe = recipeList.size() == 3 ? recipe.shape(new String[]{shape1, shape2, shape3}) : (recipeList.size() == 2 ? recipe.shape(new String[]{shape1, shape2}) : recipe.shape(new String[]{shape1}));
        for (int i = 0; i < ingredients.size(); ++i) {
            if (((ItemStack[])ingredients.get(i)).length == 0) continue;
            NMSHandler.getItemHelper().setShapedRecipeIngredient(recipe, itemChars.charAt(i), (ItemStack[])ingredients.get(i), (Boolean)exacts.get(i));
        }
        Bukkit.addRecipe((Recipe)recipe);
    }

    public void registerShapelessRecipe(ItemScriptContainer container, ItemStack item, String shapelessString, String internalId, String group) {
        BukkitTagContext context = new BukkitTagContext(null, null, new ScriptTag(container));
        String list = TagManager.tag(shapelessString, context);
        ArrayList<ItemStack[]> ingredients = new ArrayList<ItemStack[]>();
        ArrayList<Boolean> exacts = new ArrayList<Boolean>();
        for (String element : ListTag.valueOf(list, context)) {
            boolean isExact;
            String itemText = element;
            boolean bl = isExact = !itemText.startsWith("material:");
            if (!isExact) {
                itemText = itemText.substring("material:".length());
            }
            exacts.add(isExact);
            ItemStack[] items = this.textToItemArray(container, itemText, isExact);
            if (items == null) {
                return;
            }
            ingredients.add(items);
        }
        boolean[] bools = new boolean[exacts.size()];
        for (int i = 0; i < exacts.size(); ++i) {
            bools[i] = (Boolean)exacts.get(i);
        }
        NMSHandler.getItemHelper().registerShapelessRecipe(internalId, group, item, ingredients, bools);
    }

    public void registerFurnaceRecipe(ItemScriptContainer container, ItemStack item, String furnaceItemString, float exp, int time, String type, String internalId, String group) {
        ItemStack[] items;
        boolean exact = true;
        if (furnaceItemString.startsWith("material:")) {
            exact = false;
            furnaceItemString = furnaceItemString.substring("material:".length());
        }
        if ((items = this.textToItemArray(container, furnaceItemString, exact)) == null) {
            return;
        }
        NMSHandler.getItemHelper().registerFurnaceRecipe(internalId, group, item, items, exp, time, type, exact);
    }

    public void registerStonecuttingRecipe(ItemScriptContainer container, ItemStack item, String inputItemString, String internalId, String group) {
        ItemStack[] items;
        boolean exact = true;
        if (inputItemString.startsWith("material:")) {
            exact = false;
            inputItemString = inputItemString.substring("material:".length());
        }
        if ((items = this.textToItemArray(container, inputItemString, exact)) == null) {
            return;
        }
        NMSHandler.getItemHelper().registerStonecuttingRecipe(internalId, group, item, items, exact);
    }

    public void rebuildRecipes() {
        for (ItemScriptContainer container : item_scripts.values()) {
            try {
                if (container.contains("recipes")) {
                    YamlConfiguration section = container.getConfigurationSection("recipes");
                    int id = 0;
                    for (StringHolder key : section.getKeys(false)) {
                        YamlConfiguration subSection = section.getConfigurationSection(key.str);
                        String type = CoreUtilities.toLowerCase(subSection.getString("type"));
                        String internalId = subSection.contains("recipe_id") ? subSection.getString("recipe_id") : this.getIdFor(container, type + "_recipe", ++id);
                        String group = subSection.contains("group") ? subSection.getString("group") : "";
                        ItemStack item = container.getCleanReference().getItemStack().clone();
                        if (subSection.contains("output_quantity")) {
                            item.setAmount(Integer.parseInt(subSection.getString("output_quantity")));
                        }
                        if (type.equals("shaped")) {
                            this.registerShapedRecipe(container, item, subSection.getStringList("input"), internalId, group);
                            continue;
                        }
                        if (type.equals("shapeless")) {
                            this.registerShapelessRecipe(container, item, subSection.getString("input"), internalId, group);
                            continue;
                        }
                        if (type.equals("stonecutting")) {
                            this.registerStonecuttingRecipe(container, item, subSection.getString("input"), internalId, group);
                            continue;
                        }
                        if (!type.equals("furnace") && !type.equals("blast") && !type.equals("smoker") && !type.equals("campfire")) continue;
                        float exp = 0.0f;
                        int cookTime = 40;
                        if (subSection.contains("experience")) {
                            exp = Float.parseFloat(subSection.getString("experience"));
                        }
                        if (subSection.contains("cook_time")) {
                            cookTime = DurationTag.valueOf(subSection.getString("cook_time"), new BukkitTagContext(container)).getTicksAsInt();
                        }
                        this.registerFurnaceRecipe(container, item, subSection.getString("input"), exp, cookTime, type, internalId, group);
                    }
                }
                if (container.contains("RECIPE")) {
                    Deprecations.oldRecipeScript.warn(container);
                    this.registerShapedRecipe(container, container.getCleanReference().getItemStack().clone(), container.getStringList("RECIPE"), this.getIdFor(container, "old_recipe", 0), "custom");
                }
                if (container.contains("SHAPELESS_RECIPE")) {
                    Deprecations.oldRecipeScript.warn(container);
                    this.registerShapelessRecipe(container, container.getCleanReference().getItemStack().clone(), container.getString("SHAPELESS_RECIPE"), this.getIdFor(container, "old_shapeless", 0), "custom");
                }
                if (!container.contains("FURNACE_RECIPE")) continue;
                Deprecations.oldRecipeScript.warn(container);
                this.registerFurnaceRecipe(container, container.getCleanReference().getItemStack().clone(), container.getString("FURNACE_RECIPE"), 0.0f, 40, "furnace", this.getIdFor(container, "old_furnace", 0), "custom");
            }
            catch (Exception ex) {
                Debug.echoError("Error while rebuilding item script recipes for '" + container.getName() + "'...");
                Debug.echoError(ex);
            }
        }
    }

    @EventHandler
    public void scriptReload(ScriptReloadEvent event) {
        this.rebuildRecipes();
    }

    public static boolean isItemscript(ItemStack item) {
        return ItemScriptHelper.getItemScriptContainer(item) != null;
    }

    public static ItemScriptContainer getItemScriptContainer(ItemStack item) {
        if (item == null) {
            return null;
        }
        CompoundTag tag = NMSHandler.getItemHelper().getNbtData(item);
        String scriptName = tag.getString("DenizenItemScript");
        if (scriptName != null && !scriptName.equals("")) {
            return item_scripts.get(scriptName);
        }
        String nbt = tag.getString("Denizen Item Script");
        if (nbt != null && !nbt.equals("")) {
            return item_scripts_by_hash_id.get(nbt);
        }
        return null;
    }

    public static String createItemScriptID(ItemScriptContainer container) {
        String colors = ItemScriptHelper.createItemScriptID(container.getName());
        container.setHashID(colors);
        return colors;
    }

    public static String createItemScriptID(String name) {
        String script = name.toUpperCase();
        StringBuilder colors = new StringBuilder();
        colors.append(ItemScriptHashID);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = script.getBytes(StandardCharsets.UTF_8);
            md.update(bytes, 0, bytes.length);
            String hash = new BigInteger(1, md.digest()).toString(16);
            for (int i = 0; i < 16; ++i) {
                colors.append('\u00a7').append(hash.charAt(i));
            }
        }
        catch (Exception ex) {
            Debug.echoError(ex);
            colors.append(ChatColor.BLUE);
        }
        return colors.toString();
    }

    public static boolean isAllowedChoice(ItemScriptContainer script, RecipeChoice choice) {
        if (choice instanceof RecipeChoice.ExactChoice) {
            for (ItemStack choiceOpt : ((RecipeChoice.ExactChoice)choice).getChoices()) {
                ItemScriptContainer choiceOptContainer = ItemScriptHelper.getItemScriptContainer(choiceOpt);
                if (script != choiceOptContainer) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean shouldDenyCraft(ItemStack[] items, Recipe recipe) {
        for (int i = 0; i < items.length; ++i) {
            ItemScriptContainer container;
            ItemStack item = items[i];
            if (item == null || item.getType() == Material.AIR || (container = ItemScriptHelper.getItemScriptContainer(item)) == null || container.allowInMaterialRecipes) continue;
            boolean allowed = false;
            if (recipe instanceof ShapelessRecipe) {
                for (RecipeChoice choice : ((ShapelessRecipe)recipe).getChoiceList()) {
                    if (!ItemScriptHelper.isAllowedChoice(container, choice)) continue;
                    allowed = true;
                    break;
                }
            } else if (recipe instanceof ShapedRecipe) {
                int width = items.length == 9 ? 3 : 2;
                int x = i % width;
                int y = i / width;
                String[] shape = ((ShapedRecipe)recipe).getShape();
                if (y < shape.length && x < shape[y].length()) {
                    char c = shape[y].charAt(x);
                    RecipeChoice choice = (RecipeChoice)((ShapedRecipe)recipe).getChoiceMap().get(Character.valueOf(c));
                    if (ItemScriptHelper.isAllowedChoice(container, choice)) {
                        allowed = true;
                    }
                }
            } else {
                allowed = recipe instanceof CookingRecipe ? ItemScriptHelper.isAllowedChoice(container, ((CookingRecipe)recipe).getInputChoice()) : true;
            }
            if (allowed) continue;
            return true;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onCraftPrepared(PrepareItemCraftEvent event) {
        Recipe recipe = event.getRecipe();
        if (recipe == null) {
            return;
        }
        ItemStack[] items = event.getInventory().getMatrix();
        if (ItemScriptHelper.shouldDenyCraft(items, recipe)) {
            event.getInventory().setResult(null);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onItemCrafted(CraftItemEvent event) {
        Recipe recipe = event.getRecipe();
        ItemStack[] items = event.getInventory().getMatrix();
        if (ItemScriptHelper.shouldDenyCraft(items, recipe)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onItemCooked(BlockCookEvent event) {
        ItemScriptContainer container = ItemScriptHelper.getItemScriptContainer(event.getSource());
        if (container == null || container.allowInMaterialRecipes) {
            return;
        }
        ItemStack[] stacks = new ItemStack[]{event.getSource()};
        for (Recipe recipe : Bukkit.getRecipesFor((ItemStack)event.getResult())) {
            if (!(recipe instanceof CookingRecipe) || ItemScriptHelper.shouldDenyCraft(stacks, recipe)) continue;
            return;
        }
        event.setCancelled(true);
    }
}

