/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.flags;

import com.denizenscript.denizencore.flags.MapTagBasedFlagTracker;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.ScriptHelper;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SavableMapFlagTracker
extends MapTagBasedFlagTracker {
    public HashMap<StringHolder, SaveOptimizedFlag> map;
    public boolean modified;
    public static AsciiMatcher valueEscapeNeededMatcher = new AsciiMatcher("\u0000\n\\");
    public static AsciiMatcher keyEscapeNeededMatcher = new AsciiMatcher("\u0000:\n\\");

    public SavableMapFlagTracker() {
        this.map = new HashMap();
    }

    public SavableMapFlagTracker(String input) {
        this.map = new HashMap(input.length() / 50);
        int eol = input.indexOf(10);
        int startOfLine = 0;
        while (eol != -1) {
            int colon = input.indexOf(58, startOfLine);
            if (colon != -1) {
                String key = input.substring(startOfLine, colon);
                boolean expirable = key.startsWith("\\ex");
                if (expirable) {
                    key = key.substring("\\ex".length());
                }
                key = SavableMapFlagTracker.unescapeKey(key);
                String value = SavableMapFlagTracker.unescapeValue(input.substring(colon + 1, eol));
                SaveOptimizedFlag flag = new SaveOptimizedFlag();
                flag.canExpire = expirable;
                flag.string = value;
                this.map.put(new StringHolder(key), flag);
            }
            startOfLine = eol + 1;
            eol = input.indexOf(10, eol + 1);
        }
        this.doTotalClean();
    }

    public void doTotalClean() {
        if (MapTagBasedFlagTracker.skipAllCleanings) {
            return;
        }
        ArrayList<StringHolder> toRemove = new ArrayList<StringHolder>();
        for (Map.Entry<StringHolder, SaveOptimizedFlag> entry : this.map.entrySet()) {
            if (!entry.getValue().canExpire) continue;
            if (SavableMapFlagTracker.isExpired(entry.getValue().getMap().map.get(expirationString))) {
                toRemove.add(entry.getKey());
                this.modified = true;
                continue;
            }
            ObjectTag subValue = entry.getValue().getMap().map.get(valueString);
            if (!(subValue instanceof MapTag) || !this.doClean((MapTag)subValue)) continue;
            entry.getValue().string = null;
            this.modified = true;
        }
        for (StringHolder str : toRemove) {
            this.map.remove(str);
        }
    }

    @Override
    public MapTag getRootMap(String key) {
        SaveOptimizedFlag flag = this.map.get(new StringHolder(key));
        if (flag == null) {
            return null;
        }
        return flag.getMap();
    }

    @Override
    public void setRootMap(String key, MapTag value) {
        this.modified = true;
        if (value == null) {
            this.map.remove(new StringHolder(key));
            return;
        }
        SaveOptimizedFlag flag = new SaveOptimizedFlag();
        flag.map = value;
        flag.string = null;
        if (value.map.containsKey(expirationString) || value.map.get(valueString) instanceof MapTag) {
            flag.canExpire = true;
        }
        this.map.put(new StringHolder(key), flag);
    }

    @Override
    public Collection<String> listAllFlags() {
        ArrayList<String> keys = new ArrayList<String>(this.map.size());
        for (StringHolder string : this.map.keySet()) {
            keys.add(string.str);
        }
        return keys;
    }

    public static String unescapeValue(String key) {
        if (!CoreUtilities.contains(key, '\\')) {
            return key;
        }
        key = CoreUtilities.replace(key, "\\nl", "\n");
        key = CoreUtilities.replace(key, "\\bs", "\\");
        return key;
    }

    public static String escapeValue(String key) {
        if (!valueEscapeNeededMatcher.containsAnyMatch(key)) {
            return key;
        }
        key = CoreUtilities.replace(key, "\\", "\\bs");
        key = CoreUtilities.replace(key, "\n", "\\nl");
        key = CoreUtilities.replace(key, "\u0000", "");
        return key;
    }

    public static String unescapeKey(String key) {
        if (!CoreUtilities.contains(key, '\\')) {
            return key;
        }
        key = CoreUtilities.replace(key, "\\co", ":");
        key = CoreUtilities.replace(key, "\\nl", "\n");
        key = CoreUtilities.replace(key, "\\bs", "\\");
        return key;
    }

    public static String escapeKey(String key) {
        if (!keyEscapeNeededMatcher.containsAnyMatch(key)) {
            return key;
        }
        key = CoreUtilities.replace(key, "\\", "\\bs");
        key = CoreUtilities.replace(key, ":", "\\co");
        key = CoreUtilities.replace(key, "\n", "\\nl");
        key = CoreUtilities.replace(key, "\u0000", "");
        return key;
    }

    public String toString() {
        StringBuilder toOutput = new StringBuilder(this.map.size() * 100);
        for (Map.Entry<StringHolder, SaveOptimizedFlag> flag : this.map.entrySet()) {
            if (flag.getValue().canExpire) {
                toOutput.append("\\ex");
            }
            toOutput.append(SavableMapFlagTracker.escapeKey(flag.getKey().str)).append(":").append(SavableMapFlagTracker.escapeValue(flag.getValue().getString())).append('\n');
        }
        return toOutput.toString();
    }

    public static SavableMapFlagTracker loadFlagFile(String filePath) {
        try {
            File realPath;
            File flagFile = new File(filePath + ".dat");
            if (flagFile.exists()) {
                realPath = flagFile;
            } else {
                File bakFile = new File(filePath + ".dat~2");
                if (bakFile.exists()) {
                    realPath = bakFile;
                } else {
                    return new SavableMapFlagTracker();
                }
            }
            FileInputStream fis = new FileInputStream(realPath);
            String str = ScriptHelper.convertStreamToString(fis);
            fis.close();
            return new SavableMapFlagTracker(str);
        }
        catch (Throwable ex) {
            Debug.echoError("Failed to load flag data for path '" + filePath + "'");
            Debug.echoError(ex);
            return new SavableMapFlagTracker();
        }
    }

    public void saveToFile(String filePath) {
        SavableMapFlagTracker.saveToFile(filePath, this.toString());
    }

    public static void saveToFile(String filePath, String flagData) {
        File saveToFile = new File(filePath + ".dat~1");
        try {
            saveToFile.getParentFile().mkdirs();
            Charset charset = ScriptHelper.encoding == null ? null : ScriptHelper.encoding.charset();
            FileOutputStream fiout = new FileOutputStream(saveToFile);
            OutputStreamWriter writer = charset == null ? new OutputStreamWriter(fiout) : new OutputStreamWriter((OutputStream)fiout, charset);
            writer.write(flagData);
            writer.close();
            File bakFile = new File(filePath + ".dat~2");
            File realFile = new File(filePath + ".dat");
            if (realFile.exists()) {
                realFile.renameTo(bakFile);
            }
            saveToFile.renameTo(realFile);
            if (bakFile.exists()) {
                bakFile.delete();
            }
        }
        catch (Throwable ex) {
            Debug.echoError("Failed to save flag data to path '" + filePath + "'");
            Debug.echoError(ex);
        }
    }

    public static class SaveOptimizedFlag {
        public MapTag map;
        public String string;
        public boolean canExpire;

        public MapTag getMap() {
            if (this.map == null) {
                if (this.string.startsWith("map@")) {
                    this.map = MapTag.valueOf(this.string, CoreUtilities.errorButNoDebugContext);
                } else {
                    this.map = new MapTag();
                    this.map.map.put(MapTagBasedFlagTracker.valueString, ObjectFetcher.pickObjectFor(this.string, CoreUtilities.errorButNoDebugContext));
                }
            }
            return this.map;
        }

        public String getString() {
            if (this.string == null) {
                this.string = this.map.map.containsKey(MapTagBasedFlagTracker.expirationString) || this.map.map.get(MapTagBasedFlagTracker.valueString) instanceof MapTag ? this.map.savable() : this.map.map.get(MapTagBasedFlagTracker.valueString).savable();
            }
            return this.string;
        }
    }
}

