/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.flags.RedirectionFlagTracker;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import java.util.List;
import org.bukkit.block.Biome;
import org.bukkit.entity.EntityType;

public class BiomeTag
implements ObjectTag,
Adjustable,
FlaggableObject {
    private BiomeNMS biome;
    public Biome bukkitBiome;
    String prefix = "biome";
    public static ObjectTagProcessor<BiomeTag> tagProcessor = new ObjectTagProcessor();

    @Deprecated
    public static BiomeTag valueOf(String string) {
        return BiomeTag.valueOf(string, null);
    }

    @Fetchable(value="b")
    public static BiomeTag valueOf(String string, TagContext context) {
        if (string.startsWith("b@")) {
            string = string.substring(2);
        }
        for (Biome biome : Biome.values()) {
            if (!biome.name().equalsIgnoreCase(string)) continue;
            return new BiomeTag(biome);
        }
        return null;
    }

    public static boolean matches(String arg) {
        if (arg.startsWith("b@")) {
            arg = arg.substring(2);
        }
        for (Biome b : Biome.values()) {
            if (!b.name().equalsIgnoreCase(arg)) continue;
            return true;
        }
        return false;
    }

    public BiomeTag(Biome biome) {
        this.bukkitBiome = biome;
        this.biome = NMSHandler.getInstance().getBiomeNMS(biome);
    }

    public BiomeNMS getBiome() {
        return this.biome;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getObjectType() {
        return "Biome";
    }

    @Override
    public String identify() {
        return "b@" + CoreUtilities.toLowerCase(this.biome.getName());
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        if (prefix != null) {
            this.prefix = prefix;
        }
        return this;
    }

    @Override
    public AbstractFlagTracker getFlagTracker() {
        return new RedirectionFlagTracker(DenizenCore.getImplementation().getServerFlags(), "__biomes." + this.biome.getName().replace(".", "&dot"));
    }

    @Override
    public void reapplyTracker(AbstractFlagTracker tracker) {
    }

    public static void registerTags() {
        AbstractFlagTracker.registerFlagHandlers(tagProcessor);
        BiomeTag.registerTag("downfall_type", (attribute, object) -> new ElementTag(CoreUtilities.toLowerCase(object.biome.getDownfallType().name())), new String[0]);
        BiomeTag.registerTag("name", (attribute, object) -> new ElementTag(CoreUtilities.toLowerCase(object.biome.getName())), new String[0]);
        BiomeTag.registerTag("humidity", (attribute, object) -> new ElementTag(object.biome.getHumidity()), new String[0]);
        BiomeTag.registerTag("temperature", (attribute, object) -> new ElementTag(object.biome.getTemperature()), new String[0]);
        BiomeTag.registerTag("spawnable_entities", (attribute, object) -> {
            List<EntityType> entityTypes;
            if (attribute.startsWith("ambient", 2)) {
                Deprecations.biomeSpawnableTag.warn(attribute.context);
                attribute.fulfill(1);
                entityTypes = object.biome.getAmbientEntities();
            } else if (attribute.startsWith("creatures", 2)) {
                Deprecations.biomeSpawnableTag.warn(attribute.context);
                attribute.fulfill(1);
                entityTypes = object.biome.getCreatureEntities();
            } else if (attribute.startsWith("monsters", 2)) {
                Deprecations.biomeSpawnableTag.warn(attribute.context);
                attribute.fulfill(1);
                entityTypes = object.biome.getMonsterEntities();
            } else if (attribute.startsWith("water", 2)) {
                Deprecations.biomeSpawnableTag.warn(attribute.context);
                attribute.fulfill(1);
                entityTypes = object.biome.getWaterEntities();
            } else {
                String type;
                String string = type = attribute.hasContext(1) ? CoreUtilities.toLowerCase(attribute.getContext(1)) : "all";
                entityTypes = type.equals("ambient") ? object.biome.getAmbientEntities() : (type.equals("creatures") ? object.biome.getCreatureEntities() : (type.equals("monsters") ? object.biome.getMonsterEntities() : (type.equals("water") ? object.biome.getWaterEntities() : object.biome.getAllEntities())));
            }
            ListTag list = new ListTag();
            for (EntityType entityType : entityTypes) {
                list.add(entityType.name());
            }
            return list;
        }, new String[0]);
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<BiomeTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        Debug.echoError("Cannot apply properties to a biome!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("humidity") && mechanism.requireFloat()) {
            this.biome.setHumidity(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("temperature") && mechanism.requireFloat()) {
            this.biome.setTemperature(mechanism.getValue().asFloat());
        }
    }
}

