/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.blocks;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.blocks.ChunkCoordinate;
import com.denizenscript.denizencore.objects.core.DurationTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class FakeBlock {
    public static final Map<UUID, FakeBlockMap> blocks = new HashMap<UUID, FakeBlockMap>();
    public final PlayerTag player;
    public final LocationTag location;
    public final ChunkCoordinate chunkCoord;
    public MaterialTag material;
    public BukkitTask currentTask = null;
    public static HashMap<ChunkCoordinate, Long> lastChunkRefresh = new HashMap();

    public static FakeBlock getFakeBlockFor(UUID id, LocationTag location) {
        FakeBlockMap map = blocks.get(id);
        if (map == null) {
            return null;
        }
        return map.byLocation.get(location);
    }

    public static List<FakeBlock> getFakeBlocksFor(UUID id, ChunkCoordinate chunkCoord) {
        FakeBlockMap map = blocks.get(id);
        if (map == null) {
            return null;
        }
        return map.byChunk.get(chunkCoord);
    }

    private FakeBlock(PlayerTag player, LocationTag location) {
        this.player = player;
        this.location = location;
        this.chunkCoord = new ChunkCoordinate(location);
    }

    public static void showFakeBlockTo(List<PlayerTag> players, LocationTag location, MaterialTag material, DurationTag duration) {
        for (PlayerTag player : players) {
            if (!player.isOnline() || !player.isValid()) continue;
            UUID uuid = player.getPlayerEntity().getUniqueId();
            FakeBlockMap playerBlocks = blocks.get(uuid);
            if (playerBlocks == null) {
                playerBlocks = new FakeBlockMap();
                blocks.put(uuid, playerBlocks);
            }
            FakeBlock block = playerBlocks.getOrAdd(player, location);
            block.updateBlock(material, duration);
        }
        lastChunkRefresh.clear();
    }

    public static void stopShowingTo(List<PlayerTag> players, LocationTag location) {
        for (PlayerTag player : players) {
            FakeBlock block;
            FakeBlockMap playerBlocks = blocks.get(player.getPlayerEntity().getUniqueId());
            if (playerBlocks == null || (block = playerBlocks.byLocation.get(location)) == null) continue;
            block.cancelBlock();
        }
    }

    public void cancelBlock() {
        if (this.currentTask != null) {
            this.currentTask.cancel();
            this.currentTask = null;
        }
        this.material = null;
        if (this.player.isOnline()) {
            this.location.getBlock().getState().update();
            Long l = lastChunkRefresh.get(this.chunkCoord);
            if (l == null || l < this.location.getWorld().getFullTime()) {
                lastChunkRefresh.put(this.chunkCoord, this.location.getWorld().getFullTime());
                this.location.getWorld().refreshChunk(this.chunkCoord.x, this.chunkCoord.z);
            }
        }
        FakeBlockMap mapping = blocks.get(this.player.getUUID());
        mapping.remove(this);
        if (mapping.byChunk.isEmpty()) {
            blocks.remove(this.player.getUUID());
        }
    }

    private void updateBlock(MaterialTag material, DurationTag duration) {
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
        this.material = material;
        if (this.player.hasChunkLoaded(this.location.getChunk())) {
            material.getModernData().sendFakeChangeTo(this.player.getPlayerEntity(), this.location);
            if (material.getMaterial().name().endsWith("_BANNER")) {
                this.location.getWorld().refreshChunk(this.chunkCoord.x, this.chunkCoord.z);
            }
        }
        if (duration != null && duration.getTicks() > 0L) {
            this.currentTask = new BukkitRunnable(){

                public void run() {
                    FakeBlock.this.currentTask = null;
                    FakeBlock.this.cancelBlock();
                }
            }.runTaskLater((Plugin)Denizen.getInstance(), duration.getTicks());
        }
    }

    public static class FakeBlockMap {
        public Map<LocationTag, FakeBlock> byLocation = new HashMap<LocationTag, FakeBlock>();
        public Map<ChunkCoordinate, List<FakeBlock>> byChunk = new HashMap<ChunkCoordinate, List<FakeBlock>>();

        public FakeBlock getOrAdd(PlayerTag player, LocationTag location) {
            FakeBlock block = this.byLocation.get(location);
            if (block != null) {
                return block;
            }
            block = new FakeBlock(player, location);
            this.byLocation.put(location, block);
            List chunkBlocks = this.byChunk.computeIfAbsent(block.chunkCoord, k -> new ArrayList());
            chunkBlocks.add(block);
            return block;
        }

        public void remove(FakeBlock block) {
            List<FakeBlock> chunkBlocks;
            if (this.byLocation.remove(block.location) != null && (chunkBlocks = this.byChunk.get(block.chunkCoord)) != null) {
                chunkBlocks.remove(block);
                if (chunkBlocks.isEmpty()) {
                    this.byChunk.remove(block.chunkCoord);
                }
            }
        }
    }
}

